/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.CurrentBatchTimestamp;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LocalTimestamp;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2Exec;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.OffsetHolder;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.OneTimeExecutor;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.ProgressReporter;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.TERMINATED$;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.execution.streaming.WatermarkTracker;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSource;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\u0012%\u0001EB\u0011B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u001e\t\u0013q\u0002!\u0011!Q\u0001\nu\u0012\u0005\"C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#K\u0011!Y\u0005A!A!\u0002\u0013a\u0005\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u000b\u0011\u0004A\u0011A3\t\u000f1\u0004\u0001\u0019!C\t[\"I\u0011\u0011\u0001\u0001A\u0002\u0013E\u00111\u0001\u0005\b\u0003#\u0001\u0001\u0015)\u0003o\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\u0002\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0010\u0011-\t\u0019\u0005\u0001a\u0001\u0002\u0004%I!!\u0012\t\u0017\u00055\u0003\u00011AA\u0002\u0013%\u0011q\n\u0005\f\u0003'\u0002\u0001\u0019!A!B\u0013\t9\u0005\u0003\u0006\u0002V\u0001A)\u0019!C!\u0003/B\u0011\"!\u001b\u0001\u0001\u0004%I!a\u001b\t\u0013\u0005M\u0004\u00011A\u0005\n\u0005U\u0004\u0002CA=\u0001\u0001\u0006K!!\u001c\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011q\u0010\u0001\u0005R\u0005u\u0004bBAA\u0001\u0011E\u00111\u0011\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\t\t\n\u0001C\u0005\u0003WBq!a%\u0001\t\u0013\t)\nC\u0004\u0002\u001c\u0002!I!!(\t\u0011\u0005\r\u0006\u0001\"\u0001)\u0003KCQ\"!3\u0001!\u0003\r\t\u0011!C\u0005\u0003\u0017\\\u0004\"DAg\u0001A\u0005\u0019\u0011!A\u0005\n\u0005='\tC\u0007\u0002R\u0002\u0001\n1!A\u0001\n\u0013\t\u0019NS\u0004\b\u0003+$\u0003\u0012AAl\r\u0019\u0019C\u0005#\u0001\u0002Z\"1Am\bC\u0001\u0003CD\u0011\"a9 \u0005\u0004%\t!!:\t\u0011\u0005Ex\u0004)A\u0005\u0003O\u00141#T5de>\u0014\u0015\r^2i\u000bb,7-\u001e;j_:T!!\n\u0014\u0002\u0013M$(/Z1nS:<'BA\u0014)\u0003%)\u00070Z2vi&|gN\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001eA\u00111\u0007N\u0007\u0002I%\u0011Q\u0007\n\u0002\u0010'R\u0014X-Y7Fq\u0016\u001cW\u000f^5p]\u0006a1\u000f]1sWN+7o]5p]B\u0011\u0001(O\u0007\u0002Q%\u0011!\b\u000b\u0002\r'B\f'o[*fgNLwN\\\u0005\u0003mQ\nq\u0001\u001e:jO\u001e,'\u000f\u0005\u0002?\u00016\tqH\u0003\u0002&Q%\u0011\u0011i\u0010\u0002\b)JLwmZ3s\u0013\taD'\u0001\u0007ue&<w-\u001a:DY>\u001c7\u000e\u0005\u0002F\u00116\taI\u0003\u0002HU\u0005!Q\u000f^5m\u0013\tIeIA\u0003DY>\u001c7.\u0003\u0002Di\u0005aQ\r\u001f;sC>\u0003H/[8ogB!QJV-Z\u001d\tqE\u000b\u0005\u0002P%6\t\u0001K\u0003\u0002Ra\u00051AH]8pizR\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u000ba\u0001\u0015:fI\u00164\u0017BA,Y\u0005\ri\u0015\r\u001d\u0006\u0003+J\u0003\"!\u0014.\n\u0005mC&AB*ue&tw-\u0001\u0003qY\u0006t\u0007C\u00010c\u001b\u0005y&BA\u0013a\u0015\t\t\u0007&\u0001\u0005dCR\fG._:u\u0013\t\u0019wLA\u0007Xe&$X\rV8TiJ,\u0017-\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0019<\u0007.\u001b6l!\t\u0019\u0004\u0001C\u00037\r\u0001\u0007q\u0007C\u0003=\r\u0001\u0007Q\bC\u0003D\r\u0001\u0007A\tC\u0003L\r\u0001\u0007A\nC\u0003]\r\u0001\u0007Q,A\u0004t_V\u00148-Z:\u0016\u00039\u00042a\u001c;x\u001d\t\u0001(O\u0004\u0002Pc&\t1+\u0003\u0002t%\u00069\u0001/Y2lC\u001e,\u0017BA;w\u0005\r\u0019V-\u001d\u0006\u0003gJ\u0003\"\u0001\u001f@\u000e\u0003eT!!\n>\u000b\u0005md\u0018\u0001\u0002:fC\u0012T!! \u0015\u0002\u0013\r|gN\\3di>\u0014\u0018BA@z\u0005=\u0019\u0006/\u0019:l\t\u0006$\u0018m\u0015;sK\u0006l\u0017aC:pkJ\u001cWm]0%KF$B!!\u0002\u0002\u000eA!\u0011qAA\u0005\u001b\u0005\u0011\u0016bAA\u0006%\n!QK\\5u\u0011!\ty\u0001CA\u0001\u0002\u0004q\u0017a\u0001=%c\u0005A1o\\;sG\u0016\u001c\b\u0005K\u0002\n\u0003+\u0001B!a\u0002\u0002\u0018%\u0019\u0011\u0011\u0004*\u0003\u0011Y|G.\u0019;jY\u0016\fq\u0002\u001e:jO\u001e,'/\u0012=fGV$xN]\u000b\u0003\u0003?\u0011\u0002\"!\t\u0002&\u0005-\u0012\u0011\u0007\u0004\u0007\u0003G\u0001\u0001!a\b\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\t\u0005\u001d\u0011qE\u0005\u0004\u0003S\u0011&a\u0002)s_\u0012,8\r\u001e\t\u0004g\u00055\u0012bAA\u0018I\tyAK]5hO\u0016\u0014X\t_3dkR|'\u000f\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0005%|'BAA\u001e\u0003\u0011Q\u0017M^1\n\t\u0005}\u0012Q\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0011iJLwmZ3s\u000bb,7-\u001e;pe\u0002\n\u0001c^1uKJl\u0017M]6Ue\u0006\u001c7.\u001a:\u0016\u0005\u0005\u001d\u0003cA\u001a\u0002J%\u0019\u00111\n\u0013\u0003!]\u000bG/\u001a:nCJ\\GK]1dW\u0016\u0014\u0018\u0001F<bi\u0016\u0014X.\u0019:l)J\f7m[3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005E\u0003\"CA\b\u001b\u0005\u0005\t\u0019AA$\u0003E9\u0018\r^3s[\u0006\u00148\u000e\u0016:bG.,'\u000fI\u0001\fY><\u0017nY1m!2\fg.\u0006\u0002\u0002ZA!\u00111LA3\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0004\u0003G\u0002\u0017!\u00029mC:\u001c\u0018\u0002BA4\u0003;\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\u0006I\u0012n]\"veJ,g\u000e\u001e\"bi\u000eD7i\u001c8tiJ,8\r^3e+\t\ti\u0007\u0005\u0003\u0002\b\u0005=\u0014bAA9%\n9!i\\8mK\u0006t\u0017!H5t\u0007V\u0014(/\u001a8u\u0005\u0006$8\r[\"p]N$(/^2uK\u0012|F%Z9\u0015\t\u0005\u0015\u0011q\u000f\u0005\n\u0003\u001f\t\u0012\u0011!a\u0001\u0003[\n!$[:DkJ\u0014XM\u001c;CCR\u001c\u0007nQ8ogR\u0014Xo\u0019;fI\u0002\nAa\u001d;paR\u0011\u0011QA\u0001\rgR\f'\u000f\u001e+sS\u001e<WM]\u0001\u0013eVt\u0017i\u0019;jm\u0006$X\rZ*ue\u0016\fW\u000e\u0006\u0003\u0002\u0006\u0005\u0015\u0005BBAD+\u0001\u0007q'A\u000bta\u0006\u00148nU3tg&|gNR8s'R\u0014X-Y7\u0002)A|\u0007/\u001e7bi\u0016\u001cF/\u0019:u\u001f\u001a47/\u001a;t)\u0011\t)!!$\t\r\u0005=e\u00031\u00018\u0003a\u0019\b/\u0019:l'\u0016\u001c8/[8o)>\u0014VO\u001c\"bi\u000eDWm]\u0001\u0013SNtUm\u001e#bi\u0006\fe/Y5mC\ndW-\u0001\nd_:\u001cHO];di:+\u0007\u0010\u001e\"bi\u000eDG\u0003BA7\u0003/Cq!!'\u0019\u0001\u0004\ti'\u0001\u000bo_\u0012\u000bG/\u0019\"bi\u000eDWm]#oC\ndW\rZ\u0001\teVt')\u0019;dQR!\u0011QAAP\u0011\u0019\t\t+\u0007a\u0001o\u000512\u000f]1sWN+7o]5p]R{'+\u001e8CCR\u001c\u0007.\u0001\nxSRD\u0007K]8he\u0016\u001c8\u000fT8dW\u0016$W\u0003BAT\u0003[#B!!+\u0002@B!\u00111VAW\u0019\u0001!q!a,\u001b\u0005\u0004\t\tLA\u0001U#\u0011\t\u0019,!/\u0011\t\u0005\u001d\u0011QW\u0005\u0004\u0003o\u0013&a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u000f\tY,C\u0002\u0002>J\u00131!\u00118z\u0011!\t\tM\u0007CA\u0002\u0005\r\u0017!\u00014\u0011\r\u0005\u001d\u0011QYAU\u0013\r\t9M\u0015\u0002\ty\tLh.Y7f}\u0005\u00112/\u001e9fe\u0012\u001a\b/\u0019:l'\u0016\u001c8/[8o+\u00059\u0014!D:va\u0016\u0014H\u0005\u001e:jO\u001e,'/F\u0001>\u0003I\u0019X\u000f]3sIQ\u0014\u0018nZ4fe\u000ecwnY6\u0016\u0003\u0011\u000b1#T5de>\u0014\u0015\r^2i\u000bb,7-\u001e;j_:\u0004\"aM\u0010\u0014\u0007}\tY\u000e\u0005\u0003\u0002\b\u0005u\u0017bAAp%\n1\u0011I\\=SK\u001a$\"!a6\u0002\u0019\t\u000bEk\u0011%`\u0013\u0012{6*R-\u0016\u0005\u0005\u001d\b\u0003BAu\u0003_l!!a;\u000b\t\u00055\u0018\u0011H\u0001\u0005Y\u0006tw-C\u0002\\\u0003W\fQBQ!U\u0007\"{\u0016\nR0L\u000bf\u0003\u0003")
public class MicroBatchExecution
extends StreamExecution {
    private LogicalPlan logicalPlan;
    private final scala.collection.immutable.Map<String, String> extraOptions;
    private final WriteToStream plan;
    private volatile Seq<SparkDataStream> sources;
    private final Product triggerExecutor;
    private WatermarkTracker watermarkTracker;
    private boolean isCurrentBatchConstructed;
    private volatile boolean bitmap$0;

    public static String BATCH_ID_KEY() {
        return MicroBatchExecution$.MODULE$.BATCH_ID_KEY();
    }

    public /* synthetic */ SparkSession org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession() {
        return super.sparkSession();
    }

    private /* synthetic */ Trigger super$trigger() {
        return super.trigger();
    }

    private /* synthetic */ Clock super$triggerClock() {
        return super.triggerClock();
    }

    @Override
    public Seq<SparkDataStream> sources() {
        return this.sources;
    }

    public void sources_$eq(Seq<SparkDataStream> x$1) {
        this.sources = x$1;
    }

    private Product triggerExecutor() {
        return this.triggerExecutor;
    }

    private WatermarkTracker watermarkTracker() {
        return this.watermarkTracker;
    }

    private void watermarkTracker_$eq(WatermarkTracker x$1) {
        this.watermarkTracker = x$1;
    }

    private LogicalPlan logicalPlan$lzycompute() {
        MicroBatchExecution microBatchExecution = this;
        synchronized (microBatchExecution) {
            if (!this.bitmap$0) {
                LogicalPlan logicalPlan2;
                Predef$.MODULE$.assert(this.queryExecutionThread() == Thread.currentThread(), (Function0 & Serializable)() -> new StringBuilder(56).append("logicalPlan must be initialized in QueryExecutionThread ").append(new StringBuilder(27).append("but the current thread was ").append(Thread.currentThread()).toString()).toString());
                LongRef nextSourceId = LongRef.create((long)0L);
                Map toExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Seq disabledSources = Utils$.MODULE$.stringToSeq(super.sparkSession().sqlContext().conf().disabledV2StreamingMicroBatchReaders());
                LogicalPlan _logicalPlan = (LogicalPlan)this.analyzedPlan().transform((PartialFunction)new Serializable(this, toExecutionRelationMap, nextSourceId, disabledSources, v2ToRelationMap, v2ToExecutionRelationMap){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ MicroBatchExecution $outer;
                    private final Map toExecutionRelationMap$1;
                    private final LongRef nextSourceId$1;
                    private final Seq disabledSources$1;
                    private final Map v2ToRelationMap$1;
                    private final Map v2ToExecutionRelationMap$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof StreamingRelation) {
                            StreamingRelation streamingRelation = (StreamingRelation)A1;
                            DataSource dataSourceV1 = streamingRelation.dataSource();
                            String sourceName = streamingRelation.sourceName();
                            Seq<Attribute> output = streamingRelation.output();
                            object = this.toExecutionRelationMap$1.getOrElseUpdate((Object)streamingRelation, (Function0 & Serializable)() -> {
                                String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                Source source = dataSourceV1.createSource(metadataPath);
                                ++$this.nextSourceId$1.elem;
                                $this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV1 named '").append(sourceName).append("' [").append(dataSourceV1).append("]").toString());
                                return new StreamingExecutionRelation(source, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                            });
                            return (B1)object;
                        }
                        if (A1 instanceof StreamingRelationV2) {
                            StreamingRelationV2 streamingRelationV2 = (StreamingRelationV2)A1;
                            Option src = streamingRelationV2.source();
                            String srcName = streamingRelationV2.sourceName();
                            Table table = streamingRelationV2.table();
                            CaseInsensitiveStringMap options = streamingRelationV2.extraOptions();
                            Seq output = streamingRelationV2.output();
                            Option v1 = streamingRelationV2.v1Relation();
                            if (table instanceof SupportsRead) {
                                Object object2;
                                SupportsRead supportsRead = (SupportsRead)table;
                                String dsStr = src.nonEmpty() ? new StringBuilder(2).append("[").append(src.get()).append("]").toString() : "";
                                boolean v2Disabled = this.disabledSources$1.contains((Object)src.getOrElse((Function0 & Serializable)() -> None$.MODULE$).getClass().getCanonicalName());
                                if (!v2Disabled && DataSourceV2Implicits$.MODULE$.TableHelper((Table)supportsRead).supports(TableCapability.MICRO_BATCH_READ)) {
                                    object2 = this.v2ToRelationMap$1.getOrElseUpdate((Object)streamingRelationV2, (Function0 & Serializable)() -> {
                                        String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Reading table [").append(supportsRead).append("] from DataSourceV2 named '").append(srcName).append("' ").append(dsStr).toString());
                                        Scan scan = supportsRead.newScanBuilder(options).build();
                                        MicroBatchStream stream = scan.toMicroBatchStream(metadataPath);
                                        return new StreamingDataSourceV2Relation(output, scan, (SparkDataStream)stream, StreamingDataSourceV2Relation$.MODULE$.apply$default$4(), StreamingDataSourceV2Relation$.MODULE$.apply$default$5());
                                    });
                                } else {
                                    if (v1.isEmpty()) {
                                        throw QueryExecutionErrors$.MODULE$.microBatchUnsupportedByDataSourceError(srcName);
                                    }
                                    object2 = this.v2ToExecutionRelationMap$1.getOrElseUpdate((Object)streamingRelationV2, (Function0 & Serializable)() -> {
                                        String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                        Source source = ((StreamingRelation)v1.get()).dataSource().createSource(metadataPath);
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Using Source [").append(source).append("] from DataSourceV2 named '").append(srcName).append("' ").append(dsStr).toString());
                                        return new StreamingExecutionRelation(source, (Seq<Attribute>)output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                                    });
                                }
                                object = object2;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        StreamingRelationV2 streamingRelationV2;
                        Table table;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof StreamingRelation ? true : logicalPlan2 instanceof StreamingRelationV2 && (table = (streamingRelationV2 = (StreamingRelationV2)logicalPlan2).table()) instanceof SupportsRead;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.toExecutionRelationMap$1 = toExecutionRelationMap$1;
                        this.nextSourceId$1 = nextSourceId$1;
                        this.disabledSources$1 = disabledSources$1;
                        this.v2ToRelationMap$1 = v2ToRelationMap$1;
                        this.v2ToExecutionRelationMap$1 = v2ToExecutionRelationMap$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.execution.datasources.DataSource java.lang.String scala.collection.immutable.Seq ), $anonfun$applyOrElse$2(org.apache.spark.sql.execution.streaming.Source java.lang.String org.apache.spark.sql.execution.datasources.DataSource ), $anonfun$applyOrElse$3(), $anonfun$applyOrElse$4(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String java.lang.String org.apache.spark.sql.util.CaseInsensitiveStringMap scala.collection.immutable.Seq ), $anonfun$applyOrElse$5(org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String java.lang.String ), $anonfun$applyOrElse$6(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 scala.Option java.lang.String java.lang.String scala.collection.immutable.Seq ), $anonfun$applyOrElse$7(org.apache.spark.sql.execution.streaming.Source java.lang.String java.lang.String )}, serializedLambda);
                    }
                });
                this.sources_$eq((Seq<SparkDataStream>)_logicalPlan.collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof StreamingExecutionRelation) {
                            StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                            object = streamingExecutionRelation.source();
                        } else if (A1 instanceof StreamingDataSourceV2Relation) {
                            StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                            object = streamingDataSourceV2Relation.stream();
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan2 = x2;
                        boolean bl = logicalPlan2 instanceof StreamingExecutionRelation ? true : logicalPlan2 instanceof StreamingDataSourceV2Relation;
                        return bl;
                    }
                }));
                this.uniqueSources_$eq((scala.collection.immutable.Map<SparkDataStream, ReadLimit>)((IterableOnceOps)((IterableOps)this.sources().distinct()).map(arg_0 -> MicroBatchExecution.$anonfun$logicalPlan$2(this, arg_0))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                Table table = this.sink();
                if (table instanceof SupportsWrite) {
                    SupportsWrite supportsWrite = (SupportsWrite)table;
                    Tuple2<StreamingWrite, Seq<CustomMetric>> tuple2 = this.createStreamingWrite(supportsWrite, this.extraOptions, _logicalPlan);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    StreamingWrite streamingWrite = (StreamingWrite)tuple2._1();
                    Seq customMetrics = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)streamingWrite, (Object)customMetrics);
                    Tuple2 tuple23 = tuple22;
                    StreamingWrite streamingWrite2 = (StreamingWrite)tuple23._1();
                    Seq customMetrics2 = (Seq)tuple23._2();
                    Option relationOpt = this.plan.catalogAndIdent().map((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        TableCatalog catalog = (TableCatalog)tuple2._1();
                        Identifier ident = (Identifier)tuple2._2();
                        DataSourceV2Relation dataSourceV2Relation = DataSourceV2Relation$.MODULE$.create((Table)supportsWrite, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                        return dataSourceV2Relation;
                    });
                    logicalPlan2 = new WriteToMicroBatchDataSource((Option<DataSourceV2Relation>)relationOpt, streamingWrite2, _logicalPlan, (Seq<CustomMetric>)customMetrics2);
                } else {
                    logicalPlan2 = _logicalPlan;
                }
                this.logicalPlan = logicalPlan2;
                this.bitmap$0 = true;
            }
        }
        return this.logicalPlan;
    }

    @Override
    public LogicalPlan logicalPlan() {
        return !this.bitmap$0 ? this.logicalPlan$lzycompute() : this.logicalPlan;
    }

    private boolean isCurrentBatchConstructed() {
        return this.isCurrentBatchConstructed;
    }

    private void isCurrentBatchConstructed_$eq(boolean x$1) {
        this.isCurrentBatchConstructed = x$1;
    }

    @Override
    public void stop() {
        this.state().set(TERMINATED$.MODULE$);
        if (this.queryExecutionThread().isAlive()) {
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
            this.interruptAndAwaitExecutionThreadTermination();
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Query ").append(this.prettyIdString()).append(" was stopped").toString());
    }

    @Override
    public void startTrigger() {
        ProgressReporter.startTrigger$(this);
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = true;
        String x$2 = qual$1.copy$default$1();
        boolean x$3 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$3, true));
    }

    @Override
    public void runActivatedStream(SparkSession sparkSessionForStream) {
        boolean noDataBatchesEnabled = sparkSessionForStream.sessionState().conf().streamingNoDataMicroBatchesEnabled();
        ((TriggerExecutor)this.triggerExecutor()).execute((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            if (this.isActive()) {
                BooleanRef currentBatchHasNewData = BooleanRef.create((boolean)false);
                this.startTrigger();
                this.reportTimeTaken("triggerExecution", (JFunction0.mcV.sp & Serializable)() -> {
                    if (this.currentBatchId() < 0L) {
                        this.populateStartOffsets(sparkSessionForStream);
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Stream started from ").append(this.committedOffsets()).toString());
                    }
                    this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().sparkContext().setJobDescription(this.getBatchDescriptionString());
                    if (!this.isCurrentBatchConstructed()) {
                        this.isCurrentBatchConstructed_$eq(this.constructNextBatch(noDataBatchesEnabled));
                    }
                    this.recordTriggerOffsets(this.committedOffsets(), this.availableOffsets(), this.latestOffsets());
                    currentBatchHasNewData$1.elem = this.isNewDataAvailable();
                    StreamingQueryStatus qual$1 = this.currentStatus();
                    boolean x$1 = this.isNewDataAvailable();
                    String x$2 = qual$1.copy$default$1();
                    boolean x$3 = qual$1.copy$default$3();
                    this.currentStatus_$eq(qual$1.copy(x$2, x$1, x$3));
                    if (this.isCurrentBatchConstructed()) {
                        if (currentBatchHasNewData$1.elem) {
                            this.updateStatusMessage("Processing new data");
                        } else {
                            this.updateStatusMessage("No new data but cleaning up state");
                        }
                        this.runBatch(sparkSessionForStream);
                    } else {
                        this.updateStatusMessage("Waiting for data to arrive");
                    }
                });
                this.finishTrigger(currentBatchHasNewData.elem, this.isCurrentBatchConstructed());
                this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable)() -> this.awaitProgressLockCondition().signalAll());
                if (this.isCurrentBatchConstructed()) {
                    this.currentBatchId_$eq(this.currentBatchId() + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                } else {
                    Thread.sleep(this.pollingDelayMs());
                }
            }
            this.updateStatusMessage("Waiting for next trigger");
            return this.isActive();
        });
    }

    private void populateStartOffsets(SparkSession sparkSessionToRunBatches) {
        Some some;
        Tuple2 tuple2;
        this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)None$.MODULE$);
        Option option = this.offsetLog().getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Some some2;
            Tuple2 tuple22;
            long latestBatchId = tuple2._1$mcJ$sp();
            OffsetSeq nextOffsets = (OffsetSeq)tuple2._2();
            this.currentBatchId_$eq(latestBatchId);
            this.isCurrentBatchConstructed_$eq(true);
            this.availableOffsets_$eq(nextOffsets.toStreamProgress(this.sources()));
            if (latestBatchId != 0L) {
                OffsetSeq secondLatestOffsets = (OffsetSeq)this.offsetLog().get(latestBatchId - 1L).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(latestBatchId - 1L).append(" doesn't exist").toString());
                });
                this.committedOffsets_$eq(secondLatestOffsets.toStreamProgress(this.sources()));
            }
            nextOffsets.metadata().foreach((Function1 & Serializable)metadata -> {
                MicroBatchExecution.$anonfun$populateStartOffsets$2(this, sparkSessionToRunBatches, metadata);
                return BoxedUnit.UNIT;
            });
            Option option2 = this.commitLog().getLatest();
            if (option2 instanceof Some && (tuple22 = (Tuple2)(some2 = (Some)option2).value()) != null) {
                BoxedUnit boxedUnit;
                long latestCommittedBatchId = tuple22._1$mcJ$sp();
                CommitMetadata commitMetadata = (CommitMetadata)tuple22._2();
                if (latestBatchId == latestCommittedBatchId) {
                    this.availableOffsets().foreach((Function1 & Serializable)x0$1 -> {
                        void var2_10;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            SparkDataStream source = (SparkDataStream)tuple2._1();
                            org.apache.spark.sql.connector.read.streaming.Offset end = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                            if (source instanceof Source) {
                                Source source2 = (Source)source;
                                if (end instanceof Offset) {
                                    Offset offset = (Offset)end;
                                    Option start = this.committedOffsets().get(source2).map((Function1 & Serializable)x$3 -> (Offset)((Object)((Object)x$3)));
                                    Dataset<Row> dataset = source2.getBatch((Option<Offset>)start, offset);
                                    return var2_10;
                                }
                            }
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var2_10;
                    });
                    this.currentBatchId_$eq(latestCommittedBatchId + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                    this.committedOffsets_$eq((StreamProgress)this.committedOffsets().$plus$plus((IterableOnce)this.availableOffsets()));
                    this.watermarkTracker().setWatermark(package$.MODULE$.max(this.watermarkTracker().currentWatermark(), commitMetadata.nextBatchWatermarkMs()));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (latestCommittedBatchId == latestBatchId - 1L) {
                    this.availableOffsets().foreach((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) return BoxedUnit.UNIT;
                        SparkDataStream source = (SparkDataStream)tuple2._1();
                        org.apache.spark.sql.connector.read.streaming.Offset end = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                        if (!(source instanceof Source)) return BoxedUnit.UNIT;
                        Source source2 = (Source)source;
                        if (!(end instanceof Offset)) return BoxedUnit.UNIT;
                        Offset offset = (Offset)end;
                        Option start = this.committedOffsets().get(source2).map((Function1 & Serializable)x$4 -> (Offset)((Object)((Object)x$4)));
                        return BoxesRunTime.unboxToBoolean((Object)start.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$populateStartOffsets$7(offset, x$5))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true)) ? source2.getBatch((Option<Offset>)start, offset) : BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else if (latestCommittedBatchId < latestBatchId - 1L) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Batch completion log latest batch id is ").append(new StringBuilder(24).append(latestCommittedBatchId).append(", which is not trailing ").toString()).append(new StringBuilder(15).append("batchid ").append(latestBatchId).append(" by one").toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option2)) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "no commit log present");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Resuming at batch ").append(this.currentBatchId()).append(" with committed offsets ").toString()).append(new StringBuilder(23).append(this.committedOffsets()).append(" and available offsets ").append(this.availableOffsets()).toString()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Starting new streaming query.");
            this.currentBatchId_$eq(0L);
            this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches.conf()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private boolean isNewDataAvailable() {
        return this.availableOffsets().exists((Function1<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$1(this, x0$1)));
    }

    private boolean constructNextBatch(boolean noDataBatchesEnabled) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean(this.withProgressLocked((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                if (this.isCurrentBatchConstructed()) {
                    throw new NonLocalReturnControl.mcZ.sp(object, true);
                }
                Tuple2 tuple2 = ((IterableOps)this.uniqueSources().toSeq().map((Function1 & Serializable)x0$1 -> {
                    SparkDataStream s;
                    SparkDataStream s2;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        SparkDataStream s3 = (SparkDataStream)tuple2._1();
                        ReadLimit limit = (ReadLimit)tuple2._2();
                        if (s3 instanceof SupportsAdmissionControl) {
                            SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)s3;
                            this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(supportsAdmissionControl).toString());
                            return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable)() -> {
                                org.apache.spark.sql.connector.read.streaming.Offset offset2;
                                Option<org.apache.spark.sql.connector.read.streaming.Offset> startOffsetOpt = this.availableOffsets().get((SparkDataStream)supportsAdmissionControl);
                                SupportsAdmissionControl supportsAdmissionControl = supportsAdmissionControl;
                                if (supportsAdmissionControl instanceof Source) {
                                    offset2 = (org.apache.spark.sql.connector.read.streaming.Offset)startOffsetOpt.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                                } else if (supportsAdmissionControl instanceof MicroBatchStream) {
                                    SupportsAdmissionControl supportsAdmissionControl2 = supportsAdmissionControl;
                                    offset2 = (org.apache.spark.sql.connector.read.streaming.Offset)startOffsetOpt.map((Function1 & Serializable)offset -> supportsAdmissionControl2.deserializeOffset(offset.json())).getOrElse((Function0 & Serializable)() -> supportsAdmissionControl2.initialOffset());
                                } else {
                                    throw new MatchError((Object)supportsAdmissionControl);
                                }
                                org.apache.spark.sql.connector.read.streaming.Offset startOffset = offset2;
                                org.apache.spark.sql.connector.read.streaming.Offset next = supportsAdmissionControl.latestOffset(startOffset, limit);
                                org.apache.spark.sql.connector.read.streaming.Offset latest = supportsAdmissionControl.reportLatestOffset();
                                return new Tuple2((Object)new Tuple2((Object)supportsAdmissionControl, (Object)Option$.MODULE$.apply((Object)next)), (Object)new Tuple2((Object)supportsAdmissionControl, (Object)Option$.MODULE$.apply((Object)latest)));
                            });
                        }
                    }
                    if (tuple2 != null && (s2 = (SparkDataStream)tuple2._1()) instanceof Source) {
                        Source source = (Source)s2;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(source).toString());
                        return (Tuple2)this.reportTimeTaken("getOffset", (Function0 & Serializable)() -> {
                            Option<Offset> offset = source.getOffset();
                            return new Tuple2((Object)new Tuple2((Object)source, offset), (Object)new Tuple2((Object)source, offset));
                        });
                    }
                    if (tuple2 != null && (s = (SparkDataStream)tuple2._1()) instanceof MicroBatchStream) {
                        MicroBatchStream microBatchStream = (MicroBatchStream)s;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(microBatchStream).toString());
                        return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable)() -> {
                            org.apache.spark.sql.connector.read.streaming.Offset latest = microBatchStream.latestOffset();
                            return new Tuple2((Object)new Tuple2((Object)microBatchStream, (Object)Option$.MODULE$.apply((Object)latest)), (Object)new Tuple2((Object)microBatchStream, (Object)Option$.MODULE$.apply((Object)latest)));
                        });
                    }
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    SparkDataStream s4 = (SparkDataStream)tuple2._1();
                    throw new IllegalStateException(new StringBuilder(19).append("Unexpected source: ").append(s4).toString());
                })).unzip(Predef$.MODULE$.$conforms());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq nextOffsets = (Seq)tuple2._1();
                Seq recentOffsets = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)nextOffsets, (Object)recentOffsets);
                Tuple2 tuple23 = tuple22;
                Seq nextOffsets2 = (Seq)tuple23._1();
                Seq recentOffsets2 = (Seq)tuple23._2();
                this.availableOffsets_$eq((StreamProgress)this.availableOffsets().$plus$plus((IterableOnce)((IterableOnceOps)((IterableOps)nextOffsets2.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$8(x0$2)))).map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), ((Option)p._2()).get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                this.latestOffsets_$eq((StreamProgress)this.latestOffsets().$plus$plus((IterableOnce)((IterableOnceOps)((IterableOps)recentOffsets2.filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$10(x0$3)))).map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), ((Option)p._2()).get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                OffsetSeqMetadata qual$1 = this.offsetSeqMetadata();
                long x$1 = this.watermarkTracker().currentWatermark();
                long x$2 = this.super$triggerClock().getTimeMillis();
                scala.collection.immutable.Map<String, String> x$3 = qual$1.copy$default$3();
                this.offsetSeqMetadata_$eq(qual$1.copy(x$1, x$2, x$3));
                boolean lastExecutionRequiresAnotherBatch = noDataBatchesEnabled && Option$.MODULE$.apply((Object)this.lastExecution()).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.shouldRunAnotherBatch(this.offsetSeqMetadata())));
                boolean shouldConstructNextBatch = this.isNewDataAvailable() || lastExecutionRequiresAnotherBatch;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(25).append("noDataBatchesEnabled = ").append(noDataBatchesEnabled).append(", ").toString()).append(new StringBuilder(38).append("lastExecutionRequiresAnotherBatch = ").append(lastExecutionRequiresAnotherBatch).append(", ").toString()).append(new StringBuilder(23).append("isNewDataAvailable = ").append(this.isNewDataAvailable()).append(", ").toString()).append(new StringBuilder(27).append("shouldConstructNextBatch = ").append(shouldConstructNextBatch).toString()).toString());
                if (shouldConstructNextBatch) {
                    this.updateStatusMessage("Writing offsets to log");
                    this.reportTimeTaken("walCommit", (JFunction0.mcV.sp & Serializable)() -> {
                        block3: {
                            Predef$.MODULE$.assert(this.offsetLog().add(this.currentBatchId(), this.availableOffsets().toOffsetSeq(this.sources(), this.offsetSeqMetadata())), (Function0 & Serializable)() -> new StringBuilder(67).append("Concurrent update to the log. Multiple streaming jobs detected for ").append(this.currentBatchId()).toString());
                            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(30).append("Committed offsets for batch ").append(this.currentBatchId()).append(". ").toString()).append(new StringBuilder(9).append("Metadata ").append(this.offsetSeqMetadata().toString()).toString()).toString());
                            if (this.currentBatchId() != 0L) {
                                Option<OffsetSeq> prevBatchOff = this.offsetLog().get(this.currentBatchId() - 1L);
                                if (prevBatchOff.isDefined()) {
                                    ((OffsetSeq)prevBatchOff.get()).toStreamProgress(this.sources()).foreach((Function1 & Serializable)x0$4 -> {
                                        MicroBatchExecution.$anonfun$constructNextBatch$17(x0$4);
                                        return BoxedUnit.UNIT;
                                    });
                                } else {
                                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(this.currentBatchId() - 1L).append(" doesn't exist").toString());
                                }
                            }
                            if ((long)this.minLogEntriesToMaintain() >= this.currentBatchId()) break block3;
                            this.purge(this.currentBatchId() - (long)this.minLogEntriesToMaintain());
                        }
                    });
                    this.noNewData_$eq(false);
                } else {
                    this.noNewData_$eq(true);
                    this.awaitProgressLockCondition().signalAll();
                }
                return shouldConstructNextBatch;
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private void runBatch(SparkSession sparkSessionToRunBatch) {
        LogicalPlan logicalPlan2;
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("Running batch ").append(this.currentBatchId()).toString());
        this.newData_$eq((scala.collection.immutable.Map<SparkDataStream, LogicalPlan>)((scala.collection.immutable.Map)this.reportTimeTaken("getBatch", (Function0 & Serializable)() -> (scala.collection.immutable.Map)this.availableOffsets().flatMap((Function1 & Serializable)x0$1 -> {
            org.apache.spark.sql.connector.read.streaming.Offset offset;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SparkDataStream source = (SparkDataStream)tuple2._1();
                org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                if (source instanceof Source) {
                    Source source2 = (Source)source;
                    if (available instanceof Offset) {
                        Offset offset2 = (Offset)available;
                        if (BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get(source2).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$4(offset2, x$8))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true))) {
                            Option current = this.committedOffsets().get(source2).map((Function1 & Serializable)x$9 -> (Offset)((Object)((Object)((Object)x$9))));
                            Dataset<Row> batch = source2.getBatch((Option<Offset>)current, offset2);
                            Predef$.MODULE$.assert(batch.isStreaming(), (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("DataFrame returned by getBatch from ").append(source2).append(" did not have isStreaming=true\n").toString()).append(String.valueOf(batch.queryExecution().logical())).toString());
                            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(source2).append(": ").append(current).append(" -> ").append((Object)offset2).toString());
                            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source2), (Object)batch.logicalPlan()));
                        }
                    }
                }
            }
            if (tuple2 == null) return None$.MODULE$;
            SparkDataStream stream = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (!(stream instanceof MicroBatchStream)) return None$.MODULE$;
            MicroBatchStream microBatchStream = (MicroBatchStream)stream;
            if (!BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$9(available, x$10))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true))) return None$.MODULE$;
            Option current = this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable)off -> microBatchStream.deserializeOffset(off.json()));
            org.apache.spark.sql.connector.read.streaming.Offset offset3 = available;
            if (offset3 instanceof SerializedOffset) {
                SerializedOffset serializedOffset = (SerializedOffset)offset3;
                offset = microBatchStream.deserializeOffset(serializedOffset.json());
            } else {
                org.apache.spark.sql.connector.read.streaming.Offset offset4;
                if (offset3 == null) throw new MatchError((Object)offset3);
                offset = offset4 = offset3;
            }
            org.apache.spark.sql.connector.read.streaming.Offset endOffset = offset;
            org.apache.spark.sql.connector.read.streaming.Offset startOffset = (org.apache.spark.sql.connector.read.streaming.Offset)current.getOrElse((Function0 & Serializable)() -> microBatchStream.initialOffset());
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(microBatchStream).append(": ").append(current).append(" -> ").append(endOffset).toString());
            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchStream), (Object)new OffsetHolder(startOffset, endOffset)));
        }))));
        LogicalPlan newBatchesPlan = (LogicalPlan)this.logicalPlan().transform((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingExecutionRelation) {
                    StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                    SparkDataStream source = streamingExecutionRelation.source();
                    Seq<Attribute> output = streamingExecutionRelation.output();
                    object = this.$outer.newData().get((Object)source).map((Function1 & Serializable)dataPlan -> {
                        int maxFields = SQLConf$.MODULE$.get().maxToStringFields();
                        Predef$.MODULE$.assert(output.size() == dataPlan.output().size(), (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(19).append("Invalid batch: ").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(output, ",", maxFields)).append(" != ").toString()).append(String.valueOf(org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(dataPlan.output(), ",", maxFields))).toString());
                        Seq aliases = (Seq)((IterableOps)output.zip((IterableOnce)dataPlan.output())).map((Function1 & Serializable)x0$1 -> {
                            Attribute from;
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Attribute to = (Attribute)tuple2._1();
                            Attribute x$1 = from = (Attribute)tuple2._2();
                            String x$2 = to.name();
                            ExprId x$3 = to.exprId();
                            Some x$4 = new Some((Object)from.metadata());
                            Seq x$5 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                            Alias alias = new Alias((Expression)x$1, x$2, x$3, x$5, (Option)x$4, x$6);
                            return alias;
                        });
                        return new Project(aliases, dataPlan);
                    }).getOrElse((Function0 & Serializable)() -> {
                        Seq x$7 = output;
                        boolean x$8 = true;
                        Seq x$9 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$7, x$9, true);
                    });
                } else if (A1 instanceof StreamingDataSourceV2Relation) {
                    StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                    object = this.$outer.newData().get((Object)streamingDataSourceV2Relation.stream()).map((Function1 & Serializable)x0$2 -> {
                        LogicalPlan logicalPlan2 = x0$2;
                        if (!(logicalPlan2 instanceof OffsetHolder)) {
                            throw new MatchError((Object)logicalPlan2);
                        }
                        OffsetHolder offsetHolder = (OffsetHolder)logicalPlan2;
                        org.apache.spark.sql.connector.read.streaming.Offset start = offsetHolder.start();
                        org.apache.spark.sql.connector.read.streaming.Offset end = offsetHolder.end();
                        Some x$10 = new Some((Object)start);
                        Some x$11 = new Some((Object)end);
                        Seq x$12 = streamingDataSourceV2Relation.copy$default$1();
                        Scan x$13 = streamingDataSourceV2Relation.copy$default$2();
                        SparkDataStream x$14 = streamingDataSourceV2Relation.copy$default$3();
                        StreamingDataSourceV2Relation streamingDataSourceV2Relation = streamingDataSourceV2Relation.copy(x$12, x$13, x$14, (Option)x$10, (Option)x$11);
                        return streamingDataSourceV2Relation;
                    }).getOrElse((Function0 & Serializable)() -> {
                        Seq x$15 = streamingDataSourceV2Relation.output();
                        boolean x$16 = true;
                        Seq x$17 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$15, x$17, true);
                    });
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof StreamingExecutionRelation ? true : logicalPlan2 instanceof StreamingDataSourceV2Relation;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(scala.Tuple2 ), $anonfun$applyOrElse$11(scala.collection.immutable.Seq ), $anonfun$applyOrElse$12(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$13(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation ), $anonfun$applyOrElse$8(scala.collection.immutable.Seq org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$9(scala.collection.immutable.Seq int org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        LogicalPlan newAttributePlan = newBatchesPlan.transformAllExpressionsWithPruning((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.containsPattern(TreePattern$.MODULE$.CURRENT_LIKE())), newBatchesPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof CurrentTimestamp) {
                    CurrentTimestamp currentTimestamp = (CurrentTimestamp)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentTimestamp.dataType(), (Option)new Some((Object)"Dummy TimeZoneId"));
                } else if (A1 instanceof LocalTimestamp) {
                    LocalTimestamp localTimestamp = (LocalTimestamp)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), localTimestamp.dataType(), localTimestamp.timeZoneId());
                } else if (A1 instanceof CurrentDate) {
                    CurrentDate currentDate = (CurrentDate)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentDate.dataType(), currentDate.timeZoneId());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof CurrentTimestamp ? true : (expression instanceof LocalTimestamp ? true : expression instanceof CurrentDate);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Table table = this.sink();
        if (table instanceof Sink) {
            logicalPlan2 = newAttributePlan;
        } else if (table instanceof SupportsWrite) {
            logicalPlan2 = ((WriteToMicroBatchDataSource)newAttributePlan).createPlan(this.currentBatchId());
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("unknown sink type for ").append(this.sink()).toString());
        }
        LogicalPlan triggerLogicalPlan = logicalPlan2;
        sparkSessionToRunBatch.sparkContext().setLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY(), Long.toString(this.currentBatchId()));
        sparkSessionToRunBatch.sparkContext().setLocalProperty(StreamExecution$.MODULE$.IS_CONTINUOUS_PROCESSING(), Boolean.toString(false));
        this.reportTimeTaken("queryPlanning", (Function0 & Serializable)() -> {
            this.lastExecution_$eq(new IncrementalExecution(sparkSessionToRunBatch, triggerLogicalPlan, this.outputMode(), this.checkpointFile("state"), this.id(), this.runId(), this.currentBatchId(), this.offsetSeqMetadata()));
            return this.lastExecution().executedPlan();
        });
        Dataset nextBatch = new Dataset(this.lastExecution(), RowEncoder$.MODULE$.apply(this.lastExecution().analyzed().schema()));
        Option batchSinkProgress = (Option)this.reportTimeTaken("addBatch", (Function0 & Serializable)() -> (Option)SQLExecution$.MODULE$.withNewExecutionId(this.lastExecution(), SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0 & Serializable)() -> {
            Option<StreamWriterCommitProgress> option;
            Object object;
            Table table = this.sink();
            if (table instanceof Sink) {
                Sink sink = (Sink)table;
                sink.addBatch(this.currentBatchId(), nextBatch);
                object = BoxedUnit.UNIT;
            } else if (table instanceof SupportsWrite) {
                object = nextBatch.collect();
            } else {
                throw new MatchError((Object)table);
            }
            SparkPlan sparkPlan = this.lastExecution().executedPlan();
            if (sparkPlan instanceof WriteToDataSourceV2Exec) {
                WriteToDataSourceV2Exec writeToDataSourceV2Exec = (WriteToDataSourceV2Exec)sparkPlan;
                option = writeToDataSourceV2Exec.commitProgress();
            } else {
                option = None$.MODULE$;
            }
            return option;
        }));
        this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)batchSinkProgress);
            this.watermarkTracker().updateWatermark(this.lastExecution().executedPlan());
            Predef$.MODULE$.assert(this.commitLog().add(this.currentBatchId(), new CommitMetadata(this.watermarkTracker().currentWatermark())), (Function0 & Serializable)() -> new StringBuilder(74).append("Concurrent update to the commit log. Multiple streaming jobs detected for ").append(String.valueOf(BoxesRunTime.boxToLong((long)this.currentBatchId()))).toString());
            this.committedOffsets_$eq((StreamProgress)this.committedOffsets().$plus$plus((IterableOnce)this.availableOffsets()));
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Completed batch ").append(this.currentBatchId()).toString());
    }

    public <T> T withProgressLocked(Function0<T> f) {
        Object object;
        this.awaitProgressLock().lock();
        try {
            object = f.apply();
        }
        finally {
            this.awaitProgressLock().unlock();
        }
        return (T)object;
    }

    public static final /* synthetic */ String $anonfun$logicalPlan$3(ReadLimit limit$1, SupportsAdmissionControl x2$1) {
        return new StringBuilder(60).append("The read limit ").append(limit$1).append(" for ").append(x2$1).append(" is ignored when Trigger.Once() is used.").toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$logicalPlan$2(MicroBatchExecution $this, SparkDataStream x0$1) {
        block3: {
            block2: {
                var3_2 = x0$1;
                if (!(var3_2 instanceof SupportsAdmissionControl)) break block2;
                var4_3 = (SupportsAdmissionControl)var3_2;
                limit = var4_3.getDefaultReadLimit();
                v0 = $this.super$trigger();
                var6_5 = OneTimeTrigger$.MODULE$;
                if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
                v1 = limit;
                var7_6 = ReadLimit.allAvailable();
                if (v1 == null ? var7_6 != null : v1.equals(var7_6) == false) {
                    $this.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$logicalPlan$3(org.apache.spark.sql.connector.read.streaming.ReadLimit org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl ), ()Ljava/lang/String;)((ReadLimit)limit, (SupportsAdmissionControl)var4_3));
                    v2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var4_3), (Object)ReadLimit.allAvailable());
                } else lbl-1000:
                // 2 sources

                {
                    v2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var4_3), (Object)limit);
                }
                var2_7 = v2;
                break block3;
            }
            var2_7 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var3_2), (Object)ReadLimit.allAvailable());
        }
        return var2_7;
    }

    public static final /* synthetic */ void $anonfun$populateStartOffsets$2(MicroBatchExecution $this, SparkSession sparkSessionToRunBatches$1, OffsetSeqMetadata metadata) {
        OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, sparkSessionToRunBatches$1.conf());
        $this.offsetSeqMetadata_$eq(OffsetSeqMetadata$.MODULE$.apply(metadata.batchWatermarkMs(), metadata.batchTimestampMs(), sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker().setWatermark(metadata.batchWatermarkMs());
    }

    public static final /* synthetic */ boolean $anonfun$populateStartOffsets$7(Offset x3$1, Offset x$5) {
        Offset offset = x$5;
        Offset offset2 = x3$1;
        return !(offset != null ? !((Object)((Object)offset)).equals((Object)offset2) : offset2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$2(org.apache.spark.sql.connector.read.streaming.Offset available$1, org.apache.spark.sql.connector.read.streaming.Offset committed) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = committed;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$1;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$1(MicroBatchExecution $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SparkDataStream source = (SparkDataStream)tuple2._1();
        org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)$this.committedOffsets().get(source).map((Function1 & Serializable)committed -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$2(available, committed))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$8(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option o = (Option)tuple2._2();
        boolean bl = o.nonEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$10(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option o = (Option)tuple2._2();
        boolean bl = o.nonEmpty();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$constructNextBatch$17(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            SparkDataStream src = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (src instanceof Source) {
                Source source = (Source)src;
                if (off instanceof Offset) {
                    Offset offset = (Offset)off;
                    source.commit(offset);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            SparkDataStream stream = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (stream instanceof MicroBatchStream) {
                MicroBatchStream microBatchStream = (MicroBatchStream)stream;
                microBatchStream.commit(microBatchStream.deserializeOffset(off.json()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        SparkDataStream src = (SparkDataStream)tuple2._1();
        throw new IllegalArgumentException(new StringBuilder(47).append("Unknown source is found at constructNextBatch: ").append(src).toString());
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$4(Offset x3$3, org.apache.spark.sql.connector.read.streaming.Offset x$8) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$8;
        Offset offset2 = x3$3;
        return offset == null ? offset2 != null : !offset.equals((Object)offset2);
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$9(org.apache.spark.sql.connector.read.streaming.Offset available$2, org.apache.spark.sql.connector.read.streaming.Offset x$10) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$10;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$2;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public MicroBatchExecution(SparkSession sparkSession, Trigger trigger, Clock triggerClock, scala.collection.immutable.Map<String, String> extraOptions, WriteToStream plan) {
        Product product;
        this.extraOptions = extraOptions;
        this.plan = plan;
        super(sparkSession, plan.name(), plan.resolvedCheckpointLocation(), plan.inputQuery(), plan.sink(), trigger, triggerClock, plan.outputMode(), plan.deleteCheckpointOnStop());
        this.sources = (Seq)scala.package$.MODULE$.Seq().empty();
        Trigger trigger2 = super.trigger();
        if (trigger2 instanceof ProcessingTimeTrigger) {
            ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger2;
            product = new ProcessingTimeExecutor(processingTimeTrigger, super.triggerClock());
        } else if (OneTimeTrigger$.MODULE$.equals(trigger2)) {
            product = new OneTimeExecutor();
        } else {
            throw new IllegalStateException(new StringBuilder(25).append("Unknown type of trigger: ").append(super.trigger()).toString());
        }
        this.triggerExecutor = product;
        this.isCurrentBatchConstructed = false;
    }
}

