/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.streaming.WriteToStreamStatement;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\t}h\u0001\u0002\u0013&\u0001AB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0007\u0005\u0002!\taJ\"\t\u0011\u001d\u0003!\u0019!C\u0001O!CaA\u0015\u0001!\u0002\u0013I\u0005bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u00073\u0002\u0001\u000b\u0011B+\t\u000fi\u0003!\u0019!C\u00057\"1q\u000e\u0001Q\u0001\nqCq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011B@\t\u0011\u00055\u0001A1A\u0005\nyDq!a\u0004\u0001A\u0003%q\u0010C\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0003\u0002\u0014!I\u0011\u0011\u0005\u0001A\u0002\u0013%\u00111\u0005\u0005\t\u0003_\u0001\u0001\u0015)\u0003\u0002\u0016!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u007f\u0001A\u0011AA$\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!!\u0019\u0001\t\u0003\t\u0019\u000bC\u0004\u0002B\u0002!\t!a\u0019\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0007bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\t\u0003;\u0004A\u0011A\u0014\u0002`\"9\u00111\u001f\u0001\u0005\n\u0005U\b\"\u0003BD\u0001E\u0005I\u0011\u0002BE\u0011!\u0011i\n\u0001C\u0001O\t}\u0005B\u0003Bh\u0001E\u0005I\u0011A\u0014\u0003R\"Q!Q\u001b\u0001\u0012\u0002\u0013\u0005qE!5\t\u0015\t]\u0007!%A\u0005\u0002\u001d\u0012I\u000e\u0003\u0006\u0003^\u0002\t\n\u0011\"\u0001(\u0005?D!Ba9\u0001#\u0003%\ta\nBE\u0011!\u0011)\u000f\u0001C\u0001O\t\u001d\bb\u0002Bw\u0001\u0011%!q\u001e\u0002\u0016'R\u0014X-Y7j]\u001e\fV/\u001a:z\u001b\u0006t\u0017mZ3s\u0015\t1s%A\u0005tiJ,\u0017-\\5oO*\u0011\u0001&K\u0001\u0004gFd'B\u0001\u0016,\u0003\u0015\u0019\b/\u0019:l\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tA4(D\u0001:\u0015\tQ\u0014&\u0001\u0005j]R,'O\\1m\u0013\ta\u0014HA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005}\u0002U\"A\u0014\n\u0005\u0005;#\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002E\rB\u0011Q\tA\u0007\u0002K!)QH\u0001a\u0001}\u0005)2\u000f^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014X#A%\u0011\u0005)\u0003V\"A&\u000b\u00051k\u0015!B:uCR,'B\u0001\u0014O\u0015\tyu%A\u0005fq\u0016\u001cW\u000f^5p]&\u0011\u0011k\u0013\u0002\u0019'R\fG/Z*u_J,7i\\8sI&t\u0017\r^8s%\u00164\u0017AF:uCR,7\u000b^8sK\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u00171L7\u000f^3oKJ\u0014Uo]\u000b\u0002+B\u0011akV\u0007\u0002\u001b&\u0011\u0001,\u0014\u0002\u001a'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe\n+8/\u0001\u0007mSN$XM\\3s\u0005V\u001c\b%A\u0007bGRLg/Z)vKJLWm]\u000b\u00029B!QL\u00193m\u001b\u0005q&BA0a\u0003\u001diW\u000f^1cY\u0016T!!Y\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002d=\n9\u0001*Y:i\u001b\u0006\u0004\bCA3k\u001b\u00051'BA4i\u0003\u0011)H/\u001b7\u000b\u0003%\fAA[1wC&\u00111N\u001a\u0002\u0005+VKE\t\u0005\u0002F[&\u0011a.\n\u0002\u000f'R\u0014X-Y7j]\u001e\fV/\u001a:z\u00039\t7\r^5wKF+XM]5fg\u0002BC\u0001C9|yB\u0011!/_\u0007\u0002g*\u0011A/^\u0001\u000bG>t7-\u001e:sK:$(B\u0001<x\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002q\u0006)!.\u0019<bq&\u0011!p\u001d\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f\u0013!`\u0001\u0018C\u000e$\u0018N^3Rk\u0016\u0014\u0018.Z:TQ\u0006\u0014X\r\u001a'pG.,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u00015\u0002\t1\fgnZ\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0004PE*,7\r^\u0001\u0019C\u000e$\u0018N^3Rk\u0016\u0014\u0018.Z:TQ\u0006\u0014X\r\u001a'pG.\u0004\u0013\u0001F1xC&$H+\u001a:nS:\fG/[8o\u0019>\u001c7.A\u000bbo\u0006LG\u000fV3s[&t\u0017\r^5p]2{7m\u001b\u0011\u000291\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=Fq\u000e,\u0007\u000f^5p]V\u0011\u0011Q\u0003\t\u0006e\u0005]\u00111D\u0005\u0004\u00033\u0019$AB(qi&|g\u000eE\u0002F\u0003;I1!a\b&\u0005]\u0019FO]3b[&tw-U;fef,\u0005pY3qi&|g.\u0001\u0011mCN$H+\u001a:nS:\fG/\u001a3Rk\u0016\u0014\u00180\u0012=dKB$\u0018n\u001c8`I\u0015\fH\u0003BA\u0013\u0003W\u00012AMA\u0014\u0013\r\tIc\r\u0002\u0005+:LG\u000fC\u0005\u0002.9\t\t\u00111\u0001\u0002\u0016\u0005\u0019\u0001\u0010J\u0019\u0002;1\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=Fq\u000e,\u0007\u000f^5p]\u0002BSaD9|\u0003g\t#!!\u0004\u0002\r\u0005\u001cG/\u001b<f+\t\tI\u0004\u0005\u00033\u0003wa\u0017bAA\u001fg\t)\u0011I\u001d:bs\u0006\u0019q-\u001a;\u0015\u00071\f\u0019\u0005\u0003\u0004\u0002FE\u0001\r\u0001Z\u0001\u0003S\u0012$2\u0001\\A%\u0011\u001d\t)E\u0005a\u0001\u0003\u0017\u0002B!!\u0014\u0002\\9!\u0011qJA,!\r\t\tfM\u0007\u0003\u0003'R1!!\u00160\u0003\u0019a$o\\8u}%\u0019\u0011\u0011L\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\ti&a\u0018\u0003\rM#(/\u001b8h\u0015\r\tIfM\u0001\u0014C^\f\u0017\u000e^!osR+'/\\5oCRLwN\u001c\u000b\u0003\u0003KASaEA4\u0003[\u0002RAMA5\u00037I1!a\u001b4\u0005\u0019!\bN]8xgF:a$a\u0013\u0002p\u0005\u0005\u0016'C\u0012\u0002r\u0005e\u0014qSA>+\u0011\t\u0019(!\u001e\u0016\u0005\u0005-CaBA<_\t\u0007\u0011\u0011\u0011\u0002\u0002)&!\u00111PA?\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011qP\u001a\u0002\rQD'o\\<t#\u0011\t\u0019)!#\u0011\u0007I\n))C\u0002\u0002\bN\u0012qAT8uQ&tw\r\u0005\u0003\u0002\f\u0006Eeb\u0001\u001a\u0002\u000e&\u0019\u0011qR\u001a\u0002\u000fA\f7m[1hK&!\u00111SAK\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u0010N\n\u0014bIAM\u00037\u000bi*a \u000f\u0007I\nY*C\u0002\u0002\u0000M\nTA\t\u001a4\u0003?\u0013Qa]2bY\u0006\f4AJA\u000e)\u0011\t)+a+\u0011\u0007I\n9+C\u0002\u0002*N\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002.R\u0001\r!a,\u0002\u0013QLW.Z8vi6\u001b\bc\u0001\u001a\u00022&\u0019\u00111W\u001a\u0003\t1{gn\u001a\u0015\u0006)\u0005\u001d\u0014qW\u0019\b=\u0005-\u0013\u0011XA`c%\u0019\u0013\u0011OA=\u0003w\u000bY(M\u0005$\u00033\u000bY*!0\u0002\u0000E*!EM\u001a\u0002 F\u001aa%a\u0007\u0002\u001fI,7/\u001a;UKJl\u0017N\\1uK\u0012\f1\"\u00193e\u0019&\u001cH/\u001a8feR!\u0011QEAd\u0011\u001d\tIM\u0006a\u0001\u0003\u0017\f\u0001\u0002\\5ti\u0016tWM\u001d\t\u0004\u000b\u00065\u0017bAAhK\t12\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'/\u0001\bsK6|g/\u001a'jgR,g.\u001a:\u0015\t\u0005\u0015\u0012Q\u001b\u0005\b\u0003\u0013<\u0002\u0019AAf\u00035a\u0017n\u001d;MSN$XM\\3sgR\u0011\u00111\u001c\t\u0006e\u0005m\u00121Z\u0001\u0012a>\u001cH\u000fT5ti\u0016tWM]#wK:$H\u0003BA\u0013\u0003CDq!a9\u001a\u0001\u0004\t)/A\u0003fm\u0016tG\u000f\u0005\u0003\u0002h\u00065hbA#\u0002j&\u0019\u00111^\u0013\u0002-M#(/Z1nS:<\u0017+^3ss2K7\u000f^3oKJLA!a<\u0002r\n)QI^3oi*\u0019\u00111^\u0013\u0002\u0017\r\u0014X-\u0019;f#V,'/\u001f\u000b\u0019\u0003o\fiPa\u0001\u0003\b\t\u001d\"\u0011\u0007B#\u0005\u001f\u0012\u0019Fa\u0016\u0003b\t=\u0004c\u0001,\u0002z&\u0019\u00111`'\u0003+M#(/Z1nS:<\u0017+^3ss^\u0013\u0018\r\u001d9fe\"9\u0011q \u000eA\u0002\t\u0005\u0011!E;tKJ\u001c\u0006/Z2jM&,GMT1nKB)!'a\u0006\u0002L!9!Q\u0001\u000eA\u0002\t\u0005\u0011aH;tKJ\u001c\u0006/Z2jM&,Gm\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]\"9!\u0011\u0002\u000eA\u0002\t-\u0011A\u00013g!\u0011\u0011iA!\t\u000f\t\t=!q\u0004\b\u0005\u0005#\u0011iB\u0004\u0003\u0003\u0014\tma\u0002\u0002B\u000b\u00053qA!!\u0015\u0003\u0018%\ta&\u0003\u0002-[%\u0011!fK\u0005\u0003Q%J1!a$(\u0013\u0011\u0011\u0019C!\n\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAAHO!9!\u0011\u0006\u000eA\u0002\t-\u0012\u0001D3yiJ\fw\n\u001d;j_:\u001c\b\u0003CA'\u0005[\tY%a\u0013\n\t\t=\u0012q\f\u0002\u0004\u001b\u0006\u0004\bb\u0002B\u001a5\u0001\u0007!QG\u0001\u0005g&t7\u000e\u0005\u0003\u00038\t\u0005SB\u0001B\u001d\u0015\u0011\u0011YD!\u0010\u0002\u000f\r\fG/\u00197pO*\u0019!qH\u0014\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002\u0002B\"\u0005s\u0011Q\u0001V1cY\u0016DqAa\u0012\u001b\u0001\u0004\u0011I%\u0001\u0006pkR\u0004X\u000f^'pI\u0016\u00042!\u0012B&\u0013\r\u0011i%\n\u0002\u000b\u001fV$\b/\u001e;N_\u0012,\u0007b\u0002B)5\u0001\u0007\u0011QU\u0001\u001akN,G+Z7q\u0007\",7m\u001b9pS:$Hj\\2bi&|g\u000eC\u0004\u0003Vi\u0001\r!!*\u0002;I,7m\u001c<fe\u001a\u0013x.\\\"iK\u000e\\\u0007o\\5oi2{7-\u0019;j_:DqA!\u0017\u001b\u0001\u0004\u0011Y&A\u0004ue&<w-\u001a:\u0011\u0007\u0015\u0013i&C\u0002\u0003`\u0015\u0012q\u0001\u0016:jO\u001e,'\u000fC\u0004\u0003di\u0001\rA!\u001a\u0002\u0019Q\u0014\u0018nZ4fe\u000ecwnY6\u0011\t\t\u001d$1N\u0007\u0003\u0005SR!aZ\u0015\n\t\t5$\u0011\u000e\u0002\u0006\u00072|7m\u001b\u0005\n\u0005cR\u0002\u0013!a\u0001\u0005g\nqbY1uC2|w-\u00118e\u0013\u0012,g\u000e\u001e\t\u0006e\u0005]!Q\u000f\t\be\t]$1\u0010BA\u0013\r\u0011Ih\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\t]\"QP\u0005\u0005\u0005\u007f\u0012ID\u0001\u0007UC\ndWmQ1uC2|w\r\u0005\u0003\u00038\t\r\u0015\u0002\u0002BC\u0005s\u0011!\"\u00133f]RLg-[3s\u0003Y\u0019'/Z1uKF+XM]=%I\u00164\u0017-\u001e7uIE\nTC\u0001BFU\u0011\u0011\u0019H!$,\u0005\t=\u0005\u0003\u0002BI\u00053k!Aa%\u000b\t\tU%qS\u0001\nk:\u001c\u0007.Z2lK\u0012T!A^\u001a\n\t\tm%1\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AC:uCJ$\u0018+^3ssR9BN!)\u0003$\n\u0015&q\u0015BU\u0005W\u0013iKa,\u00032\nM&Q\u0017\u0005\b\u0003\u007fd\u0002\u0019\u0001B\u0001\u0011\u001d\u0011)\u0001\ba\u0001\u0005\u0003AqA!\u0003\u001d\u0001\u0004\u0011Y\u0001C\u0004\u0003*q\u0001\rAa\u000b\t\u000f\tMB\u00041\u0001\u00036!9!q\t\u000fA\u0002\t%\u0003\"\u0003B)9A\u0005\t\u0019AAS\u0011%\u0011)\u0006\bI\u0001\u0002\u0004\t)\u000bC\u0005\u0003Zq\u0001\n\u00111\u0001\u0003\\!I!1\r\u000f\u0011\u0002\u0003\u0007!Q\r\u0005\n\u0005cb\u0002\u0013!a\u0001\u0005gBS\u0001\bB]\u0005\u000b\u0004RAMA5\u0005w\u0003BA!0\u0003B6\u0011!q\u0018\u0006\u0003i\u001aLAAa1\u0003@\n\u0001B+[7f_V$X\t_2faRLwN\\\u0019\b=\u0005-#q\u0019Bgc%\u0019\u0013\u0011OA=\u0005\u0013\fY(M\u0005$\u00033\u000bYJa3\u0002\u0000E*!EM\u001a\u0002 F\u001aaEa/\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011\u0019N\u000b\u0003\u0002&\n5\u0015\u0001F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$\u0003(\u0001\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H%O\u000b\u0003\u00057TCAa\u0017\u0003\u000e\u0006)2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIE\u0002TC\u0001BqU\u0011\u0011)G!$\u0002+M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132c\u00051bn\u001c;jMf\fV/\u001a:z)\u0016\u0014X.\u001b8bi&|g\u000e\u0006\u0003\u0002&\t%\bB\u0002BvE\u0001\u0007A.A\buKJl\u0017N\\1uK\u0012\fV/\u001a:z\u0003i)hN]3hSN$XM\u001d+fe6Lg.\u0019;fIN#(/Z1n)\u0011\t)C!=\t\r\t-8\u00051\u0001mQ\r\u0001!Q\u001f\t\u0005\u0005o\u0014Y0\u0004\u0002\u0003z*\u0011a/K\u0005\u0005\u0005{\u0014IP\u0001\u0005Fm>dg/\u001b8h\u0001")
public class StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesSharedLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesSharedLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private Option<StreamingQueryException> lastTerminatedQueryException;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesSharedLock() {
        return this.activeQueriesSharedLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private Option<StreamingQueryException> lastTerminatedQueryException() {
        return this.lastTerminatedQueryException;
    }

    private void lastTerminatedQueryException_$eq(Option<StreamingQueryException> x$1) {
        this.lastTerminatedQueryException = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.nanoTime();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
            bl = this.lastTerminatedQueryException() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQueryException_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.listenerBus().listeners()).asScala()).toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent) {
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        WriteToStreamStatement dataStreamWritePlan = new WriteToStreamStatement(userSpecifiedName, userSpecifiedCheckpointLocation, useTempCheckpointLocation, recoverFromCheckpointLocation, sink, outputMode, df.sparkSession().sessionState().newHadoopConf(), trigger instanceof ContinuousTrigger, analyzedPlan, catalogAndIdent);
        WriteToStream analyzedStreamWritePlan = (WriteToStream)this.sparkSession.sessionState().executePlan((LogicalPlan)dataStreamWritePlan, this.sparkSession.sessionState().executePlan$default$2()).analyzed();
        Tuple2 tuple2 = new Tuple2((Object)sink, (Object)trigger);
        if (tuple2 == null) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan));
        Trigger trigger2 = (Trigger)tuple2._2();
        if (!(tuple2._1() instanceof SupportsWrite)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan));
        if (!(trigger2 instanceof ContinuousTrigger)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan));
        ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
        return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, continuousTrigger, triggerClock, extraOptions, analyzedStreamWritePlan));
    }

    private Option<Tuple2<TableCatalog, Identifier>> createQuery$default$11() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent) throws TimeoutException {
        None$ none$;
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock, catalogAndIdent);
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            None$ none$2;
            userSpecifiedName.foreach((Function1 & Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            Option activeOption = Option$.MODULE$.apply((Object)this.sparkSession.sharedState().activeStreamingQueries().get(query.id())).orElse((Function0 & Serializable)() -> this.activeQueries().get((Object)query.id()));
            boolean shouldStopActiveRun = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART()));
            if (activeOption.isDefined()) {
                if (!shouldStopActiveRun) throw new IllegalStateException(new StringBuilder(25).append(new StringBuilder(61).append("Cannot start query with id ").append(query.id()).append(" as another query with same id is ").toString()).append("already active. Perhaps you are attempting to restart a query from checkpoint ").append("that is already active. You may stop the old query by setting the SQL ").append("configuration: ").append(new StringBuilder(25).append("spark.conf.set(\"").append(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART().key()).append("\", true) ").toString()).append("and retry.").toString());
                StreamingQuery oldQuery = (StreamingQuery)activeOption.get();
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(40).append("Stopping existing streaming query [id=").append(query.id()).append(", ").toString()).append(new StringBuilder(39).append("runId=").append(oldQuery.runId()).append("], as a new run is being started.").toString()).toString());
                none$2 = new Some((Object)oldQuery);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ activeRunOpt = none$;
        activeRunOpt.foreach((Function1 & Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        Object object2 = this.activeQueriesSharedLock();
        synchronized (object2) {
            StreamExecution oldActiveQuery = this.sparkSession.sharedState().activeStreamingQueries().put(query.id(), query.streamingQuery());
            if (oldActiveQuery != null) {
                throw QueryExecutionErrors$.MODULE$.concurrentQueryInstanceError();
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
            return query;
        }
        catch (Throwable e) {
            this.unregisterTerminatedStream(query);
            throw e;
        }
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return Trigger.ProcessingTime(0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public Option<Tuple2<TableCatalog, Identifier>> startQuery$default$11() {
        return None$.MODULE$;
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        this.unregisterTerminatedStream(terminatedQuery);
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            if (this.lastTerminatedQueryException() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQueryException_$eq(terminatedQuery.exception());
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    private void unregisterTerminatedStream(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            this.sparkSession.sharedState().activeStreamingQueries().remove(terminatedQuery.id(), terminatedQuery);
            HashMap cfr_ignored_0 = (HashMap)this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Registered listener ").append(listener.getClass().getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$new$1(StreamingQueryManager $this, Seq classNames) {
        Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, $this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable)listener -> {
            StreamingQueryManager.$anonfun$new$2($this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.nanoTime() - startTime$1 >= TimeUnit.MILLISECONDS.toNanos(timeoutMs$1);
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$1)))) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(41).append("Cannot start query with name ").append(name).append(" as a query ").toString()).append("with that name is already active in this SparkSession").toString());
        }
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus((Option<LiveListenerBus>)new Some((Object)sparkSession.sparkContext().listenerBus()));
        this.activeQueries = new HashMap();
        this.activeQueriesSharedLock = sparkSession.sharedState().activeQueriesLock();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQueryException = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable)classNames -> {
                StreamingQueryManager.$anonfun$new$1(this, classNames);
                return BoxedUnit.UNIT;
            });
            sparkSession.sharedState().streamingQueryStatusListener().foreach((Function1 & Serializable)listener -> {
                this.addListener(listener);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw QueryExecutionErrors$.MODULE$.registeringStreamingQueryListenerError(e);
        }
    }
}

