/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnDictionary;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.StringType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0015vAB\u001e=\u0011\u0003s$J\u0002\u0004My!\u0005e(\u0014\u0005\u0006O\u0006!\t\u0001\u001b\u0005\bS\u0006\u0011\r\u0011\"\u0011k\u0011\u0019q\u0017\u0001)A\u0005W\"9q.\u0001b\u0001\n\u0003\u0001\bB\u0002;\u0002A\u0003%\u0011\u000fC\u0003v\u0003\u0011\u0005c\u000fC\u0004\u0002D\u0006!\t%!2\t\u000f\tM\u0013\u0001\"\u0011\u0003V\u00191\u00111Z\u0001\u0001\u0003\u001bD!\"!\f\u000b\u0005\u0003\u0005\u000b\u0011BAm\u0011\u00199'\u0002\"\u0001\u0002\\\"A\u0011\u0011\u001d\u0006A\u0002\u0013%!\u000eC\u0005\u0002d*\u0001\r\u0011\"\u0003\u0002f\"9\u0011\u0011\u001e\u0006!B\u0013Y\u0007\"CAv\u0015\u0001\u0007I\u0011BAM\u0011%\tiO\u0003a\u0001\n\u0013\ty\u000f\u0003\u0005\u0002t*\u0001\u000b\u0015BAN\u0011!\t)P\u0003a\u0001\n\u0013Q\u0007\"CA|\u0015\u0001\u0007I\u0011BA}\u0011\u001d\tiP\u0003Q!\n-D\u0011\"a@\u000b\u0001\u0004%IA!\u0001\t\u0013\te!\u00021A\u0005\n\tm\u0001\u0002\u0003B\u0010\u0015\u0001\u0006KAa\u0001\t\u0013\u0005\r#B1A\u0005\n\t\u0005\u0002\u0002CA*\u0015\u0001\u0006IAa\t\t\u0011\t%\"\u00021A\u0005\n)D\u0011Ba\u000b\u000b\u0001\u0004%IA!\f\t\u000f\tE\"\u0002)Q\u0005W\"9!1\u0007\u0006\u0005B\tU\u0002b\u0002B\u001e\u0015\u0011\u0005#Q\b\u0005\u0007\u0005\u000fRA\u0011\t6\t\r\t%#\u0002\"\u0011k\r\u0011Q\u0018\u0001A>\t\u0015\u0005m!E!A!\u0002\u0013\ti\u0002\u0003\u0006\u0002.\t\u0012\t\u0011)A\u0005\u0003_Aaa\u001a\u0012\u0005\u0002\u0005]\u0002\u0002CA E\t\u0007I\u0011\u00016\t\u000f\u0005\u0005#\u0005)A\u0005W\"I\u00111\t\u0012C\u0002\u0013%\u0011Q\t\u0005\t\u0003'\u0012\u0003\u0015!\u0003\u0002H!I\u0011Q\u000b\u0012A\u0002\u0013%\u0011q\u000b\u0005\n\u00037\u0012\u0003\u0019!C\u0005\u0003;B\u0001\"!\u001b#A\u0003&\u0011\u0011\f\u0005\n\u0003W\u0012\u0003\u0019!C\u0005\u0003[B\u0011\"a\u001e#\u0001\u0004%I!!\u001f\t\u0011\u0005u$\u0005)Q\u0005\u0003_Bq!a #\t\u0003\n\t\tC\u0004\u0002\u0018\n\"\t%!'\t\u000f\u0005\u0005&\u0005\"\u0011\u0002$\"I!\u0011N\u0001\u0002\u0002\u0013\u0005#1\u000e\u0005\t\u0005s\n\u0011\u0011!C\u0001U\"I!1P\u0001\u0002\u0002\u0013\u0005!Q\u0010\u0005\n\u0005\u0003\u000b\u0011\u0011!C!\u0005\u0007C\u0011B!$\u0002\u0003\u0003%\tAa$\t\u0013\tM\u0015!!A\u0005B\tU\u0005\"\u0003BL\u0003\u0005\u0005I\u0011\tBM\u0011%\u0011Y*AA\u0001\n\u0013\u0011i*\u0001\nES\u000e$\u0018n\u001c8bef,enY8eS:<'BA\u001f?\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005}\u0002\u0015\u0001C2pYVlg.\u0019:\u000b\u0005\u0005\u0013\u0015!C3yK\u000e,H/[8o\u0015\t\u0019E)A\u0002tc2T!!\u0012$\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dC\u0015AB1qC\u000eDWMC\u0001J\u0003\ry'o\u001a\t\u0003\u0017\u0006i\u0011\u0001\u0010\u0002\u0013\t&\u001cG/[8oCJLXI\\2pI&twmE\u0003\u0002\u001dR;&\f\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006K\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0017VK!A\u0016\u001f\u0003#\r{W\u000e\u001d:fgNLwN\\*dQ\u0016lW\r\u0005\u0002P1&\u0011\u0011\f\u0015\u0002\b!J|G-^2u!\tYFM\u0004\u0002]E:\u0011Q,Y\u0007\u0002=*\u0011q\fY\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\t\u0011+\u0003\u0002d!\u00069\u0001/Y2lC\u001e,\u0017BA3g\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0019\u0007+\u0001\u0004=S:LGO\u0010\u000b\u0002\u0015\u00061A/\u001f9f\u0013\u0012,\u0012a\u001b\t\u0003\u001f2L!!\u001c)\u0003\u0007%sG/A\u0004usB,\u0017\n\u001a\u0011\u0002\u001b5\u000b\u0005l\u0018#J\u0007R{6+\u0013.F+\u0005\t\bCA(s\u0013\t\u0019\bKA\u0003TQ>\u0014H/\u0001\bN\u0003b{F)S\"U?NK%,\u0012\u0011\u0002\u000f\u0011,7m\u001c3feV\u0019q/a/\u0015\u000ba\fi,a0\u0011\te\u0014\u0013\u0011X\u0007\u0002\u0003\t9A)Z2pI\u0016\u0014Xc\u0001?\u0002\u0004M\u0019!ET?\u0011\u0007-sx0\u0003\u0002{yA!\u0011\u0011AA\u0002\u0019\u0001!q!!\u0002#\u0005\u0004\t9AA\u0001U#\u0011\tI!a\u0004\u0011\u0007=\u000bY!C\u0002\u0002\u000eA\u0013qAT8uQ&tw\r\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BQ\u0001\u0006if\u0004Xm]\u0005\u0005\u00033\t\u0019B\u0001\u0006Bi>l\u0017n\u0019+za\u0016\faAY;gM\u0016\u0014\b\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0004]&|'BAA\u0014\u0003\u0011Q\u0017M^1\n\t\u0005-\u0012\u0011\u0005\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018AC2pYVlg\u000eV=qKB)\u0011\u0011GA\u001a\u007f6\ta(C\u0002\u00026y\u0012\u0001CT1uSZ,7i\u001c7v[:$\u0016\u0010]3\u0015\r\u0005e\u00121HA\u001f!\rI(e \u0005\b\u00037)\u0003\u0019AA\u000f\u0011\u001d\ti#\na\u0001\u0003_\t!\"\u001a7f[\u0016tGOT;n\u0003-)G.Z7f]RtU/\u001c\u0011\u0002\u0015\u0011L7\r^5p]\u0006\u0014\u00180\u0006\u0002\u0002HA)q*!\u0013\u0002N%\u0019\u00111\n)\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\u000by%C\u0002\u0002RA\u00131!\u00118z\u0003-!\u0017n\u0019;j_:\f'/\u001f\u0011\u0002\u001b%tG\u000fR5di&|g.\u0019:z+\t\tI\u0006\u0005\u0003P\u0003\u0013Z\u0017!E5oi\u0012K7\r^5p]\u0006\u0014\u0018p\u0018\u0013fcR!\u0011qLA3!\ry\u0015\u0011M\u0005\u0004\u0003G\u0002&\u0001B+oSRD\u0011\"a\u001a,\u0003\u0003\u0005\r!!\u0017\u0002\u0007a$\u0013'\u0001\bj]R$\u0015n\u0019;j_:\f'/\u001f\u0011\u0002\u001d1|gn\u001a#jGRLwN\\1ssV\u0011\u0011q\u000e\t\u0006\u001f\u0006%\u0013\u0011\u000f\t\u0004\u001f\u0006M\u0014bAA;!\n!Aj\u001c8h\u0003IawN\\4ES\u000e$\u0018n\u001c8bef|F%Z9\u0015\t\u0005}\u00131\u0010\u0005\n\u0003Or\u0013\u0011!a\u0001\u0003_\nq\u0002\\8oO\u0012K7\r^5p]\u0006\u0014\u0018\u0010I\u0001\u0005]\u0016DH\u000f\u0006\u0004\u0002`\u0005\r\u00151\u0013\u0005\b\u0003\u000b\u0003\u0004\u0019AAD\u0003\r\u0011xn\u001e\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\"\u0002\u0011\r\fG/\u00197zgRLA!!%\u0002\f\nY\u0011J\u001c;fe:\fGNU8x\u0011\u0019\t)\n\ra\u0001W\u00069qN\u001d3j]\u0006d\u0017a\u00025bg:+\u0007\u0010^\u000b\u0003\u00037\u00032aTAO\u0013\r\ty\n\u0015\u0002\b\u0005>|G.Z1o\u0003)!WmY8naJ,7o\u001d\u000b\u0007\u0003?\n)+!.\t\u000f\u0005\u001d&\u00071\u0001\u0002*\u0006a1m\u001c7v[:4Vm\u0019;peB!\u00111VAY\u001b\t\tiKC\u0002\u00020\u0002\u000b!B^3di>\u0014\u0018N_3e\u0013\u0011\t\u0019,!,\u0003)]\u0013\u0018\u000e^1cY\u0016\u001cu\u000e\\;n]Z+7\r^8s\u0011\u0019\t9L\ra\u0001W\u0006A1-\u00199bG&$\u0018\u0010\u0005\u0003\u0002\u0002\u0005mFaBA\u0003\u000f\t\u0007\u0011q\u0001\u0005\b\u000379\u0001\u0019AA\u000f\u0011\u001d\tic\u0002a\u0001\u0003\u0003\u0004b!!\r\u00024\u0005e\u0016aB3oG>$WM]\u000b\u0005\u0003\u000f\u0014i\u0005\u0006\u0003\u0002J\n=\u0003\u0003B=\u000b\u0005\u0017\u0012q!\u00128d_\u0012,'/\u0006\u0003\u0002P\u0006]7\u0003\u0002\u0006O\u0003#\u0004RaSAj\u0003+L1!a3=!\u0011\t\t!a6\u0005\u000f\u0005\u0015!B1\u0001\u0002\bA1\u0011\u0011GA\u001a\u0003+$B!!8\u0002`B!\u0011PCAk\u0011\u001d\ti\u0003\u0004a\u0001\u00033\f\u0011cX;oG>l\u0007O]3tg\u0016$7+\u001b>f\u0003UyVO\\2p[B\u0014Xm]:fINK'0Z0%KF$B!a\u0018\u0002h\"A\u0011q\r\b\u0002\u0002\u0003\u00071.\u0001\n`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\u0004\u0013\u0001C8wKJ4Gn\\<\u0002\u0019=4XM\u001d4m_^|F%Z9\u0015\t\u0005}\u0013\u0011\u001f\u0005\n\u0003O\n\u0012\u0011!a\u0001\u00037\u000b\u0011b\u001c<fe\u001adwn\u001e\u0011\u0002\u000b\r|WO\u001c;\u0002\u0013\r|WO\u001c;`I\u0015\fH\u0003BA0\u0003wD\u0001\"a\u001a\u0015\u0003\u0003\u0005\ra[\u0001\u0007G>,h\u000e\u001e\u0011\u0002\rY\fG.^3t+\t\u0011\u0019\u0001\u0005\u0004\u0003\u0006\t=!1C\u0007\u0003\u0005\u000fQAA!\u0003\u0003\f\u00059Q.\u001e;bE2,'b\u0001B\u0007!\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE!q\u0001\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0003\u0002V\nU\u0011\u0002\u0002B\f\u0003/\u0011A\"\u00138uKJt\u0017\r\u001c+za\u0016\f!B^1mk\u0016\u001cx\fJ3r)\u0011\tyF!\b\t\u0013\u0005\u001dt#!AA\u0002\t\r\u0011a\u0002<bYV,7\u000fI\u000b\u0003\u0005G\u0001rA!\u0002\u0003&\u00055\u0013/\u0003\u0003\u0003(\t\u001d!a\u0002%bg\"l\u0015\r]\u0001\u000fI&\u001cG/[8oCJL8+\u001b>f\u0003I!\u0017n\u0019;j_:\f'/_*ju\u0016|F%Z9\u0015\t\u0005}#q\u0006\u0005\t\u0003Ob\u0012\u0011!a\u0001W\u0006yA-[2uS>t\u0017M]=TSj,\u0007%\u0001\u000ehCRDWM]\"p[B\u0014Xm]:jE&d\u0017\u000e^=Ti\u0006$8\u000f\u0006\u0004\u0002`\t]\"\u0011\b\u0005\b\u0003\u000bs\u0002\u0019AAD\u0011\u0019\t)J\ba\u0001W\u0006A1m\\7qe\u0016\u001c8\u000f\u0006\u0004\u0002\u001e\t}\"1\t\u0005\b\u0005\u0003z\u0002\u0019AA\u000f\u0003\u00111'o\\7\t\u000f\t\u0015s\u00041\u0001\u0002\u001e\u0005\u0011Ao\\\u0001\u0011k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\fabY8naJ,7o]3e'&TX\r\u0005\u0003\u0002\u0002\t5CaBA\u0003\u0011\t\u0007\u0011q\u0001\u0005\b\u0003[A\u0001\u0019\u0001B)!\u0019\t\t$a\r\u0003L\u0005A1/\u001e9q_J$8\u000f\u0006\u0003\u0002\u001c\n]\u0003bBA\u0017\u0013\u0001\u0007!\u0011\f\u0019\u0005\u00057\u0012\u0019\u0007\u0005\u0004\u00022\tu#\u0011M\u0005\u0004\u0005?r$AC\"pYVlg\u000eV=qKB!\u0011\u0011\u0001B2\t1\u0011)Ga\u0016\u0002\u0002\u0003\u0005)\u0011\u0001B4\u0005\ryFeM\t\u0005\u0003\u0013\ti%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005[\u0002BAa\u001c\u0003v5\u0011!\u0011\u000f\u0006\u0005\u0005g\n)#\u0001\u0003mC:<\u0017\u0002\u0002B<\u0005c\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001b\u0012y\b\u0003\u0005\u0002hU\n\t\u00111\u0001l\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BC!\u0019\u00119I!#\u0002N5\u0011!1B\u0005\u0005\u0005\u0017\u0013YA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAN\u0005#C\u0011\"a\u001a8\u0003\u0003\u0005\r!!\u0014\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a[\u0001\ti>\u001cFO]5oOR\u0011!QN\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005?\u0003BAa\u001c\u0003\"&!!1\u0015B9\u0005\u0019y%M[3di\u0002")
public final class DictionaryEncoding {
    public static String toString() {
        return DictionaryEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return DictionaryEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return DictionaryEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return DictionaryEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return DictionaryEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return DictionaryEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return DictionaryEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return DictionaryEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return DictionaryEncoding$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return DictionaryEncoding$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static short MAX_DICT_SIZE() {
        return DictionaryEncoding$.MODULE$.MAX_DICT_SIZE();
    }

    public static int typeId() {
        return DictionaryEncoding$.MODULE$.typeId();
    }

    public static Iterator<String> productElementNames() {
        return DictionaryEncoding$.MODULE$.productElementNames();
    }

    public static String productElementName(int n) {
        return DictionaryEncoding$.MODULE$.productElementName(n);
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private final int elementNum;
        private final Object[] dictionary;
        private int[] intDictionary;
        private long[] longDictionary;

        public int elementNum() {
            return this.elementNum;
        }

        private Object[] dictionary() {
            return this.dictionary;
        }

        private int[] intDictionary() {
            return this.intDictionary;
        }

        private void intDictionary_$eq(int[] x$1) {
            this.intDictionary = x$1;
        }

        private long[] longDictionary() {
            return this.longDictionary;
        }

        private void longDictionary_$eq(long[] x$1) {
            this.longDictionary = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.setField(row, ordinal, this.dictionary()[this.buffer.getShort()]);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int pos;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            T t = this.columnType.dataType();
            if (t instanceof IntegerType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.intDictionary()));
                for (pos = 0; pos < capacity; ++pos) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                        continue;
                    }
                    if (++seenNulls < nullCount) {
                        nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                    }
                    columnVector.putNull(pos);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.longDictionary()));
                while (pos < capacity) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                    } else {
                        if (++seenNulls < nullCount) {
                            nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                        }
                        columnVector.putNull(pos);
                    }
                    ++pos;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException("Not supported type in DictionaryEncoding.");
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.elementNum = ByteBufferHelper$.MODULE$.getInt(buffer);
            this.dictionary = new Object[this.elementNum()];
            this.intDictionary = null;
            this.longDictionary = null;
            T t = columnType.dataType();
            if (t instanceof IntegerType) {
                this.intDictionary_$eq(new int[this.elementNum()]);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    int v;
                    $this.intDictionary()[i] = v = BoxesRunTime.unboxToInt($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToInteger((int)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                this.longDictionary_$eq(new long[this.elementNum()]);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    long v;
                    $this.longDictionary()[i] = v = BoxesRunTime.unboxToLong($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToLong((long)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof StringType) {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    Object v = $this.columnType.extract($this.buffer);
                    $this.dictionary()[i] = v;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(t);
            }
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private boolean overflow;
        private int count;
        private ArrayBuffer<Object> values;
        private final HashMap<Object, Object> dictionary;
        private int dictionarySize;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private boolean overflow() {
            return this.overflow;
        }

        private void overflow_$eq(boolean x$1) {
            this.overflow = x$1;
        }

        private int count() {
            return this.count;
        }

        private void count_$eq(int x$1) {
            this.count = x$1;
        }

        private ArrayBuffer<Object> values() {
            return this.values;
        }

        private void values_$eq(ArrayBuffer<Object> x$1) {
            this.values = x$1;
        }

        private HashMap<Object, Object> dictionary() {
            return this.dictionary;
        }

        private int dictionarySize() {
            return this.dictionarySize;
        }

        private void dictionarySize_$eq(int x$1) {
            this.dictionarySize = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            block3: {
                Object value = this.columnType.getField(row, ordinal);
                if (this.overflow()) break block3;
                int actualSize = this.columnType.actualSize(row, ordinal);
                this.count_$eq(this.count() + 1);
                this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
                if (!this.dictionary().contains(value)) {
                    if (this.dictionary().size() < DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
                        Object clone = this.columnType.clone(value);
                        this.values().$plus$eq(clone);
                        this.dictionarySize_$eq(this.dictionarySize() + actualSize);
                        this.dictionary().update(clone, (Object)BoxesRunTime.boxToShort((short)((short)this.dictionary().size())));
                    } else {
                        this.overflow_$eq(true);
                        this.values().clear();
                        this.dictionary().clear();
                    }
                }
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            if (this.overflow()) {
                throw QueryExecutionErrors$.MODULE$.useDictionaryEncodingWhenDictionaryOverflowError();
            }
            to.putInt(DictionaryEncoding$.MODULE$.typeId()).putInt(this.dictionary().size());
            for (int i = 0; i < this.values().length(); ++i) {
                this.columnType.append(this.values().apply(i), to);
            }
            while (from.hasRemaining()) {
                to.putShort(BoxesRunTime.unboxToShort((Object)this.dictionary().apply(this.columnType.extract(from))));
            }
            to.rewind();
            return to;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this.overflow() ? Integer.MAX_VALUE : this.dictionarySize() + this.count() * 2;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this.overflow = false;
            this.count = 0;
            this.values = new ArrayBuffer(1024);
            this.dictionary = HashMap$.MODULE$.empty();
            this.dictionarySize = 4;
        }
    }
}

