/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.execution.command.CreateTableLikeCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u0014(\u0001RB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t7\u0002\u0011\t\u0012)A\u0005/\"AA\f\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003X\u0011!q\u0006A!f\u0001\n\u0003y\u0006\u0002\u00034\u0001\u0005#\u0005\u000b\u0011\u00021\t\u0011\u001d\u0004!Q3A\u0005\u0002!D\u0001\u0002\u001e\u0001\u0003\u0012\u0003\u0006I!\u001b\u0005\tk\u0002\u0011)\u001a!C\u0001m\"A!\u0010\u0001B\tB\u0003%q\u000f\u0003\u0005|\u0001\tU\r\u0011\"\u0001}\u0011%\t\t\u0001\u0001B\tB\u0003%Q\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003\u0003\u0002\u0011\u0013!C\u0001\u0003\u0007B\u0011\"!\u0017\u0001#\u0003%\t!a\u0011\t\u0013\u0005m\u0003!%A\u0005\u0002\u0005u\u0003\"CA1\u0001E\u0005I\u0011AA2\u0011%\t9\u0007AI\u0001\n\u0003\tI\u0007C\u0005\u0002n\u0001\t\n\u0011\"\u0001\u0002p!I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003\u000b\u0003\u0011\u0011!C\u0001\u0003\u000fC\u0011\"a$\u0001\u0003\u0003%\t!!%\t\u0013\u0005u\u0005!!A\u0005B\u0005}\u0005\"CAW\u0001\u0005\u0005I\u0011AAX\u0011%\t\u0019\fAA\u0001\n\u0003\n)\fC\u0005\u0002:\u0002\t\t\u0011\"\u0011\u0002<\u001eI\u0011qX\u0014\u0002\u0002#\u0005\u0011\u0011\u0019\u0004\tM\u001d\n\t\u0011#\u0001\u0002D\"9\u00111\u0001\u0010\u0005\u0002\u0005m\u0007\"CAo=\u0005\u0005IQIAp\u0011%\t\tOHA\u0001\n\u0003\u000b\u0019\u000fC\u0005\u0002rz\t\n\u0011\"\u0001\u0002j!I\u00111\u001f\u0010\u0002\u0002\u0013\u0005\u0015Q\u001f\u0005\n\u0005\u0007q\u0012\u0013!C\u0001\u0003SB\u0011B!\u0002\u001f\u0003\u0003%IAa\u0002\u0003-\r\u0013X-\u0019;f)\u0006\u0014G.\u001a'jW\u0016\u001cu.\\7b]\u0012T!\u0001K\u0015\u0002\u000f\r|W.\\1oI*\u0011!fK\u0001\nKb,7-\u001e;j_:T!\u0001L\u0017\u0002\u0007M\fHN\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u001b@\u0007&\u0003\"AN\u001f\u000e\u0003]R!\u0001O\u001d\u0002\u000f1|w-[2bY*\u0011!hO\u0001\u0006a2\fgn\u001d\u0006\u0003y-\n\u0001bY1uC2L8\u000f^\u0005\u0003}]\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011\u0001)Q\u0007\u0002O%\u0011!i\n\u0002\u0014\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\b!J|G-^2u!\tQ%K\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011ajM\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019K!!U#\u0002\u000fA\f7m[1hK&\u00111\u000b\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003#\u0016\u000b1\u0002^1sO\u0016$H+\u00192mKV\tq\u000b\u0005\u0002Y36\t1(\u0003\u0002[w\tyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0007uCJ<W\r\u001e+bE2,\u0007%A\u0006t_V\u00148-\u001a+bE2,\u0017\u0001D:pkJ\u001cW\rV1cY\u0016\u0004\u0013A\u00034jY\u00164uN]7biV\t\u0001\r\u0005\u0002bI6\t!M\u0003\u0002dw\u000591-\u0019;bY><\u0017BA3c\u0005Q\u0019\u0015\r^1m_\u001e\u001cFo\u001c:bO\u00164uN]7bi\u0006Ya-\u001b7f\r>\u0014X.\u0019;!\u0003!\u0001(o\u001c<jI\u0016\u0014X#A5\u0011\u0007\u0011SG.\u0003\u0002l\u000b\n1q\n\u001d;j_:\u0004\"!\\9\u000f\u00059|\u0007C\u0001'F\u0013\t\u0001X)\u0001\u0004Qe\u0016$WMZ\u0005\u0003eN\u0014aa\u0015;sS:<'B\u00019F\u0003%\u0001(o\u001c<jI\u0016\u0014\b%\u0001\u0006qe>\u0004XM\u001d;jKN,\u0012a\u001e\t\u0005[bdG.\u0003\u0002zg\n\u0019Q*\u00199\u0002\u0017A\u0014x\u000e]3si&,7\u000fI\u0001\fS\u001atu\u000e^#ySN$8/F\u0001~!\t!e0\u0003\u0002\u0000\u000b\n9!i\\8mK\u0006t\u0017\u0001D5g\u001d>$X\t_5tiN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\b\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0011\u0005\u0001\u0003\u0001\"B+\u000e\u0001\u00049\u0006\"\u0002/\u000e\u0001\u00049\u0006\"\u00020\u000e\u0001\u0004\u0001\u0007\"B4\u000e\u0001\u0004I\u0007bB;\u000e!\u0003\u0005\ra\u001e\u0005\u0006w6\u0001\r!`\u0001\u0004eVtG\u0003BA\r\u0003O\u0001RASA\u000e\u0003?I1!!\bU\u0005\r\u0019V-\u001d\t\u0005\u0003C\t\u0019#D\u0001,\u0013\r\t)c\u000b\u0002\u0004%><\bbBA\u0015\u001d\u0001\u0007\u00111F\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003C\ti#C\u0002\u00020-\u0012Ab\u00159be.\u001cVm]:j_:\fAaY8qsRq\u0011qAA\u001b\u0003o\tI$a\u000f\u0002>\u0005}\u0002bB+\u0010!\u0003\u0005\ra\u0016\u0005\b9>\u0001\n\u00111\u0001X\u0011\u001dqv\u0002%AA\u0002\u0001DqaZ\b\u0011\u0002\u0003\u0007\u0011\u000eC\u0004v\u001fA\u0005\t\u0019A<\t\u000fm|\u0001\u0013!a\u0001{\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA#U\r9\u0016qI\u0016\u0003\u0003\u0013\u0002B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&A\u0005v]\u000eDWmY6fI*\u0019\u00111K#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u00055#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003?R3\u0001YA$\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!\u001a+\u0007%\f9%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005-$fA<\u0002H\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122TCAA9U\ri\u0018qI\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0006!!.\u0019<b\u0013\r\u0011\u00181P\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0013\u00032\u0001RAF\u0013\r\ti)\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003'\u000bI\nE\u0002E\u0003+K1!a&F\u0005\r\te.\u001f\u0005\n\u00037C\u0012\u0011!a\u0001\u0003\u0013\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAQ!\u0019\t\u0019+!+\u0002\u00146\u0011\u0011Q\u0015\u0006\u0004\u0003O+\u0015AC2pY2,7\r^5p]&!\u00111VAS\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007u\f\t\fC\u0005\u0002\u001cj\t\t\u00111\u0001\u0002\u0014\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9(a.\t\u0013\u0005m5$!AA\u0002\u0005%\u0015AB3rk\u0006d7\u000fF\u0002~\u0003{C\u0011\"a'\u001d\u0003\u0003\u0005\r!a%\u0002-\r\u0013X-\u0019;f)\u0006\u0014G.\u001a'jW\u0016\u001cu.\\7b]\u0012\u0004\"\u0001\u0011\u0010\u0014\u000by\t)-!5\u0011\u0019\u0005\u001d\u0017QZ,XA&<X0a\u0002\u000e\u0005\u0005%'bAAf\u000b\u00069!/\u001e8uS6,\u0017\u0002BAh\u0003\u0013\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87!\u0011\t\u0019.!7\u000e\u0005\u0005U'\u0002BAl\u0003\u007f\n!![8\n\u0007M\u000b)\u000e\u0006\u0002\u0002B\u0006AAo\\*ue&tw\r\u0006\u0002\u0002x\u0005)\u0011\r\u001d9msRq\u0011qAAs\u0003O\fI/a;\u0002n\u0006=\b\"B+\"\u0001\u00049\u0006\"\u0002/\"\u0001\u00049\u0006\"\u00020\"\u0001\u0004\u0001\u0007\"B4\"\u0001\u0004I\u0007bB;\"!\u0003\u0005\ra\u001e\u0005\u0006w\u0006\u0002\r!`\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u00059QO\\1qa2LH\u0003BA|\u0003\u007f\u0004B\u0001\u00126\u0002zBIA)a?X/\u0002Lw/`\u0005\u0004\u0003{,%A\u0002+va2,g\u0007C\u0005\u0003\u0002\r\n\t\u00111\u0001\u0002\b\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011I\u0001\u0005\u0003\u0002z\t-\u0011\u0002\u0002B\u0007\u0003w\u0012aa\u00142kK\u000e$\b")
public class CreateTableLikeCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier targetTable;
    private final TableIdentifier sourceTable;
    private final CatalogStorageFormat fileFormat;
    private final Option<String> provider;
    private final Map<String, String> properties;
    private final boolean ifNotExists;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Map<String, String> $lessinit$greater$default$5() {
        return CreateTableLikeCommand$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple6<TableIdentifier, TableIdentifier, CatalogStorageFormat, Option<String>, Map<String, String>, Object>> unapply(CreateTableLikeCommand createTableLikeCommand) {
        return CreateTableLikeCommand$.MODULE$.unapply(createTableLikeCommand);
    }

    public static Map<String, String> apply$default$5() {
        return CreateTableLikeCommand$.MODULE$.apply$default$5();
    }

    public static Function1<Tuple6<TableIdentifier, TableIdentifier, CatalogStorageFormat, Option<String>, Map<String, String>, Object>, CreateTableLikeCommand> tupled() {
        return CreateTableLikeCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<CatalogStorageFormat, Function1<Option<String>, Function1<Map<String, String>, Function1<Object, CreateTableLikeCommand>>>>>> curried() {
        return CreateTableLikeCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CreateTableLikeCommand createTableLikeCommand = this;
        synchronized (createTableLikeCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier targetTable() {
        return this.targetTable;
    }

    public TableIdentifier sourceTable() {
        return this.sourceTable;
    }

    public CatalogStorageFormat fileFormat() {
        return this.fileFormat;
    }

    public Option<String> provider() {
        return this.provider;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Object object;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable sourceTableDesc = catalog.getTempViewOrPermanentTableMetadata(this.sourceTable());
        if (this.provider().isDefined()) {
            Object object2 = !DDLUtils$.MODULE$.isHiveTable(this.provider()) ? DataSource$.MODULE$.lookupDataSource((String)this.provider().get(), sparkSession.sessionState().conf()) : BoxedUnit.UNIT;
            object = this.provider();
        } else if (this.fileFormat().inputFormat().isDefined()) {
            object = new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER());
        } else {
            CatalogTableType catalogTableType = sourceTableDesc.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            object = !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null) ? new Some((Object)sparkSession.sessionState().conf().defaultDataSourceName()) : sourceTableDesc.provider();
        }
        Some newProvider = object;
        CatalogStorageFormat newStorage = this.fileFormat().inputFormat().isDefined() ? this.fileFormat() : sourceTableDesc.storage().copy(this.fileFormat().locationUri(), sourceTableDesc.storage().copy$default$2(), sourceTableDesc.storage().copy$default$3(), sourceTableDesc.storage().copy$default$4(), sourceTableDesc.storage().copy$default$5(), sourceTableDesc.storage().copy$default$6());
        CatalogTableType tblType = newStorage.locationUri().isEmpty() ? CatalogTableType$.MODULE$.MANAGED() : CatalogTableType$.MODULE$.EXTERNAL();
        StructType newTableSchema = CharVarcharUtils$.MODULE$.getRawSchema(sourceTableDesc.schema());
        TableIdentifier x$1 = this.targetTable();
        CatalogTableType x$2 = tblType;
        CatalogStorageFormat x$3 = newStorage;
        StructType x$4 = newTableSchema;
        Some x$5 = newProvider;
        Seq x$6 = sourceTableDesc.partitionColumnNames();
        Option x$7 = sourceTableDesc.bucketSpec();
        Map<String, String> x$8 = this.properties();
        boolean x$9 = sourceTableDesc.tracksPartitionsInCatalog();
        String x$10 = CatalogTable$.MODULE$.apply$default$8();
        long x$11 = CatalogTable$.MODULE$.apply$default$9();
        long x$12 = CatalogTable$.MODULE$.apply$default$10();
        String x$13 = CatalogTable$.MODULE$.apply$default$11();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$14();
        Option x$16 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$17 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable newTableDesc = new CatalogTable(x$1, x$2, x$3, x$4, (Option)x$5, x$6, x$7, x$10, x$11, x$12, x$13, x$8, x$14, x$15, x$16, x$17, x$9, x$18, x$19, x$20);
        catalog.createTable(newTableDesc, this.ifNotExists(), catalog.createTable$default$3());
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public CreateTableLikeCommand copy(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Option<String> provider, Map<String, String> properties, boolean ifNotExists) {
        return new CreateTableLikeCommand(targetTable, sourceTable, fileFormat, provider, properties, ifNotExists);
    }

    public TableIdentifier copy$default$1() {
        return this.targetTable();
    }

    public TableIdentifier copy$default$2() {
        return this.sourceTable();
    }

    public CatalogStorageFormat copy$default$3() {
        return this.fileFormat();
    }

    public Option<String> copy$default$4() {
        return this.provider();
    }

    public Map<String, String> copy$default$5() {
        return this.properties();
    }

    public boolean copy$default$6() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "CreateTableLikeCommand";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.targetTable();
                break;
            }
            case 1: {
                object = this.sourceTable();
                break;
            }
            case 2: {
                object = this.fileFormat();
                break;
            }
            case 3: {
                object = this.provider();
                break;
            }
            case 4: {
                object = this.properties();
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateTableLikeCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "targetTable";
                break;
            }
            case 1: {
                string = "sourceTable";
                break;
            }
            case 2: {
                string = "fileFormat";
                break;
            }
            case 3: {
                string = "provider";
                break;
            }
            case 4: {
                string = "properties";
                break;
            }
            case 5: {
                string = "ifNotExists";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateTableLikeCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateTableLikeCommand createTableLikeCommand = (CreateTableLikeCommand)x$1;
        if (this.ifNotExists() != createTableLikeCommand.ifNotExists()) return false;
        TableIdentifier tableIdentifier = this.targetTable();
        TableIdentifier tableIdentifier2 = createTableLikeCommand.targetTable();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.sourceTable();
        TableIdentifier tableIdentifier4 = createTableLikeCommand.sourceTable();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        CatalogStorageFormat catalogStorageFormat = this.fileFormat();
        CatalogStorageFormat catalogStorageFormat2 = createTableLikeCommand.fileFormat();
        if (catalogStorageFormat == null) {
            if (catalogStorageFormat2 != null) {
                return false;
            }
        } else if (!catalogStorageFormat.equals(catalogStorageFormat2)) return false;
        Option<String> option = this.provider();
        Option<String> option2 = createTableLikeCommand.provider();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Map<String, String> map = this.properties();
        Map<String, String> map2 = createTableLikeCommand.properties();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!createTableLikeCommand.canEqual(this)) return false;
        return true;
    }

    public CreateTableLikeCommand(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Option<String> provider, Map<String, String> properties, boolean ifNotExists) {
        this.targetTable = targetTable;
        this.sourceTable = sourceTable;
        this.fileFormat = fileFormat;
        this.provider = provider;
        this.properties = properties;
        this.ifNotExists = ifNotExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

