/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.jdbc.AggregatedDialect;
import org.apache.spark.sql.jdbc.DB2Dialect$;
import org.apache.spark.sql.jdbc.DerbyDialect$;
import org.apache.spark.sql.jdbc.H2Dialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.MsSqlServerDialect$;
import org.apache.spark.sql.jdbc.MySQLDialect$;
import org.apache.spark.sql.jdbc.NoopDialect$;
import org.apache.spark.sql.jdbc.OracleDialect$;
import org.apache.spark.sql.jdbc.PostgresDialect$;
import org.apache.spark.sql.jdbc.TeradataDialect$;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
public final class JdbcDialects$ {
    public static final JdbcDialects$ MODULE$ = new JdbcDialects$();
    private static List<JdbcDialect> dialects = (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);

    static {
        MODULE$.registerDialect(MySQLDialect$.MODULE$);
        MODULE$.registerDialect(PostgresDialect$.MODULE$);
        MODULE$.registerDialect(DB2Dialect$.MODULE$);
        MODULE$.registerDialect(MsSqlServerDialect$.MODULE$);
        MODULE$.registerDialect(DerbyDialect$.MODULE$);
        MODULE$.registerDialect(OracleDialect$.MODULE$);
        MODULE$.registerDialect(TeradataDialect$.MODULE$);
        MODULE$.registerDialect(H2Dialect$.MODULE$);
    }

    public void registerDialect(JdbcDialect dialect) {
        JdbcDialect jdbcDialect = dialect;
        dialects = dialects.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JdbcDialects$.$anonfun$registerDialect$1(dialect, x$1))).$colon$colon((Object)jdbcDialect);
    }

    public void unregisterDialect(JdbcDialect dialect) {
        dialects = dialects.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JdbcDialects$.$anonfun$unregisterDialect$1(dialect, x$2)));
    }

    public JdbcDialect get(String url) {
        JdbcDialect jdbcDialect;
        List matchingDialects = dialects.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.canHandle(url)));
        int n = matchingDialects.length();
        switch (n) {
            case 0: {
                jdbcDialect = NoopDialect$.MODULE$;
                break;
            }
            case 1: {
                jdbcDialect = (JdbcDialect)matchingDialects.head();
                break;
            }
            default: {
                jdbcDialect = new AggregatedDialect((List<JdbcDialect>)matchingDialects);
                break;
            }
        }
        return jdbcDialect;
    }

    public static final /* synthetic */ boolean $anonfun$registerDialect$1(JdbcDialect dialect$1, JdbcDialect x$1) {
        JdbcDialect jdbcDialect = x$1;
        JdbcDialect jdbcDialect2 = dialect$1;
        return !(jdbcDialect != null ? !jdbcDialect.equals(jdbcDialect2) : jdbcDialect2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$unregisterDialect$1(JdbcDialect dialect$2, JdbcDialect x$2) {
        JdbcDialect jdbcDialect = x$2;
        JdbcDialect jdbcDialect2 = dialect$2;
        return !(jdbcDialect != null ? !jdbcDialect.equals(jdbcDialect2) : jdbcDialect2 != null);
    }

    private JdbcDialects$() {
    }
}

