/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.ObservationListener;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.QueryExecution;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006i\u0001!\t!\u000e\u0005\u0006i\u0001!\t!\u000f\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019y\u0004\u0001)A\u0005y!9\u0001\t\u0001a\u0001\n\u0013\t\u0005b\u0002%\u0001\u0001\u0004%I!\u0013\u0005\u0007\u001f\u0002\u0001\u000b\u0015\u0002\"\t\u000fQ\u0003\u0001\u0019!C\u0005+\"9Q\f\u0001a\u0001\n\u0013q\u0006B\u00021\u0001A\u0003&a\u000b\u0003\u0004c\u0001\u0011\u0005!d\u0019\u0005\u0006y\u0002!\t! \u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!!\u001c\u0001\t\u0013\ty\u0007\u0003\u0005\u0002r\u0001!\tAGA:\u000f\u001d\t)\t\u0007E\u0001\u0003\u000f3aa\u0006\r\t\u0002\u0005%\u0005B\u0002\u001b\u0014\t\u0003\tY\t\u0003\u0004\u0002\u000eN!\t!\u000f\u0005\b\u0003\u001b\u001bB\u0011AAH\u0005-y%m]3sm\u0006$\u0018n\u001c8\u000b\u0005eQ\u0012aA:rY*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0003oC6,\u0007C\u0001\u00162\u001d\tYs\u0006\u0005\u0002-I5\tQF\u0003\u0002/A\u00051AH]8pizJ!\u0001\r\u0013\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003a\u0011\na\u0001P5oSRtDC\u0001\u001c9!\t9\u0004!D\u0001\u0019\u0011\u0015A#\u00011\u0001*)\u00051\u0014\u0001\u00037jgR,g.\u001a:\u0016\u0003q\u0002\"aN\u001f\n\u0005yB\"aE(cg\u0016\u0014h/\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\u0018!\u00037jgR,g.\u001a:!\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\u0005\u0011\u0005cA\u0012D\u000b&\u0011A\t\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005]2\u0015BA$\u0019\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003A\u0019\b/\u0019:l'\u0016\u001c8/[8o?\u0012*\u0017\u000f\u0006\u0002K\u001bB\u00111eS\u0005\u0003\u0019\u0012\u0012A!\u00168ji\"9ajBA\u0001\u0002\u0004\u0011\u0015a\u0001=%c\u0005i1\u000f]1sWN+7o]5p]\u0002B#\u0001C)\u0011\u0005\r\u0012\u0016BA*%\u0005!1x\u000e\\1uS2,\u0017aB7fiJL7m]\u000b\u0002-B\u00191eQ,\u0011\t)B\u0016FW\u0005\u00033N\u00121!T1q!\t\u00193,\u0003\u0002]I\t\u0019\u0011I\\=\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003\u0015~CqA\u0014\u0006\u0002\u0002\u0003\u0007a+\u0001\u0005nKR\u0014\u0018nY:!Q\tY\u0011+\u0001\u0002p]V\u0011AM\u001b\u000b\u0005KB\u0014x\u000fE\u00028M\"L!a\u001a\r\u0003\u000f\u0011\u000bG/Y:fiB\u0011\u0011N\u001b\u0007\u0001\t\u0015YGB1\u0001m\u0005\u0005!\u0016CA7[!\t\u0019c.\u0003\u0002pI\t9aj\u001c;iS:<\u0007\"B9\r\u0001\u0004)\u0017A\u00013t\u0011\u0015\u0019H\u00021\u0001u\u0003\u0011)\u0007\u0010\u001d:\u0011\u0005]*\u0018B\u0001<\u0019\u0005\u0019\u0019u\u000e\\;n]\")\u0001\u0010\u0004a\u0001s\u0006)Q\r\u001f9sgB\u00191E\u001f;\n\u0005m$#A\u0003\u001fsKB,\u0017\r^3e}\u0005\u0019q-\u001a;\u0016\u0003y\u00044a`A\u0002!\u0015Q\u0003,KA\u0001!\rI\u00171\u0001\u0003\u000b\u0003\u000bi\u0011\u0011!A\u0001\u0006\u0003a'aA0%c!*Q\"!\u0003\u0002\"A)1%a\u0003\u0002\u0010%\u0019\u0011Q\u0002\u0013\u0003\rQD'o\\<t!\u0011\t\t\"a\u0007\u000f\t\u0005M\u0011q\u0003\b\u0004Y\u0005U\u0011\"A\u0013\n\u0007\u0005eA%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0011q\u0004\u0002\u0015\u0013:$XM\u001d:vaR,G-\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005eA%\r\u0004\u001fS\u0005\r\u0012qI\u0019\nG\u0005\u0015\u00121FA\u001f\u0003[)B!a\n\u0002*U\t\u0011\u0006\u0002\u0004lA\t\u0007\u00111G\u0005\u0005\u0003[\ty#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003c!\u0013A\u0002;ie><8/E\u0002n\u0003k\u0001B!a\u000e\u0002:9\u00191%a\u0006\n\t\u0005m\u0012q\u0004\u0002\n)\"\u0014xn^1cY\u0016\f\u0014bIA \u0003\u0003\n\u0019%!\r\u000f\u0007\r\n\t%C\u0002\u00022\u0011\nTAI\u0012%\u0003\u000b\u0012Qa]2bY\u0006\f4AJA\b\u0003%9W\r^!t\u0015\u00064\u0018-\u0006\u0002\u0002NA1\u0011qJA-S\tj!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0005kRLGN\u0003\u0002\u0002X\u0005!!.\u0019<b\u0013\rI\u0016\u0011\u000b\u0015\u0006\u001d\u0005%\u0011QL\u0019\u0007=%\ny&!\u001a2\u0013\r\n)#a\u000b\u0002b\u00055\u0012'C\u0012\u0002@\u0005\u0005\u00131MA\u0019c\u0015\u00113\u0005JA#c\r1\u0013qB\u0001\te\u0016<\u0017n\u001d;feR\u0019!*a\u001b\t\u000b\u0001{\u0001\u0019A#\u0002\u0015Ut'/Z4jgR,'\u000fF\u0001K\u0003!ygNR5oSNDGc\u0001&\u0002v!9\u0011qO\tA\u0002\u0005e\u0014AA9f!\u0011\tY(!!\u000e\u0005\u0005u$bAA@1\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0003\u0007\u000biH\u0001\bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8\u0002\u0017=\u00137/\u001a:wCRLwN\u001c\t\u0003oM\u0019\"a\u0005\u0012\u0015\u0005\u0005\u001d\u0015!B1qa2LHc\u0001\u001c\u0002\u0012\")\u0001F\u0006a\u0001S\u0001")
public class Observation {
    private final String name;
    private final ObservationListener listener;
    private volatile Option<SparkSession> sparkSession;
    private volatile Option<scala.collection.immutable.Map<String, Object>> metrics;

    public static Observation apply(String name) {
        return Observation$.MODULE$.apply(name);
    }

    public static Observation apply() {
        return Observation$.MODULE$.apply();
    }

    private ObservationListener listener() {
        return this.listener;
    }

    private Option<SparkSession> sparkSession() {
        return this.sparkSession;
    }

    private void sparkSession_$eq(Option<SparkSession> x$1) {
        this.sparkSession = x$1;
    }

    private Option<scala.collection.immutable.Map<String, Object>> metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Option<scala.collection.immutable.Map<String, Object>> x$1) {
        this.metrics = x$1;
    }

    public <T> Dataset<T> on(Dataset<T> ds, Column expr, Seq<Column> exprs) {
        if (ds.isStreaming()) {
            throw new IllegalArgumentException("Observation does not support streaming Datasets");
        }
        this.register(ds.sparkSession());
        return ds.observe(this.name, expr, exprs);
    }

    public scala.collection.immutable.Map<String, Object> get() throws InterruptedException {
        Observation observation = this;
        synchronized (observation) {
            while (this.metrics().isEmpty()) {
                this.wait();
            }
        }
        return (scala.collection.immutable.Map)this.metrics().get();
    }

    public java.util.Map<String, Object> getAsJava() throws InterruptedException {
        return JavaConverters$.MODULE$.mapAsJavaMap((Map)this.get().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, value);
            return tuple22;
        }));
    }

    private void register(SparkSession sparkSession) {
        Observation observation = this;
        synchronized (observation) {
            if (this.sparkSession().isDefined()) {
                throw new IllegalArgumentException("An Observation can be used with a Dataset only once");
            }
            this.sparkSession_$eq((Option<SparkSession>)new Some((Object)sparkSession));
        }
        sparkSession.listenerManager().register(this.listener());
    }

    private void unregister() {
        this.sparkSession().foreach((Function1 & Serializable)x$1 -> {
            Observation.$anonfun$unregister$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void onFinish(QueryExecution qe) {
        block1: {
            if (!this.metrics().isEmpty()) break block1;
            Option row = qe.observedMetrics().get((Object)this.name);
            this.metrics_$eq((Option<scala.collection.immutable.Map<String, Object>>)row.map((Function1 & Serializable)r -> r.getValuesMap((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)r.schema().fieldNames()))));
            if (this.metrics().isDefined()) {
                this.notifyAll();
                this.unregister();
            }
        }
    }

    public static final /* synthetic */ void $anonfun$unregister$1(Observation $this, SparkSession x$1) {
        x$1.listenerManager().unregister($this.listener());
    }

    public Observation(String name) {
        this.name = name;
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        this.listener = new ObservationListener(this);
        this.sparkSession = None$.MODULE$;
        this.metrics = None$.MODULE$;
    }

    public Observation() {
        this(UUID.randomUUID().toString());
    }
}

