/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.ShowTablesCommand$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001B\u0013'\u0001NB\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\tC\u0002\u0011\t\u0012)A\u0005-\"A!\r\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005d\u0001\tE\t\u0015!\u0003W\u0011!!\u0007A!f\u0001\n\u0003*\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00024\t\u0011A\u0004!Q3A\u0005\u0002ED\u0001\"\u001e\u0001\u0003\u0012\u0003\u0006IA\u001d\u0005\tm\u0002\u0011)\u001a!C\u0001o\"I\u0011Q\u0004\u0001\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ty\u0003\u0001C!\u0003cA\u0011\"a\u0012\u0001\u0003\u0003%\t!!\u0013\t\u0013\u0005U\u0003!%A\u0005\u0002\u0005]\u0003\"CA7\u0001E\u0005I\u0011AA,\u0011%\ty\u0007AI\u0001\n\u0003\t\t\bC\u0005\u0002v\u0001\t\n\u0011\"\u0001\u0002x!I\u00111\u0010\u0001\u0012\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003\u0003\u0003\u0011\u0011!C!\u0003\u0007C\u0011\"a%\u0001\u0003\u0003%\t!!&\t\u0013\u0005u\u0005!!A\u0005\u0002\u0005}\u0005\"CAV\u0001\u0005\u0005I\u0011IAW\u0011%\tY\fAA\u0001\n\u0003\ti\fC\u0005\u0002B\u0002\t\t\u0011\"\u0011\u0002D\"I\u0011q\u0019\u0001\u0002\u0002\u0013\u0005\u0013\u0011Z\u0004\n\u0003\u001b4\u0013\u0011!E\u0001\u0003\u001f4\u0001\"\n\u0014\u0002\u0002#\u0005\u0011\u0011\u001b\u0005\b\u0003?YB\u0011AAu\u0011%\tYoGA\u0001\n\u000b\ni\u000fC\u0005\u0002pn\t\t\u0011\"!\u0002r\"I\u0011Q`\u000e\u0012\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003\u007f\\\u0012\u0013!C\u0001\u0003{B\u0011B!\u0001\u001c\u0003\u0003%\tIa\u0001\t\u0013\tE1$%A\u0005\u0002\u0005]\u0004\"\u0003B\n7E\u0005I\u0011AA?\u0011%\u0011)bGA\u0001\n\u0013\u00119BA\tTQ><H+\u00192mKN\u001cu.\\7b]\u0012T!a\n\u0015\u0002\u000f\r|W.\\1oI*\u0011\u0011FK\u0001\nKb,7-\u001e;j_:T!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u001b?\u0005\"\u0003\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u000f1|w-[2bY*\u0011\u0011HO\u0001\u0006a2\fgn\u001d\u0006\u0003w)\n\u0001bY1uC2L8\u000f^\u0005\u0003{Y\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011q\bQ\u0007\u0002M%\u0011\u0011I\n\u0002\u0014\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\b!J|G-^2u!\tI\u0015K\u0004\u0002K\u001f:\u00111JT\u0007\u0002\u0019*\u0011QJM\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015K!\u0001\u0015#\u0002\u000fA\f7m[1hK&\u0011!k\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003!\u0012\u000bA\u0002Z1uC\n\f7/\u001a(b[\u0016,\u0012A\u0016\t\u0004\u0007^K\u0016B\u0001-E\u0005\u0019y\u0005\u000f^5p]B\u0011!L\u0018\b\u00037r\u0003\"a\u0013#\n\u0005u#\u0015A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!\u0018#\u0002\u001b\u0011\fG/\u00192bg\u0016t\u0015-\\3!\u0003Y!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b+\u0019;uKJt\u0017a\u0006;bE2,\u0017\nZ3oi&4\u0017.\u001a:QCR$XM\u001d8!\u0003\u0019yW\u000f\u001e9viV\ta\rE\u0002JO&L!\u0001[*\u0003\u0007M+\u0017\u000f\u0005\u0002k[6\t1N\u0003\u0002mu\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\tq7NA\u0005BiR\u0014\u0018NY;uK\u00069q.\u001e;qkR\u0004\u0013AC5t\u000bb$XM\u001c3fIV\t!\u000f\u0005\u0002Dg&\u0011A\u000f\u0012\u0002\b\u0005>|G.Z1o\u0003-I7/\u0012=uK:$W\r\u001a\u0011\u0002\u001bA\f'\u000f^5uS>t7\u000b]3d+\u0005A\bcA\"XsB\u0019!0a\u0006\u000f\u0007m\f\tBD\u0002}\u0003\u001bq1!`A\u0006\u001d\rq\u0018\u0011\u0002\b\u0004\u007f\u0006\u001da\u0002BA\u0001\u0003\u000bq1aSA\u0002\u0013\u0005\t\u0014BA\u00181\u0013\tic&\u0003\u0002,Y%\u00111HK\u0005\u0004\u0003\u001fQ\u0014aB2bi\u0006dwnZ\u0005\u0005\u0003'\t)\"\u0001\u0007DCR\fGn\\4UsB,7OC\u0002\u0002\u0010iJA!!\u0007\u0002\u001c\t\u0011B+\u00192mKB\u000b'\u000f^5uS>t7\u000b]3d\u0015\u0011\t\u0019\"!\u0006\u0002\u001dA\f'\u000f^5uS>t7\u000b]3dA\u00051A(\u001b8jiz\"B\"a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\u0001\"a\u0010\u0001\t\u000bQ[\u0001\u0019\u0001,\t\u000b\t\\\u0001\u0019\u0001,\t\u000b\u0011\\\u0001\u0019\u00014\t\u000fA\\\u0001\u0013!a\u0001e\"9ao\u0003I\u0001\u0002\u0004A\u0018a\u0001:v]R!\u00111GA\u001f!\u0011Iu-!\u000e\u0011\t\u0005]\u0012\u0011H\u0007\u0002U%\u0019\u00111\b\u0016\u0003\u0007I{w\u000fC\u0004\u0002@1\u0001\r!!\u0011\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005]\u00121I\u0005\u0004\u0003\u000bR#\u0001D*qCJ\\7+Z:tS>t\u0017\u0001B2paf$B\"a\t\u0002L\u00055\u0013qJA)\u0003'Bq\u0001V\u0007\u0011\u0002\u0003\u0007a\u000bC\u0004c\u001bA\u0005\t\u0019\u0001,\t\u000f\u0011l\u0001\u0013!a\u0001M\"9\u0001/\u0004I\u0001\u0002\u0004\u0011\bb\u0002<\u000e!\u0003\u0005\r\u0001_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIFK\u0002W\u00037Z#!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O\"\u0015AC1o]>$\u0018\r^5p]&!\u00111NA1\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u001d+\u0007\u0019\fY&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005e$f\u0001:\u0002\\\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA@U\rA\u00181L\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0005\u0003BAD\u0003#k!!!#\u000b\t\u0005-\u0015QR\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0010\u0006!!.\u0019<b\u0013\ry\u0016\u0011R\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003/\u00032aQAM\u0013\r\tY\n\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003C\u000b9\u000bE\u0002D\u0003GK1!!*E\u0005\r\te.\u001f\u0005\n\u0003S+\u0012\u0011!a\u0001\u0003/\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAX!\u0019\t\t,a.\u0002\"6\u0011\u00111\u0017\u0006\u0004\u0003k#\u0015AC2pY2,7\r^5p]&!\u0011\u0011XAZ\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007I\fy\fC\u0005\u0002*^\t\t\u00111\u0001\u0002\"\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t))!2\t\u0013\u0005%\u0006$!AA\u0002\u0005]\u0015AB3rk\u0006d7\u000fF\u0002s\u0003\u0017D\u0011\"!+\u001a\u0003\u0003\u0005\r!!)\u0002#MCwn\u001e+bE2,7oQ8n[\u0006tG\r\u0005\u0002@7M)1$a5\u0002`BY\u0011Q[An-Z3'\u000f_A\u0012\u001b\t\t9NC\u0002\u0002Z\u0012\u000bqA];oi&lW-\u0003\u0003\u0002^\u0006]'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8okA!\u0011\u0011]At\u001b\t\t\u0019O\u0003\u0003\u0002f\u00065\u0015AA5p\u0013\r\u0011\u00161\u001d\u000b\u0003\u0003\u001f\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000b\u000bQ!\u00199qYf$B\"a\t\u0002t\u0006U\u0018q_A}\u0003wDQ\u0001\u0016\u0010A\u0002YCQA\u0019\u0010A\u0002YCQ\u0001\u001a\u0010A\u0002\u0019Dq\u0001\u001d\u0010\u0011\u0002\u0003\u0007!\u000fC\u0004w=A\u0005\t\u0019\u0001=\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)A!\u0004\u0011\t\r;&q\u0001\t\t\u0007\n%aK\u00164sq&\u0019!1\u0002#\u0003\rQ+\b\u000f\\36\u0011%\u0011y!IA\u0001\u0002\u0004\t\u0019#A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u001aA!\u0011q\u0011B\u000e\u0013\u0011\u0011i\"!#\u0003\r=\u0013'.Z2u\u0001")
public class ShowTablesCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final Option<String> databaseName;
    private final Option<String> tableIdentifierPattern;
    private final Seq<Attribute> output;
    private final boolean isExtended;
    private final Option<Map<String, String>> partitionSpec;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Map<String, String>> $lessinit$greater$default$5() {
        return ShowTablesCommand$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return ShowTablesCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Option<String>, Option<String>, Seq<Attribute>, Object, Option<Map<String, String>>>> unapply(ShowTablesCommand x$0) {
        return ShowTablesCommand$.MODULE$.unapply(x$0);
    }

    public static Option<Map<String, String>> apply$default$5() {
        return ShowTablesCommand$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return ShowTablesCommand$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<Option<String>, Option<String>, Seq<Attribute>, Object, Option<Map<String, String>>>, ShowTablesCommand> tupled() {
        return ShowTablesCommand$.MODULE$.tupled();
    }

    public static Function1<Option<String>, Function1<Option<String>, Function1<Seq<Attribute>, Function1<Object, Function1<Option<Map<String, String>>, ShowTablesCommand>>>>> curried() {
        return ShowTablesCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        ShowTablesCommand showTablesCommand = this;
        synchronized (showTablesCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Option<String> databaseName() {
        return this.databaseName;
    }

    public Option<String> tableIdentifierPattern() {
        return this.tableIdentifierPattern;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Seq seq;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        String db = (String)this.databaseName().getOrElse((Function0 & Serializable)() -> catalog.getCurrentDatabase());
        if (this.partitionSpec().isEmpty()) {
            Seq tables = (Seq)this.tableIdentifierPattern().map((Function1 & Serializable)x$19 -> catalog.listTables(db, x$19)).getOrElse((Function0 & Serializable)() -> catalog.listTables(db));
            seq = (Seq)tables.map((Function1 & Serializable)tableIdent -> {
                Row row;
                String database = (String)tableIdent.database().getOrElse((Function0 & Serializable)() -> "");
                String tableName = tableIdent.table();
                boolean isTemp = catalog.isTempView(tableIdent);
                if (this.isExtended()) {
                    String information = catalog.getTempViewOrPermanentTableMetadata(tableIdent).simpleString();
                    row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, BoxesRunTime.boxToBoolean((boolean)isTemp), new StringBuilder(1).append(information).append("\n").toString()}));
                } else {
                    row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, BoxesRunTime.boxToBoolean((boolean)isTemp)}));
                }
                return row;
            });
        } else {
            CatalogTable table = catalog.getTableMetadata(new TableIdentifier((String)this.tableIdentifierPattern().get(), (Option)new Some((Object)db)));
            DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "SHOW TABLE EXTENDED");
            TableIdentifier tableIdent2 = table.identifier();
            Map normalizedSpec = PartitioningUtils$.MODULE$.normalizePartitionSpec((Map)this.partitionSpec().get(), table.partitionSchema(), tableIdent2.quotedString(), sparkSession.sessionState().conf().resolver());
            CatalogTablePartition partition = catalog.getPartition(tableIdent2, normalizedSpec);
            String database = (String)tableIdent2.database().getOrElse((Function0 & Serializable)() -> "");
            String tableName = tableIdent2.table();
            boolean isTemp = catalog.isTempView(tableIdent2);
            String information = partition.simpleString();
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, BoxesRunTime.boxToBoolean((boolean)isTemp), new StringBuilder(1).append(information).append("\n").toString()}))}));
        }
        return seq;
    }

    public ShowTablesCommand copy(Option<String> databaseName, Option<String> tableIdentifierPattern, Seq<Attribute> output, boolean isExtended, Option<Map<String, String>> partitionSpec) {
        return new ShowTablesCommand(databaseName, tableIdentifierPattern, output, isExtended, partitionSpec);
    }

    public Option<String> copy$default$1() {
        return this.databaseName();
    }

    public Option<String> copy$default$2() {
        return this.tableIdentifierPattern();
    }

    public Seq<Attribute> copy$default$3() {
        return this.output();
    }

    public boolean copy$default$4() {
        return this.isExtended();
    }

    public Option<Map<String, String>> copy$default$5() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "ShowTablesCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.databaseName();
                break;
            }
            case 1: {
                object = this.tableIdentifierPattern();
                break;
            }
            case 2: {
                object = this.output();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isExtended());
                break;
            }
            case 4: {
                object = this.partitionSpec();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShowTablesCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "databaseName";
                break;
            }
            case 1: {
                string = "tableIdentifierPattern";
                break;
            }
            case 2: {
                string = "output";
                break;
            }
            case 3: {
                string = "isExtended";
                break;
            }
            case 4: {
                string = "partitionSpec";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShowTablesCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShowTablesCommand showTablesCommand = (ShowTablesCommand)x$1;
        if (this.isExtended() != showTablesCommand.isExtended()) return false;
        Option<String> option = this.databaseName();
        Option<String> option2 = showTablesCommand.databaseName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.tableIdentifierPattern();
        Option<String> option4 = showTablesCommand.tableIdentifierPattern();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Seq<Attribute> seq = this.output();
        Seq<Attribute> seq2 = showTablesCommand.output();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Map<String, String>> option5 = this.partitionSpec();
        Option<Map<String, String>> option6 = showTablesCommand.partitionSpec();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!showTablesCommand.canEqual(this)) return false;
        return true;
    }

    public ShowTablesCommand(Option<String> databaseName, Option<String> tableIdentifierPattern, Seq<Attribute> output, boolean isExtended, Option<Map<String, String>> partitionSpec) {
        this.databaseName = databaseName;
        this.tableIdentifierPattern = tableIdentifierPattern;
        this.output = output;
        this.isExtended = isExtended;
        this.partitionSpec = partitionSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

