/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.lifecycle;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flume.FlumeException;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.util.concurrent.ThreadFactoryBuilder;

public class LifecycleSupervisor
implements LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(LifecycleSupervisor.class);
    private Map<LifecycleAware, Supervisoree> supervisedProcesses;
    private Map<LifecycleAware, ScheduledFuture<?>> monitorFutures;
    private ScheduledThreadPoolExecutor monitorService;
    private LifecycleState lifecycleState = LifecycleState.IDLE;
    private Purger purger;
    private boolean needToPurge;

    public LifecycleSupervisor() {
        this.supervisedProcesses = new HashMap<LifecycleAware, Supervisoree>();
        this.monitorFutures = new HashMap();
        this.monitorService = new ScheduledThreadPoolExecutor(10, new ThreadFactoryBuilder().setNameFormat("lifecycleSupervisor-" + Thread.currentThread().getId() + "-%d").build());
        this.monitorService.setMaximumPoolSize(20);
        this.monitorService.setKeepAliveTime(30L, TimeUnit.SECONDS);
        this.purger = new Purger();
        this.needToPurge = false;
    }

    @Override
    public synchronized void start() {
        logger.info("Starting lifecycle supervisor {}", (Object)Thread.currentThread().getId());
        this.monitorService.scheduleWithFixedDelay(this.purger, 2L, 2L, TimeUnit.HOURS);
        this.lifecycleState = LifecycleState.START;
        logger.debug("Lifecycle supervisor started");
    }

    @Override
    public synchronized void stop() {
        logger.info("Stopping lifecycle supervisor {}", (Object)Thread.currentThread().getId());
        if (this.monitorService != null) {
            this.monitorService.shutdown();
            try {
                this.monitorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting for monitor service to stop");
            }
            if (!this.monitorService.isTerminated()) {
                this.monitorService.shutdownNow();
                try {
                    while (!this.monitorService.isTerminated()) {
                        this.monitorService.awaitTermination(10L, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while waiting for monitor service to stop");
                }
            }
        }
        for (Map.Entry<LifecycleAware, Supervisoree> entry : this.supervisedProcesses.entrySet()) {
            if (!entry.getKey().getLifecycleState().equals((Object)LifecycleState.START)) continue;
            entry.getValue().status.desiredState = LifecycleState.STOP;
            entry.getKey().stop();
        }
        if (this.lifecycleState.equals((Object)LifecycleState.START)) {
            this.lifecycleState = LifecycleState.STOP;
        }
        this.supervisedProcesses.clear();
        this.monitorFutures.clear();
        logger.debug("Lifecycle supervisor stopped");
    }

    public synchronized void fail() {
        this.lifecycleState = LifecycleState.ERROR;
    }

    public synchronized void supervise(LifecycleAware lifecycleAware, SupervisorPolicy policy, LifecycleState desiredState) {
        if (this.monitorService.isShutdown() || this.monitorService.isTerminated() || this.monitorService.isTerminating()) {
            throw new FlumeException("Supervise called on " + lifecycleAware + " " + "after shutdown has been initiated. " + lifecycleAware + " will not" + " be started");
        }
        Preconditions.checkState((!this.supervisedProcesses.containsKey(lifecycleAware) ? 1 : 0) != 0, (Object)("Refusing to supervise " + lifecycleAware + " more than once"));
        if (logger.isDebugEnabled()) {
            logger.debug("Supervising service:{} policy:{} desiredState:{}", new Object[]{lifecycleAware, policy, desiredState});
        }
        Supervisoree process = new Supervisoree();
        process.status = new Status();
        process.policy = policy;
        process.status.desiredState = desiredState;
        process.status.error = false;
        MonitorRunnable monitorRunnable = new MonitorRunnable();
        monitorRunnable.lifecycleAware = lifecycleAware;
        monitorRunnable.supervisoree = process;
        monitorRunnable.monitorService = this.monitorService;
        this.supervisedProcesses.put(lifecycleAware, process);
        ScheduledFuture<?> future = this.monitorService.scheduleWithFixedDelay(monitorRunnable, 0L, 3L, TimeUnit.SECONDS);
        this.monitorFutures.put(lifecycleAware, future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsupervise(LifecycleAware lifecycleAware) {
        Preconditions.checkState((boolean)this.supervisedProcesses.containsKey(lifecycleAware), (Object)("Unaware of " + lifecycleAware + " - can not unsupervise"));
        logger.debug("Unsupervising service:{}", (Object)lifecycleAware);
        LifecycleAware lifecycleAware2 = lifecycleAware;
        synchronized (lifecycleAware2) {
            Supervisoree supervisoree = this.supervisedProcesses.get(lifecycleAware);
            supervisoree.status.discard = true;
            this.setDesiredState(lifecycleAware, LifecycleState.STOP);
            logger.info("Stopping component: {}", (Object)lifecycleAware);
            lifecycleAware.stop();
        }
        this.supervisedProcesses.remove(lifecycleAware);
        this.monitorFutures.get(lifecycleAware).cancel(false);
        this.needToPurge = true;
        this.monitorFutures.remove(lifecycleAware);
    }

    public synchronized void setDesiredState(LifecycleAware lifecycleAware, LifecycleState desiredState) {
        Preconditions.checkState((boolean)this.supervisedProcesses.containsKey(lifecycleAware), (Object)("Unaware of " + lifecycleAware + " - can not set desired state to " + (Object)((Object)desiredState)));
        logger.debug("Setting desiredState:{} on service:{}", (Object)desiredState, (Object)lifecycleAware);
        Supervisoree supervisoree = this.supervisedProcesses.get(lifecycleAware);
        supervisoree.status.desiredState = desiredState;
    }

    @Override
    public synchronized LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public synchronized boolean isComponentInErrorState(LifecycleAware component) {
        return this.supervisedProcesses.get((Object)component).status.error;
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }

    private static class Supervisoree {
        public SupervisorPolicy policy;
        public Status status;

        private Supervisoree() {
        }

        public String toString() {
            return "{ status:" + this.status + " policy:" + this.policy + " }";
        }
    }

    public static abstract class SupervisorPolicy {
        abstract boolean isValid(LifecycleAware var1, Status var2);

        public static class OnceOnlyPolicy
        extends SupervisorPolicy {
            @Override
            boolean isValid(LifecycleAware object, Status status) {
                return status.failures == 0;
            }
        }

        public static class AlwaysRestartPolicy
        extends SupervisorPolicy {
            @Override
            boolean isValid(LifecycleAware object, Status status) {
                return true;
            }
        }
    }

    public static class Status {
        public Long firstSeen;
        public Long lastSeen;
        public LifecycleState lastSeenState;
        public LifecycleState desiredState;
        public int failures;
        public boolean discard;
        public volatile boolean error;

        public String toString() {
            return "{ lastSeen:" + this.lastSeen + " lastSeenState:" + (Object)((Object)this.lastSeenState) + " desiredState:" + (Object)((Object)this.desiredState) + " firstSeen:" + this.firstSeen + " failures:" + this.failures + " discard:" + this.discard + " error:" + this.error + " }";
        }
    }

    private class Purger
    implements Runnable {
        private Purger() {
        }

        @Override
        public void run() {
            if (LifecycleSupervisor.this.needToPurge) {
                LifecycleSupervisor.this.monitorService.purge();
                LifecycleSupervisor.this.needToPurge = false;
            }
        }
    }

    public static class MonitorRunnable
    implements Runnable {
        public ScheduledExecutorService monitorService;
        public LifecycleAware lifecycleAware;
        public Supervisoree supervisoree;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block20: {
                LifecycleSupervisor.access$200().debug("checking process:{} supervisoree:{}", (Object)this.lifecycleAware, (Object)this.supervisoree);
                now = System.currentTimeMillis();
                try {
                    if (this.supervisoree.status.firstSeen == null) {
                        LifecycleSupervisor.access$200().debug("first time seeing {}", (Object)this.lifecycleAware);
                        this.supervisoree.status.firstSeen = now;
                    }
                    this.supervisoree.status.lastSeen = now;
                    var3_2 = this.lifecycleAware;
                    synchronized (var3_2) {
                        if (this.supervisoree.status.discard) {
                            LifecycleSupervisor.access$200().info("Component has already been stopped {}", (Object)this.lifecycleAware);
                            return;
                        }
                        if (this.supervisoree.status.error) {
                            LifecycleSupervisor.access$200().info("Component {} is in error state, and Flume will notattempt to change its state", (Object)this.lifecycleAware);
                            return;
                        }
                        this.supervisoree.status.lastSeenState = this.lifecycleAware.getLifecycleState();
                        if (this.lifecycleAware.getLifecycleState().equals((Object)this.supervisoree.status.desiredState)) break block20;
                        LifecycleSupervisor.access$200().debug("Want to transition {} from {} to {} (failures:{})", new Object[]{this.lifecycleAware, this.supervisoree.status.lastSeenState, this.supervisoree.status.desiredState, this.supervisoree.status.failures});
                        switch (1.$SwitchMap$org$apache$flume$lifecycle$LifecycleState[this.supervisoree.status.desiredState.ordinal()]) {
                            case 1: {
                                try {
                                    this.lifecycleAware.start();
                                }
                                catch (Throwable e) {
                                    LifecycleSupervisor.access$200().error("Unable to start " + this.lifecycleAware + " - Exception follows.", e);
                                    if (!(e instanceof Error)) ** GOTO lbl38
                                    this.supervisoree.status.desiredState = LifecycleState.STOP;
                                    try {
                                        this.lifecycleAware.stop();
                                        LifecycleSupervisor.access$200().warn("Component {} stopped, since it could not besuccessfully started due to missing dependencies", (Object)this.lifecycleAware);
                                    }
                                    catch (Throwable e1) {
                                        LifecycleSupervisor.access$200().error("Unsuccessful attempt to shutdown component: {} due to missing dependencies. Please shutdown the agentor disable this component, or the agent will bein an undefined state.", e1);
                                        this.supervisoree.status.error = true;
                                        if (!(e1 instanceof Error)) ** GOTO lbl38
                                        throw (Error)e1;
                                    }
lbl38:
                                    // 3 sources

                                    ++this.supervisoree.status.failures;
                                }
                                break;
                            }
                            case 2: {
                                try {
                                    this.lifecycleAware.stop();
                                }
                                catch (Throwable e) {
                                    LifecycleSupervisor.access$200().error("Unable to stop " + this.lifecycleAware + " - Exception follows.", e);
                                    if (e instanceof Error) {
                                        throw (Error)e;
                                    }
                                    ++this.supervisoree.status.failures;
                                }
                                break;
                            }
                            default: {
                                LifecycleSupervisor.access$200().warn("I refuse to acknowledge {} as a desired state", (Object)this.supervisoree.status.desiredState);
                            }
                        }
                        if (!this.supervisoree.policy.isValid(this.lifecycleAware, this.supervisoree.status)) {
                            LifecycleSupervisor.access$200().error("Policy {} of {} has been violated - supervisor should exit!", (Object)this.supervisoree.policy, (Object)this.lifecycleAware);
                        }
                    }
                }
                catch (Throwable t) {
                    LifecycleSupervisor.access$200().error("Unexpected error", t);
                }
            }
            LifecycleSupervisor.access$200().debug("Status check complete");
        }
    }
}

