/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.flume;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.avro.ipc.NettyServer;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.flume.source.avro.AvroSourceProtocol;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.flume.FlumeEventServer;
import org.apache.spark.streaming.flume.SparkFlumeEvent;
import org.apache.spark.streaming.receiver.Receiver;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.compression.ZlibDecoder;
import org.jboss.netty.handler.codec.compression.ZlibEncoder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\t\u0013\u0001Qa\u0002\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0011\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011%\t\u0011%\u0003!\u0011!Q\u0001\n)CQ!\u0014\u0001\u0005\u00029C\u0001\u0002\u0016\u0001\t\u0006\u0004%\t!\u0016\u0005\bA\u0002\u0001\r\u0011\"\u0001b\u0011\u001d1\u0007\u00011A\u0005\u0002\u001dDa!\u001c\u0001!B\u0013\u0011\u0007\"\u00028\u0001\t\u0013y\u0007\"\u00029\u0001\t\u0003\t\b\"\u0002:\u0001\t\u0003\t\b\"B:\u0001\t\u0003\"h!\u0002=\u0001\u0001QI\bBB'\u000f\t\u0003\tI\u0002C\u0004\u0002 9!\t!!\t\u0003\u001b\u0019cW/\\3SK\u000e,\u0017N^3s\u0015\t\u0019B#A\u0003gYVlWM\u0003\u0002\u0016-\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sON\u0019\u0001!H\u0014\u0011\u0007y\t3%D\u0001 \u0015\t\u0001C#\u0001\u0005sK\u000e,\u0017N^3s\u0013\t\u0011sD\u0001\u0005SK\u000e,\u0017N^3s!\t!S%D\u0001\u0013\u0013\t1#CA\bTa\u0006\u00148N\u00127v[\u0016,e/\u001a8u!\tA3&D\u0001*\u0015\tQc#\u0001\u0005j]R,'O\\1m\u0013\ta\u0013FA\u0004M_\u001e<\u0017N\\4\u0002\t!|7\u000f^\u0002\u0001!\t\u0001\u0014H\u0004\u00022oA\u0011!'N\u0007\u0002g)\u0011AGL\u0001\u0007yI|w\u000e\u001e \u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qU\nA\u0001]8siB\u0011ahP\u0007\u0002k%\u0011\u0001)\u000e\u0002\u0004\u0013:$\u0018\u0001D:u_J\fw-\u001a'fm\u0016d\u0007CA\"G\u001b\u0005!%BA#\u0017\u0003\u001d\u0019Ho\u001c:bO\u0016L!a\u0012#\u0003\u0019M#xN]1hK2+g/\u001a7\n\u0005\u0005\u000b\u0013aE3oC\ndW\rR3d_6\u0004(/Z:tS>t\u0007C\u0001 L\u0013\taUGA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0015y\u0005+\u0015*T!\t!\u0003\u0001C\u0003.\u000b\u0001\u0007q\u0006C\u0003=\u000b\u0001\u0007Q\bC\u0003B\u000b\u0001\u0007!\tC\u0003J\u000b\u0001\u0007!*A\u0005sKN\u0004xN\u001c3feV\ta\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006A1\u000f]3dS\u001aL7M\u0003\u0002\\9\u0006\u0019\u0011\u000e]2\u000b\u0005uC\u0012\u0001B1we>L!a\u0018-\u0003#M\u0003XmY5gS\u000e\u0014Vm\u001d9p]\u0012,'/\u0001\u0004tKJ4XM]\u000b\u0002EB\u00111\rZ\u0007\u00025&\u0011QM\u0017\u0002\f\u001d\u0016$H/_*feZ,'/\u0001\u0006tKJ4XM]0%KF$\"\u0001[6\u0011\u0005yJ\u0017B\u000166\u0005\u0011)f.\u001b;\t\u000f1D\u0011\u0011!a\u0001E\u0006\u0019\u0001\u0010J\u0019\u0002\u000fM,'O^3sA\u0005Q\u0011N\\5u'\u0016\u0014h/\u001a:\u0015\u0003\t\fqa\u001c8Ti\u0006\u0014H\u000fF\u0001i\u0003\u0019ygn\u0015;pa\u0006\t\u0002O]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8\u0016\u0003U\u00042A\u0010<0\u0013\t9XG\u0001\u0004PaRLwN\u001c\u0002\"\u0007>l\u0007O]3tg&|gn\u00115b]:,G\u000eU5qK2Lg.\u001a$bGR|'/_\n\u0005\u001di\f)\u0001E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fA\u0001\\1oO*\tq0\u0001\u0003kCZ\f\u0017bAA\u0002y\n1qJ\u00196fGR\u0004B!a\u0002\u0002\u00165\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0004dQ\u0006tg.\u001a7\u000b\t\u0005=\u0011\u0011C\u0001\u0006]\u0016$H/\u001f\u0006\u0004\u0003'Q\u0012!\u00026c_N\u001c\u0018\u0002BA\f\u0003\u0013\u0011ac\u00115b]:,G\u000eU5qK2Lg.\u001a$bGR|'/\u001f\u000b\u0003\u00037\u00012!!\b\u000f\u001b\u0005\u0001\u0011aC4fiBK\u0007/\u001a7j]\u0016$\"!a\t\u0011\t\u0005\u001d\u0011QE\u0005\u0005\u0003O\tIAA\bDQ\u0006tg.\u001a7QSB,G.\u001b8f\u0001")
public class FlumeReceiver
extends Receiver<SparkFlumeEvent>
implements Logging {
    private SpecificResponder responder;
    private final String host;
    private final int port;
    private final boolean enableDecompression;
    private NettyServer server;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SpecificResponder responder$lzycompute() {
        FlumeReceiver flumeReceiver = this;
        synchronized (flumeReceiver) {
            if (!this.bitmap$0) {
                this.responder = new SpecificResponder(AvroSourceProtocol.class, (Object)new FlumeEventServer(this));
                this.bitmap$0 = true;
            }
        }
        return this.responder;
    }

    public SpecificResponder responder() {
        return !this.bitmap$0 ? this.responder$lzycompute() : this.responder;
    }

    public NettyServer server() {
        return this.server;
    }

    public void server_$eq(NettyServer x$1) {
        this.server = x$1;
    }

    private NettyServer initServer() {
        NettyServer nettyServer;
        if (this.enableDecompression) {
            NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
            CompressionChannelPipelineFactory channelPipelineFactory = new CompressionChannelPipelineFactory();
            nettyServer = new NettyServer((Responder)this.responder(), new InetSocketAddress(this.host, this.port), (ChannelFactory)channelFactory, (ChannelPipelineFactory)channelPipelineFactory, null);
        } else {
            nettyServer = new NettyServer((Responder)this.responder(), new InetSocketAddress(this.host, this.port));
        }
        return nettyServer;
    }

    public void onStart() {
        FlumeReceiver flumeReceiver = this;
        synchronized (flumeReceiver) {
            if (this.server() == null) {
                this.server_$eq(this.initServer());
                this.server().start();
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Flume receiver being asked to start more then once with out close");
            }
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Flume receiver started");
    }

    public void onStop() {
        FlumeReceiver flumeReceiver = this;
        synchronized (flumeReceiver) {
            if (this.server() != null) {
                this.server().close();
                this.server_$eq(null);
            }
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Flume receiver stopped");
    }

    public Option<String> preferredLocation() {
        return Option$.MODULE$.apply((Object)this.host);
    }

    public FlumeReceiver(String host, int port, StorageLevel storageLevel, boolean enableDecompression) {
        this.host = host;
        this.port = port;
        this.enableDecompression = enableDecompression;
        super(storageLevel);
        Logging.$init$((Logging)this);
        this.server = null;
    }

    public class CompressionChannelPipelineFactory
    implements ChannelPipelineFactory {
        /*
         * WARNING - void declaration
         */
        public ChannelPipeline getPipeline() {
            void var1_1;
            ChannelPipeline pipeline = Channels.pipeline();
            ZlibEncoder encoder = new ZlibEncoder(6);
            pipeline.addFirst("deflater", (ChannelHandler)encoder);
            pipeline.addFirst("inflater", (ChannelHandler)new ZlibDecoder());
            return var1_1;
        }

        public /* synthetic */ FlumeReceiver org$apache$spark$streaming$flume$FlumeReceiver$CompressionChannelPipelineFactory$$$outer() {
            return FlumeReceiver.this;
        }

        public CompressionChannelPipelineFactory() {
            if (FlumeReceiver.this == null) {
                throw null;
            }
        }
    }
}

