/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.client.RMHAServiceTarget;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMHAUtils {
    public static String findActiveRMHAId(YarnConfiguration conf) {
        YarnConfiguration yarnConf = new YarnConfiguration(conf);
        Collection rmIds = yarnConf.getStringCollection("yarn.resourcemanager.ha.rm-ids");
        for (String currentId : rmIds) {
            yarnConf.set("yarn.resourcemanager.ha.id", currentId);
            try {
                HAServiceProtocol.HAServiceState haState = RMHAUtils.getHAState(yarnConf);
                if (!haState.equals((Object)HAServiceProtocol.HAServiceState.ACTIVE)) continue;
                return currentId;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    private static HAServiceProtocol.HAServiceState getHAState(YarnConfiguration yarnConf) throws Exception {
        int rpcTimeoutForChecks = yarnConf.getInt("ha.failover-controller.cli-check.rpc-timeout.ms", 20000);
        yarnConf.set("hadoop.security.service.user.name.key", yarnConf.get("yarn.resourcemanager.principal", ""));
        RMHAServiceTarget haServiceTarget = new RMHAServiceTarget(yarnConf);
        HAServiceProtocol proto = haServiceTarget.getProxy(yarnConf, rpcTimeoutForChecks);
        HAServiceProtocol.HAServiceState haState = proto.getServiceStatus().getState();
        return haState;
    }

    public static List<String> getRMHAWebappAddresses(YarnConfiguration conf) {
        Collection rmIds = conf.getStringCollection("yarn.resourcemanager.ha.rm-ids");
        ArrayList<String> addrs = new ArrayList<String>();
        if (YarnConfiguration.useHttps(conf)) {
            for (String id : rmIds) {
                String addr = conf.get("yarn.resourcemanager.webapp.https.address." + id);
                if (addr == null) continue;
                addrs.add(addr);
            }
        } else {
            for (String id : rmIds) {
                String addr = conf.get("yarn.resourcemanager.webapp.address." + id);
                if (addr == null) continue;
                addrs.add(addr);
            }
        }
        return addrs;
    }
}

