/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.spi.container.grizzly2;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.container.ContainerFactory;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.LowLevelAppDescriptor;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerException;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;

public class GrizzlyTestContainerFactory
implements TestContainerFactory {
    public Class<LowLevelAppDescriptor> supports() {
        return LowLevelAppDescriptor.class;
    }

    @Override
    public TestContainer create(URI baseUri, AppDescriptor ad) {
        if (!(ad instanceof LowLevelAppDescriptor)) {
            throw new IllegalArgumentException("The application descriptor must be an instance of LowLevelAppDescriptor");
        }
        return new GrizzlyTestContainer(baseUri, (LowLevelAppDescriptor)ad);
    }

    private static class GrizzlyTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(GrizzlyTestContainer.class.getName());
        final HttpServer httpServer;
        final URI baseUri;

        GrizzlyTestContainer(URI baseUri, LowLevelAppDescriptor ad) {
            this.baseUri = UriBuilder.fromUri(baseUri).path(ad.getContextPath()).build(new Object[0]);
            LOGGER.info("Creating low level grizzly2 container configured at the base URI " + this.baseUri);
            try {
                HttpHandler httpHandler = ContainerFactory.createContainer(HttpHandler.class, ad.getResourceConfig());
                this.httpServer = GrizzlyTestContainer.create(this.baseUri, httpHandler);
            }
            catch (Exception ex) {
                throw new TestContainerException(ex);
            }
        }

        @Override
        public Client getClient() {
            return null;
        }

        @Override
        public URI getBaseUri() {
            return this.baseUri;
        }

        @Override
        public void start() {
            try {
                LOGGER.info("Starting low level grizzly2 container");
                this.httpServer.start();
            }
            catch (IOException ex) {
                throw new TestContainerException(ex);
            }
        }

        @Override
        public void stop() {
            if (this.httpServer.isStarted()) {
                LOGGER.info("Stopping low level grizzly2 container");
                this.httpServer.stop();
            }
        }

        private static HttpServer create(URI u, HttpHandler handler) throws IOException, IllegalArgumentException {
            if (u == null) {
                throw new IllegalArgumentException("The URI must not be null");
            }
            String scheme = u.getScheme();
            if (!scheme.equalsIgnoreCase("http")) {
                throw new IllegalArgumentException("The URI scheme, of the URI " + u + ", must be equal (ignoring case) to 'http'");
            }
            String host = u.getHost() == null ? "0.0.0.0" : u.getHost();
            int port = u.getPort() == -1 ? 80 : u.getPort();
            HttpServer server = new HttpServer();
            NetworkListener listener = new NetworkListener("grizzly", host, port);
            server.addListener(listener);
            ServerConfiguration config = server.getServerConfiguration();
            config.addHttpHandler(handler, u.getPath());
            return server;
        }
    }
}

