/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.cluster.Broker;
import kafka.consumer.Whitelist;
import kafka.log.LogConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TopicCommand$ {
    public static final TopicCommand$ MODULE$;

    static {
        new TopicCommand$();
    }

    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        int actions = ((TraversableOnce)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.createOpt(), opts.listOpt(), opts.alterOpt(), opts.describeOpt()}))).count(new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final TopicCommand.TopicCommandOptions opts$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.opts$1.options().has(x$1);
            }
            {
                this.opts$1 = opts$1;
            }
        });
        if (actions != 1) {
            System.err.println("Command must include exactly one action: --list, --describe, --create or --alter");
            opts.parser().printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        opts.checkArgs();
        ZkClient zkClient = new ZkClient((String)opts.options().valueOf(opts.zkConnectOpt()), 30000, 30000, ZKStringSerializer$.MODULE$);
        try {
            if (opts.options().has((OptionSpec)opts.createOpt())) {
                this.createTopic(zkClient, opts);
            } else if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterTopic(zkClient, opts);
            } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                this.listTopics(zkClient, opts);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeTopic(zkClient, opts);
            }
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println(new StringBuilder().append((Object)"Error while executing topic command ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println(Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                zkClient.close();
            }
        }
        zkClient.close();
    }

    private Seq<String> getTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        Seq allTopics = (Seq)ZkUtils$.MODULE$.getAllTopics(zkClient).sorted(Ordering$String$.MODULE$);
        if (opts.options().has(opts.topicOpt())) {
            String topicsSpec = (String)opts.options().valueOf(opts.topicOpt());
            Whitelist topicsFilter = new Whitelist(topicsSpec);
            seq = (Seq)allTopics.filter(new Serializable(topicsFilter){
                public static final long serialVersionUID = 0L;
                private final Whitelist topicsFilter$1;

                public final boolean apply(String topic) {
                    return this.topicsFilter$1.isTopicAllowed(topic);
                }
                {
                    this.topicsFilter$1 = topicsFilter$1;
                }
            });
        } else {
            seq = allTopics;
        }
        return seq;
    }

    public void createTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        String topic = (String)opts.options().valueOf(opts.topicOpt());
        Properties configs = this.parseTopicConfigsToBeAdded(opts);
        if (opts.options().has(opts.replicaAssignmentOpt())) {
            Map<Object, Seq<Object>> assignment = this.parseReplicaAssignment((String)opts.options().valueOf(opts.replicaAssignmentOpt()));
            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(zkClient, topic, assignment, configs, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        } else {
            CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.partitionsOpt(), opts.replicationFactorOpt()}));
            int partitions = (Integer)opts.options().valueOf(opts.partitionsOpt());
            int replicas = (Integer)opts.options().valueOf(opts.replicationFactorOpt());
            AdminUtils$.MODULE$.createTopic(zkClient, topic, partitions, replicas, configs);
        }
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Created topic \"%s\".")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
    }

    public void alterTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        topics.foreach(new Serializable(zkClient, opts){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;
            private final TopicCommand.TopicCommandOptions opts$2;

            public final void apply(String topic) {
                if (this.opts$2.options().has(this.opts$2.configOpt()) || this.opts$2.options().has(this.opts$2.deleteConfigOpt())) {
                    Properties configsToBeAdded = TopicCommand$.MODULE$.parseTopicConfigsToBeAdded(this.opts$2);
                    Seq<String> configsToBeDeleted = TopicCommand$.MODULE$.parseTopicConfigsToBeDeleted(this.opts$2);
                    Properties configs = AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient$1, topic);
                    ((Hashtable)configs).putAll(configsToBeAdded);
                    configsToBeDeleted.foreach(new Serializable(this, configs){
                        public static final long serialVersionUID = 0L;
                        private final Properties configs$1;

                        public final Object apply(String config) {
                            return ((Hashtable)this.configs$1).remove(config);
                        }
                        {
                            this.configs$1 = configs$1;
                        }
                    });
                    AdminUtils$.MODULE$.changeTopicConfig(this.zkClient$1, topic, configs);
                    Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Updated config for topic \"%s\".")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
                }
                if (this.opts$2.options().has(this.opts$2.partitionsOpt())) {
                    Predef$.MODULE$.println("WARNING: If partitions are increased for a topic that has a key, the partition logic or ordering of the messages will be affected");
                    int nPartitions = (Integer)this.opts$2.options().valueOf(this.opts$2.partitionsOpt());
                    String replicaAssignmentStr = (String)this.opts$2.options().valueOf(this.opts$2.replicaAssignmentOpt());
                    AdminUtils$.MODULE$.addPartitions(this.zkClient$1, topic, nPartitions, replicaAssignmentStr);
                    Predef$.MODULE$.println("Adding partitions succeeded!");
                }
            }
            {
                this.zkClient$1 = zkClient$1;
                this.opts$2 = opts$2;
            }
        });
    }

    public void listTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        topics.foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String topic) {
                Predef$.MODULE$.println(topic);
            }
        });
    }

    public void describeTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        boolean reportUnderReplicatedPartitions = opts.options().has((OptionSpec)opts.reportUnderReplicatedPartitionsOpt());
        boolean reportUnavailablePartitions = opts.options().has((OptionSpec)opts.reportUnavailablePartitionsOpt());
        boolean reportOverriddenConfigs = opts.options().has((OptionSpec)opts.topicsWithOverridesOpt());
        Set liveBrokers2 = ((TraversableOnce)ZkUtils$.MODULE$.getAllBrokersInCluster(zkClient).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Broker x$1) {
                return x$1.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        topics.foreach(new Serializable(zkClient, reportUnderReplicatedPartitions, reportUnavailablePartitions, reportOverriddenConfigs, liveBrokers2){
            public static final long serialVersionUID = 0L;
            public final ZkClient zkClient$2;
            public final boolean reportUnderReplicatedPartitions$1;
            public final boolean reportUnavailablePartitions$1;
            private final boolean reportOverriddenConfigs$1;
            public final Set liveBrokers$1;

            public final void apply(String topic) {
                Option<B> option;
                block9: {
                    block8: {
                        block7: {
                            BoxedUnit boxedUnit;
                            option = ZkUtils$.MODULE$.getPartitionAssignmentForTopics(this.zkClient$2, (Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get(topic);
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            Map topicPartitionAssignment = (Map)some.x();
                            boolean describeConfigs = !this.reportUnavailablePartitions$1 && !this.reportUnderReplicatedPartitions$1;
                            boolean describePartitions = !this.reportOverriddenConfigs$1;
                            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith((Function2<Tuple2<Object, Seq<Object>>, Tuple2<Object, Seq<Object>>, Object>)((Object)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Tuple2<Object, Seq<Object>> m1, Tuple2<Object, Seq<Object>> m2) {
                                    return m1._1$mcI$sp() < m2._1$mcI$sp();
                                }
                            }));
                            if (describeConfigs) {
                                Properties configs = AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient$2, topic);
                                if (!this.reportOverriddenConfigs$1 || ((Hashtable)configs).size() != 0) {
                                    int numPartitions = topicPartitionAssignment.size();
                                    int replicationFactor = ((SeqLike)((Tuple2)topicPartitionAssignment.head())._2()).size();
                                    Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Topic:%s\tPartitionCount:%d\tReplicationFactor:%d\tConfigs:%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(numPartitions), BoxesRunTime.boxToInteger(replicationFactor), ((TraversableOnce)JavaConversions$.MODULE$.propertiesAsScalaMap(configs).map((Function1<String, String>)((Object)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Tuple2<String, String> kv) {
                                            return new StringBuilder().append((Object)kv._1()).append((Object)"=").append((Object)kv._2()).toString();
                                        }
                                    }), Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
                                }
                            }
                            if (describePartitions) {
                                sortedPartitions.withFilter(new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Tuple2<Object, Seq<Object>> check$ifrefutable$1) {
                                        Tuple2<Object, Seq<Object>> tuple2 = check$ifrefutable$1;
                                        boolean bl = tuple2 != null;
                                        return bl;
                                    }
                                }).foreach(new Serializable(this, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.describeTopic.1 $outer;
                                    private final String topic$1;

                                    public final void apply(Tuple2<Object, Seq<Object>> x$2) {
                                        Tuple2<Object, Seq<Object>> tuple2 = x$2;
                                        if (tuple2 != null) {
                                            BoxedUnit boxedUnit;
                                            int partitionId = tuple2._1$mcI$sp();
                                            Seq<Object> assignedReplicas = tuple2._2();
                                            Seq<Object> inSyncReplicas = ZkUtils$.MODULE$.getInSyncReplicasForPartition(this.$outer.zkClient$2, this.topic$1, partitionId);
                                            Option<Object> leader = ZkUtils$.MODULE$.getLeaderForPartition(this.$outer.zkClient$2, this.topic$1, partitionId);
                                            if ((this.$outer.reportUnderReplicatedPartitions$1 || this.$outer.reportUnavailablePartitions$1) && (!this.$outer.reportUnderReplicatedPartitions$1 || inSyncReplicas.size() >= assignedReplicas.size()) && (!this.$outer.reportUnavailablePartitions$1 || leader.isDefined() && this.$outer.liveBrokers$1.contains(leader.get()))) {
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                Predef$.MODULE$.print(new StringBuilder().append((Object)"\tTopic: ").append((Object)this.topic$1).toString());
                                                Predef$.MODULE$.print(new StringBuilder().append((Object)"\tPartition: ").append(BoxesRunTime.boxToInteger(partitionId)).toString());
                                                Predef$.MODULE$.print(new StringBuilder().append((Object)"\tLeader: ").append(leader.isDefined() ? leader.get() : "none").toString());
                                                Predef$.MODULE$.print(new StringBuilder().append((Object)"\tReplicas: ").append((Object)assignedReplicas.mkString(",")).toString());
                                                Predef$.MODULE$.println(new StringBuilder().append((Object)"\tIsr: ").append((Object)inSyncReplicas.mkString(",")).toString());
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit2 = boxedUnit;
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topic$1 = topic$1;
                                    }
                                });
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            break block8;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<B> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                        Predef$.MODULE$.println(new StringBuilder().append((Object)"Topic ").append((Object)topic).append((Object)" doesn't exist!").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$2 = zkClient$2;
                this.reportUnderReplicatedPartitions$1 = reportUnderReplicatedPartitions$1;
                this.reportUnavailablePartitions$1 = reportUnavailablePartitions$1;
                this.reportOverriddenConfigs$1 = reportOverriddenConfigs$1;
                this.liveBrokers$1 = liveBrokers$1;
            }
        });
    }

    public String formatBroker(Broker broker) {
        return new StringBuilder().append(broker.id()).append((Object)" (").append((Object)broker.host()).append((Object)":").append(BoxesRunTime.boxToInteger(broker.port())).append((Object)")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        Buffer<String[]> configsToBeAdded = JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.configOpt())).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$3) {
                return x$3.split("\\s*=\\s*");
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1<String[], Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] config) {
                return config.length == 2;
            }
        })), (Function0<Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid topic config: all configs to be added must be in the format \"key=val\".";
            }
        }));
        Properties props = new Properties();
        configsToBeAdded.foreach(new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String[] pair2) {
                return this.props$1.setProperty(pair2[0].trim(), pair2[1].trim());
            }
            {
                this.props$1 = props$1;
            }
        });
        LogConfig$.MODULE$.validate(props);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfigOpt())) {
            void var2_2;
            Buffer<String> configsToBeDeleted = JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.deleteConfigOpt())).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$4) {
                    return x$4.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach(new Serializable(propsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Properties propsToBeDeleted$1;

                public final Object apply(String x$5) {
                    return this.propsToBeDeleted$1.setProperty(x$5, "");
                }
                {
                    this.propsToBeDeleted$1 = propsToBeDeleted$1;
                }
            });
            LogConfig$.MODULE$.validateNames(propsToBeDeleted);
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        String[] partitionList = replicaAssignmentList.split(",");
        HashMap ret = new HashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])partitionList).size()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(partitionList, ret){
            public static final long serialVersionUID = 0L;
            private final String[] partitionList$1;
            private final HashMap ret$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])this.partitionList$1[i].split(":")).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String s2) {
                        return new StringOps(Predef$.MODULE$.augmentString(s2.trim())).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                this.ret$1.put(BoxesRunTime.boxToInteger(i), Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$1.apply(BoxesRunTime.boxToInteger(i))).size() != ((SeqLike)this.ret$1.apply(BoxesRunTime.boxToInteger(0))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"Partition ").append(BoxesRunTime.boxToInteger(i)).append((Object)" has different replication factor: ").append(brokerList).toString());
                }
            }
            {
                this.partitionList$1 = partitionList$1;
                this.ret$1 = ret$1;
            }
        }));
        return ret.toMap(Predef$.MODULE$.conforms());
    }

    private TopicCommand$() {
        MODULE$ = this;
    }
}

