/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsrRequest;
import kafka.api.PartitionStateInfo;
import kafka.api.StopReplicaRequest;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.KafkaConfig;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\res!B\u0001\u0003\u0011\u00039\u0011A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148CA\u0005\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\")1#\u0003C\u0001)\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\b-%\u0011\r\u0011\"\u0001\u0018\u0003M)fn\u001b8po:dunZ#oI>3gm]3u+\u0005A\u0002CA\u0007\u001a\u0013\tQbB\u0001\u0003M_:<\u0007B\u0002\u000f\nA\u0003%\u0001$\u0001\u000bV].twn\u001e8M_\u001e,e\u000eZ(gMN,G\u000f\t\u0005\b=%\u0011\r\u0011\"\u0001 \u0003UA\u0015n\u001a5XCR,'/\\1sW\u001aKG.\u001a8b[\u0016,\u0012\u0001\t\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019\u0019FO]5oO\"1\u0011&\u0003Q\u0001\n\u0001\na\u0003S5hQ^\u000bG/\u001a:nCJ\\g)\u001b7f]\u0006lW\r\t\u0004\u0005\u0015\t\u00011f\u0005\u0003+\u00191\u0012\u0004CA\u00171\u001b\u0005q#BA\u0018\u0005\u0003\u0015)H/\u001b7t\u0013\t\tdFA\u0004M_\u001e<\u0017N\\4\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0011aB7fiJL7m]\u0005\u0003oQ\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!I$F!b\u0001\n\u0003Q\u0014AB2p]\u001aLw-F\u0001<!\tAA(\u0003\u0002>\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011!y$F!A!\u0002\u0013Y\u0014aB2p]\u001aLw\r\t\u0005\t\u0003*\u0012\t\u0011)A\u0005\u0005\u0006!A/[7f!\ti3)\u0003\u0002E]\t!A+[7f\u0011!1%F!b\u0001\n\u00039\u0015\u0001\u0003>l\u00072LWM\u001c;\u0016\u0003!\u0003\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u0011i\\7\r\\5f]RT!!\u0014(\u0002\r%\u0003\u0014\n^3d\u0015\u0005y\u0015aA8sO&\u0011\u0011K\u0013\u0002\t5.\u001cE.[3oi\"A1K\u000bB\u0001B\u0003%\u0001*A\u0005{W\u000ec\u0017.\u001a8uA!AQK\u000bB\u0001B\u0003%a+A\u0005tG\",G-\u001e7feB\u0011QfV\u0005\u00031:\u0012\u0011bU2iK\u0012,H.\u001a:\t\u0011iS#Q1A\u0005\u0002m\u000b!\u0002\\8h\u001b\u0006t\u0017mZ3s+\u0005a\u0006CA/a\u001b\u0005q&BA0\u0005\u0003\rawnZ\u0005\u0003Cz\u0013!\u0002T8h\u001b\u0006t\u0017mZ3s\u0011!\u0019'F!A!\u0002\u0013a\u0016a\u00037pO6\u000bg.Y4fe\u0002B\u0001\"\u001a\u0016\u0003\u0006\u0004%\tAZ\u0001\u000fSN\u001c\u0006.\u001e;uS:<Gi\\<o+\u00059\u0007C\u00015p\u001b\u0005I'B\u00016l\u0003\u0019\tGo\\7jG*\u0011A.\\\u0001\u000bG>t7-\u001e:sK:$(B\u00018%\u0003\u0011)H/\u001b7\n\u0005AL'!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0005sU\t\u0005\t\u0015!\u0003h\u0003=I7o\u00155viRLgn\u001a#po:\u0004\u0003\"B\n+\t\u0003!HcB;wobL(p\u001f\t\u0003\u0011)BQ!O:A\u0002mBQ!Q:A\u0002\tCQAR:A\u0002!CQ!V:A\u0002YCQAW:A\u0002qCQ!Z:A\u0002\u001dDq! \u0016A\u0002\u0013\u0005a0A\bd_:$(o\u001c7mKJ,\u0005o\\2i+\u0005y\bcA\u0007\u0002\u0002%\u0019\u00111\u0001\b\u0003\u0007%sG\u000fC\u0005\u0002\b)\u0002\r\u0011\"\u0001\u0002\n\u0005\u00192m\u001c8ue>dG.\u001a:Fa>\u001c\u0007n\u0018\u0013fcR!\u00111BA\t!\ri\u0011QB\u0005\u0004\u0003\u001fq!\u0001B+oSRD\u0011\"a\u0005\u0002\u0006\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0018)\u0002\u000b\u0015B@\u0002!\r|g\u000e\u001e:pY2,'/\u00129pG\"\u0004\u0003\u0006BA\u000b\u00037\u00012!DA\u000f\u0013\r\tyB\u0004\u0002\tm>d\u0017\r^5mK\"A\u00111\u0005\u0016C\u0002\u0013%a0A\u0007m_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0003OQ\u0003\u0015!\u0003\u0000\u00039awnY1m\u0005J|7.\u001a:JI\u0002B\u0011\"a\u000b+\u0005\u0004%I!!\f\u0002\u001b\u0005dG\u000eU1si&$\u0018n\u001c8t+\t\ty\u0003E\u0004.\u0003c\t)$a\u0012\n\u0007\u0005MbF\u0001\u0003Q_>d\u0007CB\u0007\u00028\u0005mr0C\u0002\u0002:9\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA\u001f\u0003\u0007r1!DA \u0013\r\t\tED\u0001\u0007!J,G-\u001a4\n\u0007\u001d\n)EC\u0002\u0002B9\u0001B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\"\u0011aB2mkN$XM]\u0005\u0005\u0003#\nYEA\u0005QCJ$\u0018\u000e^5p]\"A\u0011Q\u000b\u0016!\u0002\u0013\ty#\u0001\bbY2\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u0013\u0005e#\u00061A\u0005\n\u0005m\u0013\u0001\u00057fC\u0012,'\u000fU1si&$\u0018n\u001c8t+\t\ti\u0006\u0005\u0004\u0002`\u0005%\u0014qI\u0007\u0003\u0003CRA!a\u0019\u0002f\u00059Q.\u001e;bE2,'bAA4\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\b\u0011\u0006\u001c\bnU3u\u0011%\tyG\u000ba\u0001\n\u0013\t\t(\u0001\u000bmK\u0006$WM\u001d)beRLG/[8og~#S-\u001d\u000b\u0005\u0003\u0017\t\u0019\b\u0003\u0006\u0002\u0014\u00055\u0014\u0011!a\u0001\u0003;B\u0001\"a\u001e+A\u0003&\u0011QL\u0001\u0012Y\u0016\fG-\u001a:QCJ$\u0018\u000e^5p]N\u0004\u0003\"CA>U\t\u0007I\u0011BA?\u0003QaW-\u00193feB\u000b'\u000f^5uS>t7\u000fT8dWV\u0011\u0011q\u0010\t\u0004C\u0005\u0005\u0015bAABE\t1qJ\u00196fGRD\u0001\"a\"+A\u0003%\u0011qP\u0001\u0016Y\u0016\fG-\u001a:QCJ$\u0018\u000e^5p]NdunY6!\u0011%\tYI\u000bb\u0001\n\u0013\ti(\u0001\fsKBd\u0017nY1Ti\u0006$Xm\u00115b]\u001e,Gj\\2l\u0011!\tyI\u000bQ\u0001\n\u0005}\u0014a\u0006:fa2L7-Y*uCR,7\t[1oO\u0016dunY6!\u0011%\t\u0019J\u000bb\u0001\n\u0003\t)*A\u000bsKBd\u0017nY1GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0016\u0005\u0005]\u0005c\u0001\u0005\u0002\u001a&\u0019\u00111\u0014\u0002\u0003+I+\u0007\u000f\\5dC\u001a+Go\u00195fe6\u000bg.Y4fe\"A\u0011q\u0014\u0016!\u0002\u0013\t9*\u0001\fsKBd\u0017nY1GKR\u001c\u0007.\u001a:NC:\fw-\u001a:!\u0011!\t\u0019K\u000bb\u0001\n\u00131\u0017\u0001\n5jO\"<\u0016\r^3s[\u0006\u00148n\u00115fG.\u0004v.\u001b8u)\"\u0014X-\u00193Ti\u0006\u0014H/\u001a3\t\u000f\u0005\u001d&\u0006)A\u0005O\u0006)\u0003.[4i/\u0006$XM]7be.\u001c\u0005.Z2l!>Lg\u000e\u001e+ie\u0016\fGm\u0015;beR,G\r\t\u0005\n\u0003WS#\u0019!C\u0001\u0003[\u000b\u0001\u0004[5hQ^\u000bG/\u001a:nCJ\\7\t[3dWB|\u0017N\u001c;t+\t\ty\u000bE\u0004\u00022\u0006]\u0006%a/\u000e\u0005\u0005M&\u0002BA[\u0003K\n\u0011\"[7nkR\f'\r\\3\n\t\u0005e\u00161\u0017\u0002\u0004\u001b\u0006\u0004\bc\u0001\u0005\u0002>&\u0019\u0011q\u0018\u0002\u0003!=3gm]3u\u0007\",7m\u001b9pS:$\b\u0002CAbU\u0001\u0006I!a,\u00023!Lw\r[,bi\u0016\u0014X.\u0019:l\u0007\",7m\u001b9pS:$8\u000f\t\u0005\n\u0003\u000fT\u0003\u0019!C\u0005\u0003\u0013\f1\u0003[<UQJ,\u0017\rZ%oSRL\u0017\r\\5{K\u0012,\"!a3\u0011\u00075\ti-C\u0002\u0002P:\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002T*\u0002\r\u0011\"\u0003\u0002V\u00069\u0002n\u001e+ie\u0016\fG-\u00138ji&\fG.\u001b>fI~#S-\u001d\u000b\u0005\u0003\u0017\t9\u000e\u0003\u0006\u0002\u0014\u0005E\u0017\u0011!a\u0001\u0003\u0017D\u0001\"a7+A\u0003&\u00111Z\u0001\u0015Q^$\u0006N]3bI&s\u0017\u000e^5bY&TX\r\u001a\u0011\t\u0013\u0005}'F1A\u0005\u0002\u0005\u0005\u0018!E:uCR,7\t[1oO\u0016dunZ4feV\u0011\u00111\u001d\t\u0005\u0003K\f\tP\u0004\u0003\u0002h\u00065XBAAu\u0015\r\tY\u000fB\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002BAx\u0003S\fqbS1gW\u0006\u001cuN\u001c;s_2dWM]\u0005\u0005\u0003g\f)PA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJTA!a<\u0002j\"A\u0011\u0011 \u0016!\u0002\u0013\t\u0019/\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0003\"CA\u007fU\t\u0007I\u0011AA\u0000\u00035I7O]#ya\u0006tGMU1uKV\u0011!\u0011\u0001\t\u0005\u0005\u0007\u0011\u0019\"\u0004\u0002\u0003\u0006)!!q\u0001B\u0005\u0003\u0011\u0019wN]3\u000b\u0007U\u0012YA\u0003\u0003\u0003\u000e\t=\u0011AB=b[6,'O\u0003\u0002\u0003\u0012\u0005\u00191m\\7\n\t\tU!Q\u0001\u0002\u0006\u001b\u0016$XM\u001d\u0005\t\u00053Q\u0003\u0015!\u0003\u0003\u0002\u0005q\u0011n\u001d:FqB\fg\u000e\u001a*bi\u0016\u0004\u0003\"\u0003B\u000fU\t\u0007I\u0011AA\u0000\u00035I7O]*ie&t7NU1uK\"A!\u0011\u0005\u0016!\u0002\u0013\u0011\t!\u0001\bjgJ\u001c\u0006N]5oWJ\u000bG/\u001a\u0011\t\u000f\t\u0015\"\u0006\"\u0001\u0003(\u0005iRO\u001c3feJ+\u0007\u000f\\5dCR,G\rU1si&$\u0018n\u001c8D_VtG\u000fF\u0001\u0000\u0011\u001d\u0011YC\u000bC\u0001\u0005[\t1e\u001d;beRD\u0015n\u001a5XCR,'/T1sWN\u001c\u0005.Z2l!>Lg\u000e\u001e+ie\u0016\fG\r\u0006\u0002\u0002\f!9!\u0011\u0007\u0016\u0005\u0002\tM\u0012\u0001I4fiJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'OR8s!\u0006\u0014H/\u001b;j_:$Ra B\u001b\u0005sA\u0001Ba\u000e\u00030\u0001\u0007\u00111H\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0005w\u0011y\u00031\u0001\u0000\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\t}\"\u0006\"\u0001\u0003.\u000591\u000f^1siV\u0004\bb\u0002B\"U\u0011\u0005!QI\u0001\fgR|\u0007OU3qY&\u001c\u0017\r\u0006\u0005\u0003H\t5#q\nB)!\ri!\u0011J\u0005\u0004\u0005\u0017r!!B*i_J$\b\u0002\u0003B\u001c\u0005\u0003\u0002\r!a\u000f\t\u000f\tm\"\u0011\ta\u0001\u007f\"A!1\u000bB!\u0001\u0004\tY-A\beK2,G/\u001a)beRLG/[8o\u0011\u001d\u00119F\u000bC\u0001\u00053\nAb\u001d;paJ+\u0007\u000f\\5dCN$BAa\u0017\u0003nA9Q\"a\u000e\u0003^\t\u001d\u0003\u0003CA0\u0005?\u0012\tGa\u0012\n\t\u0005e\u0016\u0011\r\t\u0005\u0005G\u0012I'\u0004\u0002\u0003f)\u0019!q\r\u0003\u0002\r\r|W.\\8o\u0013\u0011\u0011YG!\u001a\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0003p\tU\u0003\u0019\u0001B9\u0003I\u0019Ho\u001c9SKBd\u0017nY1SKF,Xm\u001d;\u0011\t\tM$\u0011P\u0007\u0003\u0005kR1Aa\u001e\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005w\u0012)H\u0001\nTi>\u0004(+\u001a9mS\u000e\f'+Z9vKN$\bb\u0002B@U\u0011\u0005!\u0011Q\u0001\u0015O\u0016$xJ]\"sK\u0006$X\rU1si&$\u0018n\u001c8\u0015\u0011\u0005\u001d#1\u0011BC\u0005\u000fC\u0001Ba\u000e\u0003~\u0001\u0007\u00111\b\u0005\b\u0005w\u0011i\b1\u0001\u0000\u0011\u001d\u0011II! A\u0002}\f\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011\u001d\u0011iI\u000bC\u0001\u0005\u001f\u000bAbZ3u!\u0006\u0014H/\u001b;j_:$bA!%\u0003\u0018\ne\u0005#B\u0007\u0003\u0014\u0006\u001d\u0013b\u0001BK\u001d\t1q\n\u001d;j_:D\u0001Ba\u000e\u0003\f\u0002\u0007\u00111\b\u0005\b\u0005w\u0011Y\t1\u0001\u0000\u0011\u001d\u0011iJ\u000bC\u0001\u0005?\u000bQcZ3u%\u0016\u0004H.[2b\u001fJ,\u0005pY3qi&|g\u000e\u0006\u0004\u0003\"\n\u001d&\u0011\u0016\t\u0005\u0003\u0013\u0012\u0019+\u0003\u0003\u0003&\u0006-#a\u0002*fa2L7-\u0019\u0005\t\u0005o\u0011Y\n1\u0001\u0002<!9!1\u0016BN\u0001\u0004y\u0018!\u00039beRLG/[8o\u0011\u001d\u0011yK\u000bC\u0001\u0005c\u000bqcZ3u\u0019\u0016\fG-\u001a:SKBd\u0017nY1JM2{7-\u00197\u0015\r\t\u0005&1\u0017B[\u0011!\u00119D!,A\u0002\u0005m\u0002b\u0002B\u001e\u0005[\u0003\ra \u0005\b\u0005sSC\u0011\u0001B^\u0003)9W\r\u001e*fa2L7-\u0019\u000b\t\u0005{\u0013yL!1\u0003DB)QBa%\u0003\"\"A!q\u0007B\\\u0001\u0004\tY\u0004C\u0004\u0003<\t]\u0006\u0019A@\t\u0013\t\u0015'q\u0017I\u0001\u0002\u0004y\u0018!\u0003:fa2L7-Y%e\u0011\u001d\u0011IM\u000bC\u0001\u0005\u0017\faCY3d_6,G*Z1eKJ|%OR8mY><XM\u001d\u000b\u0005\u0005\u001b\u0014)\u000eE\u0004\u000e\u0003o\u0011yMa\u0012\u0011\u0011\tE'1[A\u001b\u0005\u000fj!!!\u001a\n\t\u0005e\u0016Q\r\u0005\t\u0005/\u00149\r1\u0001\u0003Z\u0006\u0019B.Z1eKJ\fe\u000eZ%T%J+\u0017/^3tiB!!1\u000fBn\u0013\u0011\u0011iN!\u001e\u0003'1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;\t\u000f\t\u0005(\u0006\"\u0003\u0003d\u0006YQ.Y6f\u0019\u0016\fG-\u001a:t)1\tYA!:\u0003j\n5(\u0011 B\u007f\u0011\u001d\u00119Oa8A\u0002}\fAbY8oiJ|G\u000e\\3s\u0013\u0012DqAa;\u0003`\u0002\u0007q0A\u0003fa>\u001c\u0007\u000e\u0003\u0005\u0003p\n}\u0007\u0019\u0001By\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0002B!5\u0003T\u0006\u001d#1\u001f\t\u0005\u0005g\u0012)0\u0003\u0003\u0003x\nU$A\u0005)beRLG/[8o'R\fG/Z%oM>DqAa?\u0003`\u0002\u0007q0A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\t\u0005\u007f\u0014y\u000e1\u0001\u0004\u0002\u0005Y!/Z:q_:\u001cX-T1q!!\tyFa\u0018\u00026\t\u001d\u0003bBB\u0003U\u0011%1qA\u0001\u000e[\u0006\\WMR8mY><XM]:\u0015\u001d\u0005-1\u0011BB\u0006\u0007\u001b\u0019yaa\b\u0004\"!9!q]B\u0002\u0001\u0004y\bb\u0002Bv\u0007\u0007\u0001\ra \u0005\t\u0005_\u001c\u0019\u00011\u0001\u0003r\"A1\u0011CB\u0002\u0001\u0004\u0019\u0019\"A\u0004mK\u0006$WM]:\u0011\r\tE7QCB\r\u0013\u0011\u00199\"!\u001a\u0003\u0007M+G\u000f\u0005\u0003\u0002J\rm\u0011\u0002BB\u000f\u0003\u0017\u0012aA\u0011:pW\u0016\u0014\bb\u0002B~\u0007\u0007\u0001\ra \u0005\t\u0005\u007f\u001c\u0019\u00011\u0001\u0004\u0002!91Q\u0005\u0016\u0005\n\t5\u0012AD7bs\n,7\u000b\u001b:j].L5O\u001d\u0005\b\u0007SQC\u0011AB\u0016\u0003Y\u0011XmY8sI\u001a{G\u000e\\8xKJ\u0004vn]5uS>tGCCA\u0006\u0007[\u0019yc!\r\u00044!A!qGB\u0014\u0001\u0004\tY\u0004C\u0004\u0003<\r\u001d\u0002\u0019A@\t\u000f\t\u00157q\u0005a\u0001\u007f\"91QGB\u0014\u0001\u0004A\u0012AB8gMN,G\u000fC\u0004\u0004:)\"\tA!\f\u00021\rDWmY6q_&tG\u000fS5hQ^\u000bG/\u001a:nCJ\\7\u000fC\u0004\u0004>)\"\tA!\f\u0002\u0011MDW\u000f\u001e3po:D\u0011b!\u0011+#\u0003%\taa\u0011\u0002)\u001d,GOU3qY&\u001c\u0017\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019)EK\u0002\u0000\u0007\u000fZ#a!\u0013\u0011\t\r-3QK\u0007\u0003\u0007\u001bRAaa\u0014\u0004R\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007'r\u0011AC1o]>$\u0018\r^5p]&!1qKB'\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ReplicaManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Time time;
    private final ZkClient zkClient;
    private final Scheduler scheduler;
    private final LogManager logManager;
    private final AtomicBoolean isShuttingDown;
    private volatile int controllerEpoch;
    private final int kafka$server$ReplicaManager$$localBrokerId;
    private final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions;
    private HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions;
    private final Object kafka$server$ReplicaManager$$leaderPartitionsLock;
    private final Object replicaStateChangeLock;
    private final ReplicaFetcherManager replicaFetcherManager;
    private final AtomicBoolean highWatermarkCheckPointThreadStarted;
    private final scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints;
    private boolean hwThreadInitialized;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final Meter isrExpandRate;
    private final Meter isrShrinkRate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static String HighWatermarkFilename() {
        return ReplicaManager$.MODULE$.HighWatermarkFilename();
    }

    public static long UnknownLogEndOffset() {
        return ReplicaManager$.MODULE$.UnknownLogEndOffset();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaManager replicaManager = this;
        synchronized (replicaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    public int kafka$server$ReplicaManager$$localBrokerId() {
        return this.kafka$server$ReplicaManager$$localBrokerId;
    }

    public Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions() {
        return this.kafka$server$ReplicaManager$$allPartitions;
    }

    public HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions() {
        return this.kafka$server$ReplicaManager$$leaderPartitions;
    }

    private void kafka$server$ReplicaManager$$leaderPartitions_$eq(HashSet<Partition> x$1) {
        this.kafka$server$ReplicaManager$$leaderPartitions = x$1;
    }

    public Object kafka$server$ReplicaManager$$leaderPartitionsLock() {
        return this.kafka$server$ReplicaManager$$leaderPartitionsLock;
    }

    private Object replicaStateChangeLock() {
        return this.replicaStateChangeLock;
    }

    public ReplicaFetcherManager replicaFetcherManager() {
        return this.replicaFetcherManager;
    }

    private AtomicBoolean highWatermarkCheckPointThreadStarted() {
        return this.highWatermarkCheckPointThreadStarted;
    }

    public scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints() {
        return this.highWatermarkCheckpoints;
    }

    private boolean hwThreadInitialized() {
        return this.hwThreadInitialized;
    }

    private void hwThreadInitialized_$eq(boolean x$1) {
        this.hwThreadInitialized = x$1;
    }

    public KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public Meter isrExpandRate() {
        return this.isrExpandRate;
    }

    public Meter isrShrinkRate() {
        return this.isrShrinkRate;
    }

    public int underReplicatedPartitionCount() {
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            Integer n = BoxesRunTime.boxToInteger(this.kafka$server$ReplicaManager$$leaderPartitions().count((Function1<Partition, Object>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Partition x$1) {
                    return x$1.isUnderReplicated();
                }
            })));
            return BoxesRunTime.unboxToInt(n);
        }
    }

    public void startHighWaterMarksCheckPointThread() {
        if (this.highWatermarkCheckPointThreadStarted().compareAndSet(false, true)) {
            String x$9 = "highwatermark-checkpoint";
            scala.Serializable x$10 = new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkpointHighWatermarks();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
            long x$11 = this.config().replicaHighWatermarkCheckpointIntervalMs();
            TimeUnit x$12 = TimeUnit.MILLISECONDS;
            long x$13 = this.scheduler.schedule$default$3();
            this.scheduler.schedule(x$9, (Function0<BoxedUnit>)((Object)x$10), x$13, x$11, x$12);
        }
    }

    public int getReplicationFactorForPartition(String topic, int partitionId) {
        Option<Partition> option;
        block4: {
            int n;
            block3: {
                block2: {
                    Option<Partition> partitionOpt = this.getPartition(topic, partitionId);
                    option = partitionOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Partition partition2 = (Partition)some.x();
                    n = partition2.replicationFactor();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                n = -1;
            }
            return n;
        }
        throw new MatchError(option);
    }

    public void startup() {
        String x$14 = "isr-expiration";
        scala.Serializable x$15 = new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicaManager$$maybeShrinkIsr();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        long x$16 = this.config().replicaLagTimeMaxMs();
        TimeUnit x$17 = TimeUnit.MILLISECONDS;
        long x$18 = this.scheduler.schedule$default$3();
        this.scheduler.schedule(x$14, (Function0<BoxedUnit>)((Object)x$15), x$18, x$16, x$17);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short stopReplica(String topic, int partitionId, boolean deletePartition) {
        this.stateChangeLogger().trace((Function0<String>)((Object)new scala.Serializable(this, topic, partitionId, deletePartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;
            private final String topic$2;
            private final int partitionId$2;
            private final boolean deletePartition$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Broker %d handling stop replica (delete=%s) for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$localBrokerId()), ((Object)BoxesRunTime.boxToBoolean(this.deletePartition$1)).toString(), this.topic$2, BoxesRunTime.boxToInteger(this.partitionId$2)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.partitionId$2 = partitionId$2;
                this.deletePartition$1 = deletePartition$1;
            }
        }));
        short errorCode = ErrorMapping$.MODULE$.NoError();
        Option<Partition> option = this.getPartition(topic, partitionId);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            block11: {
                Some some = (Some)option;
                Partition partition2 = (Partition)some.x();
                Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    this.kafka$server$ReplicaManager$$leaderPartitions().$minus$eq((Object)partition2);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 10] lbl12 : MonitorExitStatement: MONITOREXIT : object
                    if (deletePartition) {
                        Partition removedPartition = this.kafka$server$ReplicaManager$$allPartitions().remove(new Tuple2<String, Integer>(topic, BoxesRunTime.boxToInteger(partitionId)));
                        if (removedPartition == null) {
                            boxedUnit = BoxedUnit.UNIT;
                            break block11;
                        } else {
                            removedPartition.delete();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block11;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            None$ none$ = None$.MODULE$;
            Option<Partition> option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError(option);
                }
            } else if (!none$.equals(option2)) throw new MatchError(option);
            this.stateChangeLogger().trace((Function0<String>)((Object)new scala.Serializable(this, topic, partitionId, deletePartition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManager $outer;
                private final String topic$2;
                private final int partitionId$2;
                private final boolean deletePartition$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Broker %d ignoring stop replica (delete=%s) for partition [%s,%d] as replica doesn't exist on broker")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean(this.deletePartition$1), this.topic$2, BoxesRunTime.boxToInteger(this.partitionId$2)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topic$2 = topic$2;
                    this.partitionId$2 = partitionId$2;
                    this.deletePartition$1 = deletePartition$1;
                }
            }));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.stateChangeLogger().trace((Function0<String>)((Object)new scala.Serializable(this, topic, partitionId, deletePartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;
            private final String topic$2;
            private final int partitionId$2;
            private final boolean deletePartition$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Broker %d finished handling stop replica (delete=%s) for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean(this.deletePartition$1), this.topic$2, BoxesRunTime.boxToInteger(this.partitionId$2)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.partitionId$2 = partitionId$2;
                this.deletePartition$1 = deletePartition$1;
            }
        }));
        return errorCode;
    }

    public Tuple2<scala.collection.mutable.Map<TopicAndPartition, Object>, Object> stopReplicas(StopReplicaRequest stopReplicaRequest) {
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2 tuple2;
            HashMap responseMap = new HashMap();
            if (stopReplicaRequest.controllerEpoch() < this.controllerEpoch()) {
                this.stateChangeLogger().warn((Function0<String>)((Object)new scala.Serializable(this, stopReplicaRequest){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaManager $outer;
                    private final StopReplicaRequest stopReplicaRequest$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d received stop replica request from an old controller epoch %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger(this.stopReplicaRequest$1.controllerEpoch())}))).append((Object)" Latest known controller epoch is %d ").append(BoxesRunTime.boxToInteger(this.$outer.controllerEpoch())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.stopReplicaRequest$1 = stopReplicaRequest$1;
                    }
                }));
                tuple2 = new Tuple2(responseMap, BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                this.controllerEpoch_$eq(stopReplicaRequest.controllerEpoch());
                this.replicaFetcherManager().removeFetcherForPartitions(stopReplicaRequest.partitions().map(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicAndPartition apply(TopicAndPartition r) {
                        return new TopicAndPartition(r.topic(), r.partition());
                    }
                }, Set$.MODULE$.canBuildFrom()));
                stopReplicaRequest.partitions().foreach(new scala.Serializable(this, stopReplicaRequest, responseMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaManager $outer;
                    private final StopReplicaRequest stopReplicaRequest$1;
                    private final HashMap responseMap$1;

                    public final Option<Object> apply(TopicAndPartition topicAndPartition) {
                        short errorCode = this.$outer.stopReplica(topicAndPartition.topic(), topicAndPartition.partition(), this.stopReplicaRequest$1.deletePartitions());
                        return this.responseMap$1.put(topicAndPartition, BoxesRunTime.boxToShort(errorCode));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.stopReplicaRequest$1 = stopReplicaRequest$1;
                        this.responseMap$1 = responseMap$1;
                    }
                });
                tuple2 = new Tuple2(responseMap, BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }
    }

    public Partition getOrCreatePartition(String topic, int partitionId, int replicationFactor) {
        Partition partition2 = this.kafka$server$ReplicaManager$$allPartitions().get(new Tuple2<String, Integer>(topic, BoxesRunTime.boxToInteger(partitionId)));
        if (partition2 == null) {
            this.kafka$server$ReplicaManager$$allPartitions().putIfNotExists(new Tuple2<String, Integer>(topic, BoxesRunTime.boxToInteger(partitionId)), new Partition(topic, partitionId, replicationFactor, this.time, this));
            partition2 = this.kafka$server$ReplicaManager$$allPartitions().get(new Tuple2<String, Integer>(topic, BoxesRunTime.boxToInteger(partitionId)));
        }
        return partition2;
    }

    public Option<Partition> getPartition(String topic, int partitionId) {
        Partition partition2 = this.kafka$server$ReplicaManager$$allPartitions().get(new Tuple2<String, Integer>(topic, BoxesRunTime.boxToInteger(partitionId)));
        return partition2 == null ? None$.MODULE$ : new Some<Partition>(partition2);
    }

    public Replica getReplicaOrException(String topic, int partition2) {
        Option<Replica> replicaOpt = this.getReplica(topic, partition2, this.getReplica$default$3());
        if (replicaOpt.isDefined()) {
            return replicaOpt.get();
        }
        throw new ReplicaNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Replica %d is not available for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.config().brokerId()), topic, BoxesRunTime.boxToInteger(partition2)})));
    }

    public Replica getLeaderReplicaIfLocal(String topic, int partitionId) {
        Option<Partition> partitionOpt;
        Option<Partition> option = partitionOpt = this.getPartition(topic, partitionId);
        None$ none$ = None$.MODULE$;
        Option<Partition> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new UnknownTopicOrPartitionException(new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] doesn't exist on %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partitionId), BoxesRunTime.boxToInteger(this.config().brokerId())})));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Partition partition2 = (Partition)some.x();
            Option<Replica> option3 = partition2.leaderReplicaIfLocal();
            if (option3 instanceof Some) {
                Replica leaderReplica;
                Replica replica;
                Some some2 = (Some)option3;
                Replica replica2 = replica = (leaderReplica = (Replica)some2.x());
                return replica2;
            }
            None$ none$2 = None$.MODULE$;
            Option<Replica> option4 = option3;
            if (!(none$2 != null ? !none$2.equals(option4) : option4 != null)) {
                throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partitionId), BoxesRunTime.boxToInteger(this.config().brokerId())})));
            }
            throw new MatchError(option3);
        }
        throw new MatchError(option);
    }

    public Option<Replica> getReplica(String topic, int partitionId, int replicaId) {
        Option<Partition> option;
        block4: {
            Option option2;
            block3: {
                block2: {
                    Option<Partition> partitionOpt;
                    option = partitionOpt = this.getPartition(topic, partitionId);
                    None$ none$ = None$.MODULE$;
                    Option<Partition> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block2;
                    option2 = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Partition partition2 = (Partition)some.x();
                option2 = partition2.getReplica(replicaId);
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getReplica$default$3() {
        return this.config().brokerId();
    }

    public Tuple2<Map<Tuple2<String, Object>, Object>, Object> becomeLeaderOrFollower(LeaderAndIsrRequest leaderAndISRRequest) {
        leaderAndISRRequest.partitionStateInfos().foreach(new scala.Serializable(this, leaderAndISRRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;
            public final LeaderAndIsrRequest leaderAndISRRequest$1;

            public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> x0$1) {
                Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2<String, Object> tuple22 = tuple2._1();
                    PartitionStateInfo stateInfo = tuple2._2();
                    if (tuple22 != null) {
                        String topic = tuple22._1();
                        int partition2 = tuple22._2$mcI$sp();
                        this.$outer.stateChangeLogger().trace((Function0<String>)((Object)new scala.Serializable(this, topic, partition2, stateInfo){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$becomeLeaderOrFollower$1 $outer;
                            private final String topic$3;
                            private final int partition$1;
                            private final PartitionStateInfo stateInfo$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request %s correlation id %d from controller %d epoch %d for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), this.stateInfo$1, BoxesRunTime.boxToInteger(this.$outer.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger(this.$outer.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger(this.$outer.leaderAndISRRequest$1.controllerEpoch()), this.topic$3, BoxesRunTime.boxToInteger(this.partition$1)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topic$3 = topic$3;
                                this.partition$1 = partition$1;
                                this.stateInfo$1 = stateInfo$1;
                            }
                        }));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leaderAndISRRequest$1 = leaderAndISRRequest$1;
            }
        });
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2<HashMap<Tuple2<String, Object>, Object>, Short> tuple2;
            HashMap<Tuple2<String, Object>, Object> responseMap = new HashMap<Tuple2<String, Object>, Object>();
            if (leaderAndISRRequest.controllerEpoch() < this.controllerEpoch()) {
                leaderAndISRRequest.partitionStateInfos().foreach(new scala.Serializable(this, leaderAndISRRequest){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaManager $outer;
                    public final LeaderAndIsrRequest leaderAndISRRequest$1;

                    public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> x0$2) {
                        Tuple2<String, Object> tuple2;
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = x0$2;
                        if (tuple22 != null && (tuple2 = tuple22._1()) != null) {
                            this.$outer.stateChangeLogger().warn((Function0<String>)((Object)new scala.Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$becomeLeaderOrFollower$2 $outer;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlation id %d with an old controller epoch %d. Latest known controller epoch is %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger(this.$outer.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger(this.$outer.leaderAndISRRequest$1.controllerEpoch()), BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().controllerEpoch())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple22);
                    }

                    public /* synthetic */ ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndISRRequest$1;
                    }
                });
                tuple2 = new Tuple2<HashMap<Tuple2<String, Object>, Object>, Short>(responseMap, BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                int controllerId = leaderAndISRRequest.controllerId();
                int correlationId = leaderAndISRRequest.correlationId();
                this.controllerEpoch_$eq(leaderAndISRRequest.controllerEpoch());
                HashMap partitionState = new HashMap();
                leaderAndISRRequest.partitionStateInfos().foreach(new scala.Serializable(this, leaderAndISRRequest, responseMap, controllerId, correlationId, partitionState){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaManager $outer;
                    public final LeaderAndIsrRequest leaderAndISRRequest$1;
                    private final HashMap responseMap$2;
                    public final int controllerId$1;
                    public final int correlationId$1;
                    private final HashMap partitionState$1;

                    public final Object apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> x0$3) {
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2 = x0$3;
                        if (tuple2 != null) {
                            Tuple2<String, Object> tuple22 = tuple2._1();
                            PartitionStateInfo partitionStateInfo = tuple2._2();
                            if (tuple22 != null) {
                                Serializable serializable2;
                                int partitionId;
                                String topic = tuple22._1();
                                Partition partition2 = this.$outer.getOrCreatePartition(topic, partitionId = tuple22._2$mcI$sp(), partitionStateInfo.replicationFactor());
                                int partitionLeaderEpoch = partition2.getLeaderEpoch();
                                if (partitionLeaderEpoch < partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()) {
                                    if (partitionStateInfo.allReplicas().contains(BoxesRunTime.boxToInteger(this.$outer.config().brokerId()))) {
                                        serializable2 = this.partitionState$1.put(partition2, partitionStateInfo);
                                    } else {
                                        this.$outer.stateChangeLogger().warn((Function0<String>)((Object)new scala.Serializable(this, topic, partitionStateInfo, partition2){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$becomeLeaderOrFollower$3 $outer;
                                            private final String topic$4;
                                            private final PartitionStateInfo partitionStateInfo$1;
                                            private final Partition partition$2;

                                            public final String apply() {
                                                return new StringOps(Predef$.MODULE$.augmentString("Broker %d ignoring LeaderAndIsr request with correlation id %d from controller %d epoch %d as broker is not in assigned replica list %s for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger(this.$outer.correlationId$1), BoxesRunTime.boxToInteger(this.$outer.controllerId$1), BoxesRunTime.boxToInteger(this.$outer.leaderAndISRRequest$1.controllerEpoch()), this.partitionStateInfo$1.allReplicas().mkString(","), this.topic$4, BoxesRunTime.boxToInteger(this.partition$2.partitionId())}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.topic$4 = topic$4;
                                                this.partitionStateInfo$1 = partitionStateInfo$1;
                                                this.partition$2 = partition$2;
                                            }
                                        }));
                                        serializable2 = BoxedUnit.UNIT;
                                    }
                                } else {
                                    this.$outer.stateChangeLogger().warn((Function0<String>)((Object)new scala.Serializable(this, topic, partitionStateInfo, partition2, partitionLeaderEpoch){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$becomeLeaderOrFollower$3 $outer;
                                        private final String topic$4;
                                        private final PartitionStateInfo partitionStateInfo$1;
                                        private final Partition partition$2;
                                        private final int partitionLeaderEpoch$1;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Broker %d received invalid LeaderAndIsr request with correlation id %d from controller %d epoch %d with an older leader epoch %d for partition [%s,%d], current leader epoch is %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger(this.$outer.correlationId$1), BoxesRunTime.boxToInteger(this.$outer.controllerId$1), BoxesRunTime.boxToInteger(this.$outer.leaderAndISRRequest$1.controllerEpoch()), BoxesRunTime.boxToInteger(this.partitionStateInfo$1.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()), this.topic$4, BoxesRunTime.boxToInteger(this.partition$2.partitionId()), BoxesRunTime.boxToInteger(this.partitionLeaderEpoch$1)}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.topic$4 = topic$4;
                                            this.partitionStateInfo$1 = partitionStateInfo$1;
                                            this.partition$2 = partition$2;
                                            this.partitionLeaderEpoch$1 = partitionLeaderEpoch$1;
                                        }
                                    }));
                                    serializable2 = this.responseMap$2.put(new Tuple2<String, Integer>(topic, BoxesRunTime.boxToInteger(partitionId)), BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.StaleLeaderEpochCode()));
                                }
                                Option<PartitionStateInfo> option = serializable2;
                                return option;
                            }
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndISRRequest$1;
                        this.responseMap$2 = responseMap$2;
                        this.controllerId$1 = controllerId$1;
                        this.correlationId$1 = correlationId$1;
                        this.partitionState$1 = partitionState$1;
                    }
                });
                HashMap partitionsTobeLeader = (HashMap)partitionState.filter((Function1<Tuple2<Partition, PartitionStateInfo>, Object>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaManager $outer;

                    public final boolean apply(Tuple2<Partition, PartitionStateInfo> x0$4) {
                        Tuple2<Partition, PartitionStateInfo> tuple2 = x0$4;
                        if (tuple2 != null) {
                            PartitionStateInfo partitionStateInfo = tuple2._2();
                            boolean bl = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader() == this.$outer.config().brokerId();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                HashMap partitionsToBeFollower = (HashMap)partitionState.$minus$minus(partitionsTobeLeader.keys());
                if (!partitionsTobeLeader.isEmpty()) {
                    this.makeLeaders(controllerId, this.controllerEpoch(), partitionsTobeLeader, leaderAndISRRequest.correlationId(), responseMap);
                }
                if (!partitionsToBeFollower.isEmpty()) {
                    this.makeFollowers(controllerId, this.controllerEpoch(), partitionsToBeFollower, leaderAndISRRequest.leaders(), leaderAndISRRequest.correlationId(), responseMap);
                }
                if (!this.hwThreadInitialized()) {
                    this.startHighWaterMarksCheckPointThread();
                    this.hwThreadInitialized_$eq(true);
                }
                this.replicaFetcherManager().shutdownIdleFetcherThreads();
                tuple2 = new Tuple2<HashMap<Tuple2<String, Object>, Object>, Short>(responseMap, BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2<HashMap<Tuple2<String, Object>, Object>, Short> tuple22 = tuple2;
            return tuple22;
        }
    }

    /*
     * Exception decompiling
     */
    private void makeLeaders(int controllerId, int epoch, Map<Partition, PartitionStateInfo> partitionState, int correlationId, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void makeFollowers(int controllerId, int epoch, Map<Partition, PartitionStateInfo> partitionState, Set<Broker> leaders, int correlationId, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void kafka$server$ReplicaManager$$maybeShrinkIsr() {
        this.trace((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Evaluating ISR list of partitions to see which replicas can be removed from the ISR";
            }
        }));
        List<Partition> curLeaderPartitions = null;
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            curLeaderPartitions = this.kafka$server$ReplicaManager$$leaderPartitions().toList();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
            curLeaderPartitions.foreach(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManager $outer;

                public final void apply(Partition partition2) {
                    partition2.maybeShrinkIsr(this.$outer.config().replicaLagTimeMaxMs(), this.$outer.config().replicaLagMaxMessages());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    public void recordFollowerPosition(String topic, int partitionId, int replicaId, long offset) {
        Option<Partition> partitionOpt = this.getPartition(topic, partitionId);
        if (partitionOpt.isDefined()) {
            partitionOpt.get().updateLeaderHWAndMaybeExpandIsr(replicaId, offset);
        } else {
            this.warn((Function0<String>)((Object)new scala.Serializable(this, topic, partitionId){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int partitionId$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("While recording the follower position, the partition [%s,%d] hasn't been created, skip updating leader HW")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToInteger(this.partitionId$1)}));
                }
                {
                    this.topic$1 = topic$1;
                    this.partitionId$1 = partitionId$1;
                }
            }));
        }
    }

    public void checkpointHighWatermarks() {
        Iterable<Replica> replicas = ((TraversableLike)this.kafka$server$ReplicaManager$$allPartitions().values().map(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final Option<Replica> apply(Partition x$5) {
                return x$5.getReplica(this.$outer.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).collect(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<Replica>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    Replica replica = (Replica)some.x();
                    object = replica;
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Option<Replica> x1) {
                Option<Replica> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map replicasByDir = ((TraversableLike)replicas.filter((Function1<Replica, Object>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Replica x$6) {
                return x$6.log().isDefined();
            }
        }))).groupBy(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Replica x$7) {
                return x$7.log().get().dir().getParentFile().getAbsolutePath();
            }
        });
        replicasByDir.withFilter((Function1<String, Object>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Iterable<Replica>> check$ifrefutable$1) {
                Tuple2<String, Iterable<Replica>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, Iterable<Replica>> x$8) {
                BoxedUnit boxedUnit;
                Tuple2<String, Iterable<Replica>> tuple2 = x$8;
                if (tuple2 == null) throw new MatchError(tuple2);
                String dir = tuple2._1();
                Iterable<Replica> reps = tuple2._2();
                scala.collection.immutable.Map<TopicAndPartition, Object> hwms = ((TraversableOnce)reps.map(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicAndPartition, Object> apply(Replica r) {
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(new TopicAndPartition(r)), BoxesRunTime.boxToLong(r.highWatermark()));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                try {
                    ((OffsetCheckpoint)this.$outer.highWatermarkCheckpoints().apply(dir)).write(hwms);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (IOException iOException) {
                    this.$outer.fatal((Function0<String>)((Object)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error writing to highwatermark file: ";
                        }
                    }), (Function0<Throwable>)((Object)new scala.Serializable(this, iOException){
                        public static final long serialVersionUID = 0L;
                        private final IOException e$3;

                        public final IOException apply() {
                            return this.e$3;
                        }
                        {
                            this.e$3 = e$3;
                        }
                    }));
                    Runtime.getRuntime().halt(1);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shut down";
            }
        }));
        this.replicaFetcherManager().shutdown();
        this.checkpointHighWatermarks();
        this.info((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutted down completely";
            }
        }));
    }

    public ReplicaManager(KafkaConfig config, Time time, ZkClient zkClient, Scheduler scheduler, LogManager logManager, AtomicBoolean isShuttingDown) {
        this.config = config;
        this.time = time;
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.logManager = logManager;
        this.isShuttingDown = isShuttingDown;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.kafka$server$ReplicaManager$$localBrokerId = config.brokerId();
        this.kafka$server$ReplicaManager$$allPartitions = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.kafka$server$ReplicaManager$$leaderPartitions = new HashSet();
        this.kafka$server$ReplicaManager$$leaderPartitionsLock = new Object();
        this.replicaStateChangeLock = new Object();
        this.replicaFetcherManager = new ReplicaFetcherManager(config, this);
        this.highWatermarkCheckPointThreadStarted = new AtomicBoolean(false);
        this.highWatermarkCheckpoints = ((TraversableOnce)config.logDirs().map(new $anonfun$4(this), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.hwThreadInitialized = false;
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica Manager on Broker ").append(BoxesRunTime.boxToInteger(this.kafka$server$ReplicaManager$$localBrokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.newGauge("LeaderCount", new Gauge<Object>(this){
            private final /* synthetic */ ReplicaManager $outer;

            public int value() {
                Object object = this.$outer.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    Integer n = BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaManager$$leaderPartitions().size());
                    return BoxesRunTime.unboxToInt(n);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("PartitionCount", new Gauge<Object>(this){
            private final /* synthetic */ ReplicaManager $outer;

            public int value() {
                return this.$outer.kafka$server$ReplicaManager$$allPartitions().size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("UnderReplicatedPartitions", new Gauge<Object>(this){
            private final /* synthetic */ ReplicaManager $outer;

            public int value() {
                return this.$outer.underReplicatedPartitionCount();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.isrExpandRate = this.newMeter("IsrExpandsPerSec", "expands", TimeUnit.SECONDS);
        this.isrShrinkRate = this.newMeter("IsrShrinksPerSec", "shrinks", TimeUnit.SECONDS);
    }
}

