/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.nonstiff;

import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.events.CombinedEventsManager;
import org.apache.commons.math.ode.nonstiff.AdamsIntegrator;
import org.apache.commons.math.ode.sampling.NordsieckStepInterpolator;
import org.apache.commons.math.ode.sampling.StepHandler;

public class AdamsBashforthIntegrator
extends AdamsIntegrator {
    public AdamsBashforthIntegrator(int nSteps, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws IllegalArgumentException {
        super("Adams-Bashforth", nSteps, nSteps, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public AdamsBashforthIntegrator(int nSteps, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super("Adams-Bashforth", nSteps, nSteps, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    public double integrate(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t, double[] y) throws DerivativeException, IntegratorException {
        boolean forward;
        int n = y0.length;
        this.sanityChecks(equations, t0, y0, t, y);
        this.setEquations(equations);
        this.resetEvaluations();
        boolean bl = forward = t > t0;
        if (y != y0) {
            System.arraycopy(y0, 0, y, 0, n);
        }
        double[] yDot = new double[n];
        double[] yTmp = new double[y0.length];
        NordsieckStepInterpolator interpolator = new NordsieckStepInterpolator();
        interpolator.reinitialize(y, forward);
        NordsieckStepInterpolator interpolatorTmp = new NordsieckStepInterpolator();
        interpolatorTmp.reinitialize(yTmp, forward);
        for (StepHandler handler : this.stepHandlers) {
            handler.reset();
        }
        CombinedEventsManager manager = this.addEndTimeChecker(t0, t, this.eventsHandlersManager);
        this.start(t0, y, t);
        interpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
        interpolator.storeTime(this.stepStart);
        int lastRow = this.nordsieck.getRowDimension() - 1;
        double hNew = this.stepSize;
        interpolator.rescale(hNew);
        boolean lastStep = false;
        while (!lastStep) {
            interpolator.shift();
            double error = 0.0;
            boolean loop2 = true;
            while (loop2) {
                this.stepSize = hNew;
                error = 0.0;
                for (int i = 0; i < y0.length; ++i) {
                    double yScale = Math.abs(y[i]);
                    double tol = this.vecAbsoluteTolerance == null ? this.scalAbsoluteTolerance + this.scalRelativeTolerance * yScale : this.vecAbsoluteTolerance[i] + this.vecRelativeTolerance[i] * yScale;
                    double ratio = this.nordsieck.getEntry(lastRow, i) / tol;
                    error += ratio * ratio;
                }
                if ((error = Math.sqrt(error / (double)y0.length)) <= 1.0) {
                    double stepEnd = this.stepStart + this.stepSize;
                    interpolator.setInterpolatedTime(stepEnd);
                    System.arraycopy(interpolator.getInterpolatedState(), 0, yTmp, 0, y0.length);
                    this.computeDerivatives(stepEnd, yTmp, yDot);
                    double[] predictedScaled = new double[y0.length];
                    for (int j = 0; j < y0.length; ++j) {
                        predictedScaled[j] = this.stepSize * yDot[j];
                    }
                    Array2DRowRealMatrix nordsieckTmp = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                    this.updateHighOrderDerivativesPhase2(this.scaled, predictedScaled, nordsieckTmp);
                    interpolatorTmp.reinitialize(stepEnd, this.stepSize, predictedScaled, nordsieckTmp);
                    interpolatorTmp.storeTime(this.stepStart);
                    interpolatorTmp.shift();
                    interpolatorTmp.storeTime(stepEnd);
                    if (manager.evaluateStep(interpolatorTmp)) {
                        double dt = manager.getEventTime() - this.stepStart;
                        if (Math.abs(dt) <= Math.ulp(this.stepStart)) {
                            interpolator.storeTime(this.stepStart);
                            System.arraycopy(y, 0, yTmp, 0, y0.length);
                            hNew = 0.0;
                            this.stepSize = 0.0;
                            loop2 = false;
                            continue;
                        }
                        hNew = dt;
                        interpolator.rescale(hNew);
                        continue;
                    }
                    this.scaled = predictedScaled;
                    this.nordsieck = nordsieckTmp;
                    interpolator.reinitialize(stepEnd, this.stepSize, this.scaled, this.nordsieck);
                    loop2 = false;
                    continue;
                }
                double factor = this.computeStepGrowShrinkFactor(error);
                hNew = this.filterStep(this.stepSize * factor, forward, false);
                interpolator.rescale(hNew);
            }
            double nextStep = this.stepStart + this.stepSize;
            System.arraycopy(yTmp, 0, y, 0, n);
            interpolator.storeTime(nextStep);
            manager.stepAccepted(nextStep, y);
            lastStep = manager.stop();
            for (StepHandler handler : this.stepHandlers) {
                interpolator.setInterpolatedTime(nextStep);
                handler.handleStep(interpolator, lastStep);
            }
            this.stepStart = nextStep;
            if (!lastStep && manager.reset(this.stepStart, y)) {
                this.start(this.stepStart, y, t);
                interpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
            }
            if (lastStep) continue;
            this.stepSize = this.filterStep(this.stepSize, forward, true);
            double factor = this.computeStepGrowShrinkFactor(error);
            double scaledH = this.stepSize * factor;
            double nextT = this.stepStart + scaledH;
            boolean nextIsLast = forward ? nextT >= t : nextT <= t;
            hNew = this.filterStep(scaledH, forward, nextIsLast);
            interpolator.rescale(hNew);
        }
        double stopTime = this.stepStart;
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
        return stopTime;
    }
}

