/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NotPositiveDefiniteMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.random.NormalizedRandomGenerator;
import org.apache.commons.math.random.RandomVectorGenerator;

public class CorrelatedRandomVectorGenerator
implements RandomVectorGenerator {
    private final double[] mean;
    private final NormalizedRandomGenerator generator;
    private final double[] normalized;
    private RealMatrix root;
    private int rank;

    public CorrelatedRandomVectorGenerator(double[] mean, RealMatrix covariance, double small, NormalizedRandomGenerator generator) throws NotPositiveDefiniteMatrixException, DimensionMismatchException {
        int order = covariance.getRowDimension();
        if (mean.length != order) {
            throw new DimensionMismatchException(mean.length, order);
        }
        this.mean = (double[])mean.clone();
        this.decompose(covariance, small);
        this.generator = generator;
        this.normalized = new double[this.rank];
    }

    public CorrelatedRandomVectorGenerator(RealMatrix covariance, double small, NormalizedRandomGenerator generator) throws NotPositiveDefiniteMatrixException {
        int order = covariance.getRowDimension();
        this.mean = new double[order];
        for (int i = 0; i < order; ++i) {
            this.mean[i] = 0.0;
        }
        this.decompose(covariance, small);
        this.generator = generator;
        this.normalized = new double[this.rank];
    }

    public NormalizedRandomGenerator getGenerator() {
        return this.generator;
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    public int getRank() {
        return this.rank;
    }

    private void decompose(RealMatrix covariance, double small) throws NotPositiveDefiniteMatrixException {
        int i;
        int order = covariance.getRowDimension();
        double[][] c = covariance.getData();
        double[][] b = new double[order][order];
        int[] swap = new int[order];
        int[] index2 = new int[order];
        for (i = 0; i < order; ++i) {
            index2[i] = i;
        }
        this.rank = 0;
        boolean loop2 = true;
        while (loop2) {
            double sqrt;
            int ir;
            swap[this.rank] = this.rank;
            for (int i2 = this.rank + 1; i2 < order; ++i2) {
                int ii = index2[i2];
                int isi = index2[swap[i2]];
                if (!(c[ii][ii] > c[isi][isi])) continue;
                swap[this.rank] = i2;
            }
            if (swap[this.rank] != this.rank) {
                int tmp = index2[this.rank];
                index2[this.rank] = index2[swap[this.rank]];
                index2[swap[this.rank]] = tmp;
            }
            if (c[ir = index2[this.rank]][ir] < small) {
                if (this.rank == 0) {
                    throw new NotPositiveDefiniteMatrixException();
                }
                for (int i3 = this.rank; i3 < order; ++i3) {
                    if (!(c[index2[i3]][index2[i3]] < -small)) continue;
                    throw new NotPositiveDefiniteMatrixException();
                }
                ++this.rank;
                loop2 = false;
                continue;
            }
            b[this.rank][this.rank] = sqrt = Math.sqrt(c[ir][ir]);
            double inverse = 1.0 / sqrt;
            for (int i4 = this.rank + 1; i4 < order; ++i4) {
                double e;
                int ii = index2[i4];
                b[i4][this.rank] = e = inverse * c[ii][ir];
                double[] dArray = c[ii];
                int n = ii;
                dArray[n] = dArray[n] - e * e;
                for (int j = this.rank + 1; j < i4; ++j) {
                    double f;
                    int ij = index2[j];
                    c[ii][ij] = f = c[ii][ij] - e * b[j][this.rank];
                    c[ij][ii] = f;
                }
            }
            loop2 = ++this.rank < order;
        }
        this.root = MatrixUtils.createRealMatrix(order, this.rank);
        for (i = 0; i < order; ++i) {
            for (int j = 0; j < this.rank; ++j) {
                this.root.setEntry(index2[i], j, b[i][j]);
            }
        }
    }

    public double[] nextVector() {
        for (int i = 0; i < this.rank; ++i) {
            this.normalized[i] = this.generator.nextNormalizedDouble();
        }
        double[] correlated = new double[this.mean.length];
        for (int i = 0; i < correlated.length; ++i) {
            correlated[i] = this.mean[i];
            for (int j = 0; j < this.rank; ++j) {
                int n = i;
                correlated[n] = correlated[n] + this.root.getEntry(i, j) * this.normalized[j];
            }
        }
        return correlated;
    }
}

