/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;

public class VectorialCovariance
implements Serializable {
    private static final long serialVersionUID = 4118372414238930270L;
    private final double[] sums;
    private final double[] productsSums;
    private final boolean isBiasCorrected;
    private long n;

    public VectorialCovariance(int dimension, boolean isBiasCorrected) {
        this.sums = new double[dimension];
        this.productsSums = new double[dimension * (dimension + 1) / 2];
        this.n = 0L;
        this.isBiasCorrected = isBiasCorrected;
    }

    public void increment(double[] v) throws DimensionMismatchException {
        if (v.length != this.sums.length) {
            throw new DimensionMismatchException(v.length, this.sums.length);
        }
        int k = 0;
        for (int i = 0; i < v.length; ++i) {
            int n = i;
            this.sums[n] = this.sums[n] + v[i];
            for (int j = 0; j <= i; ++j) {
                int n2 = k++;
                this.productsSums[n2] = this.productsSums[n2] + v[i] * v[j];
            }
        }
        ++this.n;
    }

    public RealMatrix getResult() {
        int dimension = this.sums.length;
        RealMatrix result2 = MatrixUtils.createRealMatrix(dimension, dimension);
        if (this.n > 1L) {
            double c = 1.0 / (double)(this.n * (this.isBiasCorrected ? this.n - 1L : this.n));
            int k = 0;
            for (int i = 0; i < dimension; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double e = c * ((double)this.n * this.productsSums[k++] - this.sums[i] * this.sums[j]);
                    result2.setEntry(i, j, e);
                    result2.setEntry(j, i, e);
                }
            }
        }
        return result2;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.n = 0L;
        Arrays.fill(this.sums, 0.0);
        Arrays.fill(this.productsSums, 0.0);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.isBiasCorrected ? 1231 : 1237);
        result2 = 31 * result2 + (int)(this.n ^ this.n >>> 32);
        result2 = 31 * result2 + Arrays.hashCode(this.productsSums);
        result2 = 31 * result2 + Arrays.hashCode(this.sums);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VectorialCovariance)) {
            return false;
        }
        VectorialCovariance other = (VectorialCovariance)obj;
        if (this.isBiasCorrected != other.isBiasCorrected) {
            return false;
        }
        if (this.n != other.n) {
            return false;
        }
        if (!Arrays.equals(this.productsSums, other.productsSums)) {
            return false;
        }
        return Arrays.equals(this.sums, other.sums);
    }
}

