/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;

public final class TFTPAckPacket
extends TFTPPacket {
    int _blockNumber;

    public TFTPAckPacket(InetAddress destination, int port, int blockNumber) {
        super(4, destination, port);
        this._blockNumber = blockNumber;
    }

    TFTPAckPacket(DatagramPacket datagram) throws TFTPPacketException {
        super(4, datagram.getAddress(), datagram.getPort());
        byte[] data2 = datagram.getData();
        if (this.getType() != data2[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        this._blockNumber = (data2[2] & 0xFF) << 8 | data2[3] & 0xFF;
    }

    DatagramPacket _newDatagram(DatagramPacket datagram, byte[] data2) {
        data2[0] = 0;
        data2[1] = (byte)this._type;
        data2[2] = (byte)((this._blockNumber & 0xFFFF) >> 8);
        data2[3] = (byte)(this._blockNumber & 0xFF);
        datagram.setAddress(this._address);
        datagram.setPort(this._port);
        datagram.setData(data2);
        datagram.setLength(4);
        return datagram;
    }

    public DatagramPacket newDatagram() {
        byte[] data2 = new byte[]{0, (byte)this._type, (byte)((this._blockNumber & 0xFFFF) >> 8), (byte)(this._blockNumber & 0xFF)};
        return new DatagramPacket(data2, data2.length, this._address, this._port);
    }

    public int getBlockNumber() {
        return this._blockNumber;
    }

    public void setBlockNumber(int blockNumber) {
        this._blockNumber = blockNumber;
    }
}

