/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class FSLinkResolver<T> {
    public static Path qualifySymlinkTarget(URI pathURI, Path pathWithLink, Path target) {
        URI targetUri = target.toUri();
        String scheme = targetUri.getScheme();
        String auth = targetUri.getAuthority();
        return scheme == null && auth == null ? target.makeQualified(pathURI, pathWithLink.getParent()) : target;
    }

    public abstract T next(AbstractFileSystem var1, Path var2) throws IOException, UnresolvedLinkException;

    public T resolve(FileContext fc, Path path) throws IOException {
        int count2 = 0;
        T in = null;
        Path p = path;
        AbstractFileSystem fs = fc.getFSofPath(p);
        boolean isLink = true;
        while (isLink) {
            try {
                in = this.next(fs, p);
                isLink = false;
            }
            catch (UnresolvedLinkException e) {
                if (!fc.resolveSymlinks) {
                    throw new IOException("Path " + path + " contains a symlink" + " and symlink resolution is disabled (" + "fs.client.resolve.remote.symlinks" + ").", e);
                }
                if (count2++ > 32) {
                    throw new IOException("Possible cyclic loop while following symbolic link " + path);
                }
                p = FSLinkResolver.qualifySymlinkTarget(fs.getUri(), p, fs.getLinkTarget(p));
                fs = fc.getFSofPath(p);
            }
        }
        return in;
    }
}

