/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public enum FsAction {
    NONE("---"),
    EXECUTE("--x"),
    WRITE("-w-"),
    WRITE_EXECUTE("-wx"),
    READ("r--"),
    READ_EXECUTE("r-x"),
    READ_WRITE("rw-"),
    ALL("rwx");

    private static final FsAction[] vals;
    public final String SYMBOL;

    private FsAction(String s2) {
        this.SYMBOL = s2;
    }

    public boolean implies(FsAction that) {
        if (that != null) {
            return (this.ordinal() & that.ordinal()) == that.ordinal();
        }
        return false;
    }

    public FsAction and(FsAction that) {
        return vals[this.ordinal() & that.ordinal()];
    }

    public FsAction or(FsAction that) {
        return vals[this.ordinal() | that.ordinal()];
    }

    public FsAction not() {
        return vals[7 - this.ordinal()];
    }

    static {
        vals = FsAction.values();
    }
}

