/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class XmlEditsVisitor
implements OfflineEditsVisitor {
    private OutputStream out;
    private ContentHandler contentHandler;

    public XmlEditsVisitor(OutputStream out) throws IOException {
        this.out = out;
        OutputFormat outFormat = new OutputFormat("XML", "UTF-8", true);
        outFormat.setIndenting(true);
        outFormat.setIndent(2);
        outFormat.setDoctype(null, null);
        XMLSerializer serializer = new XMLSerializer(out, outFormat);
        this.contentHandler = serializer.asContentHandler();
        try {
            this.contentHandler.startDocument();
            this.contentHandler.startElement("", "", "EDITS", new AttributesImpl());
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
    }

    @Override
    public void start(int version) throws IOException {
        try {
            this.contentHandler.startElement("", "", "EDITS_VERSION", new AttributesImpl());
            StringBuilder bld = new StringBuilder();
            bld.append(version);
            this.addString(bld.toString());
            this.contentHandler.endElement("", "", "EDITS_VERSION");
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
    }

    public void addString(String str) throws SAXException {
        int slen = str.length();
        char[] arr = new char[slen];
        str.getChars(0, slen, arr, 0);
        this.contentHandler.characters(arr, 0, slen);
    }

    @Override
    public void close(Throwable error) throws IOException {
        try {
            this.contentHandler.endElement("", "", "EDITS");
            if (error != null) {
                String msg = error.getMessage();
                XMLUtils.addSaxString(this.contentHandler, "ERROR", msg == null ? "null" : msg);
            }
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
        this.out.close();
    }

    @Override
    public void visitOp(FSEditLogOp op) throws IOException {
        try {
            op.outputToXml(this.contentHandler);
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
    }
}

