/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HttpConfig {
    private static Policy policy;

    public static void setPolicy(Policy policy) {
        HttpConfig.policy = policy;
    }

    public static boolean isSecure() {
        return policy == Policy.HTTPS_ONLY;
    }

    public static String getSchemePrefix() {
        return HttpConfig.isSecure() ? "https://" : "http://";
    }

    public static String getScheme(Policy policy) {
        return policy == Policy.HTTPS_ONLY ? "https://" : "http://";
    }

    static {
        Configuration conf = new Configuration();
        boolean sslEnabled = conf.getBoolean("hadoop.ssl.enabled", false);
        policy = sslEnabled ? Policy.HTTPS_ONLY : Policy.HTTP_ONLY;
    }

    public static enum Policy {
        HTTP_ONLY,
        HTTPS_ONLY;


        public static Policy fromString(String value2) {
            if (value2.equalsIgnoreCase("HTTPS_ONLY")) {
                return HTTPS_ONLY;
            }
            return HTTP_ONLY;
        }
    }
}

