/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.Event;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChangedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdatedEvent;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class EventReader
implements Closeable {
    private String version;
    private Schema schema;
    private DataInputStream in;
    private Decoder decoder;
    private DatumReader reader;

    public EventReader(FileSystem fs, Path name) throws IOException {
        this(fs.open(name));
    }

    public EventReader(DataInputStream in) throws IOException {
        this.in = in;
        this.version = in.readLine();
        if (!"Avro-Json".equals(this.version)) {
            throw new IOException("Incompatible event log version: " + this.version);
        }
        this.schema = Schema.parse(in.readLine());
        this.reader = new SpecificDatumReader(this.schema);
        this.decoder = DecoderFactory.get().jsonDecoder(this.schema, in);
    }

    public HistoryEvent getNextEvent() throws IOException {
        HistoryEvent result2;
        Event wrapper;
        try {
            wrapper = this.reader.read(null, this.decoder);
        }
        catch (EOFException e) {
            return null;
        }
        switch (wrapper.type) {
            case JOB_SUBMITTED: {
                result2 = new JobSubmittedEvent();
                break;
            }
            case JOB_INITED: {
                result2 = new JobInitedEvent();
                break;
            }
            case JOB_FINISHED: {
                result2 = new JobFinishedEvent();
                break;
            }
            case JOB_PRIORITY_CHANGED: {
                result2 = new JobPriorityChangeEvent();
                break;
            }
            case JOB_STATUS_CHANGED: {
                result2 = new JobStatusChangedEvent();
                break;
            }
            case JOB_FAILED: {
                result2 = new JobUnsuccessfulCompletionEvent();
                break;
            }
            case JOB_KILLED: {
                result2 = new JobUnsuccessfulCompletionEvent();
                break;
            }
            case JOB_ERROR: {
                result2 = new JobUnsuccessfulCompletionEvent();
                break;
            }
            case JOB_INFO_CHANGED: {
                result2 = new JobInfoChangeEvent();
                break;
            }
            case TASK_STARTED: {
                result2 = new TaskStartedEvent();
                break;
            }
            case TASK_FINISHED: {
                result2 = new TaskFinishedEvent();
                break;
            }
            case TASK_FAILED: {
                result2 = new TaskFailedEvent();
                break;
            }
            case TASK_UPDATED: {
                result2 = new TaskUpdatedEvent();
                break;
            }
            case MAP_ATTEMPT_STARTED: {
                result2 = new TaskAttemptStartedEvent();
                break;
            }
            case MAP_ATTEMPT_FINISHED: {
                result2 = new MapAttemptFinishedEvent();
                break;
            }
            case MAP_ATTEMPT_FAILED: {
                result2 = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case MAP_ATTEMPT_KILLED: {
                result2 = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case REDUCE_ATTEMPT_STARTED: {
                result2 = new TaskAttemptStartedEvent();
                break;
            }
            case REDUCE_ATTEMPT_FINISHED: {
                result2 = new ReduceAttemptFinishedEvent();
                break;
            }
            case REDUCE_ATTEMPT_FAILED: {
                result2 = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case REDUCE_ATTEMPT_KILLED: {
                result2 = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case SETUP_ATTEMPT_STARTED: {
                result2 = new TaskAttemptStartedEvent();
                break;
            }
            case SETUP_ATTEMPT_FINISHED: {
                result2 = new TaskAttemptFinishedEvent();
                break;
            }
            case SETUP_ATTEMPT_FAILED: {
                result2 = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case SETUP_ATTEMPT_KILLED: {
                result2 = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case CLEANUP_ATTEMPT_STARTED: {
                result2 = new TaskAttemptStartedEvent();
                break;
            }
            case CLEANUP_ATTEMPT_FINISHED: {
                result2 = new TaskAttemptFinishedEvent();
                break;
            }
            case CLEANUP_ATTEMPT_FAILED: {
                result2 = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case CLEANUP_ATTEMPT_KILLED: {
                result2 = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case AM_STARTED: {
                result2 = new AMStartedEvent();
                break;
            }
            default: {
                throw new RuntimeException("unexpected event type: " + (Object)((Object)wrapper.type));
            }
        }
        result2.setDatum(wrapper.event);
        return result2;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
    }

    static Counters fromAvro(JhCounters counters) {
        Counters result2 = new Counters();
        for (JhCounterGroup g : counters.groups) {
            CounterGroup group = (CounterGroup)result2.addGroup(StringInterner.weakIntern(((Object)g.name).toString()), StringInterner.weakIntern(((Object)g.displayName).toString()));
            for (JhCounter c : g.counts) {
                group.addCounter(StringInterner.weakIntern(((Object)c.name).toString()), StringInterner.weakIntern(((Object)c.displayName).toString()), c.value);
            }
        }
        return result2;
    }
}

