/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleScheduler;

class EventFetcher<K, V>
extends Thread {
    private static final long SLEEP_TIME = 1000L;
    private static final int MAX_RETRIES = 10;
    private static final int RETRY_PERIOD = 5000;
    private static final Log LOG = LogFactory.getLog(EventFetcher.class);
    private final TaskAttemptID reduce;
    private final TaskUmbilicalProtocol umbilical;
    private final ShuffleScheduler<K, V> scheduler;
    private int fromEventIdx = 0;
    private final int maxEventsToFetch;
    private final ExceptionReporter exceptionReporter;
    private volatile boolean stopped = false;

    public EventFetcher(TaskAttemptID reduce2, TaskUmbilicalProtocol umbilical, ShuffleScheduler<K, V> scheduler, ExceptionReporter reporter, int maxEventsToFetch) {
        this.setName("EventFetcher for fetching Map Completion Events");
        this.setDaemon(true);
        this.reduce = reduce2;
        this.umbilical = umbilical;
        this.scheduler = scheduler;
        this.exceptionReporter = reporter;
        this.maxEventsToFetch = maxEventsToFetch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int failures = 0;
        LOG.info((Object)(this.reduce + " Thread started: " + this.getName()));
        try {
            while (!this.stopped && !Thread.currentThread().isInterrupted()) {
                try {
                    int numNewMaps = this.getMapCompletionEvents();
                    failures = 0;
                    if (numNewMaps > 0) {
                        LOG.info((Object)(this.reduce + ": " + "Got " + numNewMaps + " new map-outputs"));
                    }
                    LOG.debug((Object)"GetMapEventsThread about to sleep for 1000");
                    if (Thread.currentThread().isInterrupted()) continue;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"EventFetcher is interrupted.. Returning");
                    return;
                }
                catch (IOException ie) {
                    LOG.info((Object)"Exception in getting events", (Throwable)ie);
                    if (++failures >= 10) {
                        throw new IOException("too many failures downloading events", ie);
                    }
                    if (Thread.currentThread().isInterrupted()) continue;
                    Thread.sleep(5000L);
                }
            }
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        catch (Throwable t) {
            this.exceptionReporter.reportException(t);
            return;
        }
    }

    public void shutDown() {
        this.stopped = true;
        this.interrupt();
        try {
            this.join(5000L);
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Got interrupted while joining " + this.getName()), (Throwable)ie);
        }
    }

    protected int getMapCompletionEvents() throws IOException, InterruptedException {
        int numNewMaps = 0;
        TaskCompletionEvent[] events2 = null;
        do {
            MapTaskCompletionEventsUpdate update2 = this.umbilical.getMapCompletionEvents((JobID)this.reduce.getJobID(), this.fromEventIdx, this.maxEventsToFetch, (org.apache.hadoop.mapred.TaskAttemptID)this.reduce);
            events2 = update2.getMapTaskCompletionEvents();
            LOG.debug((Object)("Got " + events2.length + " map completion events from " + this.fromEventIdx));
            assert (!update2.shouldReset()) : "Unexpected legacy state";
            this.fromEventIdx += events2.length;
            for (TaskCompletionEvent event : events2) {
                this.scheduler.resolve(event);
                if (TaskCompletionEvent.Status.SUCCEEDED != event.getTaskStatus()) continue;
                ++numNewMaps;
            }
        } while (events2.length == this.maxEventsToFetch);
        return numNewMaps;
    }
}

