/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapred.IFileInputStream;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class InMemoryMapOutput<K, V>
extends MapOutput<K, V> {
    private static final Log LOG = LogFactory.getLog(InMemoryMapOutput.class);
    private Configuration conf;
    private final MergeManagerImpl<K, V> merger;
    private final byte[] memory;
    private BoundedByteArrayOutputStream byteStream;
    private final CompressionCodec codec;
    private final Decompressor decompressor;

    public InMemoryMapOutput(Configuration conf, TaskAttemptID mapId, MergeManagerImpl<K, V> merger, int size2, CompressionCodec codec, boolean primaryMapOutput) {
        super(mapId, size2, primaryMapOutput);
        this.conf = conf;
        this.merger = merger;
        this.codec = codec;
        this.byteStream = new BoundedByteArrayOutputStream(size2);
        this.memory = this.byteStream.getBuffer();
        this.decompressor = codec != null ? CodecPool.getDecompressor(codec) : null;
    }

    public byte[] getMemory() {
        return this.memory;
    }

    public BoundedByteArrayOutputStream getArrayStream() {
        return this.byteStream;
    }

    @Override
    public void shuffle(MapHost host, InputStream input2, long compressedLength, long decompressedLength, ShuffleClientMetrics metrics, Reporter reporter) throws IOException {
        IFileInputStream checksumIn = new IFileInputStream(input2, compressedLength, this.conf);
        input2 = checksumIn;
        if (this.codec != null) {
            this.decompressor.reset();
            input2 = this.codec.createInputStream(input2, this.decompressor);
        }
        try {
            IOUtils.readFully(input2, this.memory, 0, this.memory.length);
            metrics.inputBytes(this.memory.length);
            reporter.progress();
            LOG.info((Object)("Read " + this.memory.length + " bytes from map-output for " + this.getMapId()));
            if (input2.read() >= 0) {
                throw new IOException("Unexpected extra bytes from input stream for " + this.getMapId());
            }
        }
        catch (IOException ioe) {
            IOUtils.cleanup(LOG, input2);
            throw ioe;
        }
        finally {
            CodecPool.returnDecompressor(this.decompressor);
        }
    }

    @Override
    public void commit() throws IOException {
        this.merger.closeInMemoryFile(this);
    }

    @Override
    public void abort() {
        this.merger.unreserve(this.memory.length);
    }

    @Override
    public String getDescription() {
        return "MEMORY";
    }
}

