/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.IFileOutputStream;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryWriter<K, V>
extends IFile.Writer<K, V> {
    private DataOutputStream out;

    public InMemoryWriter(BoundedByteArrayOutputStream arrayStream) {
        super(null);
        this.out = new DataOutputStream(new IFileOutputStream(arrayStream));
    }

    @Override
    public void append(K key, V value2) throws IOException {
        throw new UnsupportedOperationException("InMemoryWriter.append(K key, V value");
    }

    @Override
    public void append(DataInputBuffer key, DataInputBuffer value2) throws IOException {
        int keyLength = key.getLength() - key.getPosition();
        if (keyLength < 0) {
            throw new IOException("Negative key-length not allowed: " + keyLength + " for " + key);
        }
        int valueLength = value2.getLength() - value2.getPosition();
        if (valueLength < 0) {
            throw new IOException("Negative value-length not allowed: " + valueLength + " for " + value2);
        }
        WritableUtils.writeVInt(this.out, keyLength);
        WritableUtils.writeVInt(this.out, valueLength);
        this.out.write(key.getData(), key.getPosition(), keyLength);
        this.out.write(value2.getData(), value2.getPosition(), valueLength);
    }

    @Override
    public void close() throws IOException {
        WritableUtils.writeVInt(this.out, -1);
        WritableUtils.writeVInt(this.out, -1);
        this.out.close();
        this.out = null;
    }
}

