/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.record.compiler.CodeGenerator;
import org.apache.hadoop.record.compiler.JFile;
import org.apache.hadoop.record.compiler.JRecord;

class CppGenerator
extends CodeGenerator {
    CppGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void genCode(String name, ArrayList<JFile> ilist, ArrayList<JRecord> rlist, String destDir, ArrayList<String> options) throws IOException {
        name = new File(destDir, new File(name).getName()).getAbsolutePath();
        FileWriter cc = new FileWriter(name + ".cc");
        try {
            FileWriter hh = new FileWriter(name + ".hh");
            try {
                String fileName = new File(name).getName();
                hh.write("#ifndef __" + fileName.toUpperCase().replace('.', '_') + "__\n");
                hh.write("#define __" + fileName.toUpperCase().replace('.', '_') + "__\n");
                hh.write("#include \"recordio.hh\"\n");
                hh.write("#include \"recordTypeInfo.hh\"\n");
                Iterator<Object> iter2 = ilist.iterator();
                while (iter2.hasNext()) {
                    hh.write("#include \"" + iter2.next().getName() + ".hh\"\n");
                }
                cc.write("#include \"" + fileName + ".hh\"\n");
                cc.write("#include \"utils.hh\"\n");
                iter2 = rlist.iterator();
                while (iter2.hasNext()) {
                    ((JRecord)iter2.next()).genCppCode(hh, cc, options);
                }
                hh.write("#endif //" + fileName.toUpperCase().replace('.', '_') + "__\n");
            }
            finally {
                hh.close();
            }
        }
        finally {
            cc.close();
        }
    }
}

