/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class AbstractDelegationTokenSelector<TokenIdent extends AbstractDelegationTokenIdentifier>
implements TokenSelector<TokenIdent> {
    private Text kindName;

    protected AbstractDelegationTokenSelector(Text kindName) {
        this.kindName = kindName;
    }

    @Override
    public Token<TokenIdent> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token2 : tokens) {
            if (!this.kindName.equals(token2.getKind()) || !service.equals(token2.getService())) continue;
            return token2;
        }
        return null;
    }
}

