/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.util.NativeCrc32;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.PureJavaCrc32C;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class DataChecksum
implements Checksum {
    public static final int HEADER_LEN = 5;
    public static final int CHECKSUM_NULL = 0;
    public static final int CHECKSUM_CRC32 = 1;
    public static final int CHECKSUM_CRC32C = 2;
    public static final int CHECKSUM_DEFAULT = 3;
    public static final int CHECKSUM_MIXED = 4;
    private final Type type;
    private final Checksum summer;
    private final int bytesPerChecksum;
    private int inSum = 0;
    public static final int SIZE_OF_INTEGER = 4;

    public static DataChecksum newDataChecksum(Type type, int bytesPerChecksum) {
        if (bytesPerChecksum <= 0) {
            return null;
        }
        switch (type) {
            case NULL: {
                return new DataChecksum(type, new ChecksumNull(), bytesPerChecksum);
            }
            case CRC32: {
                return new DataChecksum(type, new PureJavaCrc32(), bytesPerChecksum);
            }
            case CRC32C: {
                return new DataChecksum(type, new PureJavaCrc32C(), bytesPerChecksum);
            }
        }
        return null;
    }

    public static DataChecksum newDataChecksum(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 5) {
            return null;
        }
        int bytesPerChecksum = (bytes[offset + 1] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 8 | bytes[offset + 4] & 0xFF;
        return DataChecksum.newDataChecksum(Type.valueOf(bytes[offset]), bytesPerChecksum);
    }

    public static DataChecksum newDataChecksum(DataInputStream in) throws IOException {
        byte type = in.readByte();
        int bpc = in.readInt();
        DataChecksum summer = DataChecksum.newDataChecksum(Type.valueOf(type), bpc);
        if (summer == null) {
            throw new IOException("Could not create DataChecksum of type " + type + " with bytesPerChecksum " + bpc);
        }
        return summer;
    }

    public void writeHeader(DataOutputStream out) throws IOException {
        out.writeByte(this.type.id);
        out.writeInt(this.bytesPerChecksum);
    }

    public byte[] getHeader() {
        byte[] header = new byte[]{(byte)(this.type.id & 0xFF), (byte)(this.bytesPerChecksum >>> 24 & 0xFF), (byte)(this.bytesPerChecksum >>> 16 & 0xFF), (byte)(this.bytesPerChecksum >>> 8 & 0xFF), (byte)(this.bytesPerChecksum & 0xFF)};
        return header;
    }

    public int writeValue(DataOutputStream out, boolean reset2) throws IOException {
        if (this.type.size <= 0) {
            return 0;
        }
        if (this.type.size != 4) {
            throw new IOException("Unknown Checksum " + (Object)((Object)this.type));
        }
        out.writeInt((int)this.summer.getValue());
        if (reset2) {
            this.reset();
        }
        return this.type.size;
    }

    public int writeValue(byte[] buf, int offset, boolean reset2) throws IOException {
        if (this.type.size <= 0) {
            return 0;
        }
        if (this.type.size != 4) {
            throw new IOException("Unknown Checksum " + (Object)((Object)this.type));
        }
        int checksum = (int)this.summer.getValue();
        buf[offset + 0] = (byte)(checksum >>> 24 & 0xFF);
        buf[offset + 1] = (byte)(checksum >>> 16 & 0xFF);
        buf[offset + 2] = (byte)(checksum >>> 8 & 0xFF);
        buf[offset + 3] = (byte)(checksum & 0xFF);
        if (reset2) {
            this.reset();
        }
        return this.type.size;
    }

    public boolean compare(byte[] buf, int offset) {
        if (this.type.size == 4) {
            int checksum = (buf[offset + 0] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
            return checksum == (int)this.summer.getValue();
        }
        return this.type.size == 0;
    }

    private DataChecksum(Type type, Checksum checksum, int chunkSize) {
        this.type = type;
        this.summer = checksum;
        this.bytesPerChecksum = chunkSize;
    }

    public Type getChecksumType() {
        return this.type;
    }

    public int getChecksumSize() {
        return this.type.size;
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public int getNumBytesInSum() {
        return this.inSum;
    }

    public static int getChecksumHeaderSize() {
        return 5;
    }

    @Override
    public long getValue() {
        return this.summer.getValue();
    }

    @Override
    public void reset() {
        this.summer.reset();
        this.inSum = 0;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (len > 0) {
            this.summer.update(b, off, len);
            this.inSum += len;
        }
    }

    @Override
    public void update(int b) {
        this.summer.update(b);
        ++this.inSum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyChunkedSums(ByteBuffer data2, ByteBuffer checksums, String fileName, long basePos) throws ChecksumException {
        if (this.type.size == 0) {
            return;
        }
        if (data2.hasArray() && checksums.hasArray()) {
            this.verifyChunkedSums(data2.array(), data2.arrayOffset() + data2.position(), data2.remaining(), checksums.array(), checksums.arrayOffset() + checksums.position(), fileName, basePos);
            return;
        }
        if (NativeCrc32.isAvailable()) {
            NativeCrc32.verifyChunkedSums(this.bytesPerChecksum, this.type.id, checksums, data2, fileName, basePos);
            return;
        }
        int startDataPos = data2.position();
        data2.mark();
        checksums.mark();
        try {
            byte[] buf = new byte[this.bytesPerChecksum];
            byte[] sum2 = new byte[this.type.size];
            while (data2.remaining() > 0) {
                int stored;
                int n = Math.min(data2.remaining(), this.bytesPerChecksum);
                checksums.get(sum2);
                data2.get(buf, 0, n);
                this.summer.reset();
                this.summer.update(buf, 0, n);
                int calculated = (int)this.summer.getValue();
                if (calculated == (stored = sum2[0] << 24 & 0xFF000000 | sum2[1] << 16 & 0xFF0000 | sum2[2] << 8 & 0xFF00 | sum2[3] & 0xFF)) continue;
                long errPos = basePos + (long)data2.position() - (long)startDataPos - (long)n;
                throw new ChecksumException("Checksum error: " + fileName + " at " + errPos + " exp: " + stored + " got: " + calculated, errPos);
            }
        }
        finally {
            data2.reset();
            checksums.reset();
        }
    }

    private void verifyChunkedSums(byte[] data2, int dataOff, int dataLen, byte[] checksums, int checksumsOff, String fileName, long basePos) throws ChecksumException {
        int remaining = dataLen;
        int dataPos = 0;
        while (remaining > 0) {
            int n = Math.min(remaining, this.bytesPerChecksum);
            this.summer.reset();
            this.summer.update(data2, dataOff + dataPos, n);
            dataPos += n;
            remaining -= n;
            int calculated = (int)this.summer.getValue();
            int stored = checksums[checksumsOff] << 24 & 0xFF000000 | checksums[checksumsOff + 1] << 16 & 0xFF0000 | checksums[checksumsOff + 2] << 8 & 0xFF00 | checksums[checksumsOff + 3] & 0xFF;
            checksumsOff += 4;
            if (calculated == stored) continue;
            long errPos = basePos + (long)dataPos - (long)n;
            throw new ChecksumException("Checksum error: " + fileName + " at " + errPos + " exp: " + stored + " got: " + calculated, errPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateChunkedSums(ByteBuffer data2, ByteBuffer checksums) {
        if (this.type.size == 0) {
            return;
        }
        if (data2.hasArray() && checksums.hasArray()) {
            this.calculateChunkedSums(data2.array(), data2.arrayOffset() + data2.position(), data2.remaining(), checksums.array(), checksums.arrayOffset() + checksums.position());
            return;
        }
        data2.mark();
        checksums.mark();
        try {
            byte[] buf = new byte[this.bytesPerChecksum];
            while (data2.remaining() > 0) {
                int n = Math.min(data2.remaining(), this.bytesPerChecksum);
                data2.get(buf, 0, n);
                this.summer.reset();
                this.summer.update(buf, 0, n);
                checksums.putInt((int)this.summer.getValue());
            }
        }
        finally {
            data2.reset();
            checksums.reset();
        }
    }

    private void calculateChunkedSums(byte[] data2, int dataOffset, int dataLength, byte[] sums, int sumsOffset) {
        int n;
        for (int remaining = dataLength; remaining > 0; remaining -= n) {
            n = Math.min(remaining, this.bytesPerChecksum);
            this.summer.reset();
            this.summer.update(data2, dataOffset, n);
            dataOffset += n;
            long calculated = this.summer.getValue();
            sums[sumsOffset++] = (byte)(calculated >> 24);
            sums[sumsOffset++] = (byte)(calculated >> 16);
            sums[sumsOffset++] = (byte)(calculated >> 8);
            sums[sumsOffset++] = (byte)calculated;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataChecksum)) {
            return false;
        }
        DataChecksum o = (DataChecksum)other;
        return o.bytesPerChecksum == this.bytesPerChecksum && o.type == this.type;
    }

    public int hashCode() {
        return (this.type.id + 31) * this.bytesPerChecksum;
    }

    public String toString() {
        return "DataChecksum(type=" + (Object)((Object)this.type) + ", chunkSize=" + this.bytesPerChecksum + ")";
    }

    static class ChecksumNull
    implements Checksum {
        @Override
        public long getValue() {
            return 0L;
        }

        @Override
        public void reset() {
        }

        @Override
        public void update(byte[] b, int off, int len) {
        }

        @Override
        public void update(int b) {
        }
    }

    public static enum Type {
        NULL(0, 0),
        CRC32(1, 4),
        CRC32C(2, 4),
        DEFAULT(3, 0),
        MIXED(4, 0);

        public final int id;
        public final int size;

        private Type(int id, int size2) {
            this.id = id;
            this.size = size2;
        }

        public static Type valueOf(int id) {
            if (id < 0 || id >= Type.values().length) {
                throw new IllegalArgumentException("id=" + id + " out of range [0, " + Type.values().length + ")");
            }
            return Type.values()[id];
        }
    }
}

