/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;

public class TransformationResult<I, O>
implements Cacheable {
    private static final ThreadCache.CachedTypeIndex<TransformationResult> CACHE_IDX = ThreadCache.obtainIndex(TransformationResult.class, 2);
    private O message;
    private Status status;
    private int errorCode;
    private String errorDescription;
    private I externalRemainder;

    public static <I, O> TransformationResult<I, O> createErrorResult(int errorCode, String errorDescription) {
        return TransformationResult.create(Status.ERROR, null, null, errorCode, errorDescription);
    }

    public static <I, O> TransformationResult<I, O> createCompletedResult(O message, I externalRemainder) {
        return TransformationResult.create(Status.COMPLETE, message, externalRemainder, 0, null);
    }

    public static <I, O> TransformationResult<I, O> createIncompletedResult(I externalRemainder) {
        return TransformationResult.create(Status.INCOMPLETE, null, externalRemainder, 0, null);
    }

    private static <I, O> TransformationResult<I, O> create(Status status, O message, I externalRemainder, int errorCode, String errorDescription) {
        TransformationResult result2 = ThreadCache.takeFromCache(CACHE_IDX);
        if (result2 != null) {
            result2.setStatus(status);
            result2.setMessage(message);
            result2.setExternalRemainder(externalRemainder);
            result2.setErrorCode(errorCode);
            result2.setErrorDescription(errorDescription);
            return result2;
        }
        return new TransformationResult<I, O>(status, message, externalRemainder, errorCode, errorDescription);
    }

    public TransformationResult() {
        this(Status.COMPLETE, null, null);
    }

    public TransformationResult(Status status, O message, I externalRemainder) {
        this.status = status;
        this.message = message;
        this.externalRemainder = externalRemainder;
    }

    public TransformationResult(int errorCode, String errorDescription) {
        this.status = Status.ERROR;
        this.errorCode = errorCode;
        this.errorDescription = errorDescription;
    }

    protected TransformationResult(Status status, O message, I externalRemainder, int errorCode, String errorDescription) {
        this.status = status;
        this.message = message;
        this.externalRemainder = externalRemainder;
        this.errorCode = errorCode;
        this.errorDescription = errorDescription;
    }

    public O getMessage() {
        return this.message;
    }

    public void setMessage(O message) {
        this.message = message;
    }

    public I getExternalRemainder() {
        return this.externalRemainder;
    }

    public void setExternalRemainder(I externalRemainder) {
        this.externalRemainder = externalRemainder;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Transformation result. Status: ").append((Object)this.status);
        sb.append(" message: ").append(this.message);
        if (this.status == Status.ERROR) {
            sb.append(" errorCode: ").append(this.errorCode);
            sb.append(" errorDescription: ").append(this.errorDescription);
        }
        return sb.toString();
    }

    public void reset() {
        this.message = null;
        this.status = null;
        this.errorCode = 0;
        this.errorDescription = null;
        this.externalRemainder = null;
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public static enum Status {
        COMPLETE,
        INCOMPLETE,
        ERROR;

    }
}

