/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.util.concurrent.Future;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.utils.DebugPoint;

public abstract class AsyncQueueRecord<R>
implements Cacheable {
    protected Connection connection;
    protected Buffer message;
    protected Future future;
    protected R currentResult;
    protected CompletionHandler completionHandler;
    protected boolean isRecycled = false;
    protected DebugPoint recycleTrack;

    public AsyncQueueRecord(Connection connection, Buffer message, Future future, R currentResult, CompletionHandler completionHandler) {
        this.set(connection, message, future, currentResult, completionHandler);
    }

    protected final void set(Connection connection, Buffer message, Future future, R currentResult, CompletionHandler completionHandler) {
        this.checkRecycled();
        this.connection = connection;
        this.message = message;
        this.future = future;
        this.currentResult = currentResult;
        this.completionHandler = completionHandler;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public final Buffer getMessage() {
        this.checkRecycled();
        return this.message;
    }

    public final void setMessage(Buffer message) {
        this.checkRecycled();
        this.message = message;
    }

    public final Future getFuture() {
        this.checkRecycled();
        return this.future;
    }

    public void setFuture(Future future) {
        this.checkRecycled();
        this.future = future;
    }

    public final R getCurrentResult() {
        this.checkRecycled();
        return this.currentResult;
    }

    public final CompletionHandler getCompletionHandler() {
        this.checkRecycled();
        return this.completionHandler;
    }

    protected final void checkRecycled() {
        if (Grizzly.isTrackingThreadCache() && this.isRecycled) {
            DebugPoint track = this.recycleTrack;
            if (track != null) {
                throw new IllegalStateException("AsyncReadQueueRecord has been recycled at: " + track);
            }
            throw new IllegalStateException("AsyncReadQueueRecord has been recycled");
        }
    }
}

