/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Appendable;
import org.glassfish.grizzly.Appender;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.ExecutorResolver;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.FilterExecutor;
import org.glassfish.grizzly.filterchain.InternalContextImpl;
import org.glassfish.grizzly.filterchain.InvokeAction;
import org.glassfish.grizzly.filterchain.ListFacadeFilterChain;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.StopAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.impl.UnsafeFutureImpl;
import org.glassfish.grizzly.memory.Buffers;

public final class DefaultFilterChain
extends ListFacadeFilterChain {
    protected final Attribute<FiltersState> FILTERS_STATE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(DefaultFilterChain.class.getName() + '-' + System.identityHashCode(this) + ".connection-state");
    private static final Logger LOGGER = Grizzly.logger(DefaultFilterChain.class);

    public DefaultFilterChain() {
        this((Collection<Filter>)new ArrayList<Filter>());
    }

    public DefaultFilterChain(Collection<Filter> initialFilters) {
        super(new ArrayList<Filter>(initialFilters));
    }

    public ProcessorResult process(Context context) throws IOException {
        if (this.isEmpty()) {
            return ProcessorResult.createComplete();
        }
        InternalContextImpl internalContext = (InternalContextImpl)context;
        FilterChainContext filterChainContext = internalContext.filterChainContext;
        if (filterChainContext.getOperation() == FilterChainContext.Operation.NONE) {
            IOEvent ioEvent = internalContext.getIoEvent();
            if (ioEvent != IOEvent.WRITE) {
                filterChainContext.setOperation(FilterChainContext.ioEvent2Operation(ioEvent));
            } else {
                Connection connection = context.getConnection();
                AsyncQueueEnabledTransport transport = (AsyncQueueEnabledTransport)((Object)connection.getTransport());
                AsyncQueueWriter writer = transport.getAsyncQueueIO().getWriter();
                return writer.processAsync(context) ? ProcessorResult.createComplete() : ProcessorResult.createLeave();
            }
        }
        return this.execute(filterChainContext);
    }

    @Override
    public ProcessorResult execute(FilterChainContext ctx) {
        FilterExecutor executor = ExecutorResolver.resolve(ctx);
        if (ctx.getFilterIdx() == Integer.MIN_VALUE) {
            executor.initIndexes(ctx);
        }
        Connection connection = ctx.getConnection();
        int end = ctx.getEndIdx();
        try {
            do {
                switch (this.executeChainPart(ctx, executor, ctx.getFilterIdx(), end)) {
                    case TERMINATE: {
                        return ProcessorResult.createTerminate();
                    }
                    case REEXECUTE: {
                        int idx = DefaultFilterChain.indexOfRemainder(this.FILTERS_STATE_ATTR.get(connection), ctx.getOperation(), ctx.getStartIdx(), end);
                        if (idx != -1) {
                            ctx = this.cloneContext(ctx);
                            ctx.setMessage(null);
                            ctx.setFilterIdx(idx);
                            return ProcessorResult.createRerun(ctx.internalContext);
                        }
                        return ProcessorResult.createReregister();
                    }
                }
            } while (DefaultFilterChain.prepareRemainder(ctx, this.FILTERS_STATE_ATTR.get(connection), ctx.getStartIdx(), end));
        }
        catch (Exception e) {
            try {
                LOGGER.log(e instanceof IOException ? Level.FINE : Level.WARNING, "Exception during FilterChain execution", e);
                this.throwChain(ctx, executor, e);
                ctx.getConnection().close().markForRecycle(true);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Exception during reporting the failure", ioe);
            }
            return ProcessorResult.createLeave();
        }
        return ProcessorResult.createComplete();
    }

    protected final FilterExecution executeChainPart(FilterChainContext ctx, FilterExecutor executor, int start, int end) throws IOException {
        Connection connection = ctx.getConnection();
        FiltersState filtersState = this.FILTERS_STATE_ATTR.get(connection);
        int i = start;
        int lastNextActionType = 0;
        NextAction lastNextAction = null;
        while (i != end) {
            Filter currentFilter = this.get(i);
            this.checkStoredMessage(ctx, filtersState, i);
            lastNextAction = this.executeFilter(executor, currentFilter, ctx);
            lastNextActionType = lastNextAction.type();
            if (lastNextActionType != 0) break;
            filtersState = this.storeMessage(ctx, filtersState, FILTER_STATE_TYPE.REMAINDER, i, ((InvokeAction)lastNextAction).getRemainder(), null);
            i = executor.getNextFilter(ctx);
            ctx.setFilterIdx(i);
        }
        switch (lastNextActionType) {
            case 0: {
                this.notifyComplete(ctx);
                break;
            }
            case 1: {
                StopAction stopAction = (StopAction)lastNextAction;
                this.storeMessage(ctx, filtersState, FILTER_STATE_TYPE.INCOMPLETE, i, stopAction.getRemainder(), stopAction.getAppender());
                break;
            }
            case 5: {
                ctx.suspend();
                return FilterExecution.REEXECUTE;
            }
            case 2: {
                return FilterExecution.TERMINATE;
            }
        }
        return FilterExecution.CONTINUE;
    }

    protected NextAction executeFilter(FilterExecutor executor, Filter currentFilter, FilterChainContext ctx) throws IOException {
        NextAction nextNextAction;
        do {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINE, "Execute filter. filter={0} context={1}", new Object[]{currentFilter, ctx});
            }
            nextNextAction = executor.execute(currentFilter, ctx);
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.log(Level.FINE, "after execute filter. filter={0} context={1} nextAction={2}", new Object[]{currentFilter, ctx, nextNextAction});
        } while (nextNextAction.type() == 4);
        return nextNextAction;
    }

    protected static boolean prepareRemainder(FilterChainContext ctx, FiltersState filtersState, int start, int end) {
        int idx = DefaultFilterChain.indexOfRemainder(filtersState, ctx.getOperation(), start, end);
        if (idx != -1) {
            ctx.setFilterIdx(idx);
            ctx.setMessage(null);
            return true;
        }
        return false;
    }

    protected static int indexOfRemainder(FiltersState filtersState, FilterChainContext.Operation operation, int start, int end) {
        if (filtersState == null) {
            return -1;
        }
        int add = end - start > 0 ? 1 : -1;
        for (int i = end - add; i != start - add; i -= add) {
            FilterStateElement element = filtersState.getState(operation, i);
            if (element == null || element.getType() != FILTER_STATE_TYPE.REMAINDER) continue;
            return i;
        }
        return -1;
    }

    public GrizzlyFuture<ReadResult> read(Connection connection, CompletionHandler completionHandler) throws IOException {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.setOperation(FilterChainContext.Operation.READ);
        context.getTransportContext().configureBlocking(true);
        return ReadyFutureImpl.create(this.read(context));
    }

    @Override
    public ReadResult read(FilterChainContext context) throws IOException {
        Connection connection = context.getConnection();
        if (!context.getTransportContext().isBlocking()) {
            throw new IllegalStateException("FilterChain doesn't support standalone non blocking read. Please use Filter instead.");
        }
        UnsafeFutureImpl<FilterChainContext> future = UnsafeFutureImpl.create();
        context.operationCompletionFuture = future;
        FilterExecutor executor = ExecutorResolver.resolve(context);
        do {
            if (!DefaultFilterChain.prepareRemainder(context, this.FILTERS_STATE_ATTR.get(connection), 0, context.getEndIdx())) {
                context.setFilterIdx(0);
                context.setMessage(null);
            }
            this.executeChainPart(context, executor, context.getFilterIdx(), context.getEndIdx());
        } while (!future.isDone());
        try {
            FilterChainContext retContext = future.get();
            ReadResult rr = ReadResult.create(connection);
            rr.setMessage(retContext.getMessage());
            rr.setSrcAddress(retContext.getAddress());
            future.recycle(false);
            return rr;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public GrizzlyFuture<WriteResult> write(Connection connection, Object dstAddress, Object message, CompletionHandler completionHandler) throws IOException {
        SafeFutureImpl<WriteResult> future = SafeFutureImpl.create();
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.transportFilterContext.future = future;
        context.transportFilterContext.completionHandler = completionHandler;
        context.setAddress(dstAddress);
        context.setMessage(message);
        context.setOperation(FilterChainContext.Operation.WRITE);
        ProcessorExecutor.execute(context.internalContext);
        return future;
    }

    @Override
    public <M> GrizzlyFuture<WriteResult> flush(Connection connection, CompletionHandler<WriteResult> completionHandler) throws IOException {
        SafeFutureImpl<WriteResult> future = SafeFutureImpl.create();
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.setOperation(FilterChainContext.Operation.EVENT);
        context.event = TransportFilter.createFlushEvent(future, completionHandler);
        ExecutorResolver.DOWNSTREAM_EXECUTOR_SAMPLE.initIndexes(context);
        ProcessorExecutor.execute(context.internalContext);
        return future;
    }

    @Override
    public GrizzlyFuture<FilterChainContext> fireEventDownstream(Connection connection, FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) throws IOException {
        SafeFutureImpl<FilterChainContext> future = SafeFutureImpl.create();
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.operationCompletionFuture = future;
        context.operationCompletionHandler = completionHandler;
        context.setOperation(FilterChainContext.Operation.EVENT);
        context.event = event;
        ExecutorResolver.DOWNSTREAM_EXECUTOR_SAMPLE.initIndexes(context);
        ProcessorExecutor.execute(context.internalContext);
        return future;
    }

    @Override
    public GrizzlyFuture<FilterChainContext> fireEventUpstream(Connection connection, FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) throws IOException {
        SafeFutureImpl<FilterChainContext> future = SafeFutureImpl.create();
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.operationCompletionFuture = future;
        context.operationCompletionHandler = completionHandler;
        context.setOperation(FilterChainContext.Operation.EVENT);
        context.event = event;
        ExecutorResolver.UPSTREAM_EXECUTOR_SAMPLE.initIndexes(context);
        ProcessorExecutor.execute(context.internalContext);
        return future;
    }

    @Override
    public void fail(FilterChainContext context, Throwable failure2) {
        this.throwChain(context, ExecutorResolver.resolve(context), failure2);
    }

    private void throwChain(FilterChainContext ctx, FilterExecutor executor, Throwable exception) {
        int i;
        this.notifyFailure(ctx, exception);
        int endIdx = ctx.getStartIdx();
        if (ctx.getFilterIdx() == endIdx) {
            return;
        }
        do {
            i = executor.getPreviousFilter(ctx);
            ctx.setFilterIdx(i);
            this.get(i).exceptionOccurred(ctx, exception);
        } while (i != endIdx);
    }

    public DefaultFilterChain subList(int fromIndex, int toIndex) {
        return new DefaultFilterChain((Collection<Filter>)this.filters.subList(fromIndex, toIndex));
    }

    private void checkStoredMessage(FilterChainContext ctx, FiltersState filtersState, int filterIdx) {
        FilterStateElement filterState;
        FilterChainContext.Operation operation = ctx.getOperation();
        if (filtersState != null && (filterState = filtersState.clearState(operation, filterIdx)) != null) {
            Object storedMessage = filterState.getState();
            Object currentMessage = ctx.getMessage();
            if (currentMessage != null) {
                Appender appender = filterState.getAppender();
                storedMessage = appender != null ? appender.append(storedMessage, currentMessage) : ((Appendable)storedMessage).append(currentMessage);
            }
            ctx.setMessage(storedMessage);
        }
    }

    private <M> FiltersState storeMessage(FilterChainContext ctx, FiltersState filtersState, FILTER_STATE_TYPE type, int filterIdx, M messageToStore, Appender<M> appender) {
        if (messageToStore != null) {
            if (filtersState == null) {
                Connection connection = ctx.getConnection();
                filtersState = new FiltersState(this.size());
                this.FILTERS_STATE_ATTR.set(connection, filtersState);
            }
            FilterChainContext.Operation operation = ctx.getOperation();
            filtersState.setState(operation, filterIdx, FilterStateElement.create(type, messageToStore, appender));
        }
        return filtersState;
    }

    private void notifyComplete(FilterChainContext context) {
        CompletionHandler<FilterChainContext> completionHandler = context.operationCompletionHandler;
        FutureImpl<FilterChainContext> future = context.operationCompletionFuture;
        if (completionHandler != null) {
            completionHandler.completed(context);
        }
        if (future != null) {
            future.result(context);
        }
        CompletionHandler transportCompletionHandler = context.transportFilterContext.completionHandler;
        FutureImpl transportFuture = context.transportFilterContext.future;
        if (transportCompletionHandler != null) {
            transportCompletionHandler.completed(null);
        }
        if (transportFuture != null) {
            transportFuture.result(null);
        }
    }

    private FilterChainContext cloneContext(FilterChainContext ctx) {
        FilterChain p = ctx.getFilterChain();
        FilterChainContext newContext = p.obtainFilterChainContext(ctx.getConnection());
        newContext.setOperation(ctx.getOperation());
        ctx.internalContext.softCopyTo(newContext.internalContext);
        newContext.setStartIdx(ctx.getStartIdx());
        newContext.setEndIdx(ctx.getEndIdx());
        newContext.setFilterIdx(ctx.getFilterIdx());
        return newContext;
    }

    private void notifyFailure(FilterChainContext context, Throwable e) {
        CompletionHandler<FilterChainContext> completionHandler = context.operationCompletionHandler;
        FutureImpl<FilterChainContext> future = context.operationCompletionFuture;
        if (completionHandler != null) {
            completionHandler.failed(e);
        }
        if (future != null) {
            future.failure(e);
        }
        CompletionHandler transportCompletionHandler = context.transportFilterContext.completionHandler;
        FutureImpl transportFuture = context.transportFilterContext.future;
        if (transportCompletionHandler != null) {
            transportCompletionHandler.failed(e);
        }
        if (transportFuture != null) {
            transportFuture.failure(e);
        }
    }

    public static final class FilterStateElement {
        private final FILTER_STATE_TYPE type;
        private final Object state;
        private final Appender appender;

        public static FilterStateElement create(FILTER_STATE_TYPE type, Object remainder) {
            if (remainder instanceof Buffer) {
                return FilterStateElement.create(type, (Buffer)remainder, Buffers.BUFFER_APPENDER);
            }
            return FilterStateElement.create(type, (Appendable)remainder);
        }

        public static FilterStateElement create(FILTER_STATE_TYPE type, Appendable state) {
            return new FilterStateElement(type, state);
        }

        public static <E> FilterStateElement create(FILTER_STATE_TYPE type, E state, Appender<E> appender) {
            return new FilterStateElement(type, state, appender);
        }

        private FilterStateElement(FILTER_STATE_TYPE type, Appendable state) {
            this.type = type;
            this.state = state;
            this.appender = null;
        }

        private <E> FilterStateElement(FILTER_STATE_TYPE type, E state, Appender<E> appender) {
            this.type = type;
            this.state = state;
            this.appender = appender;
        }

        private FILTER_STATE_TYPE getType() {
            return this.type;
        }

        public Object getState() {
            return this.state;
        }

        public Appender getAppender() {
            return this.appender;
        }
    }

    public static final class FiltersState {
        private final FilterStateElement[][] state;

        public FiltersState(int filtersNum) {
            this.state = new FilterStateElement[FilterChainContext.Operation.values().length][filtersNum];
        }

        public FilterStateElement getState(FilterChainContext.Operation operation, int filterIndex) {
            return this.state[operation.ordinal()][filterIndex];
        }

        public void setState(FilterChainContext.Operation operation, int filterIndex, FilterStateElement stateElement) {
            this.state[operation.ordinal()][filterIndex] = stateElement;
        }

        public FilterStateElement clearState(FilterChainContext.Operation operation, int filterIndex) {
            int operationIdx = operation.ordinal();
            FilterStateElement oldState = this.state[operationIdx][filterIndex];
            this.state[operationIdx][filterIndex] = null;
            return oldState;
        }

        public int indexOf(FilterChainContext.Operation operation, FILTER_STATE_TYPE type) {
            return this.indexOf(operation, type, 0);
        }

        public int indexOf(FilterChainContext.Operation operation, FILTER_STATE_TYPE type, int start) {
            int eventIdx = operation.ordinal();
            int length = this.state[eventIdx].length;
            for (int i = start; i < length; ++i) {
                FilterStateElement filterState = this.state[eventIdx][i];
                if (filterState == null || filterState.getType() != type) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(IOEvent event, FILTER_STATE_TYPE type, int end) {
            int eventIdx = event.ordinal();
            for (int i = end - 1; i >= 0; --i) {
                FilterStateElement filterState = this.state[eventIdx][i];
                if (filterState == null || filterState.getType() != type) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(IOEvent event, FILTER_STATE_TYPE type) {
            return this.lastIndexOf(event, type, this.state[event.ordinal()].length);
        }
    }

    public static enum FilterExecution {
        CONTINUE,
        REEXECUTE,
        TERMINATE;

    }

    public static enum FILTER_STATE_TYPE {
        INCOMPLETE,
        REMAINDER;

    }
}

