/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.KeepAliveProbe;
import org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringAware;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

public final class KeepAlive
implements JmxMonitoringAware<KeepAliveProbe> {
    protected final AbstractJmxMonitoringConfig<KeepAliveProbe> monitoringConfig = new AbstractJmxMonitoringConfig<KeepAliveProbe>(KeepAliveProbe.class){

        @Override
        public JmxObject createManagementObject() {
            return KeepAlive.this.createJmxManagementObject();
        }
    };
    private int idleTimeoutInSeconds = 30;
    private int maxRequestsCount = 256;

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public void setIdleTimeoutInSeconds(int idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds = idleTimeoutInSeconds < 0 ? -1 : idleTimeoutInSeconds;
    }

    public int getMaxRequestsCount() {
        return this.maxRequestsCount;
    }

    public void setMaxRequestsCount(int maxRequestsCount) {
        this.maxRequestsCount = maxRequestsCount;
    }

    @Override
    public JmxMonitoringConfig<KeepAliveProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.http.jmx.KeepAlive(this);
    }

    protected static void notifyProbesConnectionAccepted(KeepAlive keepAlive, Connection connection) {
        KeepAliveProbe[] probes = (KeepAliveProbe[])keepAlive.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (KeepAliveProbe probe : probes) {
                probe.onConnectionAcceptEvent(connection);
            }
        }
    }

    protected static void notifyProbesHit(KeepAlive keepAlive, Connection connection, int requestNumber) {
        KeepAliveProbe[] probes = (KeepAliveProbe[])keepAlive.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (KeepAliveProbe probe : probes) {
                probe.onHitEvent(connection, requestNumber);
            }
        }
    }

    protected static void notifyProbesRefused(KeepAlive keepAlive, Connection connection) {
        KeepAliveProbe[] probes = (KeepAliveProbe[])keepAlive.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (KeepAliveProbe probe : probes) {
                probe.onRefuseEvent(connection);
            }
        }
    }

    protected static void notifyProbesTimeout(KeepAlive keepAlive, Connection connection) {
        KeepAliveProbe[] probes = (KeepAliveProbe[])keepAlive.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (KeepAliveProbe probe : probes) {
                probe.onTimeoutEvent(connection);
            }
        }
    }
}

