/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.util.Ascii;

public class CookieUtils {
    private static final Logger LOGGER = Grizzly.logger(CookieUtils.class);
    public static final boolean COOKIE_VERSION_ONE_STRICT_COMPLIANCE = Boolean.getBoolean("org.glassfish.web.rfc2109_cookie_names_enforced");
    public static final boolean ALWAYS_ADD_EXPIRES = Boolean.valueOf(System.getProperty("org.glassfish.grizzly.util.http.ServerCookie.ALWAYS_ADD_EXPIRES", "true"));
    public static final char[] SEPARATORS = new char[]{'\t', ' ', '\"', '\'', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
    protected static final boolean[] separators = new boolean[128];
    static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    public static final ThreadLocal<SimpleDateFormat> OLD_COOKIE_FORMAT;
    static final String ancientDate;
    static final String tspecials = ",; ";
    static final String tspecials2 = "()<>@,;:\\\"/[]?={} \t";
    static final String tspecials2NoSlash = "()<>@,;:\\\"[]?={} \t";

    public static boolean isToken(String value2) {
        return CookieUtils.isToken(value2, null);
    }

    public static boolean isToken(String value2, String literals) {
        String ts;
        String string2 = ts = literals == null ? tspecials : literals;
        if (value2 == null) {
            return true;
        }
        int len = value2.length();
        for (int i = 0; i < len; ++i) {
            char c = value2.charAt(i);
            if (ts.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean containsCTL(String value2, int version) {
        if (value2 == null) {
            return false;
        }
        int len = value2.length();
        for (int i = 0; i < len; ++i) {
            char c = value2.charAt(i);
            if (c >= ' ' && c < '\u007f' || c == '\t') continue;
            return true;
        }
        return false;
    }

    public static boolean isToken2(String value2) {
        return CookieUtils.isToken2(value2, null);
    }

    public static boolean isToken2(String value2, String literals) {
        String ts;
        String string2 = ts = literals == null ? tspecials2 : literals;
        if (value2 == null) {
            return true;
        }
        int len = value2.length();
        for (int i = 0; i < len; ++i) {
            char c = value2.charAt(i);
            if (ts.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String s2, Buffer b, int start, int end) {
        int blen = end - start;
        if (b == null || blen != s2.length()) {
            return false;
        }
        int boff = start;
        for (int i = 0; i < blen; ++i) {
            if (b.get(boff++) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String s1, String s2, int start, int end) {
        int blen = end - start;
        if (s2 == null || blen != s1.length()) {
            return false;
        }
        int boff = start;
        for (int i = 0; i < blen; ++i) {
            if (s2.charAt(boff++) == s1.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String s2, Buffer b, int start, int end) {
        int blen = end - start;
        if (b == null || blen != s2.length()) {
            return false;
        }
        int boff = start;
        for (int i = 0; i < blen; ++i) {
            int b2;
            int b1;
            if ((b1 = Ascii.toLower(b.get(boff++))) == (b2 = Ascii.toLower(s2.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String s1, String s2, int start, int end) {
        int blen = end - start;
        if (s2 == null || blen != s1.length()) {
            return false;
        }
        int boff = start;
        for (int i = 0; i < blen; ++i) {
            int b2;
            int b1 = Ascii.toLower(s1.charAt(i));
            if (b1 == (b2 = Ascii.toLower(s2.charAt(boff++)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSeparator(int c) {
        return CookieUtils.isSeparator(c, true);
    }

    public static boolean isSeparator(int c, boolean parseAsVersion1) {
        if (parseAsVersion1) {
            return c > 0 && c < 126 && separators[c];
        }
        return c == 59 || c == 44;
    }

    public static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12;
    }

    public static int getTokenEndPosition(Buffer buffer, int off, int end) {
        return CookieUtils.getTokenEndPosition(buffer, off, end, true);
    }

    public static int getTokenEndPosition(Buffer buffer, int off, int end, boolean parseAsVersion1) {
        int pos;
        for (pos = off; pos < end && !CookieUtils.isSeparator(buffer.get(pos), parseAsVersion1); ++pos) {
        }
        if (pos > end) {
            return end;
        }
        return pos;
    }

    public static int getTokenEndPosition(String s2, int off, int end) {
        return CookieUtils.getTokenEndPosition(s2, off, end, true);
    }

    public static int getTokenEndPosition(String s2, int off, int end, boolean parseAsVersion1) {
        int pos;
        for (pos = off; pos < end && !CookieUtils.isSeparator(s2.charAt(pos), parseAsVersion1); ++pos) {
        }
        if (pos > end) {
            return end;
        }
        return pos;
    }

    public static int getQuotedValueEndPosition(Buffer buffer, int off, int end) {
        int pos = off;
        while (pos < end) {
            if (buffer.get(pos) == 34) {
                return pos;
            }
            if (buffer.get(pos) == 92 && pos < end - 1) {
                pos += 2;
                continue;
            }
            ++pos;
        }
        return end;
    }

    public static int getQuotedValueEndPosition(String s2, int off, int end) {
        int pos = off;
        while (pos < end) {
            if (s2.charAt(pos) == '\"') {
                return pos;
            }
            if (s2.charAt(pos) == '\\' && pos < end - 1) {
                pos += 2;
                continue;
            }
            ++pos;
        }
        return end;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            CookieUtils.separators[i] = false;
        }
        for (char SEPARATOR : SEPARATORS) {
            CookieUtils.separators[SEPARATOR] = true;
        }
        OLD_COOKIE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat(CookieUtils.OLD_COOKIE_PATTERN, Locale.US);
                f.setTimeZone(TimeZone.getTimeZone("GMT"));
                return f;
            }
        };
        ancientDate = OLD_COOKIE_FORMAT.get().format(new Date(10000L));
    }
}

