/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.monitoring.jmx;

import java.util.Iterator;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.utils.ServiceFinder;

public abstract class GrizzlyJmxManager {
    private static final GrizzlyJmxManager manager;
    protected final ManagedObjectManager mom;

    public static GrizzlyJmxManager instance() {
        return manager;
    }

    protected GrizzlyJmxManager(ManagedObjectManager mom) {
        this.mom = mom;
    }

    public GmbalMBean registerAtRoot(JmxObject object, String name) {
        GmbalMBean bean = this.mom.registerAtRoot(object, name);
        object.onRegister(this, bean);
        return bean;
    }

    public GmbalMBean register(Object parent, JmxObject object, String name) {
        GmbalMBean bean = this.mom.register(parent, object, name);
        object.onRegister(this, bean);
        return bean;
    }

    public void deregister(JmxObject object) {
        this.mom.unregister(object);
        object.onDeregister(this);
    }

    static {
        ServiceFinder<GrizzlyJmxManager> serviceFinder = ServiceFinder.find(GrizzlyJmxManager.class);
        Iterator<GrizzlyJmxManager> it = serviceFinder.iterator();
        manager = it.hasNext() ? it.next() : new DefaultJmxManager();
    }

    private static class DefaultJmxManager
    extends GrizzlyJmxManager {
        public DefaultJmxManager() {
            super(ManagedObjectManagerFactory.createStandalone("org.glassfish.grizzly"));
            this.mom.stripPackagePrefix();
            this.mom.createRoot();
        }
    }
}

