/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractWriter;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.PendingWriteQueueLimitExceededException;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.NullaryFunction;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.threadpool.WorkerThread;

public abstract class AbstractNIOAsyncQueueWriter
extends AbstractWriter<SocketAddress>
implements AsyncQueueWriter<SocketAddress> {
    private static final Logger logger = Grizzly.logger(AbstractNIOAsyncQueueWriter.class);
    private static final ThreadLocal<Reentrant> REENTRANTS_COUNTER = new ThreadLocal<Reentrant>(){

        @Override
        protected Reentrant initialValue() {
            return new Reentrant();
        }
    };
    private static final int EMPTY_RECORD_SPACE_VALUE = 1;
    protected final NIOTransport transport;
    protected volatile int maxPendingBytes = -1;
    protected volatile int maxWriteReentrants = 10;
    private IOException cachedIOException;
    private final Attribute<Reentrant> reentrantsAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(AbstractNIOAsyncQueueWriter.class + ".reentrant", new NullaryFunction<Reentrant>(){

        @Override
        public Reentrant evaluate() {
            return new Reentrant();
        }
    });

    public AbstractNIOAsyncQueueWriter(NIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public boolean canWrite(Connection connection, int size2) {
        if (this.maxPendingBytes < 0) {
            return true;
        }
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncWriteQueue();
        return connectionQueue.spaceInBytes() + size2 < this.maxPendingBytes;
    }

    @Override
    public void setMaxPendingBytesPerConnection(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes <= 0 ? -1 : maxPendingBytes;
    }

    @Override
    public int getMaxPendingBytesPerConnection() {
        return this.maxPendingBytes;
    }

    @Override
    public int getMaxWriteReentrants() {
        return this.maxWriteReentrants;
    }

    @Override
    public void setMaxWriteReentrants(int maxWriteReentrants) {
        this.maxWriteReentrants = maxWriteReentrants;
    }

    @Override
    public GrizzlyFuture<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor) throws IOException {
        return this.write(connection, dstAddress, buffer, completionHandler, interceptor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrizzlyFuture<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor, MessageCloner<Buffer> cloner) throws IOException {
        if (connection == null) {
            throw new IOException("Connection is null");
        }
        if (!connection.isOpen()) {
            throw new IOException("Connection is closed");
        }
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = nioConnection.getAsyncWriteQueue();
        WriteResult<Buffer, SocketAddress> currentResult = WriteResult.create(nioConnection, buffer, dstAddress, 0);
        int bufferSize = buffer.remaining();
        boolean isEmptyRecord = bufferSize == 0;
        AsyncWriteQueueRecord queueRecord = this.createRecord(nioConnection, buffer, null, currentResult, completionHandler, dstAddress, isEmptyRecord);
        int bytesToReserve = isEmptyRecord ? 1 : bufferSize;
        int pendingBytes = connectionQueue.reserveSpace(bytesToReserve);
        boolean isCurrent = pendingBytes == bytesToReserve;
        boolean isLogFine = logger.isLoggable(Level.FINEST);
        if (isLogFine) {
            AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.write connection={0} record={1} directWrite={2}", connection, queueRecord, isCurrent);
        }
        Reentrant reentrants = null;
        try {
            if (isCurrent && (reentrants = this.getWriteReentrants()).incAndGet() < this.maxWriteReentrants) {
                boolean isQueueEmpty;
                int bytesWritten = this.write0(nioConnection, queueRecord);
                int bytesToRelease = isEmptyRecord ? 1 : bytesWritten;
                boolean bl = isQueueEmpty = connectionQueue.releaseSpaceAndNotify(bytesToRelease) == 0;
                if (AbstractNIOAsyncQueueWriter.isFinished(queueRecord)) {
                    AbstractNIOAsyncQueueWriter.onWriteComplete(queueRecord);
                    if (!isQueueEmpty) {
                        this.onReadyToWrite(nioConnection);
                    }
                    ReadyFutureImpl<WriteResult<Buffer, SocketAddress>> readyFutureImpl = ReadyFutureImpl.create(currentResult);
                    return readyFutureImpl;
                }
            } else if (this.maxPendingBytes > 0 && pendingBytes > this.maxPendingBytes && !isEmptyRecord) {
                connectionQueue.releaseSpace(bytesToReserve);
                throw new PendingWriteQueueLimitExceededException("Max queued data limit exceeded: " + pendingBytes + '>' + this.maxPendingBytes);
            }
            SafeFutureImpl<WriteResult<Buffer, SocketAddress>> future = SafeFutureImpl.create();
            queueRecord.setFuture(future);
            if (cloner != null) {
                if (isLogFine) {
                    logger.log(Level.FINEST, "AsyncQueueWriter.write clone. connection={0}", nioConnection);
                }
                queueRecord.setMessage(cloner.clone(nioConnection, buffer));
            }
            if (isCurrent) {
                connectionQueue.setCurrentElement(queueRecord);
                this.onReadyToWrite(nioConnection);
                SafeFutureImpl<WriteResult<Buffer, SocketAddress>> safeFutureImpl = future;
                return safeFutureImpl;
            }
            connectionQueue.offer(queueRecord);
            if (!nioConnection.isOpen() && connectionQueue.remove(queueRecord)) {
                AbstractNIOAsyncQueueWriter.onWriteFailure(nioConnection, queueRecord, new IOException("Connection is closed"));
            }
            SafeFutureImpl<WriteResult<Buffer, SocketAddress>> safeFutureImpl = future;
            return safeFutureImpl;
        }
        catch (IOException e) {
            if (isLogFine) {
                logger.log(Level.FINEST, "AsyncQueueWriter.write exception. connection=" + nioConnection + " record=" + queueRecord, e);
            }
            AbstractNIOAsyncQueueWriter.onWriteFailure(nioConnection, queueRecord, e);
            ReadyFutureImpl<WriteResult<Buffer, SocketAddress>> readyFutureImpl = ReadyFutureImpl.create(e);
            return readyFutureImpl;
        }
        finally {
            if (reentrants != null) {
                reentrants.decAndGet();
            }
        }
    }

    protected AsyncWriteQueueRecord createRecord(Connection connection, Buffer message, Future<WriteResult<Buffer, SocketAddress>> future, WriteResult<Buffer, SocketAddress> currentResult, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, SocketAddress dstAddress, boolean isEmptyRecord) {
        return AsyncWriteQueueRecord.create(connection, message, future, currentResult, completionHandler, dstAddress, isEmptyRecord);
    }

    @Override
    public final boolean isReady(Connection connection) {
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncWriteQueue();
        return connectionQueue != null && !connectionQueue.isEmpty();
    }

    @Override
    public boolean processAsync(Context context) throws IOException {
        boolean isLogFine = logger.isLoggable(Level.FINEST);
        NIOConnection nioConnection = (NIOConnection)context.getConnection();
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = nioConnection.getAsyncWriteQueue();
        boolean done = false;
        AsyncWriteQueueRecord queueRecord = null;
        try {
            while ((queueRecord = connectionQueue.obtainCurrentElementAndReserve()) != null) {
                if (isLogFine) {
                    AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync doWriteconnection={0} record={1}", nioConnection, queueRecord);
                }
                int bytesToRelease = queueRecord.isEmptyRecord() ? 1 : this.write0(nioConnection, queueRecord);
                boolean isFinished = AbstractNIOAsyncQueueWriter.isFinished(queueRecord);
                if (isFinished && !context.isManualIOEventControl() && connectionQueue.spaceInBytes() - bytesToRelease <= 0) {
                    context.setManualIOEventControl();
                }
                boolean bl = done = connectionQueue.releaseSpaceAndNotify(bytesToRelease) == 0;
                if (isFinished) {
                    if (isLogFine) {
                        AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync finished connection={0} record={1}", nioConnection, queueRecord);
                    }
                    AbstractNIOAsyncQueueWriter.onWriteComplete(queueRecord);
                    if (isLogFine) {
                        AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync nextRecord connection={0} nextRecord={1}", nioConnection, queueRecord);
                    }
                    if (!done) continue;
                    return false;
                }
                connectionQueue.setCurrentElement(queueRecord);
                if (isLogFine) {
                    AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync onReadyToWrite connection={0} peekRecord={1}", nioConnection, queueRecord);
                }
                return true;
            }
            if (!done) {
                return true;
            }
        }
        catch (IOException e) {
            if (isLogFine) {
                logger.log(Level.FINEST, "AsyncQueueWriter.processAsync exception connection=" + nioConnection + " peekRecord=" + queueRecord, e);
            }
            AbstractNIOAsyncQueueWriter.onWriteFailure(nioConnection, queueRecord, e);
        }
        return false;
    }

    private static void doFineLog(String msg, Object ... params) {
        logger.log(Level.FINEST, msg, params);
    }

    @Override
    public void onClose(Connection connection) {
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncWriteQueueRecord> writeQueue = nioConnection.getAsyncWriteQueue();
        if (!writeQueue.isEmpty()) {
            AsyncWriteQueueRecord record;
            IOException error = this.cachedIOException;
            if (error == null) {
                this.cachedIOException = error = new IOException("Connection closed");
            }
            while ((record = writeQueue.obtainCurrentElementAndReserve()) != null) {
                AbstractNIOAsyncQueueWriter.failWriteRecord(record, error);
            }
        }
    }

    @Override
    public final void close() {
    }

    protected static void onWriteComplete(AsyncWriteQueueRecord record) throws IOException {
        WriteResult currentResult = (WriteResult)record.getCurrentResult();
        FutureImpl future = (FutureImpl)record.getFuture();
        CompletionHandler completionHandler = record.getCompletionHandler();
        Buffer originalMessage = record.getMessage();
        record.recycle();
        if (future != null) {
            future.result(currentResult);
        }
        if (completionHandler != null) {
            completionHandler.completed(currentResult);
        }
        originalMessage.tryDispose();
    }

    protected final void onWriteIncomplete(AsyncWriteQueueRecord record) throws IOException {
        WriteResult currentResult = (WriteResult)record.getCurrentResult();
        CompletionHandler completionHandler = record.getCompletionHandler();
        if (completionHandler != null) {
            completionHandler.updated(currentResult);
        }
    }

    protected static void onWriteFailure(Connection connection, AsyncWriteQueueRecord failedRecord, IOException e) {
        AbstractNIOAsyncQueueWriter.failWriteRecord(failedRecord, e);
        try {
            connection.close().markForRecycle(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void failWriteRecord(AsyncWriteQueueRecord record, Throwable e) {
        boolean hasFuture;
        if (record == null) {
            return;
        }
        FutureImpl future = (FutureImpl)record.getFuture();
        boolean bl = hasFuture = future != null;
        if (!hasFuture || !future.isDone()) {
            CompletionHandler completionHandler = record.getCompletionHandler();
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            if (hasFuture) {
                future.failure(e);
            }
        }
    }

    private static boolean isFinished(AsyncWriteQueueRecord queueRecord) {
        Buffer buffer = queueRecord.getMessage();
        return !buffer.hasRemaining();
    }

    protected abstract int write0(NIOConnection var1, AsyncWriteQueueRecord var2) throws IOException;

    protected abstract void onReadyToWrite(Connection var1) throws IOException;

    private Reentrant getWriteReentrants() {
        Thread t = Thread.currentThread();
        if (WorkerThread.class.isAssignableFrom(t.getClass())) {
            return this.reentrantsAttribute.get((WorkerThread)((Object)t));
        }
        return REENTRANTS_COUNTER.get();
    }

    private static final class Reentrant {
        private int counter;

        private Reentrant() {
        }

        public int incAndGet() {
            return ++this.counter;
        }

        public int decAndGet() {
            return --this.counter;
        }
    }
}

