/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.tmpselectors;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.nio.SelectorFactory;

public class TemporarySelectorPool {
    private static final Logger LOGGER = Grizzly.logger(TemporarySelectorPool.class);
    public static final int DEFAULT_SELECTORS_COUNT = 32;
    private static final int MISS_THRESHOLD = 10000;
    private volatile int maxPoolSize;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final Queue<Selector> selectors;
    private final AtomicInteger poolSize;
    private final AtomicInteger missesCounter;

    public TemporarySelectorPool() {
        this(32);
    }

    public TemporarySelectorPool(int selectorsCount) {
        this.maxPoolSize = selectorsCount;
        this.selectors = new ConcurrentLinkedQueue<Selector>();
        this.poolSize = new AtomicInteger();
        this.missesCounter = new AtomicInteger();
    }

    public synchronized int size() {
        return this.maxPoolSize;
    }

    public synchronized void setSize(int size2) throws IOException {
        if (this.isClosed.get()) {
            return;
        }
        this.missesCounter.set(0);
        this.maxPoolSize = size2;
    }

    public Selector poll() throws IOException {
        Selector selector = this.selectors.poll();
        if (selector != null) {
            this.poolSize.decrementAndGet();
        } else {
            try {
                selector = SelectorFactory.instance().create();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "SelectorFactory. Can not create a selector", e);
            }
            int missesCount = this.missesCounter.incrementAndGet();
            if (missesCount % 10000 == 0) {
                LOGGER.log(Level.WARNING, "SelectorFactory. Pool encounters a lot of misses {0}. Increase default {1} pool size", new Object[]{missesCount, this.maxPoolSize});
            }
        }
        return selector;
    }

    public void offer(Selector selector) {
        boolean wasReturned;
        if (this.poolSize.getAndIncrement() < this.maxPoolSize) {
            this.selectors.offer(selector);
            wasReturned = true;
        } else {
            this.poolSize.decrementAndGet();
            wasReturned = false;
        }
        if (this.isClosed.get()) {
            if (this.selectors.remove(selector)) {
                this.closeSelector(selector);
            }
        } else if (!wasReturned) {
            this.closeSelector(selector);
        }
    }

    public synchronized void close() {
        if (!this.isClosed.getAndSet(true)) {
            Selector selector;
            while ((selector = this.selectors.poll()) != null) {
                this.closeSelector(selector);
            }
        }
    }

    private void closeSelector(Selector selector) {
        block2: {
            try {
                selector.close();
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, "TemporarySelectorFactory: error occurred when trying to close the Selector", e);
            }
        }
    }
}

