/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.ProbeNotifier;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class SyncThreadPool
extends AbstractThreadPool {
    private final Queue<Runnable> workQueue;
    protected volatile int maxQueuedTasks = -1;
    private int currentPoolSize;
    private int activeThreadsCount;

    public SyncThreadPool(ThreadPoolConfig config) {
        super(config);
        if (config.getKeepAliveTime(TimeUnit.MILLISECONDS) < 0L) {
            throw new IllegalArgumentException("keepAliveTime < 0");
        }
        this.workQueue = config.getQueue() != null ? config.getQueue() : config.setQueue(new LinkedList<Runnable>()).getQueue();
        this.maxQueuedTasks = config.getQueueLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.stateLock;
        synchronized (object) {
            ProbeNotifier.notifyThreadPoolStarted(this);
            while (this.currentPoolSize < this.config.getCorePoolSize()) {
                this.startWorker(new SyncThreadWorker(true));
            }
        }
    }

    public void stop() {
        this.shutdownNow();
    }

    public int getCurrentPoolSize() {
        return this.currentPoolSize;
    }

    public int getActiveThreadsCount() {
        return this.activeThreadsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        Object object = this.stateLock;
        synchronized (object) {
            boolean isCore;
            if (!this.running) {
                throw new RejectedExecutionException("ThreadPool is not running");
            }
            int idleThreadsNumber = this.currentPoolSize - this.activeThreadsCount;
            int workQueueSize = this.workQueue.size();
            if ((this.maxQueuedTasks < 0 || workQueueSize < this.maxQueuedTasks) && this.workQueue.offer(task)) {
                this.onTaskQueued(task);
            } else {
                this.onTaskQueueOverflow();
                assert (false);
            }
            boolean bl = isCore = this.currentPoolSize < this.config.getCorePoolSize();
            if (isCore || this.currentPoolSize < this.config.getMaxPoolSize() && idleThreadsNumber < workQueueSize + 1) {
                this.startWorker(new SyncThreadWorker(isCore));
            } else if (idleThreadsNumber == 0) {
                this.onMaxNumberOfThreadsReached();
            } else {
                this.stateLock.notify();
            }
        }
    }

    @Override
    protected void startWorker(AbstractThreadPool.Worker worker) {
        super.startWorker(worker);
        ++this.currentPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onWorkerStarted(AbstractThreadPool.Worker worker) {
        super.onWorkerStarted(worker);
        Object object = this.stateLock;
        synchronized (object) {
            ++this.activeThreadsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onWorkerExit(AbstractThreadPool.Worker worker) {
        super.onWorkerExit(worker);
        Object object = this.stateLock;
        synchronized (object) {
            --this.currentPoolSize;
            --this.activeThreadsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.stateLock;
        synchronized (object) {
            return !this.running && this.workers.isEmpty();
        }
    }

    @Override
    protected void poisonAll() {
        int size2 = this.currentPoolSize;
        Queue<Runnable> q = this.getQueue();
        while (size2-- > 0) {
            q.offer(poison);
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String toString() {
        return super.toString() + ", max-queue-size=" + this.maxQueuedTasks;
    }

    protected class SyncThreadWorker
    extends AbstractThreadPool.Worker {
        private final boolean core;

        public SyncThreadWorker(boolean core) {
            this.core = core;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Runnable getTask() throws InterruptedException {
            Object object = SyncThreadPool.this.stateLock;
            synchronized (object) {
                try {
                    SyncThreadPool.this.activeThreadsCount--;
                    if (!SyncThreadPool.this.running || !this.core && SyncThreadPool.this.currentPoolSize > SyncThreadPool.this.config.getMaxPoolSize()) {
                        Runnable runnable = null;
                        return runnable;
                    }
                    Runnable r = (Runnable)SyncThreadPool.this.workQueue.poll();
                    long localKeepAlive = SyncThreadPool.this.config.getKeepAliveTime(TimeUnit.MILLISECONDS);
                    while (r == null) {
                        long startTime = System.currentTimeMillis();
                        SyncThreadPool.this.stateLock.wait(localKeepAlive);
                        r = (Runnable)SyncThreadPool.this.workQueue.poll();
                        if (SyncThreadPool.this.running && (this.core || r == null && (localKeepAlive -= System.currentTimeMillis() - startTime) >= 100L)) continue;
                    }
                    Runnable runnable = r;
                    return runnable;
                }
                finally {
                    SyncThreadPool.this.activeThreadsCount++;
                }
            }
        }
    }
}

