/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.GetObjectHeadsEvent;
import org.jets3t.service.multithread.ListObjectsEvent;
import org.jets3t.service.multithread.S3ServiceEventAdaptor;
import org.jets3t.service.multithread.S3ServiceEventListener;
import org.jets3t.service.multithread.S3ServiceMulti;
import org.jets3t.service.utils.FileComparerResults;
import org.jets3t.service.utils.ServiceUtils;

public class FileComparer {
    private static final Log log = LogFactory.getLog((Class)FileComparer.class);
    private Jets3tProperties jets3tProperties = null;

    public FileComparer(Jets3tProperties jets3tProperties) {
        this.jets3tProperties = jets3tProperties;
    }

    public static FileComparer getInstance(Jets3tProperties jets3tProperties) {
        return new FileComparer(jets3tProperties);
    }

    public static FileComparer getInstance() {
        return new FileComparer(Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    protected List buildIgnoreRegexpList(File directory, List parentIgnorePatternList) {
        ArrayList<Pattern> ignorePatternList;
        block12: {
            ignorePatternList = new ArrayList<Pattern>();
            if (parentIgnorePatternList != null) {
                Iterator parentIgnorePatternIter = parentIgnorePatternList.iterator();
                while (parentIgnorePatternIter.hasNext()) {
                    Pattern parentPattern = (Pattern)parentIgnorePatternIter.next();
                    String parentIgnorePatternString = parentPattern.pattern();
                    int slashOffset = parentIgnorePatternString.indexOf(Constants.FILE_PATH_DELIM);
                    if (slashOffset < 0 || parentIgnorePatternString.length() <= slashOffset + 1) continue;
                    String patternHeader = parentIgnorePatternString.substring(0, slashOffset);
                    String patternTail = parentIgnorePatternString.substring(slashOffset + 1);
                    if (".*.*".equals(patternHeader)) {
                        ignorePatternList.add(Pattern.compile(patternTail));
                        ignorePatternList.add(parentPattern);
                        continue;
                    }
                    if (!Pattern.compile(patternHeader).matcher(directory.getName()).matches()) continue;
                    ignorePatternList.add(Pattern.compile(patternTail));
                }
            }
            if (directory == null || !directory.isDirectory()) {
                return ignorePatternList;
            }
            File jets3tIgnoreFile = new File(directory, Constants.JETS3T_IGNORE_FILENAME);
            if (jets3tIgnoreFile.exists() && jets3tIgnoreFile.canRead()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found ignore file: " + jets3tIgnoreFile.getPath()));
                }
                try {
                    String ignorePaths = ServiceUtils.readInputStreamToString(new FileInputStream(jets3tIgnoreFile), null);
                    StringTokenizer st = new StringTokenizer(ignorePaths.trim(), "\n");
                    while (st.hasMoreTokens()) {
                        String ignorePath;
                        String ignoreRegexp = ignorePath = st.nextToken();
                        ignoreRegexp = ignoreRegexp.replaceAll("\\.", "\\\\.");
                        ignoreRegexp = ignoreRegexp.replaceAll("\\*", ".*");
                        ignoreRegexp = ignoreRegexp.replaceAll("\\?", ".");
                        Pattern pattern = Pattern.compile(ignoreRegexp);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Ignore path '" + ignorePath + "' has become the regexp: " + pattern.pattern()));
                        }
                        ignorePatternList.add(pattern);
                        if (!pattern.pattern().startsWith(".*.*/") || pattern.pattern().length() <= 5) continue;
                        ignorePatternList.add(Pattern.compile(pattern.pattern().substring(5)));
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block12;
                    log.error((Object)("Failed to read contents of ignore file '" + jets3tIgnoreFile.getPath() + "'"), (Throwable)e);
                }
            }
        }
        if (this.jets3tProperties.getBoolProperty("filecomparer.skip-upload-of-md5-files", false)) {
            Pattern pattern = Pattern.compile(".*\\.md5");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping upload of pre-computed MD5 files with path '*.md5' using the regexp: " + pattern.pattern()));
            }
            ignorePatternList.add(pattern);
        }
        return ignorePatternList;
    }

    protected boolean isIgnored(List ignorePatternList, File file) {
        Iterator patternIter = ignorePatternList.iterator();
        while (patternIter.hasNext()) {
            Pattern pattern = (Pattern)patternIter.next();
            if (!pattern.matcher(file.getName()).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring " + (file.isDirectory() ? "directory" : "file") + " matching pattern '" + pattern.pattern() + "': " + file.getName()));
            }
            return true;
        }
        return false;
    }

    public Map buildFileMap(File[] files, boolean includeDirectories) {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        List ignorePatternList = null;
        List ignorePatternListForCurrentDir = null;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getParentFile() == null) {
                if (ignorePatternListForCurrentDir == null) {
                    ignorePatternListForCurrentDir = this.buildIgnoreRegexpList(new File("."), null);
                }
                ignorePatternList = ignorePatternListForCurrentDir;
            } else {
                ignorePatternList = this.buildIgnoreRegexpList(files[i].getParentFile(), null);
            }
            if (this.isIgnored(ignorePatternList, files[i]) || !files[i].exists()) continue;
            if (!files[i].isDirectory() || includeDirectories) {
                fileMap.put(files[i].getName(), files[i]);
            }
            if (!files[i].isDirectory()) continue;
            this.buildFileMapImpl(files[i], files[i].getName() + Constants.FILE_PATH_DELIM, fileMap, includeDirectories, ignorePatternList);
        }
        return fileMap;
    }

    public Map buildFileMap(File rootDirectory, String fileKeyPrefix, boolean includeDirectories) {
        HashMap fileMap = new HashMap();
        List ignorePatternList = this.buildIgnoreRegexpList(rootDirectory, null);
        if (!this.isIgnored(ignorePatternList, rootDirectory)) {
            if (fileKeyPrefix == null || fileKeyPrefix.length() == 0) {
                fileKeyPrefix = "";
            } else if (!fileKeyPrefix.endsWith(Constants.FILE_PATH_DELIM)) {
                fileKeyPrefix = fileKeyPrefix + Constants.FILE_PATH_DELIM;
            }
            this.buildFileMapImpl(rootDirectory, fileKeyPrefix, fileMap, includeDirectories, ignorePatternList);
        }
        return fileMap;
    }

    protected void buildFileMapImpl(File directory, String fileKeyPrefix, Map fileMap, boolean includeDirectories, List parentIgnorePatternList) {
        List ignorePatternList = this.buildIgnoreRegexpList(directory, parentIgnorePatternList);
        File[] children = directory.listFiles();
        for (int i = 0; children != null && i < children.length; ++i) {
            if (this.isIgnored(ignorePatternList, children[i])) continue;
            if (!children[i].isDirectory() || includeDirectories) {
                fileMap.put(fileKeyPrefix + children[i].getName(), children[i]);
            }
            if (!children[i].isDirectory()) continue;
            this.buildFileMapImpl(children[i], fileKeyPrefix + children[i].getName() + "/", fileMap, includeDirectories, ignorePatternList);
        }
    }

    public S3Object[] listObjectsThreaded(S3Service s3Service, final String bucketName, String targetPath, String delimiter, int toDepth) throws S3ServiceException {
        final List allObjects = Collections.synchronizedList(new ArrayList());
        final List lastCommonPrefixes = Collections.synchronizedList(new ArrayList());
        final S3ServiceException[] s3ServiceExceptions = new S3ServiceException[1];
        final S3ServiceMulti s3Multi = new S3ServiceMulti(s3Service, new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(ListObjectsEvent event) {
                if (3 == event.getEventCode()) {
                    Iterator chunkIter = event.getChunkList().iterator();
                    while (chunkIter.hasNext()) {
                        S3ObjectsChunk chunk = (S3ObjectsChunk)chunkIter.next();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Listed " + chunk.getObjects().length + " objects and " + chunk.getCommonPrefixes().length + " common prefixes in bucket '" + bucketName + "' using prefix=" + chunk.getPrefix() + ", delimiter=" + chunk.getDelimiter()));
                        }
                        allObjects.addAll(Arrays.asList(chunk.getObjects()));
                        lastCommonPrefixes.addAll(Arrays.asList(chunk.getCommonPrefixes()));
                    }
                } else if (0 == event.getEventCode()) {
                    s3ServiceExceptions[0] = new S3ServiceException("Failed to list all objects in S3 bucket", event.getErrorCause());
                }
            }
        });
        String[] prefixesToList = new String[]{targetPath};
        for (int currentDepth = 0; currentDepth <= toDepth && prefixesToList.length > 0; ++currentDepth) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Listing objects in '" + bucketName + "' using " + prefixesToList.length + " prefixes: " + Arrays.asList(prefixesToList)));
            }
            lastCommonPrefixes.clear();
            final String[] finalPrefixes = prefixesToList;
            final String finalDelimiter = currentDepth < toDepth ? delimiter : null;
            new Thread(){

                public void run() {
                    s3Multi.listObjects(bucketName, finalPrefixes, finalDelimiter, 1000L);
                }
            }.run();
            if (s3ServiceExceptions[0] != null) {
                throw s3ServiceExceptions[0];
            }
            prefixesToList = lastCommonPrefixes.toArray(new String[lastCommonPrefixes.size()]);
        }
        return allObjects.toArray(new S3Object[allObjects.size()]);
    }

    public S3Object[] listObjectsThreaded(S3Service s3Service, String bucketName, String targetPath) throws S3ServiceException {
        String delimiter = null;
        int toDepth = 0;
        String bucketListingProperties = this.jets3tProperties.getStringProperty("filecomparer.bucket-listing." + bucketName, null);
        if (bucketListingProperties != null) {
            String[] splits = bucketListingProperties.split(",");
            if (splits.length != 2) {
                throw new S3ServiceException("Invalid setting for bucket listing property filecomparer.bucket-listing." + bucketName + ": '" + bucketListingProperties + "'");
            }
            delimiter = splits[0].trim();
            toDepth = Integer.parseInt(splits[1]);
        }
        return this.listObjectsThreaded(s3Service, bucketName, targetPath, delimiter, toDepth);
    }

    public Map buildS3ObjectMap(S3Service s3Service, S3Bucket bucket, String targetPath, boolean skipMetadata, S3ServiceEventListener s3ServiceEventListener) throws S3ServiceException {
        String prefix = targetPath.length() > 0 ? targetPath : null;
        S3Object[] s3ObjectsIncomplete = this.listObjectsThreaded(s3Service, bucket.getName(), prefix);
        return this.buildS3ObjectMap(s3Service, bucket, targetPath, s3ObjectsIncomplete, skipMetadata, s3ServiceEventListener);
    }

    public PartialObjectListing buildS3ObjectMapPartial(S3Service s3Service, S3Bucket bucket, String targetPath, String priorLastKey, boolean completeListing, boolean skipMetadata, S3ServiceEventListener s3ServiceEventListener) throws S3ServiceException {
        String prefix = targetPath.length() > 0 ? targetPath : null;
        S3Object[] objects = null;
        String resultPriorLastKey = null;
        if (completeListing) {
            objects = this.listObjectsThreaded(s3Service, bucket.getName(), prefix);
        } else {
            S3ObjectsChunk chunk = s3Service.listObjectsChunked(bucket.getName(), prefix, null, 1000L, priorLastKey, completeListing);
            objects = chunk.getObjects();
            resultPriorLastKey = chunk.getPriorLastKey();
        }
        Map objectsMap = this.buildS3ObjectMap(s3Service, bucket, targetPath, objects, skipMetadata, s3ServiceEventListener);
        return new PartialObjectListing(objectsMap, resultPriorLastKey);
    }

    public Map buildS3ObjectMap(S3Service s3Service, S3Bucket bucket, String targetPath, S3Object[] s3ObjectsIncomplete, boolean skipMetadata, S3ServiceEventListener s3ServiceEventListener) throws S3ServiceException {
        S3Object[] s3Objects = null;
        if (skipMetadata) {
            s3Objects = s3ObjectsIncomplete;
        } else {
            final ArrayList s3ObjectsCompleteList = new ArrayList(s3ObjectsIncomplete.length);
            final S3ServiceException[] s3ServiceExceptions = new S3ServiceException[1];
            S3ServiceMulti s3ServiceMulti = new S3ServiceMulti(s3Service, new S3ServiceEventAdaptor(){

                public void s3ServiceEventPerformed(GetObjectHeadsEvent event) {
                    if (3 == event.getEventCode()) {
                        S3Object[] finishedObjects = event.getCompletedObjects();
                        if (finishedObjects.length > 0) {
                            s3ObjectsCompleteList.addAll(Arrays.asList(finishedObjects));
                        }
                    } else if (0 == event.getEventCode()) {
                        s3ServiceExceptions[0] = new S3ServiceException("Failed to retrieve detailed information about all S3 objects", event.getErrorCause());
                    }
                }
            });
            if (s3ServiceEventListener != null) {
                s3ServiceMulti.addServiceEventListener(s3ServiceEventListener);
            }
            s3ServiceMulti.getObjectsHeads(bucket, s3ObjectsIncomplete);
            if (s3ServiceExceptions[0] != null) {
                throw s3ServiceExceptions[0];
            }
            s3Objects = s3ObjectsCompleteList.toArray(new S3Object[s3ObjectsCompleteList.size()]);
        }
        return this.populateS3ObjectMap(targetPath, s3Objects);
    }

    public Map populateS3ObjectMap(String targetPath, S3Object[] s3Objects) {
        HashMap<String, S3Object> map2 = new HashMap<String, S3Object>();
        for (int i = 0; i < s3Objects.length; ++i) {
            String relativeKey = s3Objects[i].getKey();
            if (targetPath.length() > 0) {
                int slashIndex = (relativeKey = relativeKey.substring(targetPath.length())).indexOf(Constants.FILE_PATH_DELIM);
                relativeKey = slashIndex == 0 ? relativeKey.substring(slashIndex + 1, relativeKey.length()) : ((slashIndex = targetPath.lastIndexOf(Constants.FILE_PATH_DELIM)) >= 0 ? s3Objects[i].getKey().substring(slashIndex + 1) : s3Objects[i].getKey());
            }
            if (relativeKey.length() <= 0) continue;
            map2.put(relativeKey, s3Objects[i]);
        }
        return map2;
    }

    public FileComparerResults buildDiscrepancyLists(Map filesMap, Map s3ObjectsMap) throws NoSuchAlgorithmException, FileNotFoundException, IOException, ParseException {
        return this.buildDiscrepancyLists(filesMap, s3ObjectsMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileComparerResults buildDiscrepancyLists(Map filesMap, Map s3ObjectsMap, BytesProgressWatcher progressWatcher) throws NoSuchAlgorithmException, FileNotFoundException, IOException, ParseException {
        HashSet<String> onlyOnServerKeys = new HashSet<String>();
        HashSet<String> updatedOnServerKeys = new HashSet<String>();
        HashSet<String> updatedOnClientKeys = new HashSet<String>();
        HashSet<String> alreadySynchronisedKeys = new HashSet<String>();
        HashSet onlyOnClientKeys = new HashSet();
        Iterator s3ObjectsMapIter = s3ObjectsMap.entrySet().iterator();
        while (s3ObjectsMapIter.hasNext()) {
            Map.Entry entry2 = s3ObjectsMapIter.next();
            String keyPath = (String)entry2.getKey();
            S3Object s3Object = (S3Object)entry2.getValue();
            if (keyPath.endsWith("/") && s3Object.getContentLength() == 0L && "binary/octet-stream".equals(s3Object.getContentType())) {
                boolean ignorePanicDirPlaceholders = this.jets3tProperties.getBoolProperty("filecomparer.ignore-panic-dir-placeholders", false);
                if (ignorePanicDirPlaceholders) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Ignoring object that looks like a directory placeholder created by Panic's Transmit application: " + keyPath));
                    }
                    alreadySynchronisedKeys.add(keyPath);
                    continue;
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Identified an object that looks like a directory placeholder created by Panic's Transmit application. If this object was indeed created by Transmit, it will not be handled properly unless the JetS3t property \"filecomparer.ignore-panic-dir-placeholders\" is set to true. " + s3Object));
                }
            }
            if (filesMap.containsKey(keyPath)) {
                File file = (File)filesMap.get(keyPath);
                if (file.isDirectory()) {
                    alreadySynchronisedKeys.add(keyPath);
                    continue;
                }
                boolean useMd5Files = this.jets3tProperties.getBoolProperty("filecomparer.use-md5-files", false);
                boolean generateMd5Files = this.jets3tProperties.getBoolProperty("filecomparer.generate-md5-files", false);
                byte[] computedHash = null;
                File computedHashFile = new File(file.getPath() + ".md5");
                if (useMd5Files && computedHashFile.canRead() && computedHashFile.lastModified() > file.lastModified()) {
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new FileReader(computedHashFile));
                        computedHash = ServiceUtils.fromHex(br.readLine().split("\\s")[0]);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Unable to read hash from computed MD5 file", (Throwable)e);
                        }
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                    }
                }
                if (computedHash == null) {
                    InputStream hashInputStream = null;
                    hashInputStream = progressWatcher != null ? new ProgressMonitoredInputStream(new FileInputStream(file), progressWatcher) : new FileInputStream(file);
                    computedHash = ServiceUtils.computeMD5Hash(hashInputStream);
                }
                String fileHashAsBase64 = ServiceUtils.toBase64(computedHash);
                if (!(!generateMd5Files || file.getName().endsWith(".md5") || computedHashFile.exists() && computedHashFile.lastModified() >= file.lastModified())) {
                    FileWriter fw = null;
                    try {
                        fw = new FileWriter(computedHashFile);
                        fw.write(ServiceUtils.toHex(computedHash));
                    }
                    catch (Exception e) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Unable to write computed MD5 hash to a file", (Throwable)e);
                        }
                    }
                    finally {
                        if (fw != null) {
                            fw.close();
                        }
                    }
                }
                String objectHash = null;
                if (s3Object.containsMetadata("original-md5-hash")) {
                    objectHash = (String)s3Object.getMetadata("original-md5-hash");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Object in S3 is encoded, using the object's original hash value for: " + s3Object.getKey()));
                    }
                } else {
                    objectHash = s3Object.getMd5HashAsBase64();
                }
                if (fileHashAsBase64.equals(objectHash)) {
                    alreadySynchronisedKeys.add(keyPath);
                    continue;
                }
                Date s3ObjectLastModified = null;
                String metadataLocalFileDate = (String)s3Object.getMetadata("jets3t-original-file-date-iso8601");
                if (metadataLocalFileDate == null) {
                    metadataLocalFileDate = (String)s3Object.getMetadata("jets3t-original-file-date-iso860");
                }
                if (metadataLocalFileDate == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Using S3 last modified date as file date. This is not reliable as the time according to S3 can differ from your local system time. Please use the metadata item jets3t-original-file-date-iso8601");
                    }
                    s3ObjectLastModified = s3Object.getLastModifiedDate();
                } else {
                    s3ObjectLastModified = ServiceUtils.parseIso8601Date(metadataLocalFileDate);
                }
                if (s3ObjectLastModified.getTime() > file.lastModified()) {
                    updatedOnServerKeys.add(keyPath);
                    continue;
                }
                if (s3ObjectLastModified.getTime() < file.lastModified()) {
                    updatedOnClientKeys.add(keyPath);
                    continue;
                }
                if (this.jets3tProperties.getBoolProperty("filecomparer.assume-local-latest-in-mismatch", false)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Backed-up S3Object " + s3Object.getKey() + " and local file " + file.getName() + " have the same date but different hash values. " + "Assuming local file is the latest version."));
                    }
                    updatedOnClientKeys.add(keyPath);
                    continue;
                }
                throw new IOException("Backed-up S3Object " + s3Object.getKey() + " and local file " + file.getName() + " have the same date but different hash values. " + "This shouldn't happen!");
            }
            onlyOnServerKeys.add(keyPath);
        }
        onlyOnClientKeys.addAll(filesMap.keySet());
        onlyOnClientKeys.removeAll(updatedOnClientKeys);
        onlyOnClientKeys.removeAll(alreadySynchronisedKeys);
        onlyOnClientKeys.removeAll(updatedOnServerKeys);
        return new FileComparerResults(onlyOnServerKeys, updatedOnServerKeys, updatedOnClientKeys, onlyOnClientKeys, alreadySynchronisedKeys);
    }

    public class PartialObjectListing {
        private Map objectsMap = null;
        private String priorLastKey = null;

        public PartialObjectListing(Map objectsMap, String priorLastKey) {
            this.objectsMap = objectsMap;
            this.priorLastKey = priorLastKey;
        }

        public Map getObjectsMap() {
            return this.objectsMap;
        }

        public String getPriorLastKey() {
            return this.priorLastKey;
        }
    }
}

