/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka.v09;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.kafka.v09.KafkaTestUtils$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEf!B\u0001\u0003\u0001\u0011q!AD&bM.\fG+Z:u+RLGn\u001d\u0006\u0003\u0007\u0011\t1A\u001e\u0019:\u0015\t)a!A\u0003lC\u001a\\\u0017M\u0003\u0002\b\u0011\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t1r#D\u0001\t\u0013\tA\u0002BA\u0004M_\u001e<\u0017N\\4\t\u000bi\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0019Q8\u000eS8tiV\t!\u0005\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005!A.\u00198h\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\rM#(/\u001b8h\u0011\u0019Y\u0003\u0001)A\u0005E\u00059!p\u001b%pgR\u0004\u0003bB\u0017\u0001\u0001\u0004%IAL\u0001\u0007u.\u0004vN\u001d;\u0016\u0003=\u0002\"\u0001\u0005\u0019\n\u0005E\n\"aA%oi\"91\u0007\u0001a\u0001\n\u0013!\u0014A\u0003>l!>\u0014Ho\u0018\u0013fcR\u0011Q\u0007\u000f\t\u0003!YJ!aN\t\u0003\tUs\u0017\u000e\u001e\u0005\bsI\n\t\u00111\u00010\u0003\rAH%\r\u0005\u0007w\u0001\u0001\u000b\u0015B\u0018\u0002\u000fi\\\u0007k\u001c:uA!9Q\b\u0001b\u0001\n\u0013q\u0013a\u0005>l\u0007>tg.Z2uS>tG+[7f_V$\bBB \u0001A\u0003%q&\u0001\u000b{W\u000e{gN\\3di&|g\u000eV5nK>,H\u000f\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003/\u0003AQ8nU3tg&|g\u000eV5nK>,H\u000f\u0003\u0004D\u0001\u0001\u0006IaL\u0001\u0012u.\u001cVm]:j_:$\u0016.\\3pkR\u0004\u0003\"C#\u0001\u0001\u0004\u0005\r\u0011\"\u0003G\u0003%Qxn\\6fKB,'/F\u0001H!\tA\u0015*D\u0001\u0001\r\u0011Q\u0005\u0001B&\u0003#\u0015k'-\u001a3eK\u0012Tvn\\6fKB,'o\u0005\u0002J\u001f!AQ*\u0013BC\u0002\u0013\u0005a*A\u0005{W\u000e{gN\\3diV\tq\n\u0005\u0002Q':\u0011\u0001#U\u0005\u0003%F\ta\u0001\u0015:fI\u00164\u0017BA\u0015U\u0015\t\u0011\u0016\u0003\u0003\u0005W\u0013\n\u0005\t\u0015!\u0003P\u0003)Q8nQ8o]\u0016\u001cG\u000f\t\u0005\u00065%#\t\u0001\u0017\u000b\u0003\u000ffCQ!T,A\u0002=CqaW%C\u0002\u0013\u0005A,A\u0006t]\u0006\u00048\u000f[8u\t&\u0014X#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u00014\u0013AA5p\u0013\t\u0011wL\u0001\u0003GS2,\u0007B\u00023JA\u0003%Q,\u0001\u0007t]\u0006\u00048\u000f[8u\t&\u0014\b\u0005C\u0004g\u0013\n\u0007I\u0011\u0001/\u0002\r1|w\rR5s\u0011\u0019A\u0017\n)A\u0005;\u00069An\\4ESJ\u0004\u0003bB#J\u0005\u0004%\tA[\u000b\u0002WB\u0011A\u000e]\u0007\u0002[*\u0011an\\\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u0015S\u0011BA9n\u0005=Qvn\\&fKB,'oU3sm\u0016\u0014\bBB:JA\u0003%1.\u0001\u0006{_>\\W-\u001a9fe\u0002Bq!^%\u0002B\u0003%a/A\u0002yIM\u0002B\u0001E<#_%\u0011\u00010\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u000fiL%\u0019!C\u0001C\u0005\u0011\u0011\u000e\u001d\u0005\u0007y&\u0003\u000b\u0011\u0002\u0012\u0002\u0007%\u0004\b\u0005C\u0004\u007f\u0013\n\u0007I\u0011\u0001\u0018\u0002\tA|'\u000f\u001e\u0005\b\u0003\u0003I\u0005\u0015!\u00030\u0003\u0015\u0001xN\u001d;!\u0011%\t)!\u0013b\u0001\n\u0003\t9!A\u0004gC\u000e$xN]=\u0016\u0005\u0005%\u0001c\u00017\u0002\f%\u0019\u0011QB7\u0003)9KujU3sm\u0016\u00148I\u001c=o\r\u0006\u001cGo\u001c:z\u0011!\t\t\"\u0013Q\u0001\n\u0005%\u0011\u0001\u00034bGR|'/\u001f\u0011\t\u0011\u0005U\u0011J1A\u0005\u00029\n!\"Y2uk\u0006d\u0007k\u001c:u\u0011\u001d\tI\"\u0013Q\u0001\n=\n1\"Y2uk\u0006d\u0007k\u001c:uA!9\u0011QD%\u0005\u0002\u0005}\u0011\u0001C:ikR$wn\u001e8\u0015\u0003UB1\"a\t\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002&\u0005i!p\\8lK\u0016\u0004XM]0%KF$2!NA\u0014\u0011!I\u0014\u0011EA\u0001\u0002\u00049\u0005BB:\u0001A\u0003&q\tC\u0006\u0002.\u0001\u0001\r\u00111A\u0005\n\u0005=\u0012\u0001\u0003>l\u00072LWM\u001c;\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\tu.\u001cG.[3oi*\u0019\u00111\b\u0007\u0002\r%\u0003\u0014\n^3d\u0013\u0011\ty$!\u000e\u0003\u0011i[7\t\\5f]RD1\"a\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002F\u0005a!p[\"mS\u0016tGo\u0018\u0013fcR\u0019Q'a\u0012\t\u0013e\n\t%!AA\u0002\u0005E\u0002\u0002CA&\u0001\u0001\u0006K!!\r\u0002\u0013i\\7\t\\5f]R\u0004\u0003bCA(\u0001\u0001\u0007\t\u0019!C\u0005\u0003#\nqA_6Vi&d7/\u0006\u0002\u0002TA!\u0011QKA/\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013!B;uS2\u001c(\"A\u0003\n\t\u0005}\u0013q\u000b\u0002\b5.,F/\u001b7t\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0004%I!!\u001a\u0002\u0017i\\W\u000b^5mg~#S-\u001d\u000b\u0004k\u0005\u001d\u0004\"C\u001d\u0002b\u0005\u0005\t\u0019AA*\u0011!\tY\u0007\u0001Q!\n\u0005M\u0013\u0001\u0003>l+RLGn\u001d\u0011\t\u0011\u0005=\u0004A1A\u0005\n\u0005\n!B\u0019:pW\u0016\u0014\bj\\:u\u0011\u001d\t\u0019\b\u0001Q\u0001\n\t\n1B\u0019:pW\u0016\u0014\bj\\:uA!A\u0011q\u000f\u0001A\u0002\u0013%a&\u0001\u0006ce>\\WM\u001d)peRD\u0011\"a\u001f\u0001\u0001\u0004%I!! \u0002\u001d\t\u0014xn[3s!>\u0014Ho\u0018\u0013fcR\u0019Q'a \t\u0011e\nI(!AA\u0002=Bq!a!\u0001A\u0003&q&A\u0006ce>\\WM\u001d)peR\u0004\u0003bCAD\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013\u000b!B\u0019:pW\u0016\u00148i\u001c8g+\t\tY\t\u0005\u0003\u0002\u000e\u0006EUBAAH\u0015\rq\u00171L\u0005\u0005\u0003'\u000byIA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bCAL\u0001\u0001\u0007\t\u0019!C\u0005\u00033\u000baB\u0019:pW\u0016\u00148i\u001c8g?\u0012*\u0017\u000fF\u00026\u00037C\u0011\"OAK\u0003\u0003\u0005\r!a#\t\u0011\u0005}\u0005\u0001)Q\u0005\u0003\u0017\u000b1B\u0019:pW\u0016\u00148i\u001c8gA!Qa\u000e\u0001a\u0001\u0002\u0004%I!a)\u0016\u0005\u0005\u0015\u0006\u0003BAG\u0003OKA!!+\u0002\u0010\nY1*\u00194lCN+'O^3s\u0011-\ti\u000b\u0001a\u0001\u0002\u0004%I!a,\u0002\u0015M,'O^3s?\u0012*\u0017\u000fF\u00026\u0003cC\u0011\"OAV\u0003\u0003\u0005\r!!*\t\u0011\u0005U\u0006\u0001)Q\u0005\u0003K\u000bqa]3sm\u0016\u0014\b\u0005C\u0006\u0002:\u0002\u0001\r\u00111A\u0005\n\u0005m\u0016\u0001\u00039s_\u0012,8-\u001a:\u0016\u0005\u0005u\u0006CBA`\u0003\u0007|u*\u0004\u0002\u0002B*!\u0011\u0011XA.\u0013\u0011\t)-!1\u0003\u0011A\u0013x\u000eZ;dKJD1\"!3\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L\u0006a\u0001O]8ek\u000e,'o\u0018\u0013fcR\u0019Q'!4\t\u0013e\n9-!AA\u0002\u0005u\u0006\u0002CAi\u0001\u0001\u0006K!!0\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0003\"CAk\u0001\u0001\u0007I\u0011BAl\u0003\u001dQ8NU3bIf,\"!!7\u0011\u0007A\tY.C\u0002\u0002^F\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002b\u0002\u0001\r\u0011\"\u0003\u0002d\u0006Y!p\u001b*fC\u0012Lx\fJ3r)\r)\u0014Q\u001d\u0005\ns\u0005}\u0017\u0011!a\u0001\u00033D\u0001\"!;\u0001A\u0003&\u0011\u0011\\\u0001\tu.\u0014V-\u00193zA!I\u0011Q\u001e\u0001A\u0002\u0013%\u0011q[\u0001\fEJ|7.\u001a:SK\u0006$\u0017\u0010C\u0005\u0002r\u0002\u0001\r\u0011\"\u0003\u0002t\u0006y!M]8lKJ\u0014V-\u00193z?\u0012*\u0017\u000fF\u00026\u0003kD\u0011\"OAx\u0003\u0003\u0005\r!!7\t\u0011\u0005e\b\u0001)Q\u0005\u00033\fAB\u0019:pW\u0016\u0014(+Z1es\u0002Ba!!@\u0001\t\u0003q\u0015!\u0003>l\u0003\u0012$'/Z:t\u0011\u0019\u0011\t\u0001\u0001C\u0001\u001d\u0006i!M]8lKJ\fE\r\u001a:fgNDqA!\u0002\u0001\t\u0003\ty#A\b{_>\\W-\u001a9fe\u000ec\u0017.\u001a8u\u0011\u001d\u0011I\u0001\u0001C\u0005\u0003?\tac]3ukB,UNY3eI\u0016$'l\\8lK\u0016\u0004XM\u001d\u0005\b\u0005\u001b\u0001A\u0011BA\u0010\u0003a\u0019X\r^;q\u000b6\u0014W\r\u001a3fI.\u000bgm[1TKJ4XM\u001d\u0005\b\u0005#\u0001A\u0011AA\u0010\u0003\u0015\u0019X\r^;q\u0011\u001d\u0011)\u0002\u0001C\u0001\u0003?\t\u0001\u0002^3be\u0012|wO\u001c\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u0007U\u0012i\u0002C\u0004\u0003 \t]\u0001\u0019A(\u0002\u000bQ|\u0007/[2\t\u000f\t\r\u0002\u0001\"\u0001\u0003&\u0005a1/\u001a8e\u001b\u0016\u001c8/Y4fgR)QGa\n\u0003*!9!q\u0004B\u0011\u0001\u0004y\u0005\u0002\u0003B\u0016\u0005C\u0001\rA!\f\u0002\u001b5,7o]1hKR{gI]3r!\u001d\u0011yC!\u000eP\u0005si!A!\r\u000b\u0007\tMb%\u0001\u0003vi&d\u0017\u0002\u0002B\u001c\u0005c\u00111!T1q!\r\u0019#1H\u0005\u0004\u0005{!#aB%oi\u0016<WM\u001d\u0005\b\u0005G\u0001A\u0011\u0001B!)\u0015)$1\tB#\u0011\u001d\u0011yBa\u0010A\u0002=C\u0001Ba\u000b\u0003@\u0001\u0007!q\t\t\u0006!\n%sjL\u0005\u0004\u0005o!\u0006b\u0002B\u0012\u0001\u0011\u0005!Q\n\u000b\u0006k\t=#\u0011\u000b\u0005\b\u0005?\u0011Y\u00051\u0001P\u0011!\u0011\u0019Fa\u0013A\u0002\tU\u0013\u0001C7fgN\fw-Z:\u0011\tA\u00119fT\u0005\u0004\u00053\n\"!B!se\u0006L\bb\u0002B/\u0001\u0011%!qL\u0001\u0014EJ|7.\u001a:D_:4\u0017nZ;sCRLwN\\\u000b\u0003\u0005C\u0002BAa\f\u0003d%!!Q\rB\u0019\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0005S\u0002A\u0011\u0002B0\u0003U\u0001(o\u001c3vG\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:DqA!\u001c\u0001\t\u0003\u0011y'\u0001\u0006fm\u0016tG/^1mYf,BA!\u001d\u0003zQ1!1\u000fBK\u0005C#BA!\u001e\u0003\fB!!q\u000fB=\u0019\u0001!\u0001Ba\u001f\u0003l\t\u0007!Q\u0010\u0002\u0002)F!!q\u0010BC!\r\u0001\"\u0011Q\u0005\u0004\u0005\u0007\u000b\"a\u0002(pi\"Lgn\u001a\t\u0004!\t\u001d\u0015b\u0001BE#\t\u0019\u0011I\\=\t\u0013\t5%1\u000eCA\u0002\t=\u0015\u0001\u00024v]\u000e\u0004R\u0001\u0005BI\u0005kJ1Aa%\u0012\u0005!a$-\u001f8b[\u0016t\u0004\u0002\u0003BL\u0005W\u0002\rA!'\u0002\u000fQLW.Z8viB!!1\u0014BO\u001b\u00051\u0011b\u0001BP\r\t!A+[7f\u0011!\u0011\u0019Ka\u001bA\u0002\te\u0015\u0001C5oi\u0016\u0014h/\u00197\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\u0006ir/Y5u+:$\u0018\u000e\\'fi\u0006$\u0017\r^1JgB\u0013x\u000e]1hCR,G\rF\u00036\u0005W\u0013i\u000bC\u0004\u0003 \t\u0015\u0006\u0019A(\t\u000f\t=&Q\u0015a\u0001_\u0005I\u0001/\u0019:uSRLwN\u001c")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private ZkUtils zkUtils;
    private final String brokerHost;
    private int org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server;
    private Producer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    private void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    private int org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server() {
        return this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server;
    }

    public void org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server = x$1;
    }

    private Producer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort())}));
    }

    public ZkClient zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        });
        return (ZkClient)Option$.MODULE$.apply((Object)this.zkClient()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkClient_$eq(ZkUtils$.MODULE$.createZkClient(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout()));
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkClient(), JaasUtils.isZkSecurityEnabled()));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        });
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig((Map)this.$outer.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConfiguration()));
                this.$outer.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3()));
                this.$outer.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server().startup();
                return new Tuple2((Object)this.$outer.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)port));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server_$eq(null);
        }
        this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConf().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils$.MODULE$.deleteRecursively(new File(f));
            }
        });
        if (this.zkClient() != null) {
            this.zkClient().close();
            this.zkClient_$eq(null);
        }
        if (this.zkUtils() != null) {
            this.zkUtils().close();
            this.zkUtils_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic) {
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
        this.waitUntilMetadataIsPropagated(topic, 0);
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    int freq = tuple2._2$mcI$sp();
                    Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final String s$1;

                        public final String apply() {
                            return this.s$1;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq((Producer<String, String>)new Producer(new ProducerConfig(this.producerConfiguration())));
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])messages).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final KeyedMessage<String, String> apply(String x$2) {
                return new KeyedMessage(this.topic$2, (Object)x$2);
            }
            {
                this.topic$2 = topic$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KeyedMessage.class)))));
        this.producer().close();
        this.producer_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    public Properties org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerAddress());
        props.put("serializer.class", StringEncoder.class.getName());
        props.put("request.required.acks", "-1");
        return var1_1;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, timeout, interval, func, startTime);
    }

    private void waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$1;
            public final int partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$isPropagated$1(this.topic$1, this.partition$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.$outer.partition$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.partition$1 = partition$1;
            }
        });
    }

    private final Either makeAttempt$1(Function0 func$1) {
        Throwable throwable2;
        block2: {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(func$1.apply());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                Left left = package$.MODULE$.Left().apply((Object)throwable3);
                right = left;
            }
            return right;
        }
        throw throwable2;
    }

    private final Object tryAgain$1(int attempt, Time timeout$1, Time interval$1, Function0 func$1, long startTime$1) {
        Either either;
        block2: {
            Throwable e;
            while (true) {
                if ((either = this.makeAttempt$1(func$1)) instanceof Right) {
                    Object result;
                    Right right = (Right)either;
                    Object object = result = right.b();
                    return object;
                }
                if (!(either instanceof Left)) break block2;
                Left left = (Left)either;
                e = (Throwable)left.a();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) break;
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new TimeoutException(e.getMessage());
        }
        throw new MatchError((Object)either);
    }

    public final boolean org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$isPropagated$1(String topic$1, int partition$1) {
        boolean bl;
        Option option = this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$1, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
            LeaderAndIsr leaderAndInSyncReplicas = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            bl = this.zkUtils().getLeaderForPartition(topic$1, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader()) && leaderAndInSyncReplicas.isr().size() >= 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils() {
        Logging.class.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.org$apache$spark$streaming$kafka$v09$KafkaTestUtils$$brokerPort = 9092;
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final Tuple2<String, Object> x$3;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            Utils$.MODULE$.deleteRecursively(this.logDir());
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka$v09$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2 tuple22;
                String ip = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$3 = tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
                this.ip = (String)this.x$3._1();
                this.port = this.x$3._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

