/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.apache.spark.streaming.kinesis.KinesisTestUtils$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KinesisTestUtils$ {
    public static final KinesisTestUtils$ MODULE$;
    private final String envVarNameForEnablingTests;
    private final String endVarNameForEndpoint;
    private final String defaultEndpointUrl;
    private boolean shouldRunTests;
    private String endpointUrl;
    private volatile byte bitmap$0;

    static {
        new KinesisTestUtils$();
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldRunTests$lzycompute() {
        KinesisTestUtils$ kinesisTestUtils$ = this;
        synchronized (kinesisTestUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var3_3;
                boolean isEnvSet;
                Option option = package$.MODULE$.env().get((Object)this.envVarNameForEnablingTests());
                Some some = new Some((Object)"1");
                boolean bl = !(option != null ? !option.equals(some) : some != null) ? true : (isEnvSet = false);
                if (isEnvSet) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |Kinesis tests that actually send data has been enabled by setting the environment\n          |variable ", " to 1. This will create Kinesis Streams and\n          |DynamoDB tables in AWS. Please be aware that this may incur some AWS costs.\n          |By default, the tests use the endpoint URL ", " to create Kinesis streams.\n          |To change this endpoint URL to a different region, you can set the environment variable\n          |", " to the desired endpoint URL\n          |(e.g. ", "=\"https://kinesis.us-west-2.amazonaws.com\").\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.envVarNameForEnablingTests(), this.defaultEndpointUrl(), this.endVarNameForEndpoint(), this.endVarNameForEndpoint()})))).stripMargin());
                }
                this.shouldRunTests = var3_3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.shouldRunTests;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String endpointUrl$lzycompute() {
        KinesisTestUtils$ kinesisTestUtils$ = this;
        synchronized (kinesisTestUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                String url = (String)package$.MODULE$.env().getOrElse((Object)this.endVarNameForEndpoint(), (Function0)new anonfun.2());
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using endpoint URL ", " for creating Kinesis streams for tests."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
                this.endpointUrl = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.endpointUrl;
        }
    }

    public String envVarNameForEnablingTests() {
        return this.envVarNameForEnablingTests;
    }

    public String endVarNameForEndpoint() {
        return this.endVarNameForEndpoint;
    }

    public String defaultEndpointUrl() {
        return this.defaultEndpointUrl;
    }

    public boolean shouldRunTests() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldRunTests$lzycompute() : this.shouldRunTests;
    }

    public String endpointUrl() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.endpointUrl$lzycompute() : this.endpointUrl;
    }

    public boolean isAWSCredentialsPresent() {
        return Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AWSCredentials apply() {
                return new DefaultAWSCredentialsProviderChain().getCredentials();
            }
        }).isSuccess();
    }

    public AWSCredentials getAWSCredentials() {
        Predef$.MODULE$.assert(this.shouldRunTests(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kinesis test not enabled, should not attempt to get AWS credentials";
            }
        });
        Try try_ = Try$.MODULE$.apply((Function0)new anonfun.3());
        if (try_ instanceof Success) {
            AWSCredentials cred;
            Success success = (Success)try_;
            AWSCredentials aWSCredentials = cred = (AWSCredentials)success.value();
            return aWSCredentials;
        }
        if (try_ instanceof Failure) {
            throw new Exception(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |Kinesis tests enabled using environment variable ", "\n             |but could not find AWS credentials. Please follow instructions in AWS documentation\n             |to set the credentials in your system such that the DefaultAWSCredentialsProviderChain\n             |can find the credentials.\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.envVarNameForEnablingTests()})))).stripMargin());
        }
        throw new MatchError((Object)try_);
    }

    private KinesisTestUtils$() {
        MODULE$ = this;
        this.envVarNameForEnablingTests = "ENABLE_KINESIS_TESTS";
        this.endVarNameForEndpoint = "KINESIS_TEST_ENDPOINT_URL";
        this.defaultEndpointUrl = "https://kinesis.us-west-2.amazonaws.com";
    }
}

