/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.model.Record;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer$;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=gAB\u0001\u0003\u0001\ta\u0011OA\bLS:,7/[:SK\u000e,\u0017N^3s\u0015\t\u0019A!A\u0004lS:,7/[:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WCA\u0007\u0017'\r\u0001ab\t\t\u0004\u001fI!R\"\u0001\t\u000b\u0005E!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\n\u0005M\u0001\"\u0001\u0003*fG\u0016Lg/\u001a:\u0011\u0005U1B\u0002\u0001\u0003\u0006/\u0001\u0011\r!\u0007\u0002\u0002)\u000e\u0001\u0011C\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0011\n\u0005\tb\"aA!osB\u0011AeJ\u0007\u0002K)\u0011aEB\u0001\tS:$XM\u001d8bY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0011!Q\u0003A!b\u0001\n\u0003Y\u0013AC:ue\u0016\fWNT1nKV\tA\u0006\u0005\u0002.a9\u00111DL\u0005\u0003_q\ta\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011q\u0006\b\u0005\ti\u0001\u0011\t\u0011)A\u0005Y\u0005Y1\u000f\u001e:fC6t\u0015-\\3!\u0011!1\u0004A!A!\u0002\u0013a\u0013aC3oIB|\u0017N\u001c;Ve2D\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u000be\u0016<\u0017n\u001c8OC6,\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u001f%t\u0017\u000e^5bYB{7/\u001b;j_:\u0004\"\u0001P\u001f\u000e\u0003\tI!A\u0010\u0002\u0003--Kg.Z:jg&s\u0017\u000e^5bYB{7/\u001b;j_:D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u0012G\",7m\u001b9pS:$\u0018\t\u001d9OC6,\u0007\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\u0002%\rDWmY6q_&tG/\u00138uKJ4\u0018\r\u001c\t\u0003\t\u0016k\u0011\u0001B\u0005\u0003\r\u0012\u0011\u0001\u0002R;sCRLwN\u001c\u0005\n\u0011\u0002\u0011\t\u0011)A\u0005\u0013>\u000bAb\u001d;pe\u0006<W\rT3wK2\u0004\"AS'\u000e\u0003-S!\u0001\u0014\u0004\u0002\u000fM$xN]1hK&\u0011aj\u0013\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0005\u0003\u0011JA\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IAU\u0001\u000f[\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s!\u0011Y2+\u0016\u000b\n\u0005Qc\"!\u0003$v]\u000e$\u0018n\u001c82!\t1\u0006-D\u0001X\u0015\tA\u0016,A\u0003n_\u0012,GN\u0003\u0002\u00045*\u00111\fX\u0001\tg\u0016\u0014h/[2fg*\u0011QLX\u0001\nC6\f'p\u001c8boNT\u0011aX\u0001\u0004G>l\u0017BA1X\u0005\u0019\u0011VmY8sI\"A1\r\u0001B\u0001B\u0003%A-\u0001\u0007lS:,7/[:De\u0016$7\u000f\u0005\u0002=K&\u0011aM\u0001\u0002\u0014'B\f'o[!X'\u000e\u0013X\rZ3oi&\fGn\u001d\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\u0006iA-\u001f8b[>$%i\u0011:fIN\u00042a\u00076e\u0013\tYGD\u0001\u0004PaRLwN\u001c\u0005\t[\u0002\u0011\t\u0011)A\u0005S\u0006y1\r\\8vI^\u000bGo\u00195De\u0016$7\u000fC\u0003p\u0001\u0011\u0005\u0001/\u0001\u0004=S:LGO\u0010\u000b\rcJ\u001cH/\u001e<xqfT8\u0010 \t\u0004y\u0001!\u0002\"\u0002\u0016o\u0001\u0004a\u0003\"\u0002\u001co\u0001\u0004a\u0003\"\u0002\u001do\u0001\u0004a\u0003\"\u0002\u001eo\u0001\u0004Y\u0004\"\u0002!o\u0001\u0004a\u0003\"\u0002\"o\u0001\u0004\u0019\u0005\"\u0002%o\u0001\u0004I\u0005\"B)o\u0001\u0004\u0011\u0006\"B2o\u0001\u0004!\u0007\"\u00025o\u0001\u0004I\u0007\"B7o\u0001\u0004I\u0007b\u0002@\u0001\u0001\u0004%IaK\u0001\to>\u00148.\u001a:JI\"I\u0011\u0011\u0001\u0001A\u0002\u0013%\u00111A\u0001\ro>\u00148.\u001a:JI~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u0002\u001c\u0003\u000fI1!!\u0003\u001d\u0005\u0011)f.\u001b;\t\u0011\u00055q0!AA\u00021\n1\u0001\u001f\u00132\u0011\u001d\t\t\u0002\u0001Q!\n1\n\u0011b^8sW\u0016\u0014\u0018\n\u001a\u0011)\t\u0005=\u0011Q\u0003\t\u00047\u0005]\u0011bAA\r9\tAao\u001c7bi&dW\rC\u0005\u0002\u001e\u0001\u0001\r\u0011\"\u0003\u0002 \u00051qo\u001c:lKJ,\"!!\t\u0011\t\u0005\r\u0012qF\u0007\u0003\u0003KQA!!\b\u0002()!\u0011\u0011FA\u0016\u0003\ra\u0017N\u0019\u0006\u0004\u0003[I\u0016!D2mS\u0016tG\u000f\\5ce\u0006\u0014\u00180\u0003\u0003\u00022\u0005\u0015\"AB,pe.,'\u000fC\u0005\u00026\u0001\u0001\r\u0011\"\u0003\u00028\u0005Qqo\u001c:lKJ|F%Z9\u0015\t\u0005\u0015\u0011\u0011\b\u0005\u000b\u0003\u001b\t\u0019$!AA\u0002\u0005\u0005\u0002\u0002CA\u001f\u0001\u0001\u0006K!!\t\u0002\u000f]|'o[3sA!\"\u00111HA\u000b\u0011%\t\u0019\u0005\u0001a\u0001\n\u0013\t)%\u0001\u0007x_J\\WM\u001d+ie\u0016\fG-\u0006\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013\u0001\u00027b]\u001eT!!!\u0015\u0002\t)\fg/Y\u0005\u0005\u0003+\nYE\u0001\u0004UQJ,\u0017\r\u001a\u0005\n\u00033\u0002\u0001\u0019!C\u0005\u00037\n\u0001c^8sW\u0016\u0014H\u000b\u001b:fC\u0012|F%Z9\u0015\t\u0005\u0015\u0011Q\f\u0005\u000b\u0003\u001b\t9&!AA\u0002\u0005\u001d\u0003\u0002CA1\u0001\u0001\u0006K!a\u0012\u0002\u001b]|'o[3s)\"\u0014X-\u00193!Q\u0011\ty&!\u0006\t\u0013\u0005\u001d\u0004\u00011A\u0005\n\u0005%\u0014A\u00042m_\u000e\\w)\u001a8fe\u0006$xN]\u000b\u0003\u0003W\u00022aDA7\u0013\r\ty\u0007\u0005\u0002\u000f\u00052|7m[$f]\u0016\u0014\u0018\r^8s\u0011%\t\u0019\b\u0001a\u0001\n\u0013\t)(\u0001\ncY>\u001c7nR3oKJ\fGo\u001c:`I\u0015\fH\u0003BA\u0003\u0003oB!\"!\u0004\u0002r\u0005\u0005\t\u0019AA6\u0011!\tY\b\u0001Q!\n\u0005-\u0014a\u00042m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0011)\t\u0005e\u0014Q\u0003\u0005\n\u0003\u0003\u0003!\u0019!C\u0005\u0003\u0007\u000b!d]3r\u001dVl'+\u00198hKNLenQ;se\u0016tGO\u00117pG.,\"!!\"\u0011\r\u0005\u001d\u0015\u0011SAK\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001fc\u0012AC2pY2,7\r^5p]&!\u00111SAE\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007q\n9*C\u0002\u0002\u001a\n\u00111cU3rk\u0016t7-\u001a(v[\n,'OU1oO\u0016D\u0001\"!(\u0001A\u0003%\u0011QQ\u0001\u001cg\u0016\fh*^7SC:<Wm]%o\u0007V\u0014(/\u001a8u\u00052|7m\u001b\u0011\t\u0013\u0005\u0005\u0006A1A\u0005\n\u0005\r\u0016!\u00062m_\u000e\\\u0017\n\u001a+p'\u0016\fh*^7SC:<Wm]\u000b\u0003\u0003K\u0003\u0002\"a*\u00022\u0006U\u00161X\u0007\u0003\u0003SSA!a+\u0002.\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005=\u0016qJ\u0001\u0005kRLG.\u0003\u0003\u00024\u0006%&!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0019!*a.\n\u0007\u0005e6JA\u0007TiJ,\u0017-\u001c\"m_\u000e\\\u0017\n\u001a\t\u0004y\u0005u\u0016bAA`\u0005\t!2+Z9vK:\u001cWMT;nE\u0016\u0014(+\u00198hKND\u0001\"a1\u0001A\u0003%\u0011QU\u0001\u0017E2|7m[%e)>\u001cV-\u001d(v[J\u000bgnZ3tA!I\u0011q\u0019\u0001A\u0002\u0013%\u0011\u0011Z\u0001\u0014W&tWm]5t\u0007\",7m\u001b9pS:$XM]\u000b\u0003\u0003\u0017\u00042\u0001PAg\u0013\r\tyM\u0001\u0002\u0014\u0017&tWm]5t\u0007\",7m\u001b9pS:$XM\u001d\u0005\n\u0003'\u0004\u0001\u0019!C\u0005\u0003+\fqc[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ|F%Z9\u0015\t\u0005\u0015\u0011q\u001b\u0005\u000b\u0003\u001b\t\t.!AA\u0002\u0005-\u0007\u0002CAn\u0001\u0001\u0006K!a3\u0002)-Lg.Z:jg\u000eCWmY6q_&tG/\u001a:!Q\u0011\tI.!\u0006\t\u0013\u0005\u0005\bA1A\u0005\n\u0005\r\u0018aG:iCJ$\u0017\n\u001a+p\u0019\u0006$Xm\u001d;Ti>\u0014X\rZ*fc:+X.\u0006\u0002\u0002fB1\u0011qUAYY1B\u0001\"!;\u0001A\u0003%\u0011Q]\u0001\u001dg\"\f'\u000fZ%e)>d\u0015\r^3tiN#xN]3e'\u0016\fh*^7!\u0011\u001d\ti\u000f\u0001C!\u0003_\fqa\u001c8Ti\u0006\u0014H\u000f\u0006\u0002\u0002\u0006!9\u00111\u001f\u0001\u0005B\u0005=\u0018AB8o'R|\u0007\u000f\u0003\u0005\u0002x\u0002!\tAAA}\u0003)\tG\r\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003\u000b\tY0a@\t\u000f\u0005u\u0018Q\u001fa\u0001Y\u000591\u000f[1sI&#\u0007\u0002\u0003B\u0001\u0003k\u0004\rAa\u0001\u0002\u000fI,7m\u001c:egB)!Q\u0001B\u0004+6\u0011\u0011QV\u0005\u0005\u0005\u0013\tiK\u0001\u0003MSN$\b\u0002\u0003B\u0007\u0001\u0011\u0005!Aa\u0004\u0002\u001f\u001d,GoQ;se\u0016tG\u000fT5nSR,\"A!\u0005\u0011\u0007m\u0011\u0019\"C\u0002\u0003\u0016q\u00111!\u00138u\u0011!\u0011I\u0002\u0001C\u0001\u0005\tm\u0011aG4fi2\u000bG/Z:u'\u0016\fh*^7U_\u000eCWmY6q_&tG\u000f\u0006\u0003\u0003\u001e\t}\u0001cA\u000ekY!9\u0011Q B\f\u0001\u0004a\u0003b\u0002B\u0012\u0001\u0011\u0005!QE\u0001\u0010g\u0016$8\t[3dWB|\u0017N\u001c;feR1\u0011Q\u0001B\u0014\u0005SAq!!@\u0003\"\u0001\u0007A\u0006\u0003\u0005\u0003,\t\u0005\u0002\u0019\u0001B\u0017\u00031\u0019\u0007.Z2la>Lg\u000e^3s!\u0011\u0011yC!\u000e\u000e\u0005\tE\"\u0002\u0002B\u001a\u0003W\t!\"\u001b8uKJ4\u0017mY3t\u0013\u0011\u00119D!\r\u00039%\u0013VmY8sIB\u0013xnY3tg>\u00148\t[3dWB|\u0017N\u001c;fe\"9!1\b\u0001\u0005\u0002\tu\u0012A\u0005:f[>4Xm\u00115fG.\u0004x.\u001b8uKJ$b!!\u0002\u0003@\t\u0005\u0003bBA\u007f\u0005s\u0001\r\u0001\f\u0005\t\u0005W\u0011I\u00041\u0001\u0003.!9!Q\t\u0001\u0005\n\t\u001d\u0013A\u0005:f[\u0016l'-\u001a:BI\u0012,GMU1oO\u0016$B!!\u0002\u0003J!A!1\nB\"\u0001\u0004\t)*A\u0003sC:<W\rC\u0004\u0003P\u0001!IA!\u0015\u0002;\u0019Lg.\u00197ju\u0016\u0014\u0016M\\4fg\u001a{'oQ;se\u0016tGO\u00117pG.$B!!\u0002\u0003T!A!Q\u000bB'\u0001\u0004\t),A\u0004cY>\u001c7.\u00133\t\u000f\te\u0003\u0001\"\u0003\u0003\\\u0005!2\u000f^8sK\ncwnY6XSRD'+\u00198hKN$b!!\u0002\u0003^\t}\u0003\u0002\u0003B+\u0005/\u0002\r!!.\t\u0011\t\u0005$q\u000ba\u0001\u0005G\n1\"\u0019:sCf\u0014UO\u001a4feB)\u0011qQAI)\u00191!q\r\u0001\u0005\u0005S\u0012QcR3oKJ\fG/\u001a3CY>\u001c7\u000eS1oI2,'o\u0005\u0004\u0003f\t-$\u0011\u000f\t\u00047\t5\u0014b\u0001B89\t1\u0011I\\=SK\u001a\u00042a\u0004B:\u0013\r\u0011)\b\u0005\u0002\u0017\u00052|7m[$f]\u0016\u0014\u0018\r^8s\u0019&\u001cH/\u001a8fe\"9qN!\u001a\u0005\u0002\teDC\u0001B>!\u0011\u0011iH!\u001a\u000e\u0003\u0001A\u0001B!!\u0003f\u0011\u0005!1Q\u0001\n_:\fE\r\u001a#bi\u0006$b!!\u0002\u0003\u0006\n%\u0005b\u0002BD\u0005\u007f\u0002\r\u0001I\u0001\u0005I\u0006$\u0018\rC\u0004\u0003\f\n}\u0004\u0019\u0001\u0011\u0002\u00115,G/\u00193bi\u0006D\u0001Ba$\u0003f\u0011\u0005!\u0011S\u0001\u0010_:<UM\\3sCR,'\t\\8dWR!\u0011Q\u0001BJ\u0011!\u0011)F!$A\u0002\u0005U\u0006\u0002\u0003BL\u0005K\"\tA!'\u0002\u0017=t\u0007+^:i\u00052|7m\u001b\u000b\u0007\u0003\u000b\u0011YJ!(\t\u0011\tU#Q\u0013a\u0001\u0003kC\u0001B!\u0019\u0003\u0016\u0002\u0007!q\u0014\u0019\u0005\u0005C\u0013)\u000b\u0005\u0004\u0002\b\u0006E%1\u0015\t\u0004+\t\u0015Fa\u0003BT\u0005;\u000b\t\u0011!A\u0003\u0002e\u00111a\u0018\u00132\u0011!\u0011YK!\u001a\u0005\u0002\t5\u0016aB8o\u000bJ\u0014xN\u001d\u000b\u0007\u0003\u000b\u0011yKa-\t\u000f\tE&\u0011\u0016a\u0001Y\u00059Q.Z:tC\u001e,\u0007\u0002\u0003B[\u0005S\u0003\rAa.\u0002\u0013QD'o\\<bE2,\u0007\u0003\u0002B]\u0005\u0013tAAa/\u0003F:!!Q\u0018Bb\u001b\t\u0011yLC\u0002\u0003Bb\ta\u0001\u0010:p_Rt\u0014\"A\u000f\n\u0007\t\u001dG$A\u0004qC\u000e\\\u0017mZ3\n\t\t-'Q\u001a\u0002\n)\"\u0014xn^1cY\u0016T1Aa2\u001d\u0001")
public class KinesisReceiver<T>
extends Receiver<T>
implements Logging {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final KinesisInitialPosition initialPosition;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private volatile String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    private volatile Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    private volatile Thread workerThread;
    private volatile BlockGenerator blockGenerator;
    private final ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock;
    private final ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges;
    private volatile KinesisCheckpointer kinesisCheckpointer;
    private final ConcurrentHashMap<String, String> org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String streamName() {
        return this.streamName;
    }

    public String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = x$1;
    }

    public Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(Worker x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = x$1;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    private void blockGenerator_$eq(BlockGenerator x$1) {
        this.blockGenerator = x$1;
    }

    private ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock() {
        return this.seqNumRangesInCurrentBlock;
    }

    public ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    public ConcurrentHashMap<String, String> org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum;
    }

    public void onStart() {
        KinesisClientLibConfiguration kinesisClientLibConfiguration;
        this.blockGenerator_$eq(this.supervisor().createBlockGenerator((BlockGeneratorListener)new GeneratedBlockHandler()));
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(new StringBuilder().append((Object)Utils$.MODULE$.localHostName()).append((Object)":").append((Object)UUID.randomUUID()).toString());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this, this.checkpointInterval, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId(), KinesisCheckpointer$.MODULE$.$lessinit$greater$default$4()));
        AWSCredentialsProvider kinesisProvider = this.kinesisCreds.provider();
        KinesisClientLibConfiguration baseClientLibConfiguration = new KinesisClientLibConfiguration(this.checkpointAppName, this.streamName(), kinesisProvider, (AWSCredentialsProvider)this.dynamoDBCreds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AWSCredentialsProvider apply(SparkAWSCredentials x$1) {
                return x$1.provider();
            }
        }).getOrElse((Function0)new Serializable(this, kinesisProvider){
            public static final long serialVersionUID = 0L;
            private final AWSCredentialsProvider kinesisProvider$1;

            public final AWSCredentialsProvider apply() {
                return this.kinesisProvider$1;
            }
            {
                this.kinesisProvider$1 = kinesisProvider$1;
            }
        }), (AWSCredentialsProvider)this.cloudWatchCreds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AWSCredentialsProvider apply(SparkAWSCredentials x$2) {
                return x$2.provider();
            }
        }).getOrElse((Function0)new Serializable(this, kinesisProvider){
            public static final long serialVersionUID = 0L;
            private final AWSCredentialsProvider kinesisProvider$1;

            public final AWSCredentialsProvider apply() {
                return this.kinesisProvider$1;
            }
            {
                this.kinesisProvider$1 = kinesisProvider$1;
            }
        }), this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).withKinesisEndpoint(this.endpointUrl).withInitialPositionInStream(this.initialPosition.getPosition()).withTaskBackoffTimeMillis(500L).withRegionName(this.regionName);
        KinesisInitialPosition kinesisInitialPosition = this.initialPosition;
        if (kinesisInitialPosition instanceof KinesisInitialPositions.AtTimestamp) {
            KinesisInitialPositions.AtTimestamp atTimestamp = (KinesisInitialPositions.AtTimestamp)kinesisInitialPosition;
            kinesisClientLibConfiguration = baseClientLibConfiguration.withTimestampAtInitialPositionInStream(atTimestamp.getTimestamp());
        } else {
            kinesisClientLibConfiguration = baseClientLibConfiguration;
        }
        KinesisClientLibConfiguration kinesisClientLibConfiguration2 = kinesisClientLibConfiguration;
        IRecordProcessorFactory recordProcessorFactory = new IRecordProcessorFactory(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public IRecordProcessor createProcessor() {
                return new KinesisRecordProcessor<T>(this.$outer, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(new Worker(recordProcessorFactory, kinesisClientLibConfiguration2));
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().run();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.restart("Error running the KCL worker in Receiver", e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges().clear();
        this.blockGenerator().start();
        this.workerThread().setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kinesis Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId())})));
        this.workerThread().setDaemon(true);
        this.workerThread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisReceiver $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started receiver with workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void onStop() {
        if (this.workerThread() != null) {
            if (this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() != null) {
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().shutdown();
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(null);
            }
            this.workerThread().join();
            this.workerThread_$eq(null);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisReceiver $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped receiver for workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(null);
        if (this.kinesisCheckpointer() != null) {
            this.kinesisCheckpointer().shutdown();
            this.kinesisCheckpointer_$eq(null);
        }
    }

    public void addRecords(String shardId, List<Record> records) {
        if (records.size() > 0) {
            Iterator dataIterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(records.iterator()).asScala()).map(this.messageHandler);
            SequenceNumberRange metadata = new SequenceNumberRange(this.streamName(), shardId, records.get(0).getSequenceNumber(), records.get(records.size() - 1).getSequenceNumber(), records.size());
            this.blockGenerator().addMultipleDataWithCallback(dataIterator, (Object)metadata);
        }
    }

    public int getCurrentLimit() {
        Predef$.MODULE$.assert(this.blockGenerator() != null);
        return (int)package$.MODULE$.min(this.blockGenerator().getCurrentLimit(), Integer.MAX_VALUE);
    }

    public Option<String> getLatestSeqNumToCheckpoint(String shardId) {
        return Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum().get(shardId));
    }

    public void setCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kinesis Checkpointer not initialized!";
            }
        });
        this.kinesisCheckpointer().setCheckpointer(shardId, checkpointer);
    }

    public void removeCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kinesis Checkpointer not initialized!";
            }
        });
        this.kinesisCheckpointer().removeCheckpointer(shardId, checkpointer);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange(SequenceNumberRange range) {
        this.seqNumRangesInCurrentBlock().$plus$eq((Object)range);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(StreamBlockId blockId) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges().put(blockId, new SequenceNumberRanges((Seq<SequenceNumberRange>)Predef$.MODULE$.wrapRefArray((Object[])this.seqNumRangesInCurrentBlock().toArray(ClassTag$.MODULE$.apply(SequenceNumberRange.class)))));
        this.seqNumRangesInCurrentBlock().clear();
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisReceiver $outer;
            private final StreamBlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated block ", " has ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
            }
        });
    }

    /*
     * Exception decompiling
     */
    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(StreamBlockId blockId, ArrayBuffer<T> arrayBuffer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 179->192)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public KinesisReceiver(String streamName2, String endpointUrl, String regionName, KinesisInitialPosition initialPosition, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds) {
        this.streamName = streamName2;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPosition = initialPosition;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        super(storageLevel);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = null;
        this.workerThread = null;
        this.blockGenerator = null;
        this.seqNumRangesInCurrentBlock = new ArrayBuffer();
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges = new ConcurrentHashMap();
        this.kinesisCheckpointer = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum = new ConcurrentHashMap();
    }

    public class GeneratedBlockHandler
    implements BlockGeneratorListener {
        public void onAddData(Object data, Object metadata) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange((SequenceNumberRange)metadata);
        }

        public void onGenerateBlock(StreamBlockId blockId) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(blockId);
        }

        public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(blockId, arrayBuffer);
        }

        public void onError(String message, Throwable throwable) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().reportError(message, throwable);
        }

        public /* synthetic */ KinesisReceiver org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer() {
            return KinesisReceiver.this;
        }

        public GeneratedBlockHandler() {
            if (KinesisReceiver.this == null) {
                throw null;
            }
        }
    }
}

