/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.DefaultCredentials$;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations$;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r5f!B\u0001\u0003\u0001\ta!aE&j]\u0016\u001c\u0018n]%oaV$Hi\u0015;sK\u0006l'BA\u0002\u0005\u0003\u001dY\u0017N\\3tSNT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0016\u0005512C\u0001\u0001\u000f!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\bIN$(/Z1n\u0013\t\u0019\u0002C\u0001\u000bSK\u000e,\u0017N^3s\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0003+Ya\u0001\u0001B\u0003\u0018\u0001\t\u0007\u0011DA\u0001U\u0007\u0001\t\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001B0tg\u000e\u0004\"AJ\u0014\u000e\u0003\u0011I!\u0001\u000b\u0003\u0003!M#(/Z1nS:<7i\u001c8uKb$\b\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011A\u0016\u0002\u0015M$(/Z1n\u001d\u0006lW-F\u0001-!\ti\u0003G\u0004\u0002\u001c]%\u0011q\u0006H\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u000209!AA\u0007\u0001B\u0001B\u0003%A&A\u0006tiJ,\u0017-\u001c(b[\u0016\u0004\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u0016\u0002\u0017\u0015tG\r]8j]R,&\u000f\u001c\u0005\tq\u0001\u0011\t\u0011)A\u0005Y\u0005aQM\u001c3q_&tG/\u0016:mA!A!\b\u0001BC\u0002\u0013\u00051&\u0001\u0006sK\u001eLwN\u001c(b[\u0016D\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\fe\u0016<\u0017n\u001c8OC6,\u0007\u0005\u0003\u0005?\u0001\t\u0015\r\u0011\"\u0001@\u0003=Ig.\u001b;jC2\u0004vn]5uS>tW#\u0001!\u0011\u0005\u0005\u0013U\"\u0001\u0002\n\u0005\r\u0013!AF&j]\u0016\u001c\u0018n]%oSRL\u0017\r\u001c)pg&$\u0018n\u001c8\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0001\u000b\u0001#\u001b8ji&\fG\u000eU8tSRLwN\u001c\u0011\t\u0011\u001d\u0003!Q1A\u0005\u0002-\n\u0011c\u00195fG.\u0004x.\u001b8u\u0003B\u0004h*Y7f\u0011!I\u0005A!A!\u0002\u0013a\u0013AE2iK\u000e\\\u0007o\\5oi\u0006\u0003\bOT1nK\u0002B\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001T\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG.F\u0001N!\t1c*\u0003\u0002P\t\tAA)\u001e:bi&|g\u000e\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003N\u0003M\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197!\u0011!\u0019\u0006A!b\u0001\n\u0003!\u0016!D0ti>\u0014\u0018mZ3MKZ,G.F\u0001V!\t1\u0016,D\u0001X\u0015\tAf!A\u0004ti>\u0014\u0018mZ3\n\u0005i;&\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B+\u0002\u001d}\u001bHo\u001c:bO\u0016dUM^3mA!Aa\f\u0001BC\u0002\u0013\u0005q,\u0001\bnKN\u001c\u0018mZ3IC:$G.\u001a:\u0016\u0003\u0001\u0004BaG1d)%\u0011!\r\b\u0002\n\rVt7\r^5p]F\u0002\"\u0001\u001a8\u000e\u0003\u0015T!AZ4\u0002\u000b5|G-\u001a7\u000b\u0005\rA'BA5k\u0003!\u0019XM\u001d<jG\u0016\u001c(BA6m\u0003%\tW.\u0019>p]\u0006<8OC\u0001n\u0003\r\u0019w.\\\u0005\u0003_\u0016\u0014aAU3d_J$\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u00021\u0002\u001f5,7o]1hK\"\u000bg\u000e\u001a7fe\u0002B\u0001b\u001d\u0001\u0003\u0006\u0004%\t\u0001^\u0001\rW&tWm]5t\u0007J,Gm]\u000b\u0002kB\u0011\u0011I^\u0005\u0003o\n\u00111c\u00159be.\fukU\"sK\u0012,g\u000e^5bYND\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I!^\u0001\u000eW&tWm]5t\u0007J,Gm\u001d\u0011\t\u0011m\u0004!Q1A\u0005\u0002q\fQ\u0002Z=oC6|GIQ\"sK\u0012\u001cX#A?\u0011\u0007mqX/\u0003\u0002\u00009\t1q\n\u001d;j_:D\u0011\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011B?\u0002\u001d\u0011Lh.Y7p\t\n\u001b%/\u001a3tA!I\u0011q\u0001\u0001\u0003\u0006\u0004%\t\u0001`\u0001\u0010G2|W\u000fZ,bi\u000eD7I]3eg\"I\u00111\u0002\u0001\u0003\u0002\u0003\u0006I!`\u0001\u0011G2|W\u000fZ,bi\u000eD7I]3eg\u0002B!\"a\u0004\u0001\u0005\u0007\u0005\u000b1BA\t\u0003))g/\u001b3f]\u000e,G%\r\t\u0006\u0003'\tI\u0002F\u0007\u0003\u0003+Q1!a\u0006\u001d\u0003\u001d\u0011XM\u001a7fGRLA!a\u0007\u0002\u0016\tA1\t\\1tgR\u000bw\rC\u0004\u0002 \u0001!\t!!\t\u0002\rqJg.\u001b;?)i\t\u0019#!\u000b\u0002,\u00055\u0012qFA\u0019\u0003g\t)$a\u000e\u0002:\u0005m\u0012QHA )\u0011\t)#a\n\u0011\u0007\u0005\u0003A\u0003\u0003\u0005\u0002\u0010\u0005u\u00019AA\t\u0011\u0019!\u0013Q\u0004a\u0001K!1!&!\bA\u00021BaANA\u000f\u0001\u0004a\u0003B\u0002\u001e\u0002\u001e\u0001\u0007A\u0006\u0003\u0004?\u0003;\u0001\r\u0001\u0011\u0005\u0007\u000f\u0006u\u0001\u0019\u0001\u0017\t\r-\u000bi\u00021\u0001N\u0011\u0019\u0019\u0016Q\u0004a\u0001+\"1a,!\bA\u0002\u0001Daa]A\u000f\u0001\u0004)\bBB>\u0002\u001e\u0001\u0007Q\u0010C\u0004\u0002\b\u0005u\u0001\u0019A?\t\u0011\u0005\r\u0003\u0001\"\u0011\u0005\u0003\u000b\nab\u0019:fCR,'\t\\8dWJ#E\t\u0006\u0004\u0002H\u0005M\u0013Q\f\t\u0006\u0003\u0013\ny\u0005F\u0007\u0003\u0003\u0017R1!!\u0014\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003#\nYEA\u0002S\t\u0012C\u0001\"!\u0016\u0002B\u0001\u0007\u0011qK\u0001\u0005i&lW\rE\u0002'\u00033J1!a\u0017\u0005\u0005\u0011!\u0016.\\3\t\u0011\u0005}\u0013\u0011\ta\u0001\u0003C\n!B\u00197pG.LeNZ8t!\u0019\t\u0019'a\u001d\u0002z9!\u0011QMA8\u001d\u0011\t9'!\u001c\u000e\u0005\u0005%$bAA61\u00051AH]8pizJ\u0011!H\u0005\u0004\u0003cb\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003k\n9HA\u0002TKFT1!!\u001d\u001d!\u0011\tY(!!\u000e\u0005\u0005u$bAA@\t\u0005I1o\u00195fIVdWM]\u0005\u0005\u0003\u0007\u000biHA\tSK\u000e,\u0017N^3e\u00052|7m[%oM>Dq!a\"\u0001\t\u0003\nI)A\u0006hKR\u0014VmY3jm\u0016\u0014HCAAF!\u0015\ti)a%\u0015\u001b\t\tyIC\u0002\u0002\u0012\u0012\t\u0001B]3dK&4XM]\u0005\u0005\u0003+\u000byI\u0001\u0005SK\u000e,\u0017N^3s\u000f\u001d\tIJ\u0001E\u0001\u00037\u000b1cS5oKNL7/\u00138qkR$5\u000b\u001e:fC6\u00042!QAO\r\u0019\t!\u0001#\u0001\u0002 N1\u0011QTAQ\u0003O\u00032aGAR\u0013\r\t)\u000b\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007m\tI+C\u0002\u0002,r\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"a\b\u0002\u001e\u0012\u0005\u0011q\u0016\u000b\u0003\u000373q!a-\u0002\u001e\u0002\t)LA\u0004Ck&dG-\u001a:\u0014\t\u0005E\u0016\u0011\u0015\u0005\t\u0003?\t\t\f\"\u0001\u0002:R\u0011\u00111\u0018\t\u0005\u0003{\u000b\t,\u0004\u0002\u0002\u001e\"Q\u0011\u0011YAY\u0001\u0004%I!a1\u0002!M$(/Z1nS:<7i\u001c8uKb$XCAAc!\rYb0\n\u0005\u000b\u0003\u0013\f\t\f1A\u0005\n\u0005-\u0017\u0001F:ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0006M\u0007cA\u000e\u0002P&\u0019\u0011\u0011\u001b\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003+\f9-!AA\u0002\u0005\u0015\u0017a\u0001=%c!I\u0011\u0011\\AYA\u0003&\u0011QY\u0001\u0012gR\u0014X-Y7j]\u001e\u001cuN\u001c;fqR\u0004\u0003\"\u0003\u0016\u00022\u0002\u0007I\u0011BAo+\t\ty\u000eE\u0002\u001c}2B!\"a9\u00022\u0002\u0007I\u0011BAs\u00039\u0019HO]3b[:\u000bW.Z0%KF$B!!4\u0002h\"Q\u0011Q[Aq\u0003\u0003\u0005\r!a8\t\u0011Q\n\t\f)Q\u0005\u0003?D\u0011bRAY\u0001\u0004%I!!8\t\u0015\u0005=\u0018\u0011\u0017a\u0001\n\u0013\t\t0A\u000bdQ\u0016\u001c7\u000e]8j]R\f\u0005\u000f\u001d(b[\u0016|F%Z9\u0015\t\u00055\u00171\u001f\u0005\u000b\u0003+\fi/!AA\u0002\u0005}\u0007\u0002C%\u00022\u0002\u0006K!a8\t\u0013Y\n\t\f1A\u0005\n\u0005u\u0007BCA~\u0003c\u0003\r\u0011\"\u0003\u0002~\u0006yQM\u001c3q_&tG/\u0016:m?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0006}\bBCAk\u0003s\f\t\u00111\u0001\u0002`\"A\u0001(!-!B\u0013\ty\u000eC\u0005;\u0003c\u0003\r\u0011\"\u0003\u0002^\"Q!qAAY\u0001\u0004%IA!\u0003\u0002\u001dI,w-[8o\u001d\u0006lWm\u0018\u0013fcR!\u0011Q\u001aB\u0006\u0011)\t)N!\u0002\u0002\u0002\u0003\u0007\u0011q\u001c\u0005\ty\u0005E\u0006\u0015)\u0003\u0002`\"Ia(!-A\u0002\u0013%!\u0011C\u000b\u0003\u0005'\u00012a\u0007@A\u0011)\u00119\"!-A\u0002\u0013%!\u0011D\u0001\u0014S:LG/[1m!>\u001c\u0018\u000e^5p]~#S-\u001d\u000b\u0005\u0003\u001b\u0014Y\u0002\u0003\u0006\u0002V\nU\u0011\u0011!a\u0001\u0005'A\u0001\"RAYA\u0003&!1\u0003\u0005\n\u0017\u0006E\u0006\u0019!C\u0005\u0005C)\"Aa\t\u0011\u0007mqX\n\u0003\u0006\u0003(\u0005E\u0006\u0019!C\u0005\u0005S\tac\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY~#S-\u001d\u000b\u0005\u0003\u001b\u0014Y\u0003\u0003\u0006\u0002V\n\u0015\u0012\u0011!a\u0001\u0005GA\u0001\"UAYA\u0003&!1\u0005\u0005\u000b\u0005c\t\t\f1A\u0005\n\tM\u0012\u0001D:u_J\fw-\u001a'fm\u0016dWC\u0001B\u001b!\rYb0\u0016\u0005\u000b\u0005s\t\t\f1A\u0005\n\tm\u0012\u0001E:u_J\fw-\u001a'fm\u0016dw\fJ3r)\u0011\tiM!\u0010\t\u0015\u0005U'qGA\u0001\u0002\u0004\u0011)\u0004C\u0005\u0003B\u0005E\u0006\u0015)\u0003\u00036\u0005i1\u000f^8sC\u001e,G*\u001a<fY\u0002B\u0011B!\u0012\u00022\u0002\u0007I\u0011\u0002?\u0002)-Lg.Z:jg\u000e\u0013X\rZ:Qe>4\u0018\u000eZ3s\u0011)\u0011I%!-A\u0002\u0013%!1J\u0001\u0019W&tWm]5t\u0007J,Gm\u001d)s_ZLG-\u001a:`I\u0015\fH\u0003BAg\u0005\u001bB\u0011\"!6\u0003H\u0005\u0005\t\u0019A?\t\u0011\tE\u0013\u0011\u0017Q!\nu\fQc[5oKNL7o\u0011:fIN\u0004&o\u001c<jI\u0016\u0014\b\u0005C\u0005\u0003V\u0005E\u0006\u0019!C\u0005y\u0006)B-\u001f8b[>$%i\u0011:fIN\u0004&o\u001c<jI\u0016\u0014\bB\u0003B-\u0003c\u0003\r\u0011\"\u0003\u0003\\\u0005IB-\u001f8b[>$%i\u0011:fIN\u0004&o\u001c<jI\u0016\u0014x\fJ3r)\u0011\tiM!\u0018\t\u0013\u0005U'qKA\u0001\u0002\u0004i\b\u0002\u0003B1\u0003c\u0003\u000b\u0015B?\u0002-\u0011Lh.Y7p\t\n\u001b%/\u001a3t!J|g/\u001b3fe\u0002B\u0011B!\u001a\u00022\u0002\u0007I\u0011\u0002?\u0002/\rdw.\u001e3XCR\u001c\u0007n\u0011:fIN\u0004&o\u001c<jI\u0016\u0014\bB\u0003B5\u0003c\u0003\r\u0011\"\u0003\u0003l\u0005Y2\r\\8vI^\u000bGo\u00195De\u0016$7\u000f\u0015:pm&$WM]0%KF$B!!4\u0003n!I\u0011Q\u001bB4\u0003\u0003\u0005\r! \u0005\t\u0005c\n\t\f)Q\u0005{\u0006A2\r\\8vI^\u000bGo\u00195De\u0016$7\u000f\u0015:pm&$WM\u001d\u0011\t\u0011\u0005\u0005\u0017\u0011\u0017C\u0001\u0005k\"B!a/\u0003x!9!\u0011\u0010B:\u0001\u0004)\u0013aA:tG\"A\u0011\u0011YAY\t\u0003\u0011i\b\u0006\u0003\u0002<\n}\u0004\u0002\u0003BA\u0005w\u0002\rAa!\u0002\t)\u001c8o\u0019\t\u0005\u0005\u000b\u0013y)\u0004\u0002\u0003\b*!!\u0011\u0012BF\u0003\u0011Q\u0017M^1\u000b\u0007\t5E!A\u0002ba&LAA!%\u0003\b\n!\"*\u0019<b'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqRDqAKAY\t\u0003\u0011)\n\u0006\u0003\u0002<\n]\u0005B\u0002\u0016\u0003\u0014\u0002\u0007A\u0006C\u0004H\u0003c#\tAa'\u0015\t\u0005m&Q\u0014\u0005\b\u0005?\u0013I\n1\u0001-\u0003\u001d\t\u0007\u000f\u001d(b[\u0016DqANAY\t\u0003\u0011\u0019\u000b\u0006\u0003\u0002<\n\u0015\u0006b\u0002BT\u0005C\u0003\r\u0001L\u0001\u0004kJd\u0007b\u0002\u001e\u00022\u0012\u0005!1\u0016\u000b\u0005\u0003w\u0013i\u000b\u0003\u0004;\u0005S\u0003\r\u0001\f\u0005\b}\u0005EF\u0011\u0001BY)\u0011\tYLa-\t\ry\u0012y\u000b1\u0001A\u0011!\u00119,!-\u0005\u0002\te\u0016aF5oSRL\u0017\r\u001c)pg&$\u0018n\u001c8J]N#(/Z1n)\u0011\tYLa/\t\u000fy\u0012)\f1\u0001\u0003>B!!q\u0018Bg\u001b\t\u0011\tM\u0003\u0003\u0003D\n\u0015\u0017AB<pe.,'O\u0003\u0003\u0003H\n%\u0017a\u00017jE*\u0019!1Z4\u0002\u001b\rd\u0017.\u001a8uY&\u0014'/\u0019:z\u0013\u0011\u0011yM!1\u0003/%s\u0017\u000e^5bYB{7/\u001b;j_:Len\u0015;sK\u0006l\u0007\u0006\u0003B[\u0005'\u0014IN!8\u0011\u0007m\u0011).C\u0002\u0003Xr\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\u0011Y.\u0001\u001fvg\u0016\u0004\u0013N\\5uS\u0006d\u0007k\\:ji&|g\u000eK5oSRL\u0017\r\u001c)pg&$\u0018n\u001c8;A-Kg.Z:jg&s\u0017\u000e^5bYB{7/\u001b;j_:L\u0013E\u0001Bp\u0003\u0015\u0011df\r\u00181\u0011\u001dY\u0015\u0011\u0017C\u0001\u0005G$B!a/\u0003f\"9!q\u001dBq\u0001\u0004i\u0015\u0001C5oi\u0016\u0014h/\u00197\t\u0011\tE\u0012\u0011\u0017C\u0001\u0005W$B!a/\u0003n\"9!\u0011\u0007Bu\u0001\u0004)\u0006\u0002\u0003By\u0003c#\tAa=\u0002%-Lg.Z:jg\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0005\u0003w\u0013)\u0010C\u0004\u0003x\n=\b\u0019A;\u0002\u0017\r\u0014X\rZ3oi&\fGn\u001d\u0005\t\u0005w\f\t\f\"\u0001\u0003~\u0006\u0019B-\u001f8b[>$%i\u0011:fI\u0016tG/[1mgR!\u00111\u0018B\u0000\u0011\u001d\u00119P!?A\u0002UD\u0001ba\u0001\u00022\u0012\u00051QA\u0001\u0016G2|W\u000fZ,bi\u000eD7I]3eK:$\u0018.\u00197t)\u0011\tYla\u0002\t\u000f\t]8\u0011\u0001a\u0001k\"A11BAY\t\u0003\u0019i!A\fck&dGmV5uQ6+7o]1hK\"\u000bg\u000e\u001a7feV!1qBB\f)\u0011\u0019\tba\b\u0015\t\rM1\u0011\u0004\t\u0005\u0003\u0002\u0019)\u0002E\u0002\u0016\u0007/!aaFB\u0005\u0005\u0004I\u0002BCB\u000e\u0007\u0013\t\t\u0011q\u0001\u0004\u001e\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\u0005M\u0011\u0011DB\u000b\u0011!\u0019\tc!\u0003A\u0002\r\r\u0012a\u00025b]\u0012dWM\u001d\t\u00067\u0005\u001c7Q\u0003\u0005\t\u0007O\t\t\f\"\u0001\u0004*\u0005)!-^5mIR\u001111\u0006\t\u0005\u0003\u0002\u0019i\u0003E\u0003\u001c\u0007_\u0019\u0019$C\u0002\u00042q\u0011Q!\u0011:sCf\u00042aGB\u001b\u0013\r\u00199\u0004\b\u0002\u0005\u0005f$X\r\u0003\u0005\u0004<\u0005EF\u0011BB\u001f\u0003A9W\r\u001e*fcVL'/\u001a3QCJ\fW.\u0006\u0003\u0004@\r\rCCBB!\u0007\u000b\u001aY\u0005E\u0002\u0016\u0007\u0007\"aaFB\u001d\u0005\u0004I\u0002\u0002CB$\u0007s\u0001\ra!\u0013\u0002\u000bA\f'/Y7\u0011\tmq8\u0011\t\u0005\b\u0007\u001b\u001aI\u00041\u0001-\u0003%\u0001\u0018M]1n\u001d\u0006lW\r\u000b\u0003\u00022\u000eE\u0003\u0003BB*\u0007?rAa!\u0016\u0004\\5\u00111q\u000b\u0006\u0004\u000732\u0011AC1o]>$\u0018\r^5p]&!1QLB,\u0003IIe\u000e^3sM\u0006\u001cWm\u0015;bE&d\u0017\u000e^=\n\t\r\u000541\r\u0002\t\u000bZ|GN^5oO*!1QLB,\u0011!\u00199'!(\u0005\u0002\r%\u0014a\u00022vS2$WM]\u000b\u0003\u0003wC\u0011b!\u001c\u0002\u001e\u0012\u0005!aa\u001c\u0002+\u0011,g-Y;mi6+7o]1hK\"\u000bg\u000e\u001a7feR!1QFB9\u0011\u001d\u0019\u0019ha\u001bA\u0002\r\faA]3d_J$\u0007BCB<\u0003;\u0013\r\u0011\"\u0001\u0003W\u0005aB)\u0012$B+2#vlS%O\u000bNK5kX#O\tB{\u0015J\u0014+`+Jc\u0005\u0002CB>\u0003;\u0003\u000b\u0011\u0002\u0017\u0002;\u0011+e)Q+M)~[\u0015JT#T\u0013N{VI\u0014#Q\u001f&sEkX+S\u0019\u0002B!ba \u0002\u001e\n\u0007I\u0011\u0001\u0002,\u0003m!UIR!V\u0019R{6*\u0013(F'&\u001bvLU#H\u0013>suLT!N\u000b\"A11QAOA\u0003%A&\u0001\u000fE\u000b\u001a\u000bU\u000b\u0014+`\u0017&sUiU%T?J+u)S(O?:\u000bU*\u0012\u0011\t\u0015\r\u001d\u0015Q\u0014b\u0001\n\u0003\u0011q(\u0001\rE\u000b\u001a\u000bU\u000b\u0014+`\u0013:KE+S!M?B{5+\u0013+J\u001f:C\u0001ba#\u0002\u001e\u0002\u0006I\u0001Q\u0001\u001a\t\u00163\u0015)\u0016'U?&s\u0015\nV%B\u0019~\u0003vjU%U\u0013>s\u0005\u0005\u0003\u0006\u0004\u0010\u0006u%\u0019!C\u0001\u0005Q\u000bQ\u0003R#G\u0003VcEkX*U\u001fJ\u000bu)R0M\u000bZ+E\n\u0003\u0005\u0004\u0014\u0006u\u0005\u0015!\u0003V\u0003Y!UIR!V\u0019R{6\u000bV(S\u0003\u001e+u\fT#W\u000b2\u0003\u0003BCBL\u0003;\u000b\t\u0011\"\u0003\u0004\u001a\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\n\u0005\u0003\u0004\u001e\u000e\u0015VBABP\u0015\u0011\u0019\tka)\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0013KAaa*\u0004 \n1qJ\u00196fGRDC!!(\u0004R!\"\u0011qSB)\u0001")
public class KinesisInputDStream<T>
extends ReceiverInputDStream<T> {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final KinesisInitialPosition initialPosition;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final StorageLevel _storageLevel;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private final ClassTag<T> evidence$1;

    public static Builder builder() {
        return KinesisInputDStream$.MODULE$.builder();
    }

    public String streamName() {
        return this.streamName;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    public KinesisInitialPosition initialPosition() {
        return this.initialPosition;
    }

    public String checkpointAppName() {
        return this.checkpointAppName;
    }

    public Duration checkpointInterval() {
        return this.checkpointInterval;
    }

    public StorageLevel _storageLevel() {
        return this._storageLevel;
    }

    public Function1<Record, T> messageHandler() {
        return this.messageHandler;
    }

    public SparkAWSCredentials kinesisCreds() {
        return this.kinesisCreds;
    }

    public Option<SparkAWSCredentials> dynamoDBCreds() {
        return this.dynamoDBCreds;
    }

    public Option<SparkAWSCredentials> cloudWatchCreds() {
        return this.cloudWatchCreds;
    }

    public RDD<T> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        Object object;
        boolean allBlocksHaveRanges = ((IterableLike)blockInfos.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(ReceivedBlockInfo x$1) {
                return x$1.metadataOption();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Object> x$2) {
                return x$2.nonEmpty();
            }
        });
        if (allBlocksHaveRanges) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BlockId apply(ReceivedBlockInfo x$3) {
                    return x$3.blockId();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            SequenceNumberRanges[] seqNumRanges = (SequenceNumberRanges[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceNumberRanges apply(ReceivedBlockInfo x$4) {
                    return (SequenceNumberRanges)x$4.metadataOption().get();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ReceivedBlockInfo x$5) {
                    return x$5.isBlockIdValid();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
            this.logDebug((Function0)new Serializable(this, time, seqNumRanges){
                public static final long serialVersionUID = 0L;
                private final Time time$1;
                private final SequenceNumberRanges[] seqNumRanges$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating KinesisBackedBlockRDD for ", " with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.time$1, BoxesRunTime.boxToInteger((int)this.seqNumRanges$1.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"seq number ranges: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.seqNumRanges$1).mkString(", ")}))).toString();
                }
                {
                    void var3_3;
                    this.time$1 = time$1;
                    this.seqNumRanges$1 = var3_3;
                }
            });
            object = new KinesisBackedBlockRDD<T>(this.context().sc(), this.regionName(), this.endpointUrl(), blockIds, seqNumRanges, isBlockIdValid, this.messageHandler(), this.kinesisCreds(), KinesisReadConfigurations$.MODULE$.apply(this.ssc()), this.evidence$1);
        } else {
            this.logWarning((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Kinesis sequence number information was not present with some block metadata, it may not be possible to recover from failures";
                }
            });
            object = super.createBlockRDD(time, blockInfos);
        }
        return object;
    }

    public Receiver<T> getReceiver() {
        return new KinesisReceiver<T>(this.streamName(), this.endpointUrl(), this.regionName(), this.initialPosition(), this.checkpointAppName(), this.checkpointInterval(), this._storageLevel(), this.messageHandler(), this.kinesisCreds(), this.dynamoDBCreds(), this.cloudWatchCreds());
    }

    public KinesisInputDStream(StreamingContext _ssc, String streamName2, String endpointUrl, String regionName, KinesisInitialPosition initialPosition, String checkpointAppName, Duration checkpointInterval, StorageLevel _storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds, ClassTag<T> evidence$1) {
        this.streamName = streamName2;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPosition = initialPosition;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this._storageLevel = _storageLevel;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        this.evidence$1 = evidence$1;
        super(_ssc, evidence$1);
    }

    @InterfaceStability.Evolving
    public static class Builder {
        private Option<StreamingContext> streamingContext = None$.MODULE$;
        private Option<String> streamName = None$.MODULE$;
        private Option<String> checkpointAppName = None$.MODULE$;
        private Option<String> endpointUrl = None$.MODULE$;
        private Option<String> regionName = None$.MODULE$;
        private Option<KinesisInitialPosition> initialPosition = None$.MODULE$;
        private Option<Duration> checkpointInterval = None$.MODULE$;
        private Option<StorageLevel> storageLevel = None$.MODULE$;
        private Option<SparkAWSCredentials> kinesisCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> dynamoDBCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> cloudWatchCredsProvider = None$.MODULE$;

        private Option<StreamingContext> streamingContext() {
            return this.streamingContext;
        }

        private void streamingContext_$eq(Option<StreamingContext> x$1) {
            this.streamingContext = x$1;
        }

        private Option<String> streamName() {
            return this.streamName;
        }

        private void streamName_$eq(Option<String> x$1) {
            this.streamName = x$1;
        }

        private Option<String> checkpointAppName() {
            return this.checkpointAppName;
        }

        private void checkpointAppName_$eq(Option<String> x$1) {
            this.checkpointAppName = x$1;
        }

        private Option<String> endpointUrl() {
            return this.endpointUrl;
        }

        private void endpointUrl_$eq(Option<String> x$1) {
            this.endpointUrl = x$1;
        }

        private Option<String> regionName() {
            return this.regionName;
        }

        private void regionName_$eq(Option<String> x$1) {
            this.regionName = x$1;
        }

        private Option<KinesisInitialPosition> initialPosition() {
            return this.initialPosition;
        }

        private void initialPosition_$eq(Option<KinesisInitialPosition> x$1) {
            this.initialPosition = x$1;
        }

        private Option<Duration> checkpointInterval() {
            return this.checkpointInterval;
        }

        private void checkpointInterval_$eq(Option<Duration> x$1) {
            this.checkpointInterval = x$1;
        }

        private Option<StorageLevel> storageLevel() {
            return this.storageLevel;
        }

        private void storageLevel_$eq(Option<StorageLevel> x$1) {
            this.storageLevel = x$1;
        }

        private Option<SparkAWSCredentials> kinesisCredsProvider() {
            return this.kinesisCredsProvider;
        }

        private void kinesisCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.kinesisCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> dynamoDBCredsProvider() {
            return this.dynamoDBCredsProvider;
        }

        private void dynamoDBCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.dynamoDBCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> cloudWatchCredsProvider() {
            return this.cloudWatchCredsProvider;
        }

        private void cloudWatchCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.cloudWatchCredsProvider = x$1;
        }

        public Builder streamingContext(StreamingContext ssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)ssc));
            return this;
        }

        public Builder streamingContext(JavaStreamingContext jssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)jssc.ssc()));
            return this;
        }

        public Builder streamName(String streamName2) {
            this.streamName_$eq((Option<String>)Option$.MODULE$.apply((Object)streamName2));
            return this;
        }

        public Builder checkpointAppName(String appName) {
            this.checkpointAppName_$eq((Option<String>)Option$.MODULE$.apply((Object)appName));
            return this;
        }

        public Builder endpointUrl(String url) {
            this.endpointUrl_$eq((Option<String>)Option$.MODULE$.apply((Object)url));
            return this;
        }

        public Builder regionName(String regionName) {
            this.regionName_$eq((Option<String>)Option$.MODULE$.apply((Object)regionName));
            return this;
        }

        public Builder initialPosition(KinesisInitialPosition initialPosition) {
            this.initialPosition_$eq((Option<KinesisInitialPosition>)Option$.MODULE$.apply((Object)initialPosition));
            return this;
        }

        public Builder initialPositionInStream(InitialPositionInStream initialPosition) {
            this.initialPosition_$eq((Option<KinesisInitialPosition>)Option$.MODULE$.apply((Object)KinesisInitialPositions.fromKinesisInitialPosition(initialPosition)));
            return this;
        }

        public Builder checkpointInterval(Duration interval) {
            this.checkpointInterval_$eq((Option<Duration>)Option$.MODULE$.apply((Object)interval));
            return this;
        }

        public Builder storageLevel(StorageLevel storageLevel) {
            this.storageLevel_$eq((Option<StorageLevel>)Option$.MODULE$.apply((Object)storageLevel));
            return this;
        }

        public Builder kinesisCredentials(SparkAWSCredentials credentials) {
            this.kinesisCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder dynamoDBCredentials(SparkAWSCredentials credentials) {
            this.dynamoDBCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder cloudWatchCredentials(SparkAWSCredentials credentials) {
            this.cloudWatchCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public <T> KinesisInputDStream<T> buildWithMessageHandler(Function1<Record, T> handler, ClassTag<T> evidence$2) {
            StreamingContext ssc = this.getRequiredParam(this.streamingContext(), "streamingContext");
            return new KinesisInputDStream<T>(ssc, this.getRequiredParam(this.streamName(), "streamName"), (String)this.endpointUrl().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_ENDPOINT_URL();
                }
            }), (String)this.regionName().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_REGION_NAME();
                }
            }), (KinesisInitialPosition)this.initialPosition().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final KinesisInitialPosition apply() {
                    return KinesisInputDStream$.MODULE$.DEFAULT_INITIAL_POSITION();
                }
            }), this.getRequiredParam(this.checkpointAppName(), "checkpointAppName"), (Duration)this.checkpointInterval().getOrElse((Function0)new Serializable(this, ssc){
                public static final long serialVersionUID = 0L;
                private final StreamingContext ssc$1;

                public final Duration apply() {
                    return this.ssc$1.graph().batchDuration();
                }
                {
                    this.ssc$1 = ssc$1;
                }
            }), (StorageLevel)this.storageLevel().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final StorageLevel apply() {
                    return KinesisInputDStream$.MODULE$.DEFAULT_STORAGE_LEVEL();
                }
            }), (Function1)ssc.sc().clean(handler, ssc.sc().clean$default$2()), (SparkAWSCredentials)this.kinesisCredsProvider().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final DefaultCredentials$ apply() {
                    return DefaultCredentials$.MODULE$;
                }
            }), this.dynamoDBCredsProvider(), this.cloudWatchCredsProvider(), evidence$2);
        }

        public KinesisInputDStream<byte[]> build() {
            return this.buildWithMessageHandler((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(Record record) {
                    return KinesisInputDStream$.MODULE$.defaultMessageHandler(record);
                }
            }, (ClassTag)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        }

        private <T> T getRequiredParam(Option<T> param, String paramName) {
            return (T)param.getOrElse((Function0)new Serializable(this, paramName){
                public static final long serialVersionUID = 0L;
                private final String paramName$1;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No value provided for required parameter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.paramName$1})));
                }
                {
                    this.paramName$1 = paramName$1;
                }
            });
        }
    }
}

