/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.KinesisExampleUtils;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class JavaKinesisWordCountASL {
    private static final Pattern WORD_SEPARATOR = Pattern.compile(" ");

    public static void main(String[] args) throws Exception {
        Duration batchInterval;
        int numShards;
        if (args.length != 3) {
            System.err.println("Usage: JavaKinesisWordCountASL <stream-name> <endpoint-url>\n\n    <app-name> is the name of the app, used to track the read data in DynamoDB\n    <stream-name> is the name of the Kinesis stream\n    <endpoint-url> is the endpoint of the Kinesis service\n                   (e.g. https://kinesis.us-east-1.amazonaws.com)\nGenerate data for the Kinesis stream using the example KinesisWordProducerASL.\nSee http://spark.apache.org/docs/latest/streaming-kinesis-integration.html for more\ndetails.\n");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        String kinesisAppName = args[0];
        String streamName = args[1];
        String endpointUrl = args[2];
        AmazonKinesisClient kinesisClient = new AmazonKinesisClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        kinesisClient.setEndpoint(endpointUrl);
        int numStreams = numShards = kinesisClient.describeStream(streamName).getStreamDescription().getShards().size();
        Duration kinesisCheckpointInterval = batchInterval = new Duration(2000L);
        String regionName = KinesisExampleUtils.getRegionNameByEndpoint(endpointUrl);
        SparkConf sparkConfig = new SparkConf().setAppName("JavaKinesisWordCountASL");
        JavaStreamingContext jssc = new JavaStreamingContext(sparkConfig, batchInterval);
        ArrayList<JavaDStream> streamsList = new ArrayList<JavaDStream>(numStreams);
        for (int i = 0; i < numStreams; ++i) {
            streamsList.add(JavaDStream.fromDStream(KinesisInputDStream.builder().streamingContext(jssc).checkpointAppName(kinesisAppName).streamName(streamName).endpointUrl(endpointUrl).regionName(regionName).initialPosition(new KinesisInitialPositions.Latest()).checkpointInterval(kinesisCheckpointInterval).storageLevel(StorageLevel.MEMORY_AND_DISK_2()).build(), (ClassTag)ClassTag$.MODULE$.apply(byte[].class)));
        }
        JavaDStream unionStreams = streamsList.size() > 1 ? jssc.union(streamsList.toArray(new JavaDStream[0])) : (JavaDStream)streamsList.get(0);
        JavaDStream words = unionStreams.flatMap((FlatMapFunction)new FlatMapFunction<byte[], String>(){

            public Iterator<String> call(byte[] line) {
                String s = new String(line, StandardCharsets.UTF_8);
                return Arrays.asList(WORD_SEPARATOR.split(s)).iterator();
            }
        });
        JavaPairDStream wordCounts = words.mapToPair((PairFunction)new PairFunction<String, String, Integer>(){

            public Tuple2<String, Integer> call(String s) {
                return new Tuple2((Object)s, (Object)1);
            }
        }).reduceByKey((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        });
        wordCounts.print();
        jssc.start();
        jssc.awaitTermination();
    }
}

