/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGenerator$Block$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.streaming.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tMd!B\u0001\u0003\u0001\u0011a!A\u0004\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0006\u0003\u0007\u0011\t\u0001B]3dK&4XM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011A#F\u0007\u0002\r%\u0011aC\u0002\u0002\b\u0019><w-\u001b8h\u0011!A\u0002A!A!\u0002\u0013Q\u0012\u0001\u00037jgR,g.\u001a:\u0004\u0001A\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u0017\u00052|7m[$f]\u0016\u0014\u0018\r^8s\u0019&\u001cH/\u001a8fe\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0006sK\u000e,\u0017N^3s\u0013\u0012\u0004\"AD\u0011\n\u0005\tz!aA%oi\"AA\u0005\u0001B\u0001B\u0003%Q%\u0001\u0003d_:4\u0007C\u0001\u000b'\u0013\t9cAA\u0005Ta\u0006\u00148nQ8oM\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"Ba\u000b\u0017.]A\u00111\u0004\u0001\u0005\u00061!\u0002\rA\u0007\u0005\u0006?!\u0002\r\u0001\t\u0005\u0006I!\u0002\r!\n\u0004\u0005a\u0001!\u0015GA\u0003CY>\u001c7n\u0005\u00030\u001bI*\u0004C\u0001\b4\u0013\t!tBA\u0004Qe>$Wo\u0019;\u0011\u000591\u0014BA\u001c\u0010\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!ItF!f\u0001\n\u0003Q\u0014AA5e+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$B\u0001 \u0007\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001Q\u001f\u0003\u001bM#(/Z1n\u00052|7m[%e\u0011!\u0011uF!E!\u0002\u0013Y\u0014aA5eA!AAi\fBK\u0002\u0013\u0005Q)\u0001\u0004ck\u001a4WM]\u000b\u0002\rB\u0019q\t\u0014(\u000e\u0003!S!!\u0013&\u0002\u000f5,H/\u00192mK*\u00111jD\u0001\u000bG>dG.Z2uS>t\u0017BA'I\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u00059y\u0015B\u0001)\u0010\u0005\r\te.\u001f\u0005\t%>\u0012\t\u0012)A\u0005\r\u00069!-\u001e4gKJ\u0004\u0003\"B\u00150\t\u0003!FcA+X1B\u0011akL\u0007\u0002\u0001!)\u0011h\u0015a\u0001w!)Ai\u0015a\u0001\r\"9!lLA\u0001\n\u0003Y\u0016\u0001B2paf$2!\u0016/^\u0011\u001dI\u0014\f%AA\u0002mBq\u0001R-\u0011\u0002\u0003\u0007a\tC\u0004`_E\u0005I\u0011\u00011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0011M\u000b\u0002<E.\n1\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Q>\t!\"\u00198o_R\fG/[8o\u0013\tQWMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq\u0001\\\u0018\u0012\u0002\u0013\u0005Q.\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u00039T#A\u00122\t\u000fA|\u0013\u0011!C!c\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fA\u0001\\1oO*\tq/\u0001\u0003kCZ\f\u0017BA=u\u0005\u0019\u0019FO]5oO\"91pLA\u0001\n\u0003a\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001\u0011\t\u000fy|\u0013\u0011!C\u0001\u007f\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001(\u0002\u0002!A\u00111A?\u0002\u0002\u0003\u0007\u0001%A\u0002yIEB\u0011\"a\u00020\u0003\u0003%\t%!\u0003\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0003\u0011\u000b\u00055\u0011q\u0002(\u000e\u0003)K1!!\u0005K\u0005!IE/\u001a:bi>\u0014\b\"CA\u000b_\u0005\u0005I\u0011AA\f\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\r\u0003?\u00012ADA\u000e\u0013\r\tib\u0004\u0002\b\u0005>|G.Z1o\u0011%\t\u0019!a\u0005\u0002\u0002\u0003\u0007a\nC\u0005\u0002$=\n\t\u0011\"\u0011\u0002&\u0005A\u0001.Y:i\u0007>$W\rF\u0001!\u0011%\tIcLA\u0001\n\u0003\nY#\u0001\u0005u_N#(/\u001b8h)\u0005\u0011\b\"CA\u0018_\u0005\u0005I\u0011IA\u0019\u0003\u0019)\u0017/^1mgR!\u0011\u0011DA\u001a\u0011%\t\u0019!!\f\u0002\u0002\u0003\u0007ajB\u0005\u00028\u0001\t\t\u0011#\u0003\u0002:\u0005)!\t\\8dWB\u0019a+a\u000f\u0007\u0011A\u0002\u0011\u0011!E\u0005\u0003{\u0019R!a\u000f\u0002@U\u0002r!!\u0011\u0002Hm2U+\u0004\u0002\u0002D)\u0019\u0011QI\b\u0002\u000fI,h\u000e^5nK&!\u0011\u0011JA\"\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bS\u0005mB\u0011AA')\t\tI\u0004\u0003\u0006\u0002*\u0005m\u0012\u0011!C#\u0003WA!\"a\u0015\u0002<\u0005\u0005I\u0011QA+\u0003\u0015\t\u0007\u000f\u001d7z)\u0015)\u0016qKA-\u0011\u0019I\u0014\u0011\u000ba\u0001w!1A)!\u0015A\u0002\u0019C!\"!\u0018\u0002<\u0005\u0005I\u0011QA0\u0003\u001d)h.\u00199qYf$B!!\u0019\u0002nA)a\"a\u0019\u0002h%\u0019\u0011QM\b\u0003\r=\u0003H/[8o!\u0015q\u0011\u0011N\u001eG\u0013\r\tYg\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005=\u00141LA\u0001\u0002\u0004)\u0016a\u0001=%a!Q\u00111OA\u001e\u0003\u0003%I!!\u001e\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u00022a]A=\u0013\r\tY\b\u001e\u0002\u0007\u001f\nTWm\u0019;\t\u0013\u0005}\u0004A1A\u0005\n\u0005\u0005\u0015!B2m_\u000e\\WCAAB!\u0011\t))a#\u000e\u0005\u0005\u001d%bAAE\t\u0005!Q\u000f^5m\u0013\u0011\ti)a\"\u0003\u0017MK8\u000f^3n\u00072|7m\u001b\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u0002\u0004\u000611\r\\8dW\u0002B\u0011\"!&\u0001\u0005\u0004%I!a&\u0002\u001b\tdwnY6J]R,'O^1m+\t\tI\nE\u0002\u000f\u00037K1!!(\u0010\u0005\u0011auN\\4\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u00033\u000baB\u00197pG.Le\u000e^3sm\u0006d\u0007\u0005C\u0005\u0002&\u0002\u0011\r\u0011\"\u0003\u0002(\u0006\u0011\"\r\\8dW&sG/\u001a:wC2$\u0016.\\3s+\t\tI\u000b\u0005\u0003\u0002\u0006\u0006-\u0016\u0002BAW\u0003\u000f\u0013aBU3dkJ\u0014\u0018N\\4US6,'\u000f\u0003\u0005\u00022\u0002\u0001\u000b\u0011BAU\u0003M\u0011Gn\\2l\u0013:$XM\u001d<bYRKW.\u001a:!\u0011!\t)\f\u0001b\u0001\n\u0013a\u0018A\u00042m_\u000e\\\u0017+^3vKNK'0\u001a\u0005\b\u0003s\u0003\u0001\u0015!\u0003!\u0003=\u0011Gn\\2l#V,W/Z*ju\u0016\u0004\u0003\"CA_\u0001\t\u0007I\u0011BA`\u0003A\u0011Gn\\2lg\u001a{'\u000fU;tQ&tw-\u0006\u0002\u0002BB)\u00111YAf+6\u0011\u0011Q\u0019\u0006\u0005\u0003\u000f\fI-\u0001\u0006d_:\u001cWO\u001d:f]RT1!!#w\u0013\u0011\ti-!2\u0003%\u0005\u0013(/Y=CY>\u001c7.\u001b8h#V,W/\u001a\u0005\t\u0003#\u0004\u0001\u0015!\u0003\u0002B\u0006\t\"\r\\8dWN4uN\u001d)vg\"Lgn\u001a\u0011\t\u0013\u0005U\u0007A1A\u0005\n\u0005]\u0017A\u00052m_\u000e\\\u0007+^:iS:<G\u000b\u001b:fC\u0012,\"!!7\u0011\u0007M\fY.C\u0002\u0002^R\u0014a\u0001\u00165sK\u0006$\u0007\u0002CAq\u0001\u0001\u0006I!!7\u0002'\tdwnY6QkND\u0017N\\4UQJ,\u0017\r\u001a\u0011\t\u0011\u0005\u0015\b\u00011A\u0005\n\u0015\u000bQbY;se\u0016tGOQ;gM\u0016\u0014\b\"CAu\u0001\u0001\u0007I\u0011BAv\u0003E\u0019WO\u001d:f]R\u0014UO\u001a4fe~#S-\u001d\u000b\u0005\u0003[\f\u0019\u0010E\u0002\u000f\u0003_L1!!=\u0010\u0005\u0011)f.\u001b;\t\u0013\u0005\r\u0011q]A\u0001\u0002\u00041\u0005bBA|\u0001\u0001\u0006KAR\u0001\u000fGV\u0014(/\u001a8u\u0005V4g-\u001a:!Q\u0011\t)0a?\u0011\u00079\ti0C\u0002\u0002\u0000>\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0005\u0007\u0001\u0001\u0019!C\u0005\u0005\u000b\tqa\u001d;paB,G-\u0006\u0002\u0002\u001a!I!\u0011\u0002\u0001A\u0002\u0013%!1B\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0003\u0002n\n5\u0001BCA\u0002\u0005\u000f\t\t\u00111\u0001\u0002\u001a!A!\u0011\u0003\u0001!B\u0013\tI\"\u0001\u0005ti>\u0004\b/\u001a3!Q\u0011\u0011y!a?\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a\u0005)1\u000f^1siR\u0011\u0011Q\u001e\u0005\b\u0005;\u0001A\u0011\u0001B\r\u0003\u0011\u0019Ho\u001c9\t\u000f\t\u0005\u0002\u0001\"\u0001\u0003$\u0005AA\u0005\u001d7vg\u0012*\u0017\u000f\u0006\u0003\u0002n\n\u0015\u0002b\u0002B\u0014\u0005?\u0001\rAT\u0001\u0005I\u0006$\u0018\rC\u0004\u0003,\u0001!IA!\f\u0002'U\u0004H-\u0019;f\u0007V\u0014(/\u001a8u\u0005V4g-\u001a:\u0015\t\u00055(q\u0006\u0005\t\u0005c\u0011I\u00031\u0001\u0002\u001a\u0006!A/[7f\u0011\u001d\u0011)\u0004\u0001C\u0005\u00053\t\u0011c[3faB+8\u000f[5oO\ncwnY6t\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005w\t1B]3q_J$XI\u001d:peR1\u0011Q\u001eB\u001f\u0005\u001bB\u0001Ba\u0010\u00038\u0001\u0007!\u0011I\u0001\b[\u0016\u001c8/Y4f!\u0011\u0011\u0019E!\u0013\u000f\u00079\u0011)%C\u0002\u0003H=\ta\u0001\u0015:fI\u00164\u0017bA=\u0003L)\u0019!qI\b\t\u0011\t=#q\u0007a\u0001\u0005#\n\u0011\u0001\u001e\t\u0005\u0005'\u0012\u0019G\u0004\u0003\u0003V\t}c\u0002\u0002B,\u0005;j!A!\u0017\u000b\u0007\tm\u0013$\u0001\u0004=e>|GOP\u0005\u0002!%\u0019!\u0011M\b\u0002\u000fA\f7m[1hK&!!Q\rB4\u0005%!\u0006N]8xC\ndWMC\u0002\u0003b=AqAa\u001b\u0001\t\u0013\u0011i'A\u0005qkND'\t\\8dWR!\u0011Q\u001eB8\u0011\u001d\u0011\tH!\u001bA\u0002U\u000bQA\u00197pG.\u0004")
public class BlockGenerator
implements Logging {
    private final BlockGeneratorListener listener;
    private final int receiverId;
    private final SystemClock clock;
    private final long blockInterval;
    private final RecurringTimer blockIntervalTimer;
    private final int blockQueueSize;
    private final ArrayBlockingQueue<Block> org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing;
    private final Thread blockPushingThread;
    private volatile ArrayBuffer<Object> currentBuffer;
    private volatile boolean stopped;
    private volatile BlockGenerator$Block$ Block$module;
    private transient Logger org$apache$spark$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockGenerator$Block$ org$apache$spark$streaming$receiver$BlockGenerator$$Block$lzycompute() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.Block$module != null) return this.Block$module;
            this.Block$module = new BlockGenerator$Block$(this);
            return this.Block$module;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public BlockGenerator$Block$ org$apache$spark$streaming$receiver$BlockGenerator$$Block() {
        return this.Block$module == null ? this.org$apache$spark$streaming$receiver$BlockGenerator$$Block$lzycompute() : this.Block$module;
    }

    private SystemClock clock() {
        return this.clock;
    }

    private long blockInterval() {
        return this.blockInterval;
    }

    private RecurringTimer blockIntervalTimer() {
        return this.blockIntervalTimer;
    }

    private int blockQueueSize() {
        return this.blockQueueSize;
    }

    public ArrayBlockingQueue<Block> org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing() {
        return this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing;
    }

    private Thread blockPushingThread() {
        return this.blockPushingThread;
    }

    private ArrayBuffer<Object> currentBuffer() {
        return this.currentBuffer;
    }

    private void currentBuffer_$eq(ArrayBuffer<Object> x$1) {
        this.currentBuffer = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public void start() {
        this.blockIntervalTimer().start();
        this.blockPushingThread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Started BlockGenerator";
            }
        });
    }

    public void stop() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping BlockGenerator";
            }
        });
        this.blockIntervalTimer().stop(false);
        this.stopped_$eq(true);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting for block pushing thread";
            }
        });
        this.blockPushingThread().join();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped BlockGenerator";
            }
        });
    }

    public void $plus$eq(Object data) {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            this.currentBuffer().$plus$eq(data);
            return;
        }
    }

    public synchronized void org$apache$spark$streaming$receiver$BlockGenerator$$updateCurrentBuffer(long time) {
        try {
            ArrayBuffer<Object> newBlockBuffer = this.currentBuffer();
            this.currentBuffer_$eq((ArrayBuffer<Object>)new ArrayBuffer());
            if (newBlockBuffer.size() > 0) {
                StreamBlockId blockId = new StreamBlockId(this.receiverId, time - this.blockInterval());
                Block newBlock = new Block(this, blockId, newBlockBuffer);
                this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().put(newBlock);
                this.logDebug((Function0<String>)new Serializable(this, newBlockBuffer, blockId){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer newBlockBuffer$1;
                    private final StreamBlockId blockId$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Last element in ").append((Object)this.blockId$1).append((Object)" is ").append(this.newBlockBuffer$1.last()).toString();
                    }
                    {
                        this.newBlockBuffer$1 = newBlockBuffer$1;
                        this.blockId$1 = blockId$1;
                    }
                });
            }
        }
        catch (Throwable throwable) {
            this.reportError("Error in block updating thread", throwable);
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Block updating timer thread was interrupted";
                }
            });
        }
    }

    public void org$apache$spark$streaming$receiver$BlockGenerator$$keepPushingBlocks() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Started block pushing thread";
            }
        });
        try {
            block8: {
                Option option;
                while (true) {
                    BoxedUnit boxedUnit;
                    if (this.stopped()) {
                        this.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ BlockGenerator $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Pushing out the last ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().size())).append((Object)" blocks").toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        while (true) {
                            if (!this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().isEmpty()) {
                                this.logDebug((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Getting block ";
                                    }
                                });
                                Block block = this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().take();
                                this.pushBlock(block);
                                this.logInfo((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ BlockGenerator $outer;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Blocks left to push ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().size())).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                continue;
                            }
                            break block8;
                            break;
                        }
                    }
                    option = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().poll(100L, TimeUnit.MILLISECONDS));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Block block = (Block)some.x();
                        this.pushBlock(block);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break;
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopped block pushing thread";
                }
            });
        }
        catch (Throwable throwable) {
            this.reportError("Error in block pushing thread", throwable);
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Block pushing thread was interrupted";
                }
            });
        }
    }

    private void reportError(String message, Throwable t) {
        this.logError((Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        }, t);
        this.listener.onError(message, t);
    }

    private void pushBlock(Block block) {
        this.listener.onPushBlock(block.id(), block.buffer());
        this.logInfo((Function0<String>)new Serializable(this, block){
            public static final long serialVersionUID = 0L;
            private final Block block$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Pushed block ").append((Object)this.block$1.id()).toString();
            }
            {
                this.block$1 = block$1;
            }
        });
    }

    public BlockGenerator(BlockGeneratorListener listener, int receiverId, SparkConf conf) {
        this.listener = listener;
        this.receiverId = receiverId;
        Logging.class.$init$((Logging)this);
        this.clock = new SystemClock();
        this.blockInterval = conf.getLong("spark.streaming.blockInterval", 200L);
        this.blockIntervalTimer = new RecurringTimer(this.clock(), this.blockInterval(), (Function1<Object, BoxedUnit>)new $anonfun$1(this), "BlockGenerator");
        this.blockQueueSize = conf.getInt("spark.streaming.blockQueueSize", 10);
        this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing = new ArrayBlockingQueue(this.blockQueueSize());
        this.blockPushingThread = new $anon$1(this);
        this.currentBuffer = new ArrayBuffer();
        this.stopped = false;
    }

    public class Block
    implements Product,
    Serializable {
        private final StreamBlockId id;
        private final ArrayBuffer<Object> buffer;
        public final /* synthetic */ BlockGenerator $outer;

        public StreamBlockId id() {
            return this.id;
        }

        public ArrayBuffer<Object> buffer() {
            return this.buffer;
        }

        public Block copy(StreamBlockId id, ArrayBuffer<Object> buffer) {
            return new Block(this.org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer(), id, buffer);
        }

        public StreamBlockId copy$default$1() {
            return this.id();
        }

        public ArrayBuffer<Object> copy$default$2() {
            return this.buffer();
        }

        public String productPrefix() {
            return "Block";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            StreamBlockId streamBlockId;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    streamBlockId = this.buffer();
                    break;
                }
                case 0: {
                    streamBlockId = this.id();
                }
            }
            return streamBlockId;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Block;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Block)) return false;
            boolean bl = true;
            if (!bl) return false;
            Block block = (Block)x$1;
            StreamBlockId streamBlockId = this.id();
            StreamBlockId streamBlockId2 = block.id();
            if (streamBlockId == null) {
                if (streamBlockId2 != null) {
                    return false;
                }
            } else if (!streamBlockId.equals(streamBlockId2)) return false;
            ArrayBuffer<Object> arrayBuffer = this.buffer();
            ArrayBuffer<Object> arrayBuffer2 = block.buffer();
            if (arrayBuffer == null) {
                if (arrayBuffer2 != null) {
                    return false;
                }
            } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
            if (!block.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BlockGenerator org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer() {
            return this.$outer;
        }

        public Block(BlockGenerator $outer, StreamBlockId id, ArrayBuffer<Object> buffer) {
            this.id = id;
            this.buffer = buffer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

