/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.rdd.PairRDDFunctions$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.ErrorReported;
import org.apache.spark.streaming.scheduler.InputInfoTracker;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobCompleted;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.apache.spark.streaming.scheduler.JobScheduler$;
import org.apache.spark.streaming.scheduler.JobSchedulerEvent;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobStarted;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.util.Clock;
import org.apache.spark.util.EventLoop;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a!B\u0001\u0003\u0001\u0011a!\u0001\u0004&pEN\u001b\u0007.\u001a3vY\u0016\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!Q1A\u0005\u0002i\t1a]:d\u0007\u0001)\u0012a\u0007\t\u00039ui\u0011\u0001B\u0005\u0003=\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011\u0001\u0002!\u0011!Q\u0001\nm\tAa]:dA!)!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000ba\t\u0003\u0019A\u000e\t\u000f!\u0002!\u0019!C\u0005S\u00059!n\u001c2TKR\u001cX#\u0001\u0016\u0011\t-\u0012DgN\u0007\u0002Y)\u0011QFL\u0001\u000bG>t7-\u001e:sK:$(BA\u00181\u0003\u0011)H/\u001b7\u000b\u0003E\nAA[1wC&\u00111\u0007\f\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001\u000f6\u0013\t1DA\u0001\u0003US6,\u0007CA\u00139\u0013\tI$A\u0001\u0004K_\n\u001cV\r\u001e\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u0016\u0002\u0011)|'mU3ug\u0002Bq!\u0010\u0001C\u0002\u0013%a(A\tok6\u001cuN\\2veJ,g\u000e\u001e&pEN,\u0012a\u0010\t\u0003\u001d\u0001K!!Q\b\u0003\u0007%sG\u000f\u0003\u0004D\u0001\u0001\u0006IaP\u0001\u0013]Vl7i\u001c8dkJ\u0014XM\u001c;K_\n\u001c\b\u0005C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u0017)|'-\u0012=fGV$xN]\u000b\u0002\u000fB\u00111\u0006S\u0005\u0003\u00132\u0012q\"\u0012=fGV$xN]*feZL7-\u001a\u0005\u0007\u0017\u0002\u0001\u000b\u0011B$\u0002\u0019)|'-\u0012=fGV$xN\u001d\u0011\t\u000f5\u0003!\u0019!C\u0005\u001d\u0006a!n\u001c2HK:,'/\u0019;peV\tq\n\u0005\u0002&!&\u0011\u0011K\u0001\u0002\r\u0015>\u0014w)\u001a8fe\u0006$xN\u001d\u0005\u0007'\u0002\u0001\u000b\u0011B(\u0002\u001b)|'mR3oKJ\fGo\u001c:!\u0011\u001d)\u0006A1A\u0005\u0002Y\u000bQa\u00197pG.,\u0012a\u0016\t\u00031jk\u0011!\u0017\u0006\u0003_\u0019I!aW-\u0003\u000b\rcwnY6\t\ru\u0003\u0001\u0015!\u0003X\u0003\u0019\u0019Gn\\2lA!9q\f\u0001b\u0001\n\u0003\u0001\u0017a\u00037jgR,g.\u001a:CkN,\u0012!\u0019\t\u0003K\tL!a\u0019\u0002\u0003)M#(/Z1nS:<G*[:uK:,'OQ;t\u0011\u0019)\u0007\u0001)A\u0005C\u0006aA.[:uK:,'OQ;tA!9q\r\u0001a\u0001\n\u0003A\u0017a\u0004:fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u0016\u0003%\u0004\"!\n6\n\u0005-\u0014!a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\t\u000f5\u0004\u0001\u0019!C\u0001]\u0006\u0019\"/Z2fSZ,'\u000f\u0016:bG.,'o\u0018\u0013fcR\u0011qN\u001d\t\u0003\u001dAL!!]\b\u0003\tUs\u0017\u000e\u001e\u0005\bg2\f\t\u00111\u0001j\u0003\rAH%\r\u0005\u0007k\u0002\u0001\u000b\u0015B5\u0002!I,7-Z5wKJ$&/Y2lKJ\u0004\u0003bB<\u0001\u0001\u0004%\t\u0001_\u0001\u0011S:\u0004X\u000f^%oM>$&/Y2lKJ,\u0012!\u001f\t\u0003KiL!a\u001f\u0002\u0003!%s\u0007/\u001e;J]\u001a|GK]1dW\u0016\u0014\bbB?\u0001\u0001\u0004%\tA`\u0001\u0015S:\u0004X\u000f^%oM>$&/Y2lKJ|F%Z9\u0015\u0005=|\bbB:}\u0003\u0003\u0005\r!\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003z\u0003EIg\u000e];u\u0013:4w\u000e\u0016:bG.,'\u000f\t\u0005\n\u0003\u000f\u0001\u0001\u0019!C\u0005\u0003\u0013\t\u0011\"\u001a<f]Rdun\u001c9\u0016\u0005\u0005-\u0001#\u0002-\u0002\u000e\u0005E\u0011bAA\b3\nIQI^3oi2{w\u000e\u001d\t\u0004K\u0005M\u0011bAA\u000b\u0005\t\t\"j\u001c2TG\",G-\u001e7fe\u00163XM\u001c;\t\u0013\u0005e\u0001\u00011A\u0005\n\u0005m\u0011!D3wK:$Hj\\8q?\u0012*\u0017\u000fF\u0002p\u0003;A\u0011b]A\f\u0003\u0003\u0005\r!a\u0003\t\u0011\u0005\u0005\u0002\u0001)Q\u0005\u0003\u0017\t!\"\u001a<f]Rdun\u001c9!\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\tQa\u001d;beR$\u0012a\u001c\u0005\b\u0003W\u0001A\u0011AA\u0017\u0003\u0011\u0019Ho\u001c9\u0015\u0007=\fy\u0003\u0003\u0005\u00022\u0005%\u0002\u0019AA\u001a\u0003Y\u0001(o\\2fgN\fE\u000e\u001c*fG\u0016Lg/\u001a3ECR\f\u0007c\u0001\b\u00026%\u0019\u0011qG\b\u0003\u000f\t{w\u000e\\3b]\"9\u00111\b\u0001\u0005\u0002\u0005u\u0012\u0001D:vE6LGOS8c'\u0016$HcA8\u0002@!9\u0011\u0011IA\u001d\u0001\u00049\u0014A\u00026pEN+G\u000fC\u0004\u0002F\u0001!\t!a\u0012\u0002\u001f\u001d,G\u000fU3oI&tw\rV5nKN$\"!!\u0013\u0011\u000b\u0005-\u00131\f\u001b\u000f\t\u00055\u0013q\u000b\b\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111K\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012bAA-\u001f\u00059\u0001/Y2lC\u001e,\u0017\u0002BA/\u0003?\u00121aU3r\u0015\r\tIf\u0004\u0005\b\u0003G\u0002A\u0011AA3\u0003-\u0011X\r]8si\u0016\u0013(o\u001c:\u0015\u000b=\f9'!\u001f\t\u0011\u0005%\u0014\u0011\ra\u0001\u0003W\n1!\\:h!\u0011\ti'a\u001d\u000f\u00079\ty'C\u0002\u0002r=\ta\u0001\u0015:fI\u00164\u0017\u0002BA;\u0003o\u0012aa\u0015;sS:<'bAA9\u001f!A\u00111PA1\u0001\u0004\ti(A\u0001f!\u0011\tY%a \n\t\u0005\u0005\u0015q\f\u0002\n)\"\u0014xn^1cY\u0016Dq!!\"\u0001\t\u0003\t9)A\u0005jgN#\u0018M\u001d;fIR\u0011\u00111\u0007\u0005\b\u0003\u0017\u0003A\u0011BAG\u00031\u0001(o\\2fgN,e/\u001a8u)\ry\u0017q\u0012\u0005\t\u0003#\u000bI\t1\u0001\u0002\u0012\u0005)QM^3oi\"9\u0011Q\u0013\u0001\u0005\n\u0005]\u0015A\u00045b]\u0012dWMS8c'R\f'\u000f\u001e\u000b\u0004_\u0006e\u0005\u0002CAN\u0003'\u0003\r!!(\u0002\u0007)|'\rE\u0002&\u0003?K1!!)\u0003\u0005\rQuN\u0019\u0005\b\u0003K\u0003A\u0011BAT\u0003MA\u0017M\u001c3mK*{'mQ8na2,G/[8o)\ry\u0017\u0011\u0016\u0005\t\u00037\u000b\u0019\u000b1\u0001\u0002\u001e\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0016a\u00035b]\u0012dW-\u0012:s_J$Ra\\AY\u0003gC\u0001\"!\u001b\u0002,\u0002\u0007\u00111\u000e\u0005\t\u0003w\nY\u000b1\u0001\u0002~\u00191\u0011q\u0017\u0001\u0005\u0003s\u0013!BS8c\u0011\u0006tG\r\\3s'\u001d\t),a/\u0002HN\u0001B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003\u0004\u0014\u0001\u00027b]\u001eLA!!2\u0002@\n1qJ\u00196fGR\u0004B!!0\u0002J&!\u00111ZA`\u0005!\u0011VO\u001c8bE2,\u0007bCAN\u0003k\u0013\t\u0011)A\u0005\u0003;CqAIA[\t\u0003\t\t\u000e\u0006\u0003\u0002T\u0006]\u0007\u0003BAk\u0003kk\u0011\u0001\u0001\u0005\t\u00037\u000by\r1\u0001\u0002\u001e\"A\u00111\\A[\t\u0003\t9#A\u0002sk:<\u0001\"a8\u0003\u0011\u0003!\u0011\u0011]\u0001\r\u0015>\u00147k\u00195fIVdWM\u001d\t\u0004K\u0005\rhaB\u0001\u0003\u0011\u0003!\u0011Q]\n\u0004\u0003Gl\u0001b\u0002\u0012\u0002d\u0012\u0005\u0011\u0011\u001e\u000b\u0003\u0003CD!\"!<\u0002d\n\u0007I\u0011AAx\u0003]\u0011\u0015\tV\"I?RKU*R0Q%>\u0003VI\u0015+Z?.+\u0015,\u0006\u0002\u0002rB!\u0011QXAz\u0013\u0011\t)(a0\t\u0013\u0005]\u00181\u001dQ\u0001\n\u0005E\u0018\u0001\u0007\"B)\u000eCu\fV%N\u000b~\u0003&k\u0014)F%RKvlS#ZA!Q\u00111`Ar\u0005\u0004%\t!a<\u00023=+F\u000bU+U?>\u0003v,\u0013#`!J{\u0005+\u0012*U3~[U)\u0017\u0005\n\u0003\u007f\f\u0019\u000f)A\u0005\u0003c\f!dT+U!V#vl\u0014)`\u0013\u0012{\u0006KU(Q\u000bJ#\u0016lX&F3\u0002\u0002")
public class JobScheduler
implements Logging {
    private final StreamingContext ssc;
    private final ConcurrentHashMap<Time, JobSet> jobSets;
    private final int numConcurrentJobs;
    private final ExecutorService org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor;
    private final JobGenerator jobGenerator;
    private final Clock clock;
    private final StreamingListenerBus listenerBus;
    private ReceiverTracker receiverTracker;
    private InputInfoTracker inputInfoTracker;
    private EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String OUTPUT_OP_ID_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY();
    }

    public static String BATCH_TIME_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    private ConcurrentHashMap<Time, JobSet> jobSets() {
        return this.jobSets;
    }

    private int numConcurrentJobs() {
        return this.numConcurrentJobs;
    }

    public ExecutorService org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor;
    }

    private JobGenerator jobGenerator() {
        return this.jobGenerator;
    }

    public Clock clock() {
        return this.clock;
    }

    public StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public ReceiverTracker receiverTracker() {
        return this.receiverTracker;
    }

    public void receiverTracker_$eq(ReceiverTracker x$1) {
        this.receiverTracker = x$1;
    }

    public InputInfoTracker inputInfoTracker() {
        return this.inputInfoTracker;
    }

    public void inputInfoTracker_$eq(InputInfoTracker x$1) {
        this.inputInfoTracker = x$1;
    }

    public EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    }

    private void org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(EventLoop<JobSchedulerEvent> x$1) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = x$1;
    }

    public synchronized void start() {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() == null) {
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobScheduler";
                }
            });
            this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(new EventLoop<JobSchedulerEvent>(this){
                private final /* synthetic */ JobScheduler $outer;

                public void onReceive(JobSchedulerEvent event) {
                    this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(event);
                }

                public void onError(Throwable e) {
                    this.$outer.reportError("Error in job scheduler", e);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super("JobScheduler");
                }
            });
            this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().start();
            this.listenerBus().start(this.ssc().sparkContext());
            this.receiverTracker_$eq(new ReceiverTracker(this.ssc(), ReceiverTracker$.MODULE$.$lessinit$greater$default$2()));
            this.inputInfoTracker_$eq(new InputInfoTracker(this.ssc()));
            this.receiverTracker().start();
            this.jobGenerator().start();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Started JobScheduler";
                }
            });
            return;
        }
    }

    public synchronized void stop(boolean processAllReceivedData) {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() == null) {
            return;
        }
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping JobScheduler";
            }
        });
        this.receiverTracker().stop(processAllReceivedData);
        this.jobGenerator().stop(processAllReceivedData);
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping job executor";
            }
        });
        this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().shutdown();
        boolean terminated = processAllReceivedData ? this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().awaitTermination(1L, TimeUnit.HOURS) : this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().awaitTermination(2L, TimeUnit.SECONDS);
        Object object = terminated ? BoxedUnit.UNIT : this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().shutdownNow();
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped job executor";
            }
        });
        this.listenerBus().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(null);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped JobScheduler";
            }
        });
    }

    public void submitJobSet(JobSet jobSet) {
        if (jobSet.jobs().isEmpty()) {
            this.logInfo((Function0<String>)new Serializable(this, jobSet){
                public static final long serialVersionUID = 0L;
                private final JobSet jobSet$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"No jobs added for time ").append((Object)this.jobSet$1.time()).toString();
                }
                {
                    this.jobSet$1 = jobSet$1;
                }
            });
        } else {
            this.listenerBus().post(new StreamingListenerBatchSubmitted(jobSet.toBatchInfo()));
            this.jobSets().put(jobSet.time(), jobSet);
            jobSet.jobs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobScheduler $outer;

                public final void apply(Job job) {
                    this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().execute(new JobHandler(this.$outer, job));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.logInfo((Function0<String>)new Serializable(this, jobSet){
                public static final long serialVersionUID = 0L;
                private final JobSet jobSet$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Added jobs for time ").append((Object)this.jobSet$1.time()).toString();
                }
                {
                    this.jobSet$1 = jobSet$1;
                }
            });
        }
    }

    public Seq<Time> getPendingTimes() {
        return JavaConversions$.MODULE$.asScalaSet(this.jobSets().keySet()).toSeq();
    }

    public void reportError(String msg, Throwable e) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().post((Object)new ErrorReported(msg, e));
    }

    public synchronized boolean isStarted() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() != null;
    }

    public void org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(JobSchedulerEvent event) {
        block5: {
            try {
                JobSchedulerEvent jobSchedulerEvent = event;
                if (jobSchedulerEvent instanceof JobStarted) {
                    JobStarted jobStarted = (JobStarted)jobSchedulerEvent;
                    Job job = jobStarted.job();
                    this.handleJobStart(job);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof JobCompleted) {
                    JobCompleted jobCompleted = (JobCompleted)jobSchedulerEvent;
                    Job job = jobCompleted.job();
                    this.handleJobCompletion(job);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof ErrorReported) {
                    ErrorReported errorReported = (ErrorReported)jobSchedulerEvent;
                    String m = errorReported.msg();
                    Throwable e = errorReported.e();
                    this.handleError(m, e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError((Object)jobSchedulerEvent);
            }
            catch (Throwable throwable) {
                this.reportError("Error in job scheduler", throwable);
            }
        }
    }

    private void handleJobStart(Job job) {
        JobSet jobSet = this.jobSets().get(job.time());
        boolean isFirstJobOfJobSet = !jobSet.hasStarted();
        jobSet.handleJobStart(job);
        if (isFirstJobOfJobSet) {
            this.listenerBus().post(new StreamingListenerBatchStarted(jobSet.toBatchInfo()));
        }
        this.logInfo((Function0<String>)new Serializable(this, job, jobSet){
            public static final long serialVersionUID = 0L;
            private final Job job$1;
            private final JobSet jobSet$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Starting job ").append((Object)this.job$1.id()).append((Object)" from job set of time ").append((Object)this.jobSet$2.time()).toString();
            }
            {
                this.job$1 = job$1;
                this.jobSet$2 = jobSet$2;
            }
        });
    }

    private void handleJobCompletion(Job job) {
        Try<?> try_;
        block7: {
            block6: {
                block5: {
                    BoxedUnit boxedUnit;
                    try_ = job.result();
                    if (!(try_ instanceof Success)) break block5;
                    JobSet jobSet = this.jobSets().get(job.time());
                    jobSet.handleJobCompletion(job);
                    this.logInfo((Function0<String>)new Serializable(this, job, jobSet){
                        public static final long serialVersionUID = 0L;
                        private final Job job$2;
                        private final JobSet jobSet$3;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Finished job ").append((Object)this.job$2.id()).append((Object)" from job set of time ").append((Object)this.jobSet$3.time()).toString();
                        }
                        {
                            this.job$2 = job$2;
                            this.jobSet$3 = jobSet$3;
                        }
                    });
                    if (jobSet.hasCompleted()) {
                        this.jobSets().remove(jobSet.time());
                        this.jobGenerator().onBatchCompletion(jobSet.time());
                        this.logInfo((Function0<String>)new Serializable(this, jobSet){
                            public static final long serialVersionUID = 0L;
                            private final JobSet jobSet$3;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Total delay: %.3f s for time %s (execution: %.3f s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)this.jobSet$3.totalDelay() / 1000.0)), this.jobSet$3.time().toString(), BoxesRunTime.boxToDouble((double)((double)this.jobSet$3.processingDelay() / 1000.0))}));
                            }
                            {
                                this.jobSet$3 = jobSet$3;
                            }
                        });
                        this.listenerBus().post(new StreamingListenerBatchCompleted(jobSet.toBatchInfo()));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block6;
                }
                if (!(try_ instanceof Failure)) break block7;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.reportError(new StringBuilder().append((Object)"Error running job ").append((Object)job).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(try_);
    }

    private void handleError(String msg, Throwable e) {
        this.logError((Function0<String>)new Serializable(this, msg){
            public static final long serialVersionUID = 0L;
            private final String msg$1;

            public final String apply() {
                return this.msg$1;
            }
            {
                this.msg$1 = msg$1;
            }
        }, e);
        this.ssc().waiter().notifyError(e);
    }

    public JobScheduler(StreamingContext ssc) {
        this.ssc = ssc;
        Logging.class.$init$((Logging)this);
        this.jobSets = new ConcurrentHashMap();
        this.numConcurrentJobs = ssc.conf().getInt("spark.streaming.concurrentJobs", 1);
        this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor = Executors.newFixedThreadPool(this.numConcurrentJobs());
        this.jobGenerator = new JobGenerator(this);
        this.clock = this.jobGenerator().clock();
        this.listenerBus = new StreamingListenerBus();
        this.receiverTracker = null;
        this.inputInfoTracker = null;
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = null;
    }

    public class JobHandler
    implements Runnable,
    Logging {
        public final Job org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job;
        public final /* synthetic */ JobScheduler $outer;
        private transient Logger org$apache$spark$Logging$$log_;

        public Logger org$apache$spark$Logging$$log_() {
            return this.org$apache$spark$Logging$$log_;
        }

        public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$Logging$$log_ = x$1;
        }

        public String logName() {
            return Logging.class.logName((Logging)this);
        }

        public Logger log() {
            return Logging.class.log((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.class.logInfo((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.class.logDebug((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.class.logTrace((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.class.logWarning((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.class.logError((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.class.logError((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.class.isTraceEnabled((Logging)this);
        }

        @Override
        public void run() {
            this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToLong((long)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.time().milliseconds())).toString());
            this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.outputOpId())).toString());
            try {
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().post((Object)new JobStarted(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job));
                PairRDDFunctions$.MODULE$.disableOutputSpecValidation().withValue((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JobHandler $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.run();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().post((Object)new JobCompleted(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job));
                return;
            }
            finally {
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY(), null);
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY(), null);
            }
        }

        public /* synthetic */ JobScheduler org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer() {
            return this.$outer;
        }

        public JobHandler(JobScheduler $outer, Job job) {
            this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job = job;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging.class.$init$((Logging)this);
        }
    }
}

