/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler.rate;

import org.apache.spark.Logging;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0001\u0002\u0001\r9\u0011\u0001\u0003U%E%\u0006$X-R:uS6\fGo\u001c:\u000b\u0005\r!\u0011\u0001\u0002:bi\u0016T!!\u0002\u0004\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0004\t\u0003%\u0019HO]3b[&twM\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\u0011\u0001q\"F\r\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t1r#D\u0001\u0003\u0013\tA\"AA\u0007SCR,Wi\u001d;j[\u0006$xN\u001d\t\u00035mi\u0011\u0001C\u0005\u00039!\u0011q\u0001T8hO&tw\r\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003!\u0003M\u0011\u0017\r^2i\u0013:$XM\u001d<bY6KG\u000e\\5t\u0007\u0001\u0001\"\u0001E\u0011\n\u0005\t\n\"\u0001\u0002'p]\u001eD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\raJ|\u0007o\u001c:uS>t\u0017\r\u001c\t\u0003!\u0019J!aJ\t\u0003\r\u0011{WO\u00197f\u0011!I\u0003A!A!\u0002\u0013)\u0013\u0001C5oi\u0016<'/\u00197\t\u0011-\u0002!\u0011!Q\u0001\n\u0015\n!\u0002Z3sSZ\fG/\u001b<f\u0011!i\u0003A!A!\u0002\u0013)\u0013aB7j]J\u000bG/\u001a\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\rE\u00124\u0007N\u001b7!\t1\u0002\u0001C\u0003\u001f]\u0001\u0007\u0001\u0005C\u0003%]\u0001\u0007Q\u0005C\u0003*]\u0001\u0007Q\u0005C\u0003,]\u0001\u0007Q\u0005C\u0003.]\u0001\u0007Q\u0005C\u00049\u0001\u0001\u0007I\u0011B\u001d\u0002\u0011\u0019L'o\u001d;Sk:,\u0012A\u000f\t\u0003!mJ!\u0001P\t\u0003\u000f\t{w\u000e\\3b]\"9a\b\u0001a\u0001\n\u0013y\u0014\u0001\u00044jeN$(+\u001e8`I\u0015\fHC\u0001!D!\t\u0001\u0012)\u0003\u0002C#\t!QK\\5u\u0011\u001d!U(!AA\u0002i\n1\u0001\u001f\u00132\u0011\u00191\u0005\u0001)Q\u0005u\u0005Ia-\u001b:tiJ+h\u000e\t\u0005\b\u0011\u0002\u0001\r\u0011\"\u0003J\u0003)a\u0017\r^3tiRKW.Z\u000b\u0002A!91\n\u0001a\u0001\n\u0013a\u0015A\u00047bi\u0016\u001cH\u000fV5nK~#S-\u001d\u000b\u0003\u00016Cq\u0001\u0012&\u0002\u0002\u0003\u0007\u0001\u0005\u0003\u0004P\u0001\u0001\u0006K\u0001I\u0001\fY\u0006$Xm\u001d;US6,\u0007\u0005C\u0004R\u0001\u0001\u0007I\u0011\u0002*\u0002\u00151\fG/Z:u%\u0006$X-F\u0001&\u0011\u001d!\u0006\u00011A\u0005\nU\u000ba\u0002\\1uKN$(+\u0019;f?\u0012*\u0017\u000f\u0006\u0002A-\"9AiUA\u0001\u0002\u0004)\u0003B\u0002-\u0001A\u0003&Q%A\u0006mCR,7\u000f\u001e*bi\u0016\u0004\u0003b\u0002.\u0001\u0001\u0004%IAU\u0001\fY\u0006$Xm\u001d;FeJ|'\u000fC\u0004]\u0001\u0001\u0007I\u0011B/\u0002\u001f1\fG/Z:u\u000bJ\u0014xN]0%KF$\"\u0001\u00110\t\u000f\u0011[\u0016\u0011!a\u0001K!1\u0001\r\u0001Q!\n\u0015\nA\u0002\\1uKN$XI\u001d:pe\u0002BQA\u0019\u0001\u0005\u0002\r\fqaY8naV$X\rF\u0003eO&\\W\u000eE\u0002\u0011K\u0016J!AZ\t\u0003\r=\u0003H/[8o\u0011\u0015A\u0017\r1\u0001!\u0003\u0011!\u0018.\\3\t\u000b)\f\u0007\u0019\u0001\u0011\u0002\u00179,X.\u00127f[\u0016tGo\u001d\u0005\u0006Y\u0006\u0004\r\u0001I\u0001\u0010aJ|7-Z:tS:<G)\u001a7bs\")a.\u0019a\u0001A\u0005y1o\u00195fIVd\u0017N\\4EK2\f\u0017\u0010")
public class PIDRateEstimator
implements RateEstimator,
Logging {
    public final long org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$batchIntervalMillis;
    public final double org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$proportional;
    public final double org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$integral;
    public final double org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$derivative;
    public final double org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$minRate;
    private boolean firstRun;
    private long latestTime;
    private double org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate;
    private double org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private boolean firstRun() {
        return this.firstRun;
    }

    private void firstRun_$eq(boolean x$1) {
        this.firstRun = x$1;
    }

    private long latestTime() {
        return this.latestTime;
    }

    private void latestTime_$eq(long x$1) {
        this.latestTime = x$1;
    }

    public double org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate() {
        return this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate;
    }

    private void org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate_$eq(double x$1) {
        this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate = x$1;
    }

    public double org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError() {
        return this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError;
    }

    private void org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError_$eq(double x$1) {
        this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError = x$1;
    }

    @Override
    public Option<Object> compute(long time, long numElements, long processingDelay2, long schedulingDelay2) {
        this.logTrace((Function0<String>)new Serializable(this, time, numElements, processingDelay2, schedulingDelay2){
            public static final long serialVersionUID = 0L;
            private final long time$1;
            private final long numElements$1;
            private final long processingDelay$1;
            private final long schedulingDelay$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\ntime = ", ", # records = ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.time$1), BoxesRunTime.boxToLong((long)this.numElements$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"processing time = ", ", scheduling delay = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.processingDelay$1), BoxesRunTime.boxToLong((long)this.schedulingDelay$1)}))).toString();
            }
            {
                this.time$1 = time$1;
                this.numElements$1 = numElements$1;
                this.processingDelay$1 = processingDelay$1;
                this.schedulingDelay$1 = schedulingDelay$1;
            }
        });
        PIDRateEstimator pIDRateEstimator = this;
        synchronized (pIDRateEstimator) {
            None$ none$;
            if (time > this.latestTime() && numElements > 0L && processingDelay2 > 0L) {
                double delaySinceUpdate = (double)(time - this.latestTime()) / (double)1000;
                double processingRate = (double)numElements / (double)processingDelay2 * (double)1000;
                double error = this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate() - processingRate;
                double historicalError = (double)schedulingDelay2 * processingRate / (double)this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$batchIntervalMillis;
                double dError = (error - this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError()) / delaySinceUpdate;
                double newRate = BoxesRunTime.unboxToDouble((Object)new RichDouble(Predef$.MODULE$.doubleWrapper(this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate() - this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$proportional * error - this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$integral * historicalError - this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$derivative * dError)).max((Object)BoxesRunTime.boxToDouble((double)this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$minRate)));
                this.logTrace((Function0<String>)new Serializable(this, delaySinceUpdate, error, historicalError, dError){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PIDRateEstimator $outer;
                    private final double delaySinceUpdate$1;
                    private final double error$1;
                    private final double historicalError$1;
                    private final double dError$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            | latestRate = ", ", error = ", "\n            | latestError = ", ", historicalError = ", "\n            | delaySinceUpdate = ", ", dError = ", "\n            "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate()), BoxesRunTime.boxToDouble((double)this.error$1), BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError()), BoxesRunTime.boxToDouble((double)this.historicalError$1), BoxesRunTime.boxToDouble((double)this.delaySinceUpdate$1), BoxesRunTime.boxToDouble((double)this.dError$1)})))).stripMargin();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.delaySinceUpdate$1 = delaySinceUpdate$1;
                        this.error$1 = error$1;
                        this.historicalError$1 = historicalError$1;
                        this.dError$1 = dError$1;
                    }
                });
                this.latestTime_$eq(time);
                if (this.firstRun()) {
                    this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate_$eq(processingRate);
                    this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError_$eq(0.0);
                    this.firstRun_$eq(false);
                    this.logTrace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "First run, rate estimation skipped";
                        }
                    });
                    none$ = None$.MODULE$;
                } else {
                    this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate_$eq(newRate);
                    this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError_$eq(error);
                    this.logTrace((Function0<String>)new Serializable(this, newRate){
                        public static final long serialVersionUID = 0L;
                        private final double newRate$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New rate = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.newRate$1)}));
                        }
                        {
                            this.newRate$1 = newRate$1;
                        }
                    });
                    none$ = new Some((Object)BoxesRunTime.boxToDouble((double)newRate));
                }
            } else {
                this.logTrace((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Rate estimation skipped";
                    }
                });
                none$ = None$.MODULE$;
            }
            None$ none$2 = none$;
            return (Option)none$2;
        }
    }

    public PIDRateEstimator(long batchIntervalMillis, double proportional, double integral, double derivative, double minRate) {
        this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$batchIntervalMillis = batchIntervalMillis;
        this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$proportional = proportional;
        this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$integral = integral;
        this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$derivative = derivative;
        this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$minRate = minRate;
        Logging.class.$init$((Logging)this);
        this.firstRun = true;
        this.latestTime = -1L;
        this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestRate = -1.0;
        this.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$latestError = -1.0;
        Predef$.MODULE$.require(batchIntervalMillis > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PIDRateEstimator $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified batch interval ", " in PIDRateEstimator is invalid."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$batchIntervalMillis)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(proportional >= 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PIDRateEstimator $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Proportional term ", " in PIDRateEstimator should be >= 0."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$proportional)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(integral >= 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PIDRateEstimator $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Integral term ", " in PIDRateEstimator should be >= 0."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$integral)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(derivative >= 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PIDRateEstimator $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Derivative term ", " in PIDRateEstimator should be >= 0."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$derivative)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(minRate > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Minimum rate in PIDRateEstimator should be > 0"})).s((Seq)Nil$.MODULE$);
            }
        });
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PIDRateEstimator $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created PIDRateEstimator with proportional = ", ", integral = ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$proportional), BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$integral)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"derivative = ", ", min rate = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$derivative), BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$rate$PIDRateEstimator$$minRate)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

