/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.TaskLocality$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestOutputStream$;
import org.apache.spark.streaming.TestReceiver;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.ConstantInputDStream;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.RateTestInputDStream;
import org.apache.spark.streaming.scheduler.RateTestReceiver;
import org.apache.spark.streaming.scheduler.RateTestReceiver$;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.StoppableReceiver;
import org.apache.spark.streaming.scheduler.StoppableReceiver$;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.StreamingListenerStreamingStarted;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.SpanSugar$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileIntRef;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001\u001d!)q\u0003\u0001C\u00011\t!\"+Z2fSZ,'\u000f\u0016:bG.,'oU;ji\u0016T!\u0001B\u0003\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0004\b\u0003%\u0019HO]3b[&twM\u0003\u0002\t\u0013\u0005)1\u000f]1sW*\u0011!bC\u0001\u0007CB\f7\r[3\u000b\u00031\t1a\u001c:h\u0007\u0001\u00192\u0001A\b\u0014!\t\u0001\u0012#D\u0001\b\u0013\t\u0011rAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003)Ui\u0011!B\u0005\u0003-\u0015\u0011Q\u0002V3tiN+\u0018\u000e^3CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0004\u0001")
public class ReceiverTrackerSuite
extends SparkFunSuite
implements TestSuiteBase {
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public String framework() {
        return TestSuiteBase.framework$(this);
    }

    @Override
    public String master() {
        return TestSuiteBase.master$(this);
    }

    @Override
    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$(this);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase.beforeFunction$(this);
    }

    @Override
    public void afterFunction() {
        TestSuiteBase.afterFunction$(this);
    }

    @Override
    public void beforeEach() {
        TestSuiteBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        TestSuiteBase.afterEach$(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$(this, input, operation, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$(this);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$(this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$(this);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$(this);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$(this, output, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$(this);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    private String checkpointDir$lzycompute() {
        ReceiverTrackerSuite receiverTrackerSuite = this;
        synchronized (receiverTrackerSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$(this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    @Override
    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public ReceiverTrackerSuite() {
        TestSuiteBase.$init$(this);
        this.test("send rate update to receivers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> this.withStreamingContext(new StreamingContext(this.conf(), Milliseconds$.MODULE$.apply(100L)), (Function1 & Serializable & scala.Serializable)ssc -> {
            Object object;
            long newRateLimit = 100L;
            RateTestInputDStream inputDStream = new RateTestInputDStream((StreamingContext)ssc);
            ReceiverTracker tracker = new ReceiverTracker(ssc, ReceiverTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.start();
            try {
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(5).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
                    Option<RateTestReceiver> $org_scalatest_assert_macro_left = RateTestReceiver$.MODULE$.getActive();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
                RateTestReceiver activeReceiver = (RateTestReceiver)((Object)((Object)((Object)RateTestReceiver$.MODULE$.getActive().get())));
                tracker.sendRateUpdate(inputDStream.id(), newRateLimit);
                object = Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(5).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)activeReceiver.getDefaultBlockGeneratorRateLimit()));
                    long $org_scalatest_assert_macro_right = newRateLimit;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"default block generator did not receive rate update", Prettifier$.MODULE$.default(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)activeReceiver.getCustomBlockGeneratorRateLimit()));
                    long $org_scalatest_assert_macro_right2 = newRateLimit;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"other block generator did not receive rate update", Prettifier$.MODULE$.default(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            }
            finally {
                tracker.stop(false);
                tracker.stop(false);
            }
            return object;
        }), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("should restart receiver after stopping it", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withStreamingContext(new StreamingContext(this.conf(), Milliseconds$.MODULE$.apply(100L)), (Function1 & Serializable & scala.Serializable)ssc -> {
            VolatileIntRef startTimes = VolatileIntRef.create((int)0);
            ssc.addStreamingListener(new StreamingListener(null, startTimes){
                private final VolatileIntRef startTimes$1;

                public void onStreamingStarted(StreamingListenerStreamingStarted streamingStarted) {
                    StreamingListener.onStreamingStarted$((StreamingListener)this, (StreamingListenerStreamingStarted)streamingStarted);
                }

                public void onReceiverError(StreamingListenerReceiverError receiverError) {
                    StreamingListener.onReceiverError$((StreamingListener)this, (StreamingListenerReceiverError)receiverError);
                }

                public void onReceiverStopped(StreamingListenerReceiverStopped receiverStopped) {
                    StreamingListener.onReceiverStopped$((StreamingListener)this, (StreamingListenerReceiverStopped)receiverStopped);
                }

                public void onBatchSubmitted(StreamingListenerBatchSubmitted batchSubmitted) {
                    StreamingListener.onBatchSubmitted$((StreamingListener)this, (StreamingListenerBatchSubmitted)batchSubmitted);
                }

                public void onBatchStarted(StreamingListenerBatchStarted batchStarted) {
                    StreamingListener.onBatchStarted$((StreamingListener)this, (StreamingListenerBatchStarted)batchStarted);
                }

                public void onBatchCompleted(StreamingListenerBatchCompleted batchCompleted) {
                    StreamingListener.onBatchCompleted$((StreamingListener)this, (StreamingListenerBatchCompleted)batchCompleted);
                }

                public void onOutputOperationStarted(StreamingListenerOutputOperationStarted outputOperationStarted) {
                    StreamingListener.onOutputOperationStarted$((StreamingListener)this, (StreamingListenerOutputOperationStarted)outputOperationStarted);
                }

                public void onOutputOperationCompleted(StreamingListenerOutputOperationCompleted outputOperationCompleted) {
                    StreamingListener.onOutputOperationCompleted$((StreamingListener)this, (StreamingListenerOutputOperationCompleted)outputOperationCompleted);
                }

                public void onReceiverStarted(StreamingListenerReceiverStarted receiverStarted) {
                    ++this.startTimes$1.elem;
                }
                {
                    this.startTimes$1 = startTimes$1;
                    StreamingListener.$init$((StreamingListener)this);
                }
            });
            ReceiverInputDStream input = ssc.receiverStream((Receiver)new StoppableReceiver(), ClassTag$.MODULE$.Int());
            TestOutputStream output = new TestOutputStream(input, TestOutputStream$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.Int());
            output.register();
            ssc.start();
            StoppableReceiver$.MODULE$.shouldStop_$eq(true);
            return (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)startTimes$1.elem));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        }), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("SPARK-11063: TaskSetManager should use Receiver RDD's preferredLocations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf _conf = this.conf().clone().set("spark.streaming.clock", "org.apache.spark.util.ManualClock");
            return (Assertion)this.withStreamingContext(new StreamingContext(_conf, Milliseconds$.MODULE$.apply(100L)), (Function1 & Serializable & scala.Serializable)ssc -> {
                VolatileObjectRef receiverTaskLocality = VolatileObjectRef.create(null);
                ssc.sparkContext().addSparkListener((SparkListenerInterface)new SparkListener(null, receiverTaskLocality){
                    private final VolatileObjectRef receiverTaskLocality$1;

                    public void onTaskStart(SparkListenerTaskStart taskStart) {
                        this.receiverTaskLocality$1.elem = taskStart.taskInfo().taskLocality();
                    }
                    {
                        this.receiverTaskLocality$1 = receiverTaskLocality$1;
                    }
                });
                ReceiverInputDStream input = ssc.receiverStream((Receiver)new TestReceiver(), ClassTag$.MODULE$.Int());
                TestOutputStream output = new TestOutputStream(input, TestOutputStream$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.Int());
                output.register();
                ssc.start();
                return (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer((Enumeration.Value)receiverTaskLocality$1.elem);
                    Enumeration.Value $org_scalatest_assert_macro_right = TaskLocality$.MODULE$.PROCESS_LOCAL();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
                }, Retrying$.MODULE$.retryingNatureOfT(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            });
        }, new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("get allocated executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.withStreamingContext(new StreamingContext(this.conf(), Milliseconds$.MODULE$.apply(100L)), (Function1 & Serializable & scala.Serializable)ssc -> {
                ReceiverInputDStream input = ssc.receiverStream((Receiver)new TestReceiver(), ClassTag$.MODULE$.Int());
                TestOutputStream output = new TestOutputStream(input, TestOutputStream$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.Int());
                output.register();
                ssc.start();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ssc.scheduler().receiverTracker().allocatedExecutors().size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            });
            return (Assertion)this.withStreamingContext(new StreamingContext(this.conf(), Milliseconds$.MODULE$.apply(100L)), (Function1 & Serializable & scala.Serializable)ssc -> {
                RDD rdd = ssc.sc().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10), ssc.sc().parallelize$default$2(), ClassTag$.MODULE$.Int());
                ConstantInputDStream input = new ConstantInputDStream(ssc, rdd, ClassTag$.MODULE$.Int());
                TestOutputStream output = new TestOutputStream(input, TestOutputStream$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.Int());
                output.register();
                ssc.start();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ssc.scheduler().receiverTracker().allocatedExecutors());
                Map $org_scalatest_assert_macro_right = Predef$.MODULE$.Map().empty();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            });
        }, new Position("ReceiverTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }
}

