/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.Checkpoint$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.TestInputStream;
import org.apache.spark.streaming.TestOutputStreamWithPartitions;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f!C\u0005\u000b!\u0003\r\taEAK\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0011\u0015y\u0002\u0001\"\u0005!\u0011\u001dY\u0007!%A\u0005\u00121DqA\u001f\u0001\u0012\u0002\u0013E1\u0010C\u0004\u0002\u0002\u0001!\t\"a\u0001\t\u000f\u00055\u0001\u0001\"\u0005\u0002\u0010!9\u0011\u0011\b\u0001\u0005\u0012\u0005m\u0002bBA;\u0001\u0011%\u0011q\u000f\u0002\u0018\tN#(/Z1n\u0007\",7m\u001b9pS:$H+Z:uKJT!a\u0003\u0007\u0002\u0013M$(/Z1nS:<'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005a\u0002CA\u000b\u001e\u0013\tqbC\u0001\u0003V]&$\u0018!\u0007;fgR\u001c\u0005.Z2la>Lg\u000e^3e\u001fB,'/\u0019;j_:,2!I\u0017;)\u001d\u0011ChS,\\A\u001a$2\u0001H\u00127\u0011\u001d!#!!AA\u0004\u0015\n!\"\u001a<jI\u0016t7-\u001a\u00132!\r1\u0013fK\u0007\u0002O)\u0011\u0001FF\u0001\be\u00164G.Z2u\u0013\tQsE\u0001\u0005DY\u0006\u001c8\u000fV1h!\taS\u0006\u0004\u0001\u0005\u000b9\u0012!\u0019A\u0018\u0003\u0003U\u000b\"\u0001M\u001a\u0011\u0005U\t\u0014B\u0001\u001a\u0017\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u0006\u001b\n\u0005U2\"aA!os\"9qGAA\u0001\u0002\bA\u0014AC3wS\u0012,gnY3%eA\u0019a%K\u001d\u0011\u00051RD!B\u001e\u0003\u0005\u0004y#!\u0001,\t\u000bu\u0012\u0001\u0019\u0001 \u0002\u000b%t\u0007/\u001e;\u0011\u0007}:%J\u0004\u0002A\u000b:\u0011\u0011\tR\u0007\u0002\u0005*\u00111IE\u0001\u0007yI|w\u000e\u001e \n\u0003]I!A\u0012\f\u0002\u000fA\f7m[1hK&\u0011\u0001*\u0013\u0002\u0004'\u0016\f(B\u0001$\u0017!\ryti\u000b\u0005\u0006\u0019\n\u0001\r!T\u0001\n_B,'/\u0019;j_:\u0004B!\u0006(Q-&\u0011qJ\u0006\u0002\n\rVt7\r^5p]F\u00022!\u0015+,\u001b\u0005\u0011&BA*\u000b\u0003\u001d!7\u000f\u001e:fC6L!!\u0016*\u0003\u000f\u0011\u001bFO]3b[B\u0019\u0011\u000bV\u001d\t\u000ba\u0013\u0001\u0019A-\u0002\u001d\u0015D\b/Z2uK\u0012|U\u000f\u001e9viB\u0019qh\u0012.\u0011\u0007}:\u0015\bC\u0003]\u0005\u0001\u0007Q,A\fok6\u0014\u0015\r^2iKN\u0014UMZ8sKJ+7\u000f^1siB\u0011QCX\u0005\u0003?Z\u00111!\u00138u\u0011\u001d\t'\u0001%AA\u0002\t\fQBY1uG\"$UO]1uS>t\u0007CA2e\u001b\u0005Q\u0011BA3\u000b\u0005!!UO]1uS>t\u0007bB4\u0003!\u0003\u0005\r\u0001[\u0001\u001agR|\u0007o\u00159be.\u001cuN\u001c;fqR\fe\r^3s)\u0016\u001cH\u000f\u0005\u0002\u0016S&\u0011!N\u0006\u0002\b\u0005>|G.Z1o\u0003\r\"Xm\u001d;DQ\u0016\u001c7\u000e]8j]R,Gm\u00149fe\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uIU*2!\u001c=z+\u0005q'F\u00012pW\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003%)hn\u00195fG.,GM\u0003\u0002v-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]\u0014(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)af\u0001b\u0001_\u0011)1h\u0001b\u0001_\u0005\u0019C/Z:u\u0007\",7m\u001b9pS:$X\rZ(qKJ\fG/[8oI\u0011,g-Y;mi\u00122Tc\u0001?\u007f\u007fV\tQP\u000b\u0002i_\u0012)a\u0006\u0002b\u0001_\u0011)1\b\u0002b\u0001_\u0005\u00193M]3bi\u0016\u001cuN\u001c;fqR4uN]\"iK\u000e\\\u0007o\\5oi>\u0003XM]1uS>tG\u0003BA\u0003\u0003\u0017\u00012aYA\u0004\u0013\r\tIA\u0003\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqRDQ!Y\u0003A\u0002\t\f1cZ3u)\u0016\u001cHoT;uaV$8\u000b\u001e:fC6,B!!\u0005\u0002\u001eQ!\u00111CA\u0013)\u0011\t)\"a\b\u0011\u000b\r\f9\"a\u0007\n\u0007\u0005e!B\u0001\u0010UKN$x*\u001e;qkR\u001cFO]3b[^KG\u000f\u001b)beRLG/[8ogB\u0019A&!\b\u0005\u000bm2!\u0019A\u0018\t\u0013\u0005\u0005b!!AA\u0004\u0005\r\u0012AC3wS\u0012,gnY3%gA!a%KA\u000e\u0011\u001d\t9C\u0002a\u0001\u0003S\tqa\u001d;sK\u0006l7\u000fE\u0003\u0016\u0003W\ty#C\u0002\u0002.Y\u0011Q!\u0011:sCf\u0004D!!\r\u00026A!\u0011\u000bVA\u001a!\ra\u0013Q\u0007\u0003\f\u0003o\t)#!A\u0001\u0002\u000b\u0005qFA\u0002`IE\nabZ3oKJ\fG/Z(viB,H/\u0006\u0003\u0002>\u0005\u001dCCCA \u0003\u001f\n\u0019&!\u0018\u0002rQ!\u0011\u0011IA%!\u0011yt)a\u0011\u0011\t}:\u0015Q\t\t\u0004Y\u0005\u001dC!B\u001e\b\u0005\u0004y\u0003\"CA&\u000f\u0005\u0005\t9AA'\u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0005M%\n)\u0005C\u0004\u0002R\u001d\u0001\r!!\u0002\u0002\u0007M\u001c8\rC\u0004\u0002V\u001d\u0001\r!a\u0016\u0002\u001fQ\f'oZ3u\u0005\u0006$8\r\u001b+j[\u0016\u00042aYA-\u0013\r\tYF\u0003\u0002\u0005)&lW\rC\u0004\u0002`\u001d\u0001\r!!\u0019\u0002\u001b\rDWmY6q_&tG\u000fR5s!\u0011\t\u0019'a\u001b\u000f\t\u0005\u0015\u0014q\r\t\u0003\u0003ZI1!!\u001b\u0017\u0003\u0019\u0001&/\u001a3fM&!\u0011QNA8\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u000e\f\t\r\u0005Mt\u00011\u0001i\u0003A\u0019Ho\u001c9Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0007bgN,'\u000f^(viB,H/\u0006\u0003\u0002z\u0005\u0015E\u0003CA>\u0003\u000f\u000by)!%\u0015\u0007q\ti\bC\u0005\u0002\u0000!\t\t\u0011q\u0001\u0002\u0002\u0006QQM^5eK:\u001cW\rJ\u001b\u0011\t\u0019J\u00131\u0011\t\u0004Y\u0005\u0015E!B\u001e\t\u0005\u0004y\u0003bBAE\u0011\u0001\u0007\u00111R\u0001\u0007_V$\b/\u001e;\u0011\t}:\u0015Q\u0012\t\u0005\u007f\u001d\u000b\u0019\t\u0003\u0004Y\u0011\u0001\u0007\u00111\u0012\u0005\u0007\u0003'C\u0001\u0019\u00015\u0002\u001b\t,gm\u001c:f%\u0016\u001cH/\u0019:u%\u0019\t9*a'\u0002\u001e\u001a1\u0011\u0011\u0014\u0001\u0001\u0003+\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002\"a\u0019\u0001\u0011\t\u0005}\u0015\u0011U\u0007\u0002\u0019%\u0019\u00111\u0015\u0007\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0001")
public interface DStreamCheckpointTester {
    public static /* synthetic */ void testCheckpointedOperation$(DStreamCheckpointTester $this, Seq input, Function1 operation, Seq expectedOutput, int numBatchesBeforeRestart, Duration batchDuration, boolean stopSparkContextAfterTest, ClassTag evidence$1, ClassTag evidence$2) {
        $this.testCheckpointedOperation(input, operation, expectedOutput, numBatchesBeforeRestart, batchDuration, stopSparkContextAfterTest, evidence$1, evidence$2);
    }

    default public <U, V> void testCheckpointedOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatchesBeforeRestart, Duration batchDuration, boolean stopSparkContextAfterTest, ClassTag<U> evidence$1, ClassTag<V> evidence$2) {
        Predef$.MODULE$.require(numBatchesBeforeRestart < expectedOutput.size(), (Function0 & Serializable & scala.Serializable)() -> "Number of batches before context restart less than number of expected output (i.e. number of total batches to run)");
        Predef$.MODULE$.require(StreamingContext$.MODULE$.getActive().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Cannot run test with already active streaming context");
        int totalNumBatches = input.size();
        long batchDurationMillis = batchDuration.milliseconds();
        String x$1 = this.getClass().getSimpleName();
        String x$2 = Utils$.MODULE$.createTempDir$default$1();
        String checkpointDir = Utils$.MODULE$.createTempDir(x$2, x$1).toString();
        ((Logging)this).logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Using checkpoint directory ").append(checkpointDir).toString());
        StreamingContext ssc = this.createContextForCheckpointOperation(batchDuration);
        Predef$.MODULE$.require(((TripleEquals)this).convertToEqualizer((Object)ssc.conf().get("spark.streaming.clock")).$eq$eq$eq((Object)ManualClock.class.getName(), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "Cannot run test without manual clock in the conf");
        TestInputStream<U> inputStream = new TestInputStream<U>(ssc, input, 2, evidence$1);
        DStream operatedStream = (DStream)operation.apply(inputStream);
        operatedStream.print();
        TestOutputStreamWithPartitions outputStream = new TestOutputStreamWithPartitions(operatedStream, new ConcurrentLinkedQueue(), evidence$2);
        outputStream.register();
        ssc.checkpoint(checkpointDir);
        Seq<Seq<V>> beforeRestartOutput = this.generateOutput(ssc, new Time(batchDurationMillis * (long)numBatchesBeforeRestart), checkpointDir, stopSparkContextAfterTest, evidence$2);
        this.assertOutput(beforeRestartOutput, expectedOutput, true, evidence$2);
        ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> "\n-------------------------------------------\n        Restarting stream computation          \n-------------------------------------------\n");
        StreamingContext restartedSsc = new StreamingContext(checkpointDir);
        Seq<Seq<V>> afterRestartOutput = this.generateOutput(restartedSsc, new Time(batchDurationMillis * (long)totalNumBatches), checkpointDir, stopSparkContextAfterTest, evidence$2);
        this.assertOutput(afterRestartOutput, expectedOutput, false, evidence$2);
    }

    public static /* synthetic */ Duration testCheckpointedOperation$default$5$(DStreamCheckpointTester $this) {
        return $this.testCheckpointedOperation$default$5();
    }

    default public <U, V> Duration testCheckpointedOperation$default$5() {
        return Milliseconds$.MODULE$.apply(500L);
    }

    public static /* synthetic */ boolean testCheckpointedOperation$default$6$(DStreamCheckpointTester $this) {
        return $this.testCheckpointedOperation$default$6();
    }

    default public <U, V> boolean testCheckpointedOperation$default$6() {
        return true;
    }

    public static /* synthetic */ StreamingContext createContextForCheckpointOperation$(DStreamCheckpointTester $this, Duration batchDuration) {
        return $this.createContextForCheckpointOperation(batchDuration);
    }

    default public StreamingContext createContextForCheckpointOperation(Duration batchDuration) {
        SparkConf conf = new SparkConf().setMaster("local").setAppName(this.getClass().getSimpleName());
        conf.set("spark.streaming.clock", ManualClock.class.getName());
        return new StreamingContext(SparkContext$.MODULE$.getOrCreate(conf), batchDuration);
    }

    public static /* synthetic */ TestOutputStreamWithPartitions getTestOutputStream$(DStreamCheckpointTester $this, DStream[] streams, ClassTag evidence$3) {
        return $this.getTestOutputStream(streams, evidence$3);
    }

    default public <V> TestOutputStreamWithPartitions<V> getTestOutputStream(DStream<?>[] streams, ClassTag<V> evidence$3) {
        return (TestOutputStreamWithPartitions)((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])streams)).collect((PartialFunction)new scala.Serializable((SparkFunSuite)this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends DStream<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TestOutputStreamWithPartitions) {
                    TestOutputStreamWithPartitions testOutputStreamWithPartitions = (TestOutputStreamWithPartitions)A1;
                    return (B1)((Object)testOutputStreamWithPartitions);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(DStream<?> x1) {
                DStream<?> dStream = x1;
                return dStream instanceof TestOutputStreamWithPartitions;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TestOutputStreamWithPartitions.class))))).head());
    }

    public static /* synthetic */ Seq generateOutput$(DStreamCheckpointTester $this, StreamingContext ssc, Time targetBatchTime, String checkpointDir, boolean stopSparkContext, ClassTag evidence$4) {
        return $this.generateOutput(ssc, targetBatchTime, checkpointDir, stopSparkContext, evidence$4);
    }

    default public <V> Seq<Seq<V>> generateOutput(StreamingContext ssc, Time targetBatchTime, String checkpointDir, boolean stopSparkContext, ClassTag<V> evidence$4) {
        Seq seq;
        try {
            BatchCounter batchCounter = new BatchCounter(ssc);
            ssc.start();
            ManualClock clock = (ManualClock)ssc.scheduler().clock();
            ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Manual clock before advancing = ").append(clock.getTimeMillis()).toString());
            clock.setTime(targetBatchTime.milliseconds());
            ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Manual clock after advancing = ").append(clock.getTimeMillis()).toString());
            TestOutputStreamWithPartitions<V> outputStream = this.getTestOutputStream(ssc.graph().getOutputStreams(), evidence$4);
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
                ssc.awaitTerminationOrTimeout(10L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)this).convertToEqualizer((Object)batchCounter.getLastCompletedBatchTime());
                Time $org_scalatest_assert_macro_right = targetBatchTime;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Seq checkpointFilesOfLatestTime = (Seq)Checkpoint$.MODULE$.getCheckpointFiles(checkpointDir, Checkpoint$.MODULE$.getCheckpointFiles$default$2()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DStreamCheckpointTester.$anonfun$generateOutput$5(clock, x$1)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)this).convertToEqualizer((Object)BoxesRunTime.boxToInteger((int)checkpointFilesOfLatestTime.size()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            seq = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputStream.output()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)x$2.flatten((Function1)Predef$.MODULE$.$conforms()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        finally {
            ssc.stop(stopSparkContext);
        }
        return seq;
    }

    private <V> void assertOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean beforeRestart, ClassTag<V> evidence$5) {
        Seq expectedPartialOutput = beforeRestart ? (Seq)expectedOutput.take(output.size()) : (Seq)expectedOutput.takeRight(output.size());
        boolean setComparison = ((IterableLike)output.zip((GenIterable)expectedPartialOutput, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DStreamCheckpointTester.$anonfun$assertOutput$1(this, x0$1)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(setComparison, "setComparison", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(70).append("set comparison failed\n").append("Expected output items:\n").append(expectedPartialOutput.mkString("\n")).append("\n").append("Generated output items: ").append(output.mkString("\n")).toString(), Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
    }

    public static /* synthetic */ boolean $anonfun$generateOutput$5(ManualClock clock$1, Path x$1) {
        return x$1.getName().contains(Long.toString(clock$1.getTimeMillis()));
    }

    public static /* synthetic */ boolean $anonfun$assertOutput$1(DStreamCheckpointTester $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq o = (Seq)tuple2._1();
            Seq e = (Seq)tuple2._2();
            return ((TripleEquals)$this).convertToEqualizer((Object)o.toSet()).$eq$eq$eq((Object)e.toSet(), Equality$.MODULE$.default());
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(DStreamCheckpointTester $this) {
    }
}

