/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.StreamingConf$;
import org.apache.spark.streaming.util.BatchedWriteAheadLog;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class WriteAheadLogUtils$
implements Logging {
    public static WriteAheadLogUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new WriteAheadLogUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean enableReceiverLog(SparkConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)conf.get(StreamingConf$.MODULE$.RECEIVER_WAL_ENABLE_CONF_KEY()));
    }

    public int getRollingIntervalSecs(SparkConf conf, boolean isDriver) {
        if (isDriver) {
            return BoxesRunTime.unboxToInt((Object)conf.get(StreamingConf$.MODULE$.DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY()));
        }
        return BoxesRunTime.unboxToInt((Object)conf.get(StreamingConf$.MODULE$.RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY()));
    }

    public int getMaxFailures(SparkConf conf, boolean isDriver) {
        if (isDriver) {
            return BoxesRunTime.unboxToInt((Object)conf.get(StreamingConf$.MODULE$.DRIVER_WAL_MAX_FAILURES_CONF_KEY()));
        }
        return BoxesRunTime.unboxToInt((Object)conf.get(StreamingConf$.MODULE$.RECEIVER_WAL_MAX_FAILURES_CONF_KEY()));
    }

    public boolean isBatchingEnabled(SparkConf conf, boolean isDriver) {
        return isDriver && BoxesRunTime.unboxToBoolean((Object)conf.get(StreamingConf$.MODULE$.DRIVER_WAL_BATCHING_CONF_KEY()));
    }

    public long getBatchingTimeout(SparkConf conf) {
        return BoxesRunTime.unboxToLong((Object)conf.get(StreamingConf$.MODULE$.DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY()));
    }

    public boolean shouldCloseFileAfterWrite(SparkConf conf, boolean isDriver) {
        if (isDriver) {
            return BoxesRunTime.unboxToBoolean((Object)conf.get(StreamingConf$.MODULE$.DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY()));
        }
        return BoxesRunTime.unboxToBoolean((Object)conf.get(StreamingConf$.MODULE$.RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY()));
    }

    public WriteAheadLog createLogForDriver(SparkConf sparkConf, String fileWalLogDirectory, Configuration fileWalHadoopConf) {
        return this.createLog(true, sparkConf, fileWalLogDirectory, fileWalHadoopConf);
    }

    public WriteAheadLog createLogForReceiver(SparkConf sparkConf, String fileWalLogDirectory, Configuration fileWalHadoopConf) {
        return this.createLog(false, sparkConf, fileWalLogDirectory, fileWalHadoopConf);
    }

    private WriteAheadLog createLog(boolean isDriver, SparkConf sparkConf, String fileWalLogDirectory, Configuration fileWalHadoopConf) {
        Option classNameOption = isDriver ? (Option)sparkConf.get(StreamingConf$.MODULE$.DRIVER_WAL_CLASS_CONF_KEY()) : (Option)sparkConf.get(StreamingConf$.MODULE$.RECEIVER_WAL_CLASS_CONF_KEY());
        WriteAheadLog wal = (WriteAheadLog)classNameOption.map((Function1 & java.io.Serializable & Serializable)className -> {
            WriteAheadLog writeAheadLog;
            try {
                writeAheadLog = MODULE$.instantiateClass(Utils$.MODULE$.classForName(className, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()), sparkConf);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new SparkException(new StringBuilder(44).append("Could not create a write ahead log of class ").append((String)className).toString(), e);
                }
                throw throwable;
            }
            return writeAheadLog;
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> new FileBasedWriteAheadLog(sparkConf, fileWalLogDirectory, fileWalHadoopConf, MODULE$.getRollingIntervalSecs(sparkConf, isDriver), MODULE$.getMaxFailures(sparkConf, isDriver), MODULE$.shouldCloseFileAfterWrite(sparkConf, isDriver)));
        if (this.isBatchingEnabled(sparkConf, isDriver)) {
            return new BatchedWriteAheadLog(wal, sparkConf);
        }
        return wal;
    }

    private WriteAheadLog instantiateClass(Class<? extends WriteAheadLog> cls, SparkConf conf) {
        WriteAheadLog writeAheadLog;
        try {
            writeAheadLog = cls.getConstructor(SparkConf.class).newInstance(conf);
        }
        catch (NoSuchMethodException nsme) {
            writeAheadLog = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return writeAheadLog;
    }

    private WriteAheadLogUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

