/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.streaming.KryoState;
import org.apache.spark.streaming.rdd.MapWithStateRDDRecord;
import org.apache.spark.streaming.util.EmptyStateMap;
import org.apache.spark.streaming.util.OpenHashMapBasedStateMap;
import org.apache.spark.streaming.util.StateMap;
import org.apache.spark.streaming.util.StateMap$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\u0005\u000b\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAq\u0001\b\u0001C\u0002\u0013%Q\u0004\u0003\u0004\"\u0001\u0001\u0006IA\b\u0005\u0006E\u0001!Ia\t\u0005\u0006E\u0001!I!\u0015\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006G\u0002!I\u0001\u001f\u0005\b\u0003+\u0001A\u0011BA\f\u00055\u0019F/\u0019;f\u001b\u0006\u00048+^5uK*\u00111\u0002D\u0001\ngR\u0014X-Y7j]\u001eT!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\tA\"\u0003\u0002\u0018\u0019\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0006\u0002\t\r|gNZ\u000b\u0002=A\u0011QcH\u0005\u0003A1\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002#Q,7\u000f^*fe&\fG.\u001b>bi&|g.\u0006\u0002%]Q\u0019QE\u0011#\u0015\u0005\u0019R\u0004\u0003B\u0014+Y1j\u0011\u0001\u000b\u0006\u0003S)\tA!\u001e;jY&\u00111\u0006\u000b\u0002\u0019\u001fB,g\u000eS1tQ6\u000b\u0007OQ1tK\u0012\u001cF/\u0019;f\u001b\u0006\u0004\bCA\u0017/\u0019\u0001!Qa\f\u0003C\u0002A\u0012\u0011\u0001V\t\u0003c]\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012qAT8uQ&tw\r\u0005\u00023q%\u0011\u0011h\r\u0002\u0004\u0003:L\bbB\u001e\u0005\u0003\u0003\u0005\u001d\u0001P\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA\u001fAY5\taH\u0003\u0002@g\u00059!/\u001a4mK\u000e$\u0018BA!?\u0005!\u0019E.Y:t)\u0006<\u0007\"B\"\u0005\u0001\u00041\u0013aA7ba\")Q\t\u0002a\u0001\r\u0006\u0019Qn]4\u0011\u0005\u001dseB\u0001%M!\tI5'D\u0001K\u0015\tY%#\u0001\u0004=e>|GOP\u0005\u0003\u001bN\na\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011QjM\u000b\u0003%Z#Ba\u0015.bER\u0011Ak\u0016\t\u0005O)*V\u000b\u0005\u0002.-\u0012)q&\u0002b\u0001a!9\u0001,BA\u0001\u0002\bI\u0016AC3wS\u0012,gnY3%eA\u0019Q\bQ+\t\u000bm+\u0001\u0019\u0001/\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0002^?6\taL\u0003\u0002\\\u0019%\u0011\u0001M\u0018\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\"B\"\u0006\u0001\u0004!\u0006\"B#\u0006\u0001\u00041\u0015!C1tg\u0016\u0014H/T1q+\t)w\u000eF\u0003gSB\u0014x\u000f\u0005\u00023O&\u0011\u0001n\r\u0002\u0005+:LG\u000fC\u0003k\r\u0001\u00071.A\u0005nCB$v\u000eV3tiB!q\u0005\u001c8o\u0013\ti\u0007F\u0001\u0005Ti\u0006$X-T1q!\tis\u000eB\u00030\r\t\u0007\u0001\u0007C\u0003r\r\u0001\u00071.\u0001\tsK\u001al\u0015\r\u001d+p)\u0016\u001cHoV5uQ\")1O\u0002a\u0001i\u0006!A/[7f!\t\u0011T/\u0003\u0002wg\t!Aj\u001c8h\u0011\u0015)e\u00011\u0001G)\u001d1\u0017P`A\t\u0003'AQA[\u0004A\u0002i\u0004Ba\n7|wB\u0011!\u0007`\u0005\u0003{N\u00121!\u00138u\u0011\u0015\tx\u00011\u0001\u0000!\u001d\t\t!a\u0002|\u0003\u0017i!!a\u0001\u000b\u0007\u0005\u00151'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0003\u0002\u0004\t\u0019Q*\u00199\u0011\u000bI\nia\u001f;\n\u0007\u0005=1G\u0001\u0004UkBdWM\r\u0005\u0006g\u001e\u0001\r\u0001\u001e\u0005\u0006\u000b\u001e\u0001\rAR\u0001\u0018g\u0016\u0014\u0018.\u00197ju\u0016\fe\u000e\u001a#fg\u0016\u0014\u0018.\u00197ju\u0016,B!!\u0007\u0002 Q1\u00111DA\u0014\u0003S!B!!\b\u0002\"A\u0019Q&a\b\u0005\u000b=B!\u0019\u0001\u0019\t\u0013\u0005\r\u0002\"!AA\u0004\u0005\u0015\u0012AC3wS\u0012,gnY3%gA!Q\bQA\u000f\u0011\u0015Y\u0006\u00021\u0001]\u0011\u001d\tY\u0003\u0003a\u0001\u0003;\t\u0011\u0001\u001e")
public class StateMapSuite
extends SparkFunSuite {
    private final SparkConf conf = new SparkConf();

    private SparkConf conf() {
        return this.conf;
    }

    private <T> OpenHashMapBasedStateMap<T, T> testSerialization(OpenHashMapBasedStateMap<T, T> map, String msg, ClassTag<T> evidence$1) {
        this.testSerialization((Serializer)new JavaSerializer(this.conf()), map, msg, evidence$1);
        return this.testSerialization((Serializer)new KryoSerializer(this.conf()), map, msg, evidence$1);
    }

    private <T> OpenHashMapBasedStateMap<T, T> testSerialization(Serializer serializer, OpenHashMapBasedStateMap<T, T> map, String msg, ClassTag<T> evidence$2) {
        OpenHashMapBasedStateMap<T, T> deserMap = this.serializeAndDeserialize(serializer, map, ClassTag$.MODULE$.apply(OpenHashMapBasedStateMap.class));
        this.assertMap((StateMap<T, T>)deserMap, (StateMap<T, T>)map, 1L, msg);
        return deserMap;
    }

    private <T> void assertMap(StateMap<T, T> mapToTest, StateMap<T, T> refMapToTestWith, long time, String msg) {
        this.withClue(msg, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mapToTest.getAll().toSet());
            Set $org_scalatest_assert_macro_right = refMapToTestWith.getAll().toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            refMapToTestWith.getAll().map((Function1 & Serializable)x$1 -> x$1._1()).foreach((Function1 & Serializable)keyId -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mapToTest.get(keyId));
                Option $org_scalatest_assert_macro_right = refMapToTestWith.get(keyId);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            });
            new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)(time + 1L))).foreach((Function1 & Serializable)t -> StateMapSuite.$anonfun$assertMap$4(this, mapToTest, refMapToTestWith, BoxesRunTime.unboxToLong((Object)t)));
        });
    }

    private void assertMap(StateMap<Object, Object> mapToTest, Map<Object, Tuple2<Object, Object>> refMapToTestWith, long time, String msg) {
        this.withClue(msg, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mapToTest.getAll().toSet());
            Set $org_scalatest_assert_macro_right = refMapToTestWith.iterator().map((Function1 & Serializable)x -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)((Tuple2)x._2())._1$mcI$sp()), (Object)BoxesRunTime.boxToLong((long)((Tuple2)x._2())._2$mcJ$sp()))).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            refMapToTestWith.keys().foreach((Function1 & Serializable)keyId -> StateMapSuite.$anonfun$assertMap$7(this, mapToTest, refMapToTestWith, BoxesRunTime.unboxToInt((Object)keyId)));
            new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)(time + 1L))).foreach((Function1 & Serializable)t -> StateMapSuite.$anonfun$assertMap$9(this, refMapToTestWith, mapToTest, BoxesRunTime.unboxToLong((Object)t)));
        });
    }

    private <T> T serializeAndDeserialize(Serializer serializer, T t, ClassTag<T> evidence$3) {
        SerializerInstance serializerInstance = serializer.newInstance();
        return (T)serializerInstance.deserialize(serializerInstance.serialize(t, evidence$3), Thread.currentThread().getContextClassLoader(), evidence$3);
    }

    public static final /* synthetic */ Option $anonfun$new$11(LongRef time$1, int numTypeMapOps$1, int numTotalOps$1, int opId$1, ObjectRef stateMap$1, HashMap refMap$1, int keyId) {
        int opCode;
        ++time$1.elem;
        int n = opCode = keyId / (int)package$.MODULE$.pow((double)numTypeMapOps$1, (double)(numTotalOps$1 - opId$1 - 1)) % numTypeMapOps$1;
        switch (n) {
            case 0: {
                int value = Random$.MODULE$.nextInt();
                ((StateMap)stateMap$1.elem).put((Object)BoxesRunTime.boxToInteger((int)keyId), (Object)BoxesRunTime.boxToInteger((int)value), time$1.elem);
                return refMap$1.put((Object)BoxesRunTime.boxToInteger((int)keyId), (Object)new Tuple2.mcIJ.sp(value, time$1.elem));
            }
            case 1: {
                ((StateMap)stateMap$1.elem).remove((Object)BoxesRunTime.boxToInteger((int)keyId));
                return refMap$1.remove((Object)BoxesRunTime.boxToInteger((int)keyId));
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static final /* synthetic */ Assertion $anonfun$assertMap$4(StateMapSuite $this, StateMap mapToTest$1, StateMap refMapToTestWith$1, long t) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(mapToTest$1.getByTime(t).toSet());
        Set $org_scalatest_assert_macro_right = refMapToTestWith$1.getByTime(t).toSet();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
    }

    public static final /* synthetic */ Assertion $anonfun$assertMap$7(StateMapSuite $this, StateMap mapToTest$2, Map refMapToTestWith$2, int keyId) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(mapToTest$2.get((Object)BoxesRunTime.boxToInteger((int)keyId)));
        Option $org_scalatest_assert_macro_right = refMapToTestWith$2.get((Object)BoxesRunTime.boxToInteger((int)keyId)).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._1$mcI$sp()));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
    }

    public static final /* synthetic */ boolean $anonfun$assertMap$10(long t$1, Tuple2 x$3) {
        return ((Tuple2)x$3._2())._2$mcJ$sp() < t$1;
    }

    public static final /* synthetic */ Assertion $anonfun$assertMap$9(StateMapSuite $this, Map refMapToTestWith$2, StateMap mapToTest$2, long t) {
        Iterator expectedRecords = refMapToTestWith$2.iterator().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StateMapSuite.$anonfun$assertMap$10(t, x$3))).map((Function1 & Serializable)x -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)((Tuple2)x._2())._1$mcI$sp()), (Object)BoxesRunTime.boxToLong((long)((Tuple2)x._2())._2$mcJ$sp())));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(mapToTest$2.getByTime(t).toSet());
        Set $org_scalatest_assert_macro_right = expectedRecords.toSet();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
    }

    public StateMapSuite() {
        this.test("EmptyStateMap", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            EmptyStateMap map = new EmptyStateMap();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> map.put((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), 1L), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)1)));
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Iterator $org_scalatest_assert_macro_left2 = map.getByTime(10000L);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            Iterator $org_scalatest_assert_macro_left3 = map.getAll();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            map.remove((Object)BoxesRunTime.boxToInteger((int)1));
            StateMap $org_scalatest_assert_macro_left4 = map.copy();
            EmptyStateMap $org_scalatest_assert_macro_right2 = map;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        }, new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("OpenHashMapBasedStateMap - put, get, getByTime, getAll, remove", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            OpenHashMapBasedStateMap map = new OpenHashMapBasedStateMap((ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
            map.put((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), 10L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)1)));
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)100));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)2)));
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(map.getByTime(11L).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToInteger((int)10))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(map.getByTime(10L).toSet());
            Set $org_scalatest_assert_macro_right4 = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(map.getByTime(9L).toSet());
            Set $org_scalatest_assert_macro_right5 = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(map.getAll().toSet());
            Set $org_scalatest_assert_macro_right6 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToInteger((int)10))}));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            map.put((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), 20L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(map.getByTime(21L).toSet());
            Set $org_scalatest_assert_macro_right7 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToInteger((int)10)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(map.getByTime(11L).toSet());
            Set $org_scalatest_assert_macro_right8 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToInteger((int)10))}));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(map.getByTime(10L).toSet());
            Set $org_scalatest_assert_macro_right9 = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(map.getByTime(9L).toSet());
            Set $org_scalatest_assert_macro_right10 = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(map.getAll().toSet());
            Set $org_scalatest_assert_macro_right11 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToInteger((int)10)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            map.remove((Object)BoxesRunTime.boxToInteger((int)1));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)1)));
            None$ $org_scalatest_assert_macro_right12 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(map.getAll().toSet());
            Set $org_scalatest_assert_macro_right13 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("OpenHashMapBasedStateMap - put, get, getByTime, getAll, remove with copy", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            OpenHashMapBasedStateMap parentMap = new OpenHashMapBasedStateMap((ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
            parentMap.put((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), 1L);
            parentMap.put((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), 2L);
            parentMap.remove((Object)BoxesRunTime.boxToInteger((int)1));
            StateMap map = parentMap.copy();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)1)));
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)2)));
            Some $org_scalatest_assert_macro_right2 = new Some((Object)BoxesRunTime.boxToInteger((int)200));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(map.getByTime(10L).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(map.getByTime(2L).toSet());
            Set $org_scalatest_assert_macro_right4 = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(map.getAll().toSet());
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            map.put((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), 3L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)3)));
            Some $org_scalatest_assert_macro_right6 = new Some((Object)BoxesRunTime.boxToInteger((int)300));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            map.put((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)400), 4L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)4)));
            Some $org_scalatest_assert_macro_right7 = new Some((Object)BoxesRunTime.boxToInteger((int)400));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(map.getByTime(10L).toSet());
            Set $org_scalatest_assert_macro_right8 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)400), (Object)BoxesRunTime.boxToInteger((int)4))}));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(map.getByTime(4L).toSet());
            Set $org_scalatest_assert_macro_right9 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(map.getAll().toSet());
            Set $org_scalatest_assert_macro_right10 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)400), (Object)BoxesRunTime.boxToInteger((int)4))}));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(parentMap.getAll().toSet());
            Set $org_scalatest_assert_macro_right11 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            map.remove((Object)BoxesRunTime.boxToInteger((int)4));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)4)));
            None$ $org_scalatest_assert_macro_right12 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            map.remove((Object)BoxesRunTime.boxToInteger((int)2));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)2)));
            None$ $org_scalatest_assert_macro_right13 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(map.getAll().toSet());
            Set $org_scalatest_assert_macro_right14 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(parentMap.getAll().toSet());
            Set $org_scalatest_assert_macro_right15 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            map.put((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1000), 100L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)1)));
            Some $org_scalatest_assert_macro_right16 = new Some((Object)BoxesRunTime.boxToInteger((int)1000));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)$org_scalatest_assert_macro_right16, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            map.put((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2000), 200L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)2)));
            Some $org_scalatest_assert_macro_right17 = new Some((Object)BoxesRunTime.boxToInteger((int)2000));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)$org_scalatest_assert_macro_right17, $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)$org_scalatest_assert_macro_right17, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            map.put((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)3000), 300L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)3)));
            Some $org_scalatest_assert_macro_right18 = new Some((Object)BoxesRunTime.boxToInteger((int)3000));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right18, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right18, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            map.put((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)4000), 400L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.convertToEqualizer(map.get((Object)BoxesRunTime.boxToInteger((int)4)));
            Some $org_scalatest_assert_macro_right19 = new Some((Object)BoxesRunTime.boxToInteger((int)4000));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)$org_scalatest_assert_macro_right19, $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)$org_scalatest_assert_macro_right19, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.convertToEqualizer(map.getAll().toSet());
            Set $org_scalatest_assert_macro_right20 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)BoxesRunTime.boxToInteger((int)100)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2000), (Object)BoxesRunTime.boxToInteger((int)200)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)3000), (Object)BoxesRunTime.boxToInteger((int)300)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)4000), (Object)BoxesRunTime.boxToInteger((int)400))}));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)$org_scalatest_assert_macro_right20, $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)$org_scalatest_assert_macro_right20, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.convertToEqualizer(parentMap.getAll().toSet());
            Set $org_scalatest_assert_macro_right21 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)$org_scalatest_assert_macro_right21, $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)$org_scalatest_assert_macro_right21, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            map.remove((Object)BoxesRunTime.boxToInteger((int)2));
            StateMap childMap = map.copy();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left22 = this.convertToEqualizer(childMap.getAll().toSet());
            Set $org_scalatest_assert_macro_right22 = map.getAll().toSet();
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left22, "===", (Object)$org_scalatest_assert_macro_right22, $org_scalatest_assert_macro_left22.$eq$eq$eq((Object)$org_scalatest_assert_macro_right22, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left23 = this.convertToEqualizer(childMap.get((Object)BoxesRunTime.boxToInteger((int)1)));
            Some $org_scalatest_assert_macro_right23 = new Some((Object)BoxesRunTime.boxToInteger((int)1000));
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "===", (Object)$org_scalatest_assert_macro_right23, $org_scalatest_assert_macro_left23.$eq$eq$eq((Object)$org_scalatest_assert_macro_right23, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left24 = this.convertToEqualizer(childMap.get((Object)BoxesRunTime.boxToInteger((int)2)));
            None$ $org_scalatest_assert_macro_right24 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left24, "===", (Object)$org_scalatest_assert_macro_right24, $org_scalatest_assert_macro_left24.$eq$eq$eq((Object)$org_scalatest_assert_macro_right24, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left25 = this.convertToEqualizer(childMap.get((Object)BoxesRunTime.boxToInteger((int)3)));
            Some $org_scalatest_assert_macro_right25 = new Some((Object)BoxesRunTime.boxToInteger((int)3000));
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "===", (Object)$org_scalatest_assert_macro_right25, $org_scalatest_assert_macro_left25.$eq$eq$eq((Object)$org_scalatest_assert_macro_right25, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            childMap.put((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)20000), 200L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left26 = this.convertToEqualizer(childMap.get((Object)BoxesRunTime.boxToInteger((int)2)));
            Some $org_scalatest_assert_macro_right26 = new Some((Object)BoxesRunTime.boxToInteger((int)20000));
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left26, "===", (Object)$org_scalatest_assert_macro_right26, $org_scalatest_assert_macro_left26.$eq$eq$eq((Object)$org_scalatest_assert_macro_right26, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("OpenHashMapBasedStateMap - serializing and deserializing", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            OpenHashMapBasedStateMap map1 = new OpenHashMapBasedStateMap((ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
            this.testSerialization((OpenHashMapBasedStateMap)map1, "error deserializing and serialized empty map", (ClassTag)ClassTag$.MODULE$.Int());
            map1.put((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), 1L);
            map1.put((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), 2L);
            this.testSerialization((OpenHashMapBasedStateMap)map1, "error deserializing and serialized map with data + no delta", (ClassTag)ClassTag$.MODULE$.Int());
            OpenHashMapBasedStateMap map2 = (OpenHashMapBasedStateMap)map1.copy();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)map2.shouldCompact()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            this.testSerialization((OpenHashMapBasedStateMap)map2, "error deserializing and serialized map with 1 delta + no new data", (ClassTag)ClassTag$.MODULE$.Int());
            map2.put((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), 3L);
            map2.put((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)400), 4L);
            this.testSerialization((OpenHashMapBasedStateMap)map2, "error deserializing and serialized map with 1 delta + new data", (ClassTag)ClassTag$.MODULE$.Int());
            OpenHashMapBasedStateMap map3 = (OpenHashMapBasedStateMap)map2.copy();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)map3.shouldCompact()));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            this.testSerialization((OpenHashMapBasedStateMap)map3, "error deserializing and serialized map with 2 delta + no new data", (ClassTag)ClassTag$.MODULE$.Int());
            map3.put((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)600), 3L);
            map3.remove((Object)BoxesRunTime.boxToInteger((int)2));
            return this.testSerialization((OpenHashMapBasedStateMap)map3, "error deserializing and serialized map with 2 delta + new data", (ClassTag)ClassTag$.MODULE$.Int());
        }, new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("OpenHashMapBasedStateMap - serializing and deserializing with compaction", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int targetDeltaLength = 10;
            int deltaChainThreshold = 5;
            ObjectRef map = ObjectRef.create((Object)new OpenHashMapBasedStateMap(deltaChainThreshold, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), targetDeltaLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                ((OpenHashMapBasedStateMap)map$2.elem).put((Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt()), (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt()), 1L);
                map$2.elem = (OpenHashMapBasedStateMap)((OpenHashMapBasedStateMap)map$2.elem).copy();
            });
            int $org_scalatest_assert_macro_left = ((OpenHashMapBasedStateMap)map.elem).deltaChainLength();
            int $org_scalatest_assert_macro_right = deltaChainThreshold;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((OpenHashMapBasedStateMap)map.elem).shouldCompact(), "map.shouldCompact", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            OpenHashMapBasedStateMap deser_map = this.testSerialization((OpenHashMapBasedStateMap)((OpenHashMapBasedStateMap)map.elem), "Deserialized + compacted map not same as original map", (ClassTag)ClassTag$.MODULE$.Int());
            int $org_scalatest_assert_macro_left2 = deser_map.deltaChainLength();
            int $org_scalatest_assert_macro_right2 = deltaChainThreshold;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)deser_map.shouldCompact()));
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        }, new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("OpenHashMapBasedStateMap - all possible sequences of operations with copies ", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int numTypeMapOps = 2;
            int numSets = 3;
            int numOpsPerSet = 3;
            int numTotalOps = numOpsPerSet * numSets;
            int numKeys = (int)package$.MODULE$.pow((double)numTypeMapOps, (double)numTotalOps);
            HashMap refMap = new HashMap();
            ObjectRef prevSetRefMap = ObjectRef.create(null);
            ObjectRef stateMap = ObjectRef.create((Object)new OpenHashMapBasedStateMap((ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()));
            ObjectRef prevSetStateMap = ObjectRef.create(null);
            LongRef time = LongRef.create((long)1L);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numSets).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)setId -> {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numOpsPerSet).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)opInSetId -> {
                    int opId = setId * numOpsPerSet + opInSetId;
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numKeys).foreach((Function1 & Serializable)keyId -> StateMapSuite.$anonfun$new$11(time, numTypeMapOps, numTotalOps, opId, stateMap, refMap, BoxesRunTime.unboxToInt((Object)keyId)));
                    this.assertMap((StateMap<Object, Object>)((StateMap)stateMap$1.elem), (Map<Object, Tuple2<Object, Object>>)refMap, time$1.elem, "State map does not match reference map");
                    if ((StateMap)prevSetStateMap$1.elem != null && (scala.collection.immutable.Map)prevSetRefMap$1.elem != null) {
                        this.assertMap((StateMap<Object, Object>)((StateMap)prevSetStateMap$1.elem), (Map<Object, Tuple2<Object, Object>>)((scala.collection.immutable.Map)prevSetRefMap$1.elem), time$1.elem, "Parent state map somehow got modified, does not match corresponding reference map");
                        return;
                    }
                });
                prevSetStateMap$1.elem = (StateMap)stateMap$1.elem;
                prevSetRefMap$1.elem = refMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                stateMap$1.elem = ((StateMap)stateMap$1.elem).copy();
                this.assertMap((StateMap<Object, Object>)((StateMap)stateMap$1.elem), (Map<Object, Tuple2<Object, Object>>)((scala.collection.immutable.Map)prevSetRefMap$1.elem), time$1.elem, "State map does not match reference map after copying");
            });
            this.assertMap((StateMap<Object, Object>)((StateMap)stateMap.elem), (Map<Object, Tuple2<Object, Object>>)refMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), time.elem, "Final state map does not match reference map");
        }, new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("OpenHashMapBasedStateMap - serializing and deserializing with KryoSerializable states", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            OpenHashMapBasedStateMap map = new OpenHashMapBasedStateMap(ClassTag$.MODULE$.apply(KryoState.class), ClassTag$.MODULE$.apply(KryoState.class));
            map.put((Object)new KryoState("a"), (Object)new KryoState("b"), 1L);
            return this.testSerialization((Serializer)new KryoSerializer(this.conf()), map, "error deserializing and serialized KryoSerializable states", ClassTag$.MODULE$.apply(KryoState.class));
        }, new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.test("EmptyStateMap - serializing and deserializing", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StateMap map = StateMap$.MODULE$.empty();
            StateMap $org_scalatest_assert_macro_left = this.serializeAndDeserialize((Serializer)new JavaSerializer(this.conf()), map, ClassTag$.MODULE$.apply(StateMap.class));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.streaming.util.EmptyStateMap", $org_scalatest_assert_macro_left instanceof EmptyStateMap, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            StateMap $org_scalatest_assert_macro_left2 = this.serializeAndDeserialize((Serializer)new KryoSerializer(this.conf()), map, ClassTag$.MODULE$.apply(StateMap.class));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.streaming.util.EmptyStateMap", $org_scalatest_assert_macro_left2 instanceof EmptyStateMap, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        }, new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        this.test("MapWithStateRDDRecord - serializing and deserializing with KryoSerializable states", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            OpenHashMapBasedStateMap map = new OpenHashMapBasedStateMap(ClassTag$.MODULE$.apply(KryoState.class), ClassTag$.MODULE$.apply(KryoState.class));
            map.put((Object)new KryoState("a"), (Object)new KryoState("b"), 1L);
            MapWithStateRDDRecord record = new MapWithStateRDDRecord((StateMap)map, (Seq)new .colon.colon((Object)new KryoState("c"), (List)Nil$.MODULE$));
            MapWithStateRDDRecord deserRecord = this.serializeAndDeserialize((Serializer)new KryoSerializer(this.conf()), record, ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
            MapWithStateRDDRecord $org_scalatest_assert_macro_left = record;
            MapWithStateRDDRecord $org_scalatest_assert_macro_right = deserRecord;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(record.stateMap().getAll().toSeq());
            Seq $org_scalatest_assert_macro_right2 = deserRecord.stateMap().getAll().toSeq();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(record.mappedData());
            Seq $org_scalatest_assert_macro_right3 = deserRecord.mappedData();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        }, new Position("StateMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
    }
}

